/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.docvalues.DoubleDocValues;
import org.apache.lucene.queries.function.valuesource.FieldCacheSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueDouble;

public class DoubleFieldSource
extends FieldCacheSource {
    public DoubleFieldSource(String field2) {
        super(field2);
    }

    @Override
    public String description() {
        return "double(" + this.field + ')';
    }

    @Override
    public SortField getSortField(boolean reverse) {
        return new SortField(this.field, SortField.Type.DOUBLE, reverse);
    }

    @Override
    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        final NumericDocValues values2 = this.getNumericDocValues(context, readerContext);
        return new DoubleDocValues(this){
            int lastDocID;

            private double getValueForDoc(int doc) throws IOException {
                if (doc < this.lastDocID) {
                    throw new IllegalArgumentException("docs were sent out-of-order: lastDocID=" + this.lastDocID + " vs docID=" + doc);
                }
                this.lastDocID = doc;
                int curDocID = values2.docID();
                if (doc > curDocID) {
                    curDocID = values2.advance(doc);
                }
                if (doc == curDocID) {
                    return Double.longBitsToDouble(values2.longValue());
                }
                return 0.0;
            }

            @Override
            public double doubleVal(int doc) throws IOException {
                return this.getValueForDoc(doc);
            }

            @Override
            public boolean exists(int doc) throws IOException {
                this.getValueForDoc(doc);
                return doc == values2.docID();
            }

            @Override
            public FunctionValues.ValueFiller getValueFiller() {
                return new FunctionValues.ValueFiller(){
                    private final MutableValueDouble mval = new MutableValueDouble();

                    @Override
                    public MutableValue getValue() {
                        return this.mval;
                    }

                    @Override
                    public void fillValue(int doc) throws IOException {
                        this.mval.value = this.getValueForDoc(doc);
                        this.mval.exists = this.exists(doc);
                    }
                };
            }
        };
    }

    protected NumericDocValues getNumericDocValues(Map context, LeafReaderContext readerContext) throws IOException {
        return DocValues.getNumeric(readerContext.reader(), this.field);
    }

    @Override
    public boolean equals(Object o) {
        if (o.getClass() != DoubleFieldSource.class) {
            return false;
        }
        DoubleFieldSource other = (DoubleFieldSource)o;
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        int h = Double.class.hashCode();
        return h += super.hashCode();
    }
}

