/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.intervals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.lucene.queries.intervals.Intervals;
import org.apache.lucene.queries.intervals.IntervalsSource;
import org.apache.lucene.search.BooleanQuery;

final class Disjunctions {
    Disjunctions() {
    }

    public static List<IntervalsSource> pullUp(List<IntervalsSource> sources, Function<List<IntervalsSource>, IntervalsSource> function2) {
        ArrayList rewritten = new ArrayList();
        rewritten.add(new ArrayList());
        for (IntervalsSource source : sources) {
            List<IntervalsSource> disjuncts = Disjunctions.splitDisjunctions(source);
            if (disjuncts.size() == 1) {
                rewritten.forEach(l -> l.add(disjuncts.get(0)));
                continue;
            }
            if (rewritten.size() * disjuncts.size() > BooleanQuery.getMaxClauseCount()) {
                throw new IllegalArgumentException("Too many disjunctions to expand");
            }
            ArrayList toAdd = new ArrayList();
            for (IntervalsSource disj : disjuncts) {
                for (List list : rewritten) {
                    ArrayList<IntervalsSource> l2 = new ArrayList<IntervalsSource>(list);
                    l2.add(disj);
                    toAdd.add(l2);
                }
            }
            rewritten = toAdd;
        }
        if (rewritten.size() == 1) {
            return Collections.singletonList(function2.apply((List<IntervalsSource>)rewritten.get(0)));
        }
        return rewritten.stream().map(function2).collect(Collectors.toList());
    }

    public static List<IntervalsSource> pullUp(IntervalsSource source, Function<IntervalsSource, IntervalsSource> function2) {
        List<IntervalsSource> disjuncts = Disjunctions.splitDisjunctions(source);
        if (disjuncts.size() == 1) {
            return Collections.singletonList(function2.apply(disjuncts.get(0)));
        }
        return disjuncts.stream().map(function2).collect(Collectors.toList());
    }

    private static List<IntervalsSource> splitDisjunctions(IntervalsSource source) {
        ArrayList<IntervalsSource> singletons = new ArrayList<IntervalsSource>();
        ArrayList<IntervalsSource> nonSingletons = new ArrayList<IntervalsSource>();
        for (IntervalsSource disj : source.pullUpDisjunctions()) {
            if (disj.minExtent() == 1) {
                singletons.add(disj);
                continue;
            }
            nonSingletons.add(disj);
        }
        ArrayList<IntervalsSource> split2 = new ArrayList<IntervalsSource>();
        if (singletons.size() > 0) {
            split2.add(Intervals.or(singletons.toArray(new IntervalsSource[0])));
        }
        split2.addAll(nonSingletons);
        return split2;
    }
}

