/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.FutureArrays;

public final class CharsRef
implements Comparable<CharsRef>,
CharSequence,
Cloneable {
    public static final char[] EMPTY_CHARS = new char[0];
    public char[] chars;
    public int offset;
    public int length;
    @Deprecated
    private static final Comparator<CharsRef> utf16SortedAsUTF8SortOrder = new UTF16SortedAsUTF8Comparator();

    public CharsRef() {
        this(EMPTY_CHARS, 0, 0);
    }

    public CharsRef(int capacity) {
        this.chars = new char[capacity];
    }

    public CharsRef(char[] chars, int offset, int length) {
        this.chars = chars;
        this.offset = offset;
        this.length = length;
        assert (this.isValid());
    }

    public CharsRef(String string2) {
        this.chars = string2.toCharArray();
        this.offset = 0;
        this.length = this.chars.length;
    }

    public CharsRef clone() {
        return new CharsRef(this.chars, this.offset, this.length);
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 0;
        int end = this.offset + this.length;
        for (int i = this.offset; i < end; ++i) {
            result2 = 31 * result2 + this.chars[i];
        }
        return result2;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof CharsRef) {
            return this.charsEquals((CharsRef)other);
        }
        return false;
    }

    public boolean charsEquals(CharsRef other) {
        return Arrays.equals(this.chars, this.offset, this.offset + this.length, other.chars, other.offset, other.offset + other.length);
    }

    @Override
    public int compareTo(CharsRef other) {
        return Arrays.compare(this.chars, this.offset, this.offset + this.length, other.chars, other.offset, other.offset + other.length);
    }

    @Override
    public String toString() {
        return new String(this.chars, this.offset, this.length);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        Objects.checkIndex(index, this.length);
        return this.chars[this.offset + index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        Objects.checkFromToIndex(start, end, this.length);
        return new CharsRef(this.chars, this.offset + start, end - start);
    }

    @Deprecated
    public static Comparator<CharsRef> getUTF16SortedAsUTF8Comparator() {
        return utf16SortedAsUTF8SortOrder;
    }

    public static CharsRef deepCopyOf(CharsRef other) {
        return new CharsRef(ArrayUtil.copyOfSubArray(other.chars, other.offset, other.offset + other.length), 0, other.length);
    }

    public boolean isValid() {
        if (this.chars == null) {
            throw new IllegalStateException("chars is null");
        }
        if (this.length < 0) {
            throw new IllegalStateException("length is negative: " + this.length);
        }
        if (this.length > this.chars.length) {
            throw new IllegalStateException("length is out of bounds: " + this.length + ",chars.length=" + this.chars.length);
        }
        if (this.offset < 0) {
            throw new IllegalStateException("offset is negative: " + this.offset);
        }
        if (this.offset > this.chars.length) {
            throw new IllegalStateException("offset out of bounds: " + this.offset + ",chars.length=" + this.chars.length);
        }
        if (this.offset + this.length < 0) {
            throw new IllegalStateException("offset+length is negative: offset=" + this.offset + ",length=" + this.length);
        }
        if (this.offset + this.length > this.chars.length) {
            throw new IllegalStateException("offset+length out of bounds: offset=" + this.offset + ",length=" + this.length + ",chars.length=" + this.chars.length);
        }
        return true;
    }

    @Deprecated
    private static class UTF16SortedAsUTF8Comparator
    implements Comparator<CharsRef> {
        private UTF16SortedAsUTF8Comparator() {
        }

        @Override
        public int compare(CharsRef a, CharsRef b) {
            int aEnd = a.offset + a.length;
            int bEnd = b.offset + b.length;
            int i = FutureArrays.mismatch(a.chars, a.offset, aEnd, b.chars, b.offset, bEnd);
            if (i >= 0 && i < Math.min(a.length, b.length)) {
                char aChar = a.chars[a.offset + i];
                char bChar = b.chars[b.offset + i];
                if (aChar >= '\ud800' && bChar >= '\ud800') {
                    aChar = aChar >= '\ue000' ? (char)(aChar - 2048) : (char)(aChar + 8192);
                    bChar = bChar >= '\ue000' ? (char)(bChar - 2048) : (char)(bChar + 8192);
                }
                return aChar - bChar;
            }
            return a.length - b.length;
        }
    }
}

