/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.middleware;

import cats.effect.Concurrent;
import cats.effect.Resource;
import cats.effect.Resource$;
import cats.effect.Timer;
import cats.syntax.FlatMapOps$;
import cats.syntax.package$all$;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.HttpDate;
import org.http4s.Method;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.client.Client;
import org.http4s.client.Client$;
import org.http4s.headers.Retry$minusAfter;
import org.http4s.headers.Retry$minusAfter$;
import org.http4s.util.CaseInsensitiveString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Retry$ {
    public static final Retry$ MODULE$ = new Retry$();
    private static final Logger logger = LoggerFactory.getLogger("org.http4s.client.middleware.Retry");

    public <F> Client<F> apply(Function3<Request<F>, Either<Throwable, Response<F>>, Object, Option<FiniteDuration>> policy, Function1<CaseInsensitiveString, Object> redactHeaderWhen, Client<F> client, Concurrent<F> F2, Timer<F> T) {
        return Client$.MODULE$.apply((Function1<Request, Resource> & Serializable)x$2 -> Retry$.prepareLoop$1(x$2, 1, F2, client, policy, redactHeaderWhen, T), F2);
    }

    public <F> Function1<CaseInsensitiveString, Object> apply$default$2() {
        return (Function1<CaseInsensitiveString, Object> & Serializable)elem -> BoxesRunTime.boxToBoolean(Retry$.$anonfun$apply$default$2$1(elem));
    }

    private static final Resource prepareLoop$1(Request req, int attempts, Concurrent F$1, Client client$1, Function3 policy$1, Function1 redactHeaderWhen$1, Timer T$1) {
        return Resource$.MODULE$.suspend(F$1.continual(client$1.run(req).allocated(F$1), (Function1<Either, Object> & Serializable)x0$1 -> {
            Object f;
            Right right;
            Tuple2 tuple2;
            Either either2 = x0$1;
            if (either2 instanceof Right && (tuple2 = (Tuple2)(right = (Right)either2).value()) != null) {
                Object object;
                Response response = (Response)tuple2._1();
                Object dispose = tuple2._2();
                Option option = (Option)policy$1.apply(req, package$.MODULE$.Right().apply(response), BoxesRunTime.boxToInteger(attempts));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    FiniteDuration duration = (FiniteDuration)some.value();
                    if (logger.isInfoEnabled()) {
                        logger.info(new StringBuilder(63).append("Request ").append(Retry$.showRequest$1(req, redactHeaderWhen$1)).append(" has failed on attempt #").append(attempts).append(" with reason ").append(response.status()).append(". Retrying after ").append(duration).append(".").toString());
                    }
                    object = FlatMapOps$.MODULE$.$greater$greater$extension(package$all$.MODULE$.catsSyntaxFlatMapOps(dispose, F$1), (Function0<Object> & Serializable)() -> F$1.pure(Retry$.nextAttempt$1(req, attempts, duration, Headers$.MODULE$.get$extension((List<Header>)response.headers(), Retry$minusAfter$.MODULE$), T$1, F$1, client$1, policy$1, redactHeaderWhen$1)), F$1);
                } else if (None$.MODULE$.equals(option)) {
                    object = F$1.pure(Resource$.MODULE$.make(F$1.pure(response), (Function1<Response, Object> & Serializable)x$1 -> dispose, F$1));
                } else {
                    throw new MatchError(option);
                }
                f = object;
            } else if (either2 instanceof Left) {
                Object f2;
                Left left = (Left)either2;
                Throwable e = (Throwable)left.value();
                Option option = (Option)policy$1.apply(req, package$.MODULE$.Left().apply(e), BoxesRunTime.boxToInteger(attempts));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    FiniteDuration duration = (FiniteDuration)some.value();
                    if (logger.isInfoEnabled()) {
                        logger.info(new StringBuilder(56).append("Request threw an exception on attempt #").append(attempts).append(". Retrying after ").append(duration).toString(), e);
                    }
                    f2 = F$1.pure(Retry$.nextAttempt$1(req, attempts, duration, None$.MODULE$, T$1, F$1, client$1, policy$1, redactHeaderWhen$1));
                } else if (None$.MODULE$.equals(option)) {
                    if (logger.isInfoEnabled()) {
                        logger.info(new StringBuilder(52).append("Request ").append(Retry$.showRequest$1(req, redactHeaderWhen$1)).append(" threw an exception on attempt #").append(attempts).append(". Giving up.").toString(), e);
                    }
                    f2 = F$1.pure(Resource$.MODULE$.eval(F$1.raiseError(e), F$1));
                } else {
                    throw new MatchError(option);
                }
                f = f2;
            } else {
                throw new MatchError(either2);
            }
            return f;
        }));
    }

    private static final String showRequest$1(Request request, Function1 redactWhen) {
        String headers = Headers$.MODULE$.toList$extension(Headers$.MODULE$.redactSensitive$extension(request.headers(), redactWhen)).mkString(",");
        String uri = request.uri().renderString();
        Method method = request.method();
        return new StringBuilder(21).append("method=").append(method).append(" uri=").append(uri).append(" headers=").append(headers).toString();
    }

    public static final /* synthetic */ long $anonfun$apply$4(Retry$minusAfter h) {
        long l;
        Either<HttpDate, Object> either2 = h.retry();
        if (either2 instanceof Left) {
            Left left = (Left)either2;
            HttpDate d = (HttpDate)left.value();
            l = Instant.now().until(d.toInstant(), ChronoUnit.SECONDS);
        } else if (either2 instanceof Right) {
            long secs;
            Right right = (Right)either2;
            l = secs = BoxesRunTime.unboxToLong(right.value());
        } else {
            throw new MatchError(either2);
        }
        return l;
    }

    private static final Resource nextAttempt$1(Request req, int attempts, FiniteDuration duration, Option retryHeader, Timer T$1, Concurrent F$1, Client client$1, Function3 policy$1, Function1 redactHeaderWhen$1) {
        long headerDuration = BoxesRunTime.unboxToLong(retryHeader.map((Function1<Retry$minusAfter, Object> & Serializable)h -> BoxesRunTime.boxToLong(Retry$.$anonfun$apply$4(h))).getOrElse(() -> 0L));
        FiniteDuration sleepDuration = new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(headerDuration)).seconds().max(duration);
        return package$all$.MODULE$.catsSyntaxApply(Resource$.MODULE$.eval(T$1.sleep(sleepDuration), F$1), Resource$.MODULE$.catsEffectMonadErrorForResource(F$1)).$times$greater(Retry$.prepareLoop$1(req, attempts + 1, F$1, client$1, policy$1, redactHeaderWhen$1, T$1));
    }

    public static final /* synthetic */ boolean $anonfun$apply$default$2$1(CaseInsensitiveString elem) {
        return Headers$.MODULE$.SensitiveHeaders().contains(elem);
    }

    private Retry$() {
    }
}

