/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.oauth1;

import cats.Monad;
import cats.MonadError;
import cats.Show;
import cats.Show$;
import cats.data.Chain;
import cats.data.NonEmptyList;
import cats.instances.package$order$;
import cats.kernel.Eq$;
import cats.syntax.package$all$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.http4s.Charset;
import org.http4s.Charset$;
import org.http4s.Credentials;
import org.http4s.EntityDecoder;
import org.http4s.Header;
import org.http4s.MediaType;
import org.http4s.MediaType$;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Query;
import org.http4s.Query$;
import org.http4s.Request;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.http4s.UrlForm;
import org.http4s.UrlForm$;
import org.http4s.client.oauth1.Consumer;
import org.http4s.client.oauth1.ProtocolParameter;
import org.http4s.client.oauth1.ProtocolParameter$;
import org.http4s.client.oauth1.ProtocolParameter$SignatureMethod$;
import org.http4s.client.oauth1.ProtocolParameter$Version$;
import org.http4s.client.oauth1.Token;
import org.http4s.headers.Authorization;
import org.http4s.headers.Content$minusType;
import org.http4s.internal.parboiled2.CharPredicate;
import org.http4s.syntax.StringOps$;
import org.http4s.syntax.package$string$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.AbstractIterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ListBuffer;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class package$ {
    public static final package$ MODULE$ = new package$();
    private static final String SHA1 = "HmacSHA1";
    private static final String OutOfBand = "oob";

    private String SHA1() {
        return SHA1;
    }

    private java.nio.charset.Charset UTF_8() {
        return StandardCharsets.UTF_8;
    }

    private String OutOfBand() {
        return OutOfBand;
    }

    public <F> F signRequest(Request<F> req, Consumer consumer, Option<Uri> callback, Option<String> verifier, Option<Token> token, MonadError<F, Throwable> F2, EntityDecoder<F, UrlForm> W) {
        return package$all$.MODULE$.toFunctorOps(this.getUserParams(req, F2, W), F2).map((Function1<Tuple2, Request> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Request req = (Request)tuple2._1();
            Seq params = (Seq)tuple2._2();
            Authorization auth = MODULE$.genAuthHeader(req.method(), req.uri(), params, consumer, callback, verifier, token);
            Request request = (Request)req.putHeaders(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{auth}));
            return request;
        });
    }

    public <F> F signRequest(Request<F> req, ProtocolParameter.Consumer consumer, Option<ProtocolParameter.Token> token, Option<ProtocolParameter.Realm> realm, ProtocolParameter.SignatureMethod signatureMethod, F timestampGenerator, ProtocolParameter.Version version, F nonceGenerator, Option<ProtocolParameter.Callback> callback, Option<ProtocolParameter.Verifier> verifier, MonadError<F, Throwable> F2, EntityDecoder<F, UrlForm> W) {
        return package$all$.MODULE$.toFlatMapOps(this.getUserParams(req, F2, W), F2).flatMap((Function1<Tuple2, Object> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Request req = (Request)tuple2._1();
            Seq params = (Seq)tuple2._2();
            Object object = package$all$.MODULE$.toFunctorOps(MODULE$.genAuthHeader(req.method(), req.uri(), consumer, token, realm, signatureMethod, timestampGenerator, version, nonceGenerator, callback, verifier, (Seq)params.map((Function1<Tuple2, ProtocolParameter> & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                ProtocolParameter.Custom custom = new ProtocolParameter.Custom(k, v);
                return custom;
            }), F2), F2).map((Function1<Authorization, Request> & Serializable)auth -> (Request)req.putHeaders(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{auth})));
            return object;
        });
    }

    public <F> ProtocolParameter.SignatureMethod signRequest$default$5() {
        return new ProtocolParameter.SignatureMethod(ProtocolParameter$SignatureMethod$.MODULE$.apply$default$1());
    }

    public <F> ProtocolParameter.Version signRequest$default$7() {
        return new ProtocolParameter.Version(ProtocolParameter$Version$.MODULE$.apply$default$1());
    }

    public <F> Option<ProtocolParameter.Callback> signRequest$default$9() {
        return None$.MODULE$;
    }

    public <F> Option<ProtocolParameter.Verifier> signRequest$default$10() {
        return None$.MODULE$;
    }

    public <F> F takeSigHeaders(ProtocolParameter.Consumer consumer, Option<ProtocolParameter.Token> token, ProtocolParameter.SignatureMethod signatureMethod, F timestampGenerator, ProtocolParameter.Version version, F nonceGenerator, Option<ProtocolParameter.Callback> callback, Option<ProtocolParameter.Verifier> verifier, Monad<F> evidence$1) {
        return package$all$.MODULE$.toFlatMapOps(timestampGenerator, evidence$1).flatMap((Function1<ProtocolParameter.Timestamp, Object> & Serializable)timestamp -> package$all$.MODULE$.toFunctorOps(nonceGenerator, evidence$1).map((Function1<ProtocolParameter.Nonce, List> & Serializable)nonce -> {
            List headers = (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Product[]{consumer, signatureMethod, timestamp, nonce, version}));
            return (List)headers.$plus$plus((IterableOnce)((StrictOptimizedIterableOps)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{token, callback, verifier}))).flatten(Predef$.MODULE$.$conforms()));
        }));
    }

    public <F> F genAuthHeader(Method method, Uri uri, ProtocolParameter.Consumer consumer, Option<ProtocolParameter.Token> token, Option<ProtocolParameter.Realm> realm, ProtocolParameter.SignatureMethod signatureMethod, F timestampGenerator, ProtocolParameter.Version version, F nonceGenerator, Option<ProtocolParameter.Callback> callback, Option<ProtocolParameter.Verifier> verifier, Seq<ProtocolParameter> queryParams, Monad<F> evidence$2) {
        return package$all$.MODULE$.toFunctorOps(this.takeSigHeaders(consumer, token, signatureMethod, timestampGenerator, version, nonceGenerator, callback, verifier, evidence$2), evidence$2).map((Function1<Seq, Authorization> & Serializable)headers -> {
            Show<ProtocolParameter> show = Show$.MODULE$.apply(ProtocolParameter$.MODULE$.oauth1HeaderShow());
            String baseStr = MODULE$.mkBaseString(method, uri, ((IterableOnceOps)((IterableOps)((SeqOps)headers.$plus$plus(queryParams)).sorted(package$order$.MODULE$.catsKernelOrderingForOrder(ProtocolParameter$.MODULE$.http4sClientOauth1SortForProtocolParameters()))).map((Function1<ProtocolParameter, String> & Serializable)t -> show.show((ProtocolParameter)t))).mkString("&"));
            String sig = MODULE$.makeSHASig(baseStr, consumer.secret(), token.map((Function1<ProtocolParameter.Token, String> & Serializable)x$2 -> x$2.secret()));
            Credentials.AuthParams creds = new Credentials.AuthParams(StringOps$.MODULE$.ci$extension(package$string$.MODULE$.http4sStringSyntax("OAuth")), new NonEmptyList<Tuple2<String, String>>(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("oauth_signature"), MODULE$.encode(sig)), ((IterableOnceOps)realm.fold((Function0<Seq> & Serializable)() -> (Seq)headers.map((Function1<ProtocolParameter, Tuple2> & Serializable)x$3 -> x$3.toTuple()), (Function1<ProtocolParameter.Realm, Seq> & Serializable)x$4 -> {
                Tuple2<String, String> tuple2 = x$4.toTuple();
                return (Seq)((SeqOps)headers.map((Function1<ProtocolParameter, Tuple2> & Serializable)x$5 -> x$5.toTuple())).$plus$colon(tuple2);
            })).toList()));
            return new Authorization(creds);
        });
    }

    public Authorization genAuthHeader(Method method, Uri uri, Seq<Tuple2<String, String>> userParams, Consumer consumer, Option<Uri> callback, Option<String> verifier, Option<Token> token) {
        ListBuffer<Tuple2<String, String>> params = new ListBuffer<Tuple2<String, String>>();
        params.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("oauth_consumer_key"), this.encode(consumer.key())));
        params.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("oauth_signature_method"), "HMAC-SHA1"));
        params.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("oauth_timestamp"), Long.toString(System.currentTimeMillis() / 1000L)));
        params.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("oauth_nonce"), Long.toString(System.nanoTime())));
        params.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("oauth_version"), "1.0"));
        params.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("oauth_callback"), callback.map((Function1<Uri, String> & Serializable)c -> MODULE$.encode(c.renderString())).getOrElse((Function0<String> & Serializable)() -> MODULE$.OutOfBand())));
        token.foreach((Function1<Token, ListBuffer> & Serializable)t -> (ListBuffer)params.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("oauth_token"), MODULE$.encode(t.value()))));
        verifier.foreach((Function1<String, ListBuffer> & Serializable)v -> (ListBuffer)params.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("oauth_verifier"), MODULE$.encode((String)v))));
        Object params2 = params.result();
        String baseString = this.genBaseString(method, uri, (Seq)((AbstractIterable)params2).$plus$plus((IterableOnce)userParams.map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Tuple2<String, String> tuple22 = new Tuple2<String, String>(MODULE$.encode(k), MODULE$.encode(v));
            return tuple22;
        })));
        String sig = this.makeSHASig(baseString, consumer, token);
        Credentials.AuthParams creds = new Credentials.AuthParams(StringOps$.MODULE$.ci$extension(package$string$.MODULE$.http4sStringSyntax("OAuth")), new NonEmptyList<Tuple2<String, String>>(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("oauth_signature"), this.encode(sig)), (List<Tuple2<String, String>>)params2));
        return new Authorization(creds);
    }

    public String makeSHASig(String baseString, Consumer consumer, Option<Token> token) {
        return this.makeSHASig(baseString, consumer.secret(), token.map((Function1<Token, String> & Serializable)x$6 -> x$6.secret()));
    }

    public String makeSHASig(String baseString, String consumerSecret, Option<String> tokenSecret) {
        Mac sha1 = Mac.getInstance(this.SHA1());
        String key = new StringBuilder(1).append(this.encode(consumerSecret)).append("&").append(tokenSecret.map((Function1<String, String> & Serializable)t -> MODULE$.encode((String)t)).getOrElse((Function0<String> & Serializable)() -> "")).toString();
        sha1.init(new SecretKeySpec(this.bytes(key), this.SHA1()));
        byte[] sigBytes = sha1.doFinal(this.bytes(baseString));
        return Base64.getEncoder().encodeToString(sigBytes);
    }

    public String genBaseString(Method method, Uri uri, Seq<Tuple2<String, String>> params) {
        String paramsStr = ((IterableOnceOps)((SeqOps)params.map((Function1<Tuple2, String> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            String string2 = new StringBuilder(1).append(k).append("=").append(v).toString();
            return string2;
        })).sorted(package$order$.MODULE$.catsKernelOrderingForOrder(Eq$.MODULE$.catsKernelInstancesForString()))).mkString("&");
        return this.mkBaseString(method, uri, paramsStr);
    }

    public String mkBaseString(Method method, Uri uri, String paramsStr) {
        Query x$1 = Query$.MODULE$.empty();
        None$ x$2 = None$.MODULE$;
        Option<Uri.Scheme> x$3 = uri.copy$default$1();
        Option<Uri.Authority> x$4 = uri.copy$default$2();
        String x$5 = uri.copy$default$3();
        return new $colon$colon<Nothing$>((Nothing$)((Object)method.name()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.encode(uri.copy(x$3, x$4, x$5, x$1, x$2).renderString())), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.encode(paramsStr)), Nil$.MODULE$))).mkString("&");
    }

    public String encode(String str) {
        String x$1 = str;
        boolean x$2 = false;
        CharPredicate x$3 = Uri$.MODULE$.Unreserved();
        java.nio.charset.Charset x$4 = Uri$.MODULE$.encode$default$2();
        return Uri$.MODULE$.encode(x$1, x$4, false, x$3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public <F> F getUserParams(Request<F> req, MonadError<F, Throwable> F2, EntityDecoder<F, UrlForm> W) {
        Object f;
        Vector qparams;
        block4: {
            Content$minusType t;
            block5: {
                qparams = (Vector)req.uri().query().pairs().map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    String k = (String)tuple2._1();
                    Option ov = (Option)tuple2._2();
                    Tuple2 tuple22 = new Tuple2(k, ov.getOrElse((Function0<String> & Serializable)() -> ""));
                    return tuple22;
                });
                Option<Content$minusType> option = req.contentType();
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                t = (Content$minusType)some.value();
                Method method = req.method();
                Method.Semantics.Default default_ = Method$.MODULE$.POST();
                if (!(method == null ? default_ != null : !((Object)method).equals(default_))) break block5;
                Method method2 = req.method();
                Method.Semantics.Idempotent idempotent = Method$.MODULE$.PUT();
                if (method2 != null ? !((Object)method2).equals(idempotent) : idempotent != null) break block4;
            }
            MediaType mediaType = t.mediaType();
            MediaType mediaType2 = MediaType$.MODULE$.application().x$minuswww$minusform$minusurlencoded();
            if (!(mediaType != null ? !((Object)mediaType).equals(mediaType2) : mediaType2 != null)) {
                f = package$all$.MODULE$.toFunctorOps(req.as(F2, W), F2).map((Function1<Object, Tuple2> & Serializable)urlform -> package$.$anonfun$getUserParams$3(req, qparams, ((UrlForm)urlform).values()));
                return f;
            }
        }
        f = F2.pure(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(req), qparams));
        return f;
    }

    private byte[] bytes(String str) {
        return str.getBytes(this.UTF_8());
    }

    public static final /* synthetic */ Tuple2 $anonfun$getUserParams$3(Request req$2, Vector qparams$1, Map urlform) {
        Seq bodyparams = (Seq)urlform.toSeq().flatMap((Function1<Tuple2, Seq> & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String k = (String)tuple2._1();
            Chain vs = (Chain)tuple2._2();
            Object object = vs.isEmpty() ? (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(k), "")})) : vs.toList().map((Function1<String, Tuple2> & Serializable)x$7 -> new Tuple2<String, String>(k, (String)x$7));
            return object;
        });
        Charset charset = (Charset)req$2.charset().getOrElse((Function0<Charset> & Serializable)() -> Charset$.MODULE$.UTF$minus8());
        return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(req$2.withEntity(new UrlForm(urlform), UrlForm$.MODULE$.entityEncoder(charset))), qparams$1.$plus$plus((IterableOnce)bodyparams));
    }

    private package$() {
    }
}

