/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.staticcontent;

import cats.data.Kleisli;
import cats.data.NonEmptyList;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.data.OptionT$PurePartiallyApplied$;
import cats.effect.ContextShift;
import cats.effect.Sync;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.package$all$;
import fs2.internal.FreeC;
import io.chrisdavenport.vault.Vault;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.HttpVersion;
import org.http4s.RangeUnit;
import org.http4s.RangeUnit$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.StaticFile$;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.Uri$;
import org.http4s.headers.Content$minusRange$;
import org.http4s.headers.Range;
import org.http4s.headers.Range$;
import org.http4s.headers.Range$SubRange$;
import org.http4s.server.middleware.TranslateUri$;
import org.http4s.server.staticcontent.FileService;
import org.http4s.server.staticcontent.FileService$BadTraversal$1$;
import org.http4s.server.staticcontent.package$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Array$UnapplySeqWrapper$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class FileService$ {
    public static final FileService$ MODULE$ = new FileService$();
    private static final Logger logger = LoggerFactory.getLogger("org.http4s.server.staticcontent.FileService");

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public <F> Kleisli<?, Request<F>, Response<F>> apply(FileService.Config<F> config, Sync<F> F2) {
        void var3_12;
        LazyRef BadTraversal$module = new LazyRef();
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0<Path> & Serializable)() -> Paths.get(config.systemPath(), new String[0]).toRealPath(new LinkOption[0]));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Path rootPath = (Path)success.value();
            Kleisli kleisli = TranslateUri$.MODULE$.apply(config.pathPrefix(), new Kleisli((Function1<Request, OptionT> & Serializable)x0$1 -> {
                Request request = x0$1;
                OptionT optionT = ApplicativeErrorOps$.MODULE$.recoverWith$extension(package$all$.MODULE$.catsSyntaxApplicativeError(this.resolvedPath$1(request, rootPath, F2, BadTraversal$module).flatMapF((Function1<Path, Object> & Serializable)path -> F2.delay((Function0<Option> & Serializable)() -> Files.exists(path, LinkOption.NOFOLLOW_LINKS) ? new Some<Path>(path.toRealPath(LinkOption.NOFOLLOW_LINKS)) : None$.MODULE$), F2).collect(new Serializable(rootPath){
                    private static final long serialVersionUID = 0L;
                    private final Path rootPath$1;

                    public final <A1 extends Path, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        File file = A1.startsWith(this.rootPath$1) ? A1.toFile() : function1.apply(x1);
                        return (B1)file;
                    }

                    public final boolean isDefinedAt(Path x1) {
                        Path path = x1;
                        boolean bl = path.startsWith(this.rootPath$1);
                        return bl;
                    }
                    {
                        this.rootPath$1 = rootPath$1;
                    }
                }, F2).flatMap((Function1<File, OptionT> & Serializable)f -> config.pathCollector().apply((File)f, config, request), F2).semiflatMap((Function1<Response, Object> & Serializable)x$1 -> config.cacheStrategy().cache(request.pathInfo(), x$1, F2), F2), OptionT$.MODULE$.catsDataMonadErrorForOptionT(F2)), new Serializable(F2, BadTraversal$module){
                    private static final long serialVersionUID = 0L;
                    private final Sync F$1;
                    private final LazyRef BadTraversal$module$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        A1 A1 = x2;
                        Object object = FileService$.MODULE$.org$http4s$server$staticcontent$FileService$$BadTraversal$2(this.BadTraversal$module$1).equals(A1) ? OptionT$PurePartiallyApplied$.MODULE$.apply$extension(OptionT$.MODULE$.some(), new Response<Nothing$>(Status$.MODULE$.BadRequest(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()), this.F$1) : function1.apply(x2);
                        return object;
                    }

                    public final boolean isDefinedAt(Throwable x2) {
                        Throwable throwable = x2;
                        boolean bl = FileService$.MODULE$.org$http4s$server$staticcontent$FileService$$BadTraversal$2(this.BadTraversal$module$1).equals(throwable);
                        return bl;
                    }
                    {
                        this.F$1 = F$1;
                        this.BadTraversal$module$1 = BadTraversal$module$1;
                    }
                }, OptionT$.MODULE$.catsDataMonadErrorForOptionT(F2));
                return optionT;
            }), OptionT$.MODULE$.catsDataMonoidKForOptionT(F2), F2);
            return var3_12;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof NoSuchFileException) {
                if (logger.isErrorEnabled()) {
                    logger.error(new StringBuilder(110).append("Could not find root path from FileService config: systemPath = ").append(config.systemPath()).append(", pathPrefix = ").append(config.pathPrefix()).append(". All requests will return none.").toString());
                }
                Kleisli kleisli = new Kleisli((Function1<Request, OptionT> & Serializable)x$2 -> OptionT$.MODULE$.none(F2));
                return var3_12;
            }
        }
        if (!bl) throw new MatchError(try_);
        Throwable e = failure.exception();
        if (logger.isErrorEnabled()) {
            logger.error(new StringBuilder(117).append("Could not resolve root path from FileService config: systemPath = ").append(config.systemPath()).append(", pathPrefix = ").append(config.pathPrefix()).append(". All requests will fail with a 500.").toString(), e);
        }
        Kleisli kleisli = new Kleisli((Function1<Request, OptionT> & Serializable)x$3 -> OptionT$PurePartiallyApplied$.MODULE$.apply$extension(OptionT$.MODULE$.pure(), new Response<Nothing$>(Status$.MODULE$.InternalServerError(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()), F2));
        return var3_12;
    }

    public <F> OptionT<F, Response<F>> org$http4s$server$staticcontent$FileService$$filesOnly(File file, FileService.Config<F> config, Request<F> req, Sync<F> F2, ContextShift<F> cs) {
        return new OptionT(F2.defer((Function0<Object> & Serializable)() -> file.isDirectory() ? StaticFile$.MODULE$.fromFile(new File(file, "index.html"), config.blocker(), new Some(req), F2, cs).value() : (!file.isFile() ? F2.pure(None$.MODULE$) : new OptionT(MODULE$.getPartialContentFile(file, config, req, F2, cs)).orElse((Function0<OptionT> & Serializable)() -> StaticFile$.MODULE$.fromFile(file, config.bufferSize(), config.blocker(), new Some(req), StaticFile$.MODULE$.calcETag(F2), F2, cs).map((Function1<Response, Response> & Serializable)x$4 -> (Response)x$4.putHeaders(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{package$.MODULE$.AcceptRangeHeader()})), F2), F2).value())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validRange(long start, Option<Object> end, long fileLength) {
        if (start >= fileLength) return false;
        Option<Object> option = end;
        if (option instanceof Some) {
            Some some = (Some)option;
            long end2 = BoxesRunTime.unboxToLong(some.value());
            if (start < 0L) return false;
            if (start > end2) return false;
            return true;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        if (start >= 0L) return true;
        if (fileLength + start - 1L < 0L) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private <F> F getPartialContentFile(File file, FileService.Config<F> config, Request<F> req, Sync<F> F2, ContextShift<F> cs) {
        Object f;
        Some some;
        Range range;
        Option<Header> option = Headers$.MODULE$.get$extension((List<Header>)req.headers(), Range$.MODULE$);
        if (option instanceof Some && (range = (Range)(some = (Some)option).value()) != null) {
            RangeUnit rangeUnit = range.unit();
            NonEmptyList<Range.SubRange> nonEmptyList2 = range.ranges();
            RangeUnit rangeUnit2 = RangeUnit$.MODULE$.Bytes();
            RangeUnit rangeUnit3 = rangeUnit;
            if (!(rangeUnit2 != null ? !((Object)rangeUnit2).equals(rangeUnit3) : rangeUnit3 != null) && nonEmptyList2 != null) {
                Range.SubRange subRange = nonEmptyList2.head();
                Object object = nonEmptyList2.tail();
                if (subRange != null) {
                    long s2 = subRange.first();
                    Option<Object> e = subRange.second();
                    Nil$ nil$ = scala.package$.MODULE$.Nil();
                    Object object2 = object;
                    if (!(nil$ != null ? !((Object)nil$).equals(object2) : object2 != null)) {
                        f = this.validRange(s2, e, file.length()) ? F2.defer((Function0<Object> & Serializable)() -> {
                            long size = file.length();
                            long start = s2 >= 0L ? s2 : scala.math.package$.MODULE$.max(0L, size + s2);
                            long end = scala.math.package$.MODULE$.min(size - 1L, BoxesRunTime.unboxToLong(e.getOrElse(() -> size - 1L)));
                            return StaticFile$.MODULE$.fromFile(file, start, end + 1L, config.bufferSize(), config.blocker(), new Some(req), StaticFile$.MODULE$.calcETag(F2), F2, cs).map((Function1<Response, Response> & Serializable)resp -> {
                                List<Header> hs = Headers$.MODULE$.put$extension(resp.headers(), ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{package$.MODULE$.AcceptRangeHeader(), Content$minusRange$.MODULE$.apply(Range$SubRange$.MODULE$.apply(start, end), new Some<Object>(BoxesRunTime.boxToLong(size)))}));
                                Status x$1 = Status$.MODULE$.PartialContent();
                                List<Header> x$2 = hs;
                                HttpVersion x$3 = resp.copy$default$2();
                                FreeC x$4 = resp.copy$default$4();
                                Vault x$5 = resp.copy$default$5();
                                return resp.copy(x$1, x$3, x$2, x$4, x$5);
                            }, F2).value();
                        }) : package$all$.MODULE$.toFunctorOps(F2.delay(() -> file.length()), F2).map((Function1<Object, Some> & Serializable)size -> FileService$.$anonfun$getPartialContentFile$5(BoxesRunTime.unboxToLong(size)));
                        return f;
                    }
                }
            }
        }
        f = F2.pure(None$.MODULE$);
        return f;
    }

    private static final /* synthetic */ FileService$BadTraversal$1$ BadTraversal$lzycompute$1(LazyRef BadTraversal$module$1) {
        FileService$BadTraversal$1$ fileService$BadTraversal$1$;
        LazyRef lazyRef = BadTraversal$module$1;
        synchronized (lazyRef) {
            fileService$BadTraversal$1$ = BadTraversal$module$1.initialized() ? (FileService$BadTraversal$1$)BadTraversal$module$1.value() : BadTraversal$module$1.initialize(new FileService$BadTraversal$1$());
        }
        return fileService$BadTraversal$1$;
    }

    public final FileService$BadTraversal$1$ org$http4s$server$staticcontent$FileService$$BadTraversal$2(LazyRef BadTraversal$module$1) {
        return BadTraversal$module$1.initialized() ? (FileService$BadTraversal$1$)BadTraversal$module$1.value() : FileService$.BadTraversal$lzycompute$1(BadTraversal$module$1);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final OptionT resolvedPath$1(Request x1$1, Path rootPath$1, Sync F$1, LazyRef BadTraversal$module$1) {
        Object object;
        void var5_10;
        Object object2;
        String[] stringArray = x1$1.pathInfo().split("/");
        if (stringArray != null && !Array$UnapplySeqWrapper$.MODULE$.isEmpty$extension(object2 = Array$.MODULE$.unapplySeq(stringArray)) && new Array.UnapplySeqWrapper(Array$UnapplySeqWrapper$.MODULE$.get$extension(object2)) != null && Array$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object2), 0) == 0) {
            OptionT optionT = OptionT$PurePartiallyApplied$.MODULE$.apply$extension(OptionT$.MODULE$.some(), rootPath$1, F$1);
            return var5_10;
        }
        if (stringArray != null && !Array$UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq(stringArray)) && new Array.UnapplySeqWrapper(Array$UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 1) >= 0) {
            String head = (String)Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
            Seq segments = Array$UnapplySeqWrapper$.MODULE$.drop$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
            if (head.isEmpty()) {
                OptionT optionT = OptionT$.MODULE$.liftF(F$1.catchNonFatal((Function0<Path> & Serializable)() -> segments.foldLeft(rootPath$1, (Function2<Path, String, Path> & Serializable)(x0$1, x1$1) -> {
                    String segment;
                    String string2;
                    boolean bl;
                    Tuple2<Path, String> tuple2 = new Tuple2<Path, String>((Path)x0$1, (String)x1$1);
                    if (tuple2 != null && (bl = "".equals(string2 = tuple2._2()) ? true : (".".equals(string2) ? true : "..".equals(string2)))) {
                        throw this.org$http4s$server$staticcontent$FileService$$BadTraversal$2(BadTraversal$module$1);
                    }
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    Path path = tuple2._1();
                    String x$1 = segment = tuple2._2();
                    boolean x$2 = true;
                    Charset x$3 = Uri$.MODULE$.decode$default$2();
                    Function1<Object, Object> x$4 = Uri$.MODULE$.decode$default$4();
                    Path path2 = path.resolve(Uri$.MODULE$.decode(x$1, x$3, true, x$4));
                    return path2;
                }), $less$colon$less$.MODULE$.refl()), F$1);
                return var5_10;
            }
        }
        OptionT optionT = OptionT$.MODULE$.none(F$1);
        return var5_10;
    }

    public static final /* synthetic */ Some $anonfun$getPartialContentFile$5(long size) {
        Status x$6 = Status$.MODULE$.RangeNotSatisfiable();
        List<Header> x$7 = Headers$.MODULE$.of(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{package$.MODULE$.AcceptRangeHeader(), Content$minusRange$.MODULE$.apply(Range$SubRange$.MODULE$.apply(0L, size - 1L), new Some<Object>(BoxesRunTime.boxToLong(size)))}));
        HttpVersion x$8 = Response$.MODULE$.apply$default$2();
        FreeC<Nothing$, Object, BoxedUnit> x$9 = Response$.MODULE$.apply$default$4();
        Vault x$10 = Response$.MODULE$.apply$default$5();
        return new Some<Response<Nothing$>>(new Response<Nothing$>(x$6, x$8, x$7, x$9, x$10));
    }

    private FileService$() {
    }
}

