/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import org.jline.utils.NonBlockingInputStream;
import org.jline.utils.NonBlockingInputStreamImpl;
import org.jline.utils.NonBlockingPumpInputStream;
import org.jline.utils.NonBlockingPumpReader;
import org.jline.utils.NonBlockingReader;
import org.jline.utils.NonBlockingReaderImpl;

public class NonBlocking {
    public static NonBlockingPumpReader nonBlockingPumpReader() {
        return new NonBlockingPumpReader();
    }

    public static NonBlockingPumpReader nonBlockingPumpReader(int size) {
        return new NonBlockingPumpReader(size);
    }

    public static NonBlockingPumpInputStream nonBlockingPumpInputStream() {
        return new NonBlockingPumpInputStream();
    }

    public static NonBlockingPumpInputStream nonBlockingPumpInputStream(int size) {
        return new NonBlockingPumpInputStream(size);
    }

    public static NonBlockingInputStream nonBlockingStream(NonBlockingReader reader, Charset encoding) {
        return new NonBlockingReaderInputStream(reader, encoding);
    }

    public static NonBlockingInputStream nonBlocking(String name, InputStream inputStream2) {
        if (inputStream2 instanceof NonBlockingInputStream) {
            return (NonBlockingInputStream)inputStream2;
        }
        return new NonBlockingInputStreamImpl(name, inputStream2);
    }

    public static NonBlockingReader nonBlocking(String name, Reader reader) {
        if (reader instanceof NonBlockingReader) {
            return (NonBlockingReader)reader;
        }
        return new NonBlockingReaderImpl(name, reader);
    }

    public static NonBlockingReader nonBlocking(String name, InputStream inputStream2, Charset encoding) {
        return new NonBlockingInputStreamReader(NonBlocking.nonBlocking(name, inputStream2), encoding);
    }

    private static class NonBlockingInputStreamReader
    extends NonBlockingReader {
        private final NonBlockingInputStream input;
        private final CharsetDecoder decoder;
        private final ByteBuffer bytes;
        private final CharBuffer chars;

        public NonBlockingInputStreamReader(NonBlockingInputStream inputStream2, Charset encoding) {
            this(inputStream2, (encoding != null ? encoding : Charset.defaultCharset()).newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE));
        }

        public NonBlockingInputStreamReader(NonBlockingInputStream input, CharsetDecoder decoder) {
            this.input = input;
            this.decoder = decoder;
            this.bytes = ByteBuffer.allocate(4);
            this.chars = CharBuffer.allocate(2);
            this.bytes.limit(0);
            this.chars.limit(0);
        }

        @Override
        protected int read(long timeout, boolean isPeek) throws IOException {
            boolean isInfinite;
            boolean bl = isInfinite = timeout <= 0L;
            while (!this.chars.hasRemaining() && (isInfinite || timeout > 0L)) {
                int b;
                long start = 0L;
                if (!isInfinite) {
                    start = System.currentTimeMillis();
                }
                if ((b = this.input.read(timeout)) == -1) {
                    return -1;
                }
                if (b >= 0) {
                    if (!this.bytes.hasRemaining()) {
                        this.bytes.position(0);
                        this.bytes.limit(0);
                    }
                    int l = this.bytes.limit();
                    this.bytes.array()[this.bytes.arrayOffset() + l] = (byte)b;
                    this.bytes.limit(l + 1);
                    this.chars.clear();
                    this.decoder.decode(this.bytes, this.chars, false);
                    this.chars.flip();
                }
                if (isInfinite) continue;
                timeout -= System.currentTimeMillis() - start;
            }
            if (this.chars.hasRemaining()) {
                if (isPeek) {
                    return this.chars.get(this.chars.position());
                }
                return this.chars.get();
            }
            return -2;
        }

        @Override
        public int readBuffered(char[] b) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (b.length == 0) {
                return 0;
            }
            if (this.chars.hasRemaining()) {
                int r = Math.min(b.length, this.chars.remaining());
                this.chars.get(b);
                return r;
            }
            byte[] buf = new byte[b.length];
            int l = this.input.readBuffered(buf);
            if (l < 0) {
                return l;
            }
            ByteBuffer bytes = ByteBuffer.wrap(buf, 0, l);
            CharBuffer chars = CharBuffer.wrap(b);
            this.decoder.decode(bytes, chars, false);
            chars.flip();
            return chars.remaining();
        }

        @Override
        public void shutdown() {
            this.input.shutdown();
        }

        @Override
        public void close() throws IOException {
            this.input.close();
        }
    }

    private static class NonBlockingReaderInputStream
    extends NonBlockingInputStream {
        private final NonBlockingReader reader;
        private final CharsetEncoder encoder;
        private final ByteBuffer bytes;
        private final CharBuffer chars;

        private NonBlockingReaderInputStream(NonBlockingReader reader, Charset charset) {
            this.reader = reader;
            this.encoder = charset.newEncoder().onUnmappableCharacter(CodingErrorAction.REPLACE).onMalformedInput(CodingErrorAction.REPLACE);
            this.bytes = ByteBuffer.allocate(4);
            this.chars = CharBuffer.allocate(2);
            this.bytes.limit(0);
            this.chars.limit(0);
        }

        @Override
        public int available() {
            return (int)((float)this.reader.available() * this.encoder.averageBytesPerChar()) + this.bytes.remaining();
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }

        @Override
        public int read(long timeout, boolean isPeek) throws IOException {
            boolean isInfinite;
            boolean bl = isInfinite = timeout <= 0L;
            while (!this.bytes.hasRemaining() && (isInfinite || timeout > 0L)) {
                int c;
                long start = 0L;
                if (!isInfinite) {
                    start = System.currentTimeMillis();
                }
                if ((c = this.reader.read(timeout)) == -1) {
                    return -1;
                }
                if (c >= 0) {
                    if (!this.chars.hasRemaining()) {
                        this.chars.position(0);
                        this.chars.limit(0);
                    }
                    int l = this.chars.limit();
                    this.chars.array()[this.chars.arrayOffset() + l] = (char)c;
                    this.chars.limit(l + 1);
                    this.bytes.clear();
                    this.encoder.encode(this.chars, this.bytes, false);
                    this.bytes.flip();
                }
                if (isInfinite) continue;
                timeout -= System.currentTimeMillis() - start;
            }
            if (this.bytes.hasRemaining()) {
                if (isPeek) {
                    return this.bytes.get(this.bytes.position());
                }
                return this.bytes.get();
            }
            return -2;
        }
    }
}

