/*
 * Decompiled with CFR 0.152.
 */
package slick.util;

import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.NonLocalReturnControl$mcZ$sp;
import slick.util.AsyncExecutor;
import slick.util.AsyncExecutor$Continuation$;
import slick.util.AsyncExecutor$Fresh$;
import slick.util.AsyncExecutor$WithConnection$;
import slick.util.InternalArrayQueue;
import slick.util.Logging;
import slick.util.ManagedArrayBlockingQueue$;
import slick.util.SlickLogger;

@ScalaSignature(bytes="\u0006\u0005\t%a\u0001\u0002\u0015*\u00019B\u0001B\u0017\u0001\u0003\u0002\u0003\u0006Ia\u0017\u0005\t=\u0002\u0011\t\u0011)A\u00057\"Aq\f\u0001B\u0001B\u0003%\u0001\rC\u0003d\u0001\u0011\u0005A\r\u0003\u0007j\u0001\u0011\u0005\tQ!A\u0001B\u0003%!\u000e\u0003\u0004q\u0001\u0001\u0006I!\u001d\u0005\u0007i\u0002\u0001\u000b\u0011B9\t\rU\u0004\u0001\u0015\"\u0003w\u0011\u001dy\b\u0001)C\u0005\u0003\u0003A\u0001\"a\u0002\u0001A\u0003%\u0011\u0011\u0002\u0005\t\u0003\u001f\u0001\u0001\u0015!\u0003\u0002\n!A\u0011\u0011\u0003\u0001!\n\u0013\t\u0019\u0002C\u0004\u0002\u0016\u0001\u0001\u000b\u0015B.\t\u000f\u0005]\u0001\u0001)Q\u0005A\"A\u0011\u0011\u0004\u0001\u0005\u0002%\nY\u0002\u0003\u0005\u0002\"\u0001!\t!KA\u0012\u0011!\t)\u0003\u0001Q\u0005\n\u0005\u001d\u0002bBA\u0016\u0001\u0011\u0005\u0011Q\u0006\u0005\b\u0003c\u0001A\u0011AA\u001a\u0011\u001d\tY\u0003\u0001C\u0001\u0003oA\u0001\"a\u0014\u0001A\u0013%\u0011\u0011\u000b\u0005\b\u0003'\u0002A\u0011AA)\u0011\u001d\t)\u0006\u0001C\u0001\u0003#Bq!a\u0015\u0001\t\u0003\t9\u0006C\u0004\u0002^\u0001!\t!!\u0015\t\u000f\u0005}\u0003\u0001\"\u0001\u0002b!9\u00111\r\u0001\u0005\u0002\u0005\u0005\u0004bBA3\u0001\u0011\u0005\u0013q\r\u0005\b\u0003[\u0002A\u0011IA8\u0011\u001d\t\u0019\b\u0001C!\u0003GAq!!\u001e\u0001\t\u0003\t9\bC\u0004\u0002v\u0001!\t!a%\t\u000f\u0005\u0015\u0006\u0001\"\u0001\u0002(\"A\u0011q\u0016\u0001!\n\u0013\t\t\f\u0003\u0005\u0002V\u0002\u0001K\u0011BAl\u000f%\t)/KA\u0001\u0012\u0003\t9O\u0002\u0005)S\u0005\u0005\t\u0012AAu\u0011\u0019\u0019W\u0005\"\u0001\u0002l\"I\u0011Q^\u0013\u0012\u0002\u0013\u0005\u0011q\u001e\u0002\u001a\u001b\u0006t\u0017mZ3e\u0003J\u0014\u0018-\u001f\"m_\u000e\\\u0017N\\4Rk\u0016,XM\u0003\u0002+W\u0005!Q\u000f^5m\u0015\u0005a\u0013!B:mS\u000e\\7\u0001A\u000b\u0003_e\u001aB\u0001\u0001\u0019Q-B\u0019\u0011'N\u001c\u000e\u0003IR!AK\u001a\u000b\u0003Q\nAA[1wC&\u0011aG\r\u0002\u000e\u0003\n\u001cHO]1diF+X-^3\u0011\u0005aJD\u0002\u0001\u0003\u0006u\u0001\u0011\ra\u000f\u0002\u0002\u000bF\u0011AH\u0011\t\u0003{\u0001k\u0011A\u0010\u0006\u0002\u007f\u0005)1oY1mC&\u0011\u0011I\u0010\u0002\u0005\u001dVdG\u000e\u0005\u0002D\u001b:\u0011Ai\u0013\b\u0003\u000b*s!AR%\u000e\u0003\u001dS!\u0001S\u0017\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0013B\u0001\u0016,\u0013\ta\u0015&A\u0007Bgft7-\u0012=fGV$xN]\u0005\u0003\u001d>\u00131\u0003\u0015:j_JLG/\u001b>fIJ+hN\\1cY\u0016T!\u0001T\u0015\u0011\u0007E#v'D\u0001S\u0015\t\u0019&'\u0001\u0006d_:\u001cWO\u001d:f]RL!!\u0016*\u0003\u001b\tcwnY6j]\u001e\fV/Z;f!\t9\u0006,D\u0001*\u0013\tI\u0016FA\u0004M_\u001e<\u0017N\\4\u0002\u00195\f\u00070[7v[&sWk]3\u0011\u0005ub\u0016BA/?\u0005\rIe\u000e^\u0001\tG\u0006\u0004\u0018mY5us\u0006!a-Y5s!\ti\u0014-\u0003\u0002c}\t9!i\\8mK\u0006t\u0017A\u0002\u001fj]&$h\b\u0006\u0003fM\u001eD\u0007cA,\u0001o!)!\f\u0002a\u00017\")a\f\u0002a\u00017\"9q\f\u0002I\u0001\u0002\u0004\u0001\u0017AK:mS\u000e\\G%\u001e;jY\u0012j\u0015M\\1hK\u0012\f%O]1z\u00052|7m[5oOF+X-^3%I1|7m\u001b\t\u0003W:l\u0011\u0001\u001c\u0006\u0003[J\u000bQ\u0001\\8dWNL!a\u001c7\u0003\u001bI+WM\u001c;sC:$Hj\\2l\u0003!qw\u000e^#naRL\bCA6s\u0013\t\u0019HNA\u0005D_:$\u0017\u000e^5p]\u0006\u0001\u0012\u000e^3n#V,W/\u001a(pi\u001a+H\u000e\\\u0001\rG\",7m\u001b(pi:+H\u000e\u001c\u000b\u0003oj\u0004\"!\u0010=\n\u0005et$\u0001B+oSRDQa\u001f\u0005A\u0002q\f\u0011A\u001e\t\u0003{uL!A  \u0003\r\u0005s\u0017PU3g\u00035\u0019\u0007.Z2l\u001d>$\u0018J\\+tKR\u0019q/a\u0001\t\r\u0005\u0015\u0011\u00021\u00018\u0003\u0005)\u0017!C5uK6\fV/Z;f!\u00119\u00161B\u001c\n\u0007\u00055\u0011F\u0001\nJ]R,'O\\1m\u0003J\u0014\u0018-_)vKV,\u0017!\u00055jO\"\u0004&/[8Ji\u0016l\u0017+^3vK\u000611m\\;oiN,\u0012aW\u0001\u000bS:,6/Z\"pk:$\u0018A\u00029bkN,G-\u0001\nj]\u000e\u0014X-Y:f\u0013:,6/Z\"pk:$HcA<\u0002\u001e!1\u0011qD\bA\u0002\t\u000b!\u0001\u001d:\u0002%\u0011,7M]3bg\u0016Le.V:f\u0007>,h\u000e\u001e\u000b\u0002o\u00061\u0011N\\:feR$2\u0001YA\u0015\u0011\u0019\t)!\u0005a\u0001o\u0005)qN\u001a4feR\u0019\u0001-a\f\t\r\u0005\u0015!\u00031\u00018\u0003\r\u0001X\u000f\u001e\u000b\u0004o\u0006U\u0002BBA\u0003'\u0001\u0007q\u0007F\u0004a\u0003s\tY$!\u0012\t\r\u0005\u0015A\u00031\u00018\u0011\u001d\ti\u0004\u0006a\u0001\u0003\u007f\tq\u0001^5nK>,H\u000fE\u0002>\u0003\u0003J1!a\u0011?\u0005\u0011auN\\4\t\u000f\u0005\u001dC\u00031\u0001\u0002J\u0005!QO\\5u!\r\t\u00161J\u0005\u0004\u0003\u001b\u0012&\u0001\u0003+j[\u0016,f.\u001b;\u0002\u000f\u0015DHO]1diR\tq'\u0001\u0003q_2d\u0017\u0001\u0002;bW\u0016$RaNA-\u00037Bq!!\u0010\u0019\u0001\u0004\ty\u0004C\u0004\u0002Ha\u0001\r!!\u0013\u0002\tA,Wm[\u0001\u0005g&TX\rF\u0001\\\u0003E\u0011X-\\1j]&twmQ1qC\u000eLG/_\u0001\u0007e\u0016lwN^3\u0015\u0007\u0001\fI\u0007\u0003\u0004\u0002lq\u0001\r\u0001`\u0001\u0002_\u0006A1m\u001c8uC&t7\u000fF\u0002a\u0003cBa!a\u001b\u001e\u0001\u0004a\u0018!B2mK\u0006\u0014\u0018a\u00023sC&tGk\u001c\u000b\u00047\u0006e\u0004bBA>?\u0001\u0007\u0011QP\u0001\u0002GB\"\u0011qPAD!\u0015\t\u0014\u0011QAC\u0013\r\t\u0019I\r\u0002\u000b\u0007>dG.Z2uS>t\u0007c\u0001\u001d\u0002\b\u0012a\u0011\u0011RA=\u0003\u0003\u0005\tQ!\u0001\u0002\f\n\u0019q\fJ\u0019\u0012\u0007]\ni\tE\u0002>\u0003\u001fK1!!%?\u0005\r\te.\u001f\u000b\u00067\u0006U\u0015\u0011\u0015\u0005\b\u0003w\u0002\u0003\u0019AALa\u0011\tI*!(\u0011\u000bE\n\t)a'\u0011\u0007a\ni\n\u0002\u0007\u0002 \u0006U\u0015\u0011!A\u0001\u0006\u0003\tYIA\u0002`IIBa!a)!\u0001\u0004Y\u0016aC7bq\u0016cW-\\3oiN\f\u0001\"\u001b;fe\u0006$xN\u001d\u000b\u0003\u0003S\u0003B!MAVo%\u0019\u0011Q\u0016\u001a\u0003\u0011%#XM]1u_J\fa\u0001\\8dW\u0016$W\u0003BAZ\u0003o#B!!.\u0002DB\u0019\u0001(a.\u0005\u000f\u0005e&E1\u0001\u0002<\n\tA+\u0005\u0003\u0002>\u00065\u0005cA\u001f\u0002@&\u0019\u0011\u0011\u0019 \u0003\u000f9{G\u000f[5oO\"A\u0011Q\u0019\u0012\u0005\u0002\u0004\t9-A\u0001g!\u0015i\u0014\u0011ZA[\u0013\r\tYM\u0010\u0002\ty\tLh.Y7f}!\u001a!%a4\u0011\u0007u\n\t.C\u0002\u0002Tz\u0012a!\u001b8mS:,\u0017a\u00057pG.,G-\u00138uKJ\u0014X\u000f\u001d;jE2LX\u0003BAm\u0003;$B!a7\u0002`B\u0019\u0001(!8\u0005\u000f\u0005e6E1\u0001\u0002<\"A\u0011QY\u0012\u0005\u0002\u0004\t\t\u000fE\u0003>\u0003\u0013\fY\u000eK\u0002$\u0003\u001f\f\u0011$T1oC\u001e,G-\u0011:sCf\u0014En\\2lS:<\u0017+^3vKB\u0011q+J\n\u0003Kq$\"!a:\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\u0011\t\tPa\u0002\u0016\u0005\u0005M(f\u00011\u0002v.\u0012\u0011q\u001f\t\u0005\u0003s\u0014\u0019!\u0004\u0002\u0002|*!\u0011Q`A\u0000\u0003%)hn\u00195fG.,GMC\u0002\u0003\u0002y\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0011)!a?\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rB\u0003;O\t\u00071\b")
public class ManagedArrayBlockingQueue<E extends AsyncExecutor.PrioritizedRunnable>
extends AbstractQueue<E>
implements BlockingQueue<E>,
Logging {
    private final int maximumInUse;
    private final int capacity;
    public final ReentrantLock slick$util$ManagedArrayBlockingQueue$$lock;
    private final Condition notEmpty;
    private final Condition itemQueueNotFull;
    private final InternalArrayQueue<E> itemQueue;
    private final InternalArrayQueue<E> highPrioItemQueue;
    private int inUseCount;
    private boolean paused;
    private SlickLogger logger;
    private volatile boolean bitmap$0;

    public static <E extends AsyncExecutor.PrioritizedRunnable> boolean $lessinit$greater$default$3() {
        return ManagedArrayBlockingQueue$.MODULE$.$lessinit$greater$default$3();
    }

    private SlickLogger logger$lzycompute() {
        ManagedArrayBlockingQueue managedArrayBlockingQueue = this;
        synchronized (managedArrayBlockingQueue) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public SlickLogger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    private void checkNotNull(Object v) {
        if (v == null) {
            throw new NullPointerException();
        }
    }

    private void checkNotInUse(E e) {
        Predef$.MODULE$.require(!e.inUseCounterSet(), (Function0<Object>)(Function0<String> & Serializable)() -> "in use count is already set");
    }

    private int counts() {
        return (this.paused ? 0 : this.itemQueue.count()) + this.highPrioItemQueue.count();
    }

    public void increaseInUseCount(AsyncExecutor.PrioritizedRunnable pr) {
        this.locked(() -> {
            block1: {
                if (pr.inUseCounterSet()) break block1;
                Predef$.MODULE$.require($this.inUseCount < $this.maximumInUse, (Function0<Object>)(Function0<String> & Serializable)() -> "count cannot be increased");
                ++$this.inUseCount;
                pr.inUseCounterSet_$eq(true);
                if ($this.inUseCount == $this.maximumInUse) {
                    this.logger().debug((Function0<String> & Serializable)() -> "pausing");
                    $this.paused = true;
                }
            }
        });
    }

    public void decreaseInUseCount() {
        this.locked(() -> {
            block1: {
                Predef$.MODULE$.require($this.inUseCount > 0, (Function0<Object>)(Function0<String> & Serializable)() -> "count cannot be decreased");
                --$this.inUseCount;
                if ($this.inUseCount != $this.maximumInUse - 1) break block1;
                this.logger().debug((Function0<String> & Serializable)() -> "resuming");
                $this.paused = false;
                if (this.counts() > 0) {
                    $this.notEmpty.signalAll();
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private boolean insert(E e) {
        void var3_4;
        block6: {
            boolean bl;
            AsyncExecutor.Priority priority = e.priority();
            if (AsyncExecutor$WithConnection$.MODULE$.equals(priority)) {
                bl = this.highPrioItemQueue.insert(e);
            } else if (AsyncExecutor$Continuation$.MODULE$.equals(priority)) {
                bl = this.itemQueue.insert(e);
            } else if (AsyncExecutor$Fresh$.MODULE$.equals(priority)) {
                bl = this.itemQueue.count() < this.capacity ? this.itemQueue.insert(e) : false;
            } else {
                throw new MatchError(priority);
            }
            boolean r = bl;
            if (!r) break block6;
            this.notEmpty.signal();
        }
        return (boolean)var3_4;
    }

    @Override
    public boolean offer(E e) {
        this.checkNotNull(e);
        this.checkNotInUse(e);
        return BoxesRunTime.unboxToBoolean(this.locked(() -> this.insert(e)));
    }

    @Override
    public void put(E e) {
        this.checkNotNull(e);
        this.checkNotInUse(e);
        this.lockedInterruptibly(() -> {
            while (true) {
                AsyncExecutor.Priority priority = e.priority();
                AsyncExecutor$Fresh$ asyncExecutor$Fresh$ = AsyncExecutor$Fresh$.MODULE$;
                if ((priority != null ? !priority.equals(asyncExecutor$Fresh$) : asyncExecutor$Fresh$ != null) || $this.itemQueue.count() < $this.capacity) break;
                $this.itemQueueNotFull.await();
            }
            return this.insert(e);
        });
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) {
        boolean bl;
        Object object = new Object();
        try {
            this.checkNotNull(e);
            this.checkNotInUse(e);
            LongRef nanos = LongRef.create(unit.toNanos(timeout));
            bl = BoxesRunTime.unboxToBoolean(this.lockedInterruptibly(() -> {
                while (true) {
                    AsyncExecutor.Priority priority = e.priority();
                    AsyncExecutor$Fresh$ asyncExecutor$Fresh$ = AsyncExecutor$Fresh$.MODULE$;
                    if ((priority != null ? !priority.equals(asyncExecutor$Fresh$) : asyncExecutor$Fresh$ != null) || $this.itemQueue.count() < $this.capacity) break;
                    if (nanos$1.elem <= 0L) {
                        throw new NonLocalReturnControl$mcZ$sp(object, false);
                    }
                    nanos$1.elem = $this.itemQueueNotFull.awaitNanos(nanos$1.elem);
                }
                return this.insert(e);
            }));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private E extract() {
        AsyncExecutor.PrioritizedRunnable prioritizedRunnable;
        if (this.highPrioItemQueue.count() != 0) {
            prioritizedRunnable = (AsyncExecutor.PrioritizedRunnable)this.highPrioItemQueue.extract();
        } else if (!this.paused && this.itemQueue.count() != 0) {
            void var1_1;
            AsyncExecutor.PrioritizedRunnable item = (AsyncExecutor.PrioritizedRunnable)this.itemQueue.extract();
            this.increaseInUseCount(item);
            prioritizedRunnable = var1_1;
        } else {
            prioritizedRunnable = null;
        }
        return (E)prioritizedRunnable;
    }

    @Override
    public E poll() {
        return (E)((AsyncExecutor.PrioritizedRunnable)this.locked((Function0<AsyncExecutor.PrioritizedRunnable> & Serializable)() -> this.extract()));
    }

    @Override
    public E take() {
        return (E)((AsyncExecutor.PrioritizedRunnable)this.lockedInterruptibly((Function0<AsyncExecutor.PrioritizedRunnable> & Serializable)() -> {
            while (this.counts() == 0) {
                $this.notEmpty.await();
            }
            return this.extract();
        }));
    }

    @Override
    public E poll(long timeout, TimeUnit unit) {
        AsyncExecutor.PrioritizedRunnable prioritizedRunnable;
        Object object = new Object();
        try {
            LongRef nanos = LongRef.create(unit.toNanos(timeout));
            prioritizedRunnable = (AsyncExecutor.PrioritizedRunnable)this.lockedInterruptibly((Function0<AsyncExecutor.PrioritizedRunnable> & Serializable)() -> {
                while (this.counts() == 0) {
                    if (nanos$2.elem <= 0L) {
                        throw new NonLocalReturnControl<Object>(object, null);
                    }
                    nanos$2.elem = $this.notEmpty.awaitNanos(nanos$2.elem);
                }
                return this.extract();
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                prioritizedRunnable = (AsyncExecutor.PrioritizedRunnable)ex.value();
            }
            throw ex;
        }
        return (E)prioritizedRunnable;
    }

    @Override
    public E peek() {
        return (E)((AsyncExecutor.PrioritizedRunnable)this.locked((Function0<AsyncExecutor.PrioritizedRunnable> & Serializable)() -> {
            AsyncExecutor.PrioritizedRunnable e;
            return this.counts() == 0 ? null : ((e = (AsyncExecutor.PrioritizedRunnable)$this.highPrioItemQueue.peek()) != null ? e : (AsyncExecutor.PrioritizedRunnable)$this.itemQueue.peek());
        }));
    }

    @Override
    public int size() {
        return BoxesRunTime.unboxToInt(this.locked(() -> $this.itemQueue.count() + $this.highPrioItemQueue.count()));
    }

    @Override
    public int remainingCapacity() {
        return package$.MODULE$.max(BoxesRunTime.unboxToInt(this.locked(() -> $this.capacity - $this.itemQueue.count())), 0);
    }

    @Override
    public boolean remove(Object o) {
        return o == null ? false : BoxesRunTime.unboxToBoolean(this.locked(() -> {
            void var2_2;
            if ($this.highPrioItemQueue.remove(o)) return true;
            boolean r = $this.itemQueue.remove(o);
            if (r && this.remainingCapacity() != 0) {
                $this.itemQueueNotFull.signalAll();
            }
            if (var2_2 == false) return false;
            return true;
        }));
    }

    @Override
    public boolean contains(Object o) {
        return BoxesRunTime.unboxToBoolean(this.locked(() -> $this.itemQueue.contains(o) || $this.highPrioItemQueue.contains(o)));
    }

    @Override
    public void clear() {
        this.locked(() -> {
            $this.itemQueue.clear();
            $this.highPrioItemQueue.clear();
            $this.itemQueueNotFull.signalAll();
        });
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        return BoxesRunTime.unboxToInt(this.locked(() -> {
            void var2_2;
            block0: {
                int n = $this.highPrioItemQueue.drainTo(c) + $this.itemQueue.drainTo(c);
                if (this.remainingCapacity() == 0) break block0;
                $this.itemQueueNotFull.signalAll();
            }
            return (int)var2_2;
        }));
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        return BoxesRunTime.unboxToInt(this.locked(() -> {
            void var3_3;
            block1: {
                int n = $this.highPrioItemQueue.drainTo(c, maxElements);
                if (n < maxElements) {
                    n += $this.itemQueue.drainTo(c, maxElements - n);
                }
                if (this.remainingCapacity() == 0) break block1;
                $this.itemQueueNotFull.signalAll();
            }
            return (int)var3_3;
        }));
    }

    @Override
    public java.util.Iterator<E> iterator() {
        Iterator items = (Iterator)this.locked((Function0<Iterator> & Serializable)() -> JavaConverters$.MODULE$.asScalaIteratorConverter($this.highPrioItemQueue.iterator()).asScala().$plus$plus((Function0<Iterator> & Serializable)() -> JavaConverters$.MODULE$.asScalaIteratorConverter($this.itemQueue.iterator()).asScala()).toList().toIterator());
        return new java.util.Iterator<E>(null, items){
            private final Iterator items$1;

            public void forEachRemaining(Consumer<? super E> x$1) {
                java.util.Iterator.super.forEachRemaining(x$1);
            }

            public boolean hasNext() {
                return this.items$1.hasNext();
            }

            public E next() {
                return (E)((AsyncExecutor.PrioritizedRunnable)this.items$1.next());
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
            {
                this.items$1 = items$1;
            }
        };
    }

    private <T> T locked(Function0<T> f) {
        T t;
        this.slick$util$ManagedArrayBlockingQueue$$lock.lock();
        try {
            t = f.apply();
        }
        finally {
            this.slick$util$ManagedArrayBlockingQueue$$lock.unlock();
        }
        return t;
    }

    private <T> T lockedInterruptibly(Function0<T> f) {
        T t;
        this.slick$util$ManagedArrayBlockingQueue$$lock.lockInterruptibly();
        try {
            t = f.apply();
        }
        finally {
            this.slick$util$ManagedArrayBlockingQueue$$lock.unlock();
        }
        return t;
    }

    public ManagedArrayBlockingQueue(int maximumInUse, int capacity, boolean fair) {
        this.maximumInUse = maximumInUse;
        this.capacity = capacity;
        Logging.$init$(this);
        this.slick$util$ManagedArrayBlockingQueue$$lock = new ReentrantLock(fair);
        this.notEmpty = this.slick$util$ManagedArrayBlockingQueue$$lock.newCondition();
        this.itemQueueNotFull = this.slick$util$ManagedArrayBlockingQueue$$lock.newCondition();
        this.itemQueue = new InternalArrayQueue(2 * capacity);
        this.highPrioItemQueue = new InternalArrayQueue(capacity);
        this.inUseCount = 0;
        this.paused = false;
    }
}

