/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.internals;

import cats.effect.IO;
import cats.effect.IO$Async$;
import cats.effect.internals.ArrayStack;
import cats.effect.internals.IOConnection;
import cats.effect.internals.IOConnection$;
import cats.effect.internals.IOContext;
import cats.effect.internals.IOFrame;
import cats.effect.internals.IORunLoop;
import cats.effect.internals.TracingPlatform;
import cats.effect.tracing.IOEvent;
import cats.effect.tracing.IOTrace$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Function4;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.AbstractIterable;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.NameTransformer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.control.NonFatal$;

public final class IORunLoop$ {
    public static final IORunLoop$ MODULE$ = new IORunLoop$();
    private static final List<String> runLoopFilter = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"cats.effect.", "scala.runtime."}));
    private static final int maxAutoCancelableBatchSize = 512;

    public <A> void start(IO<A> source, Function1<Either<Throwable, A>, BoxedUnit> cb) {
        this.cats$effect$internals$IORunLoop$$loop(source, IOConnection$.MODULE$.uncancelable(), cb, null, null, null, null);
    }

    public <A> void restart(IO<A> source, IOContext ctx, Function1<Either<Throwable, A>, BoxedUnit> cb) {
        this.cats$effect$internals$IORunLoop$$loop(source, IOConnection$.MODULE$.uncancelable(), cb, ctx, null, null, null);
    }

    public <A> void startCancelable(IO<A> source, IOConnection conn, Function1<Either<Throwable, A>, BoxedUnit> cb) {
        this.cats$effect$internals$IORunLoop$$loop(source, conn, cb, null, null, null, null);
    }

    public <A> void restartCancelable(IO<A> source, IOConnection conn, IOContext ctx, Function1<Either<Throwable, A>, BoxedUnit> cb) {
        this.cats$effect$internals$IORunLoop$$loop(source, conn, cb, ctx, null, null, null);
    }

    public void cats$effect$internals$IORunLoop$$loop(IO<Object> source, IOConnection cancelable, Function1<Either<Throwable, Object>, BoxedUnit> cb, IOContext ctxRef, IORunLoop.RestartCallback rcbRef, Function1<Object, IO<Object>> bFirstRef, ArrayStack<Function1<Object, IO<Object>>> bRestRef) {
        IO currentIO = source;
        IOConnection conn = cancelable;
        IOContext ctx = ctxRef;
        IO.Map bFirst = bFirstRef;
        ArrayStack<Function1<Object, IO<Object>>> bRest = bRestRef;
        IORunLoop.RestartCallback rcb = rcbRef;
        boolean hasUnboxed = false;
        Object unboxed = null;
        int currentIndex = 0;
        do {
            BoxedUnit boxedUnit;
            IO<Object> iO;
            if ((iO = currentIO) instanceof IO.Bind) {
                IO.Bind bind = (IO.Bind)iO;
                IO fa = bind.source();
                Function1 bindNext = bind.f();
                if (TracingPlatform.isStackTracing) {
                    Object trace;
                    if (ctx == null) {
                        ctx = new IOContext();
                    }
                    if ((trace = bind.trace()) != null) {
                        ctx.pushEvent((IOEvent)trace);
                    }
                }
                if (bFirst != null) {
                    if (bRest == null) {
                        bRest = new ArrayStack();
                    }
                    bRest.push(bFirst);
                }
                bFirst = bindNext;
                currentIO = fa;
                boxedUnit = BoxedUnit.UNIT;
            } else if (iO instanceof IO.Pure) {
                IO.Pure pure = (IO.Pure)iO;
                Object value = pure.a();
                unboxed = value;
                hasUnboxed = true;
                boxedUnit = BoxedUnit.UNIT;
            } else if (iO instanceof IO.Delay) {
                BoxedUnit boxedUnit2;
                IO.Delay delay = (IO.Delay)iO;
                Function0 thunk = delay.thunk();
                try {
                    unboxed = thunk.apply();
                    hasUnboxed = true;
                    currentIO = null;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Option<Throwable> option;
                    Throwable throwable2 = throwable;
                    if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = option.get();
                    currentIO = new IO.RaiseError(e);
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
            } else if (iO instanceof IO.Suspend) {
                IO.Suspend suspend = (IO.Suspend)iO;
                Function0 thunk = suspend.thunk();
                currentIO = IORunLoop$.liftedTree1$1(thunk);
                boxedUnit = BoxedUnit.UNIT;
            } else if (iO instanceof IO.RaiseError) {
                IO.RaiseError raiseError;
                IOFrame<Object, IO<Object>> iOFrame;
                IO.RaiseError raiseError2 = (IO.RaiseError)iO;
                Throwable ex = raiseError2.e();
                if (TracingPlatform.isStackTracing && TracingPlatform.enhancedExceptions && ctx != null) {
                    this.augmentException(ex, ctx);
                }
                if ((iOFrame = this.findErrorHandler(bFirst, bRest)) == null) {
                    cb.apply(package$.MODULE$.Left().apply(ex));
                    return;
                }
                try {
                    raiseError = iOFrame.recover(ex);
                }
                catch (Throwable throwable) {
                    Option<Throwable> option;
                    Throwable throwable3 = throwable;
                    if (throwable3 == null || (option = NonFatal$.MODULE$.unapply(throwable3)).isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = option.get();
                    IO.RaiseError raiseError3 = new IO.RaiseError(e);
                    raiseError = raiseError3;
                }
                IO.RaiseError fa = raiseError;
                bFirst = null;
                currentIO = fa;
                BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                boxedUnit = BoxedUnit.UNIT;
            } else if (iO instanceof IO.Map) {
                IO.Map map = (IO.Map)iO;
                IO.RaiseError fa = map.source();
                if (TracingPlatform.isStackTracing) {
                    Object trace;
                    if (ctx == null) {
                        ctx = new IOContext();
                    }
                    if ((trace = map.trace()) != null) {
                        ctx.pushEvent((IOEvent)trace);
                    }
                }
                if (bFirst != null) {
                    if (bRest == null) {
                        bRest = new ArrayStack();
                    }
                    bRest.push(bFirst);
                }
                bFirst = map;
                currentIO = fa;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                if (iO instanceof IO.Async) {
                    Object trace;
                    IO.Async async = (IO.Async)iO;
                    if (conn == null) {
                        conn = IOConnection$.MODULE$.apply();
                    }
                    if (ctx == null) {
                        ctx = new IOContext();
                    }
                    if (rcb == null) {
                        rcb = new IORunLoop.RestartCallback(conn, cb);
                    }
                    if (TracingPlatform.isStackTracing && (trace = async.trace()) != null) {
                        ctx.pushEvent((IOEvent)trace);
                    }
                    rcb.start(async, ctx, bFirst, bRest);
                    return;
                }
                if (iO instanceof IO.ContextSwitch) {
                    BoxedUnit boxedUnit5;
                    IO.ContextSwitch contextSwitch = (IO.ContextSwitch)iO;
                    IO next = contextSwitch.source();
                    Function1<IOConnection, IOConnection> modify2 = contextSwitch.modify();
                    Function4<Object, Throwable, IOConnection, IOConnection, IOConnection> restore = contextSwitch.restore();
                    IOConnection old = conn != null ? conn : IOConnection$.MODULE$.apply();
                    conn = modify2.apply(old);
                    currentIO = next;
                    if (conn != old) {
                        if (rcb != null) {
                            rcb.contextSwitch(conn);
                        }
                        if (restore != null) {
                            currentIO = new IO.Bind<Object, Object>(next, new IORunLoop.RestoreContext(old, restore), null);
                            boxedUnit5 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit5 = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit5 = BoxedUnit.UNIT;
                    }
                    boxedUnit = boxedUnit5;
                } else if (iO instanceof IO.Trace) {
                    IO.Trace trace = (IO.Trace)iO;
                    IO source2 = trace.source();
                    IOEvent frame = trace.trace();
                    if (ctx == null) {
                        ctx = new IOContext();
                    }
                    ctx.pushEvent(frame);
                    currentIO = source2;
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError(iO);
                }
            }
            if (hasUnboxed) {
                IO.RaiseError raiseError;
                Function1<Object, IO<Object>> function1 = this.popNextBind(bFirst, bRest);
                if (function1 == null) {
                    cb.apply(package$.MODULE$.Right().apply(unboxed));
                    return;
                }
                try {
                    raiseError = function1.apply(unboxed);
                }
                catch (Throwable throwable) {
                    Option<Throwable> option;
                    Throwable throwable4 = throwable;
                    if (throwable4 == null || (option = NonFatal$.MODULE$.unapply(throwable4)).isEmpty()) {
                        throw throwable;
                    }
                    Throwable ex = option.get();
                    IO.RaiseError raiseError4 = new IO.RaiseError(ex);
                    raiseError = raiseError4;
                }
                IO.RaiseError fa = raiseError;
                hasUnboxed = false;
                unboxed = null;
                bFirst = null;
                currentIO = fa;
                BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
            }
            if (++currentIndex != maxAutoCancelableBatchSize) continue;
            if (conn.isCanceled()) {
                return;
            }
            currentIndex = 0;
        } while (true);
    }

    public <A> IO<A> step(IO<A> source) {
        IO currentIO = source;
        IO.Map bFirst = null;
        ArrayStack<Function1<Object, IO<Object>>> bRest = null;
        IOContext ctx = null;
        boolean hasUnboxed = false;
        Object unboxed = null;
        do {
            IO.RaiseError raiseError;
            BoxedUnit boxedUnit;
            IO<A> iO;
            if ((iO = currentIO) instanceof IO.Bind) {
                IO.Bind bind = (IO.Bind)iO;
                IO fa = bind.source();
                IO.Map bindNext = bind.f();
                if (TracingPlatform.isStackTracing) {
                    Object trace;
                    if (ctx == null) {
                        ctx = new IOContext();
                    }
                    if ((trace = bind.trace()) != null) {
                        ctx.pushEvent((IOEvent)trace);
                    }
                }
                if (bFirst != null) {
                    if (bRest == null) {
                        bRest = new ArrayStack<Function1<Object, IO<Object>>>();
                    }
                    bRest.push(bFirst);
                }
                bFirst = bindNext;
                currentIO = fa;
                boxedUnit = BoxedUnit.UNIT;
            } else if (iO instanceof IO.Pure) {
                IO.Pure pure = (IO.Pure)iO;
                Object value = pure.a();
                unboxed = value;
                hasUnboxed = true;
                boxedUnit = BoxedUnit.UNIT;
            } else if (iO instanceof IO.Delay) {
                BoxedUnit boxedUnit2;
                IO.Delay delay = (IO.Delay)iO;
                Function0 thunk = delay.thunk();
                try {
                    unboxed = thunk.apply();
                    hasUnboxed = true;
                    currentIO = null;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Option<Throwable> option;
                    Throwable throwable2 = throwable;
                    if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = option.get();
                    currentIO = new IO.RaiseError(e);
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
            } else if (iO instanceof IO.Suspend) {
                IO.Suspend suspend = (IO.Suspend)iO;
                Function0 thunk = suspend.thunk();
                currentIO = IORunLoop$.liftedTree2$1(thunk);
                boxedUnit = BoxedUnit.UNIT;
            } else if (iO instanceof IO.RaiseError) {
                IO.RaiseError raiseError2;
                IOFrame<Object, IO<Object>> iOFrame;
                IO.RaiseError raiseError3 = (IO.RaiseError)iO;
                Throwable ex = raiseError3.e();
                if (TracingPlatform.isStackTracing && TracingPlatform.enhancedExceptions && ctx != null) {
                    this.augmentException(ex, ctx);
                }
                if ((iOFrame = this.findErrorHandler(bFirst, bRest)) == null) {
                    return currentIO;
                }
                try {
                    raiseError2 = iOFrame.recover(ex);
                }
                catch (Throwable throwable) {
                    Option<Throwable> option;
                    Throwable throwable3 = throwable;
                    if (throwable3 == null || (option = NonFatal$.MODULE$.unapply(throwable3)).isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = option.get();
                    IO.RaiseError raiseError4 = new IO.RaiseError(e);
                    raiseError2 = raiseError4;
                }
                IO.RaiseError fa = raiseError2;
                bFirst = null;
                currentIO = fa;
                BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                boxedUnit = BoxedUnit.UNIT;
            } else if (iO instanceof IO.Map) {
                BoxedUnit boxedUnit5;
                IO.Map map = (IO.Map)iO;
                IO.RaiseError fa = map.source();
                if (TracingPlatform.isStackTracing) {
                    Object trace;
                    if (ctx == null) {
                        ctx = new IOContext();
                    }
                    if ((trace = map.trace()) != null) {
                        ctx.pushEvent((IOEvent)trace);
                    }
                }
                if (bFirst != null) {
                    if (bRest == null) {
                        bRest = new ArrayStack();
                    }
                    bRest.push(bFirst);
                }
                bFirst = map;
                currentIO = fa;
                if (ctx == null) {
                    ctx = new IOContext();
                    boxedUnit5 = BoxedUnit.UNIT;
                } else {
                    boxedUnit5 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit5;
            } else if (iO instanceof IO.Trace) {
                IO.Trace trace = (IO.Trace)iO;
                IO source2 = trace.source();
                IOEvent frame = trace.trace();
                if (ctx == null) {
                    ctx = new IOContext();
                }
                ctx.pushEvent(frame);
                currentIO = source2;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                return this.suspendAsync(currentIO, ctx, bFirst, bRest);
            }
            if (!hasUnboxed) continue;
            Function1<Object, IO<Object>> function1 = this.popNextBind(bFirst, bRest);
            if (function1 == null) {
                return currentIO != null ? currentIO : new IO.Pure<Object>(unboxed);
            }
            try {
                raiseError = function1.apply(unboxed);
            }
            catch (Throwable throwable) {
                Option<Throwable> option;
                Throwable throwable4 = throwable;
                if (throwable4 == null || (option = NonFatal$.MODULE$.unapply(throwable4)).isEmpty()) {
                    throw throwable;
                }
                Throwable ex = option.get();
                IO.RaiseError raiseError5 = new IO.RaiseError(ex);
                raiseError = raiseError5;
            }
            IO.RaiseError fa = raiseError;
            hasUnboxed = false;
            unboxed = null;
            bFirst = null;
            currentIO = fa;
            BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
        } while (true);
        return null;
    }

    private <A> IO<A> suspendAsync(IO<A> currentIO, IOContext ctx, Function1<Object, IO<Object>> bFirst, ArrayStack<Function1<Object, IO<Object>>> bRest) {
        return new IO.Async((Function3<IOConnection, IOContext, Function1, Object> & Serializable)(conn, x$1, cb) -> {
            IORunLoop$.MODULE$.cats$effect$internals$IORunLoop$$loop(currentIO, conn, cb, ctx, null, bFirst, bRest);
            return BoxedUnit.UNIT;
        }, IO$Async$.MODULE$.apply$default$2(), IO$Async$.MODULE$.apply$default$3());
    }

    private Function1<Object, IO<Object>> popNextBind(Function1<Object, IO<Object>> bFirst, ArrayStack<Function1<Object, IO<Object>>> bRest) {
        if (bFirst != null && !(bFirst instanceof IOFrame.ErrorHandler)) {
            return bFirst;
        }
        if (bRest == null) {
            return null;
        }
        do {
            Function1<Object, IO<Object>> next;
            if ((next = bRest.pop()) == null) {
                return null;
            }
            if (next instanceof IOFrame.ErrorHandler) continue;
            return next;
        } while (true);
        return null;
    }

    private IOFrame<Object, IO<Object>> findErrorHandler(Function1<Object, IO<Object>> bFirst, ArrayStack<Function1<Object, IO<Object>>> bRest) {
        IOFrame iOFrame;
        Function1<Object, IO<Object>> function1 = bFirst;
        if (function1 instanceof IOFrame) {
            IOFrame iOFrame2;
            iOFrame = iOFrame2 = (IOFrame)function1;
        } else {
            Object v0;
            if (bRest == null) {
                v0 = null;
            } else {
                do {
                    Function1<Object, IO<Object>> ref;
                    if ((ref = bRest.pop()) == null) {
                        return null;
                    }
                    if (!(ref instanceof IOFrame)) continue;
                    return (IOFrame)ref;
                } while (true);
                v0 = null;
            }
            iOFrame = v0;
        }
        return iOFrame;
    }

    private void augmentException(Throwable ex, IOContext ctx) {
        block1: {
            boolean augmented;
            StackTraceElement[] stackTrace = ex.getStackTrace();
            if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps(stackTrace))) break block1;
            boolean bl = augmented = stackTrace[stackTrace.length - 1].getClassName().indexOf(64) != -1;
            if (!augmented) {
                StackTraceElement[] prefix = this.dropRunLoopFrames(stackTrace);
                StackTraceElement[] suffix = (StackTraceElement[])((AbstractIterable)((List)ctx.getStackTraces().flatMap((Function1<IOEvent.StackTrace, Option> & Serializable)t -> IOTrace$.MODULE$.getOpAndCallSite(t.stackTrace()))).map((Function1<Tuple2, StackTraceElement> & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    StackTraceElement methodSite = (StackTraceElement)tuple2._1();
                    StackTraceElement callSite = (StackTraceElement)tuple2._2();
                    String op2 = NameTransformer$.MODULE$.decode(methodSite.getMethodName());
                    StackTraceElement stackTraceElement = new StackTraceElement(new StringBuilder(3).append(op2).append(" @ ").append(callSite.getClassName()).toString(), callSite.getMethodName(), callSite.getFileName(), callSite.getLineNumber());
                    return stackTraceElement;
                })).toArray(ClassTag$.MODULE$.apply(StackTraceElement.class));
                ex.setStackTrace((StackTraceElement[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps(prefix), suffix, ClassTag$.MODULE$.apply(StackTraceElement.class)));
            }
        }
    }

    private StackTraceElement[] dropRunLoopFrames(StackTraceElement[] frames) {
        return (StackTraceElement[])ArrayOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.refArrayOps(frames), (Function1<StackTraceElement, Object> & Serializable)ste -> BoxesRunTime.boxToBoolean(IORunLoop$.$anonfun$dropRunLoopFrames$1(ste)));
    }

    private static final /* synthetic */ IO liftedTree1$1(Function0 thunk$1) {
        IO iO;
        try {
            iO = (IO)thunk$1.apply();
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                throw throwable;
            }
            Throwable ex = option.get();
            IO.RaiseError raiseError = new IO.RaiseError(ex);
            iO = raiseError;
        }
        return iO;
    }

    private static final /* synthetic */ IO liftedTree2$1(Function0 thunk$2) {
        IO iO;
        try {
            iO = (IO)thunk$2.apply();
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                throw throwable;
            }
            Throwable ex = option.get();
            IO.RaiseError raiseError = new IO.RaiseError(ex);
            iO = raiseError;
        }
        return iO;
    }

    public static final /* synthetic */ boolean $anonfun$dropRunLoopFrames$2(StackTraceElement ste$1, String x$2) {
        return ste$1.getClassName().startsWith(x$2);
    }

    public static final /* synthetic */ boolean $anonfun$dropRunLoopFrames$1(StackTraceElement ste) {
        return !runLoopFilter.exists((Function1<String, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(IORunLoop$.$anonfun$dropRunLoopFrames$2(ste, x$2)));
    }

    private IORunLoop$() {
    }
}

