/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.internals;

import java.util.Optional;

public final class TracingPlatform {
    private static final String stackTracingMode = Optional.ofNullable(System.getProperty("cats.effect.stackTracingMode")).filter(string2 -> !string2.isEmpty()).orElse("cached");
    public static final boolean isCachedStackTracing = stackTracingMode.equalsIgnoreCase("cached");
    public static final boolean isFullStackTracing = stackTracingMode.equalsIgnoreCase("full");
    public static final boolean isStackTracing = isFullStackTracing || isCachedStackTracing;
    public static final int traceBufferLogSize = Optional.ofNullable(System.getProperty("cats.effect.traceBufferLogSize")).filter(string2 -> !string2.isEmpty()).flatMap(string2 -> {
        try {
            return Optional.of(Integer.valueOf(string2));
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }).orElse(4);
    public static final boolean enhancedExceptions = Optional.ofNullable(System.getProperty("cats.effect.enhancedExceptions")).map(string2 -> Boolean.valueOf(string2)).orElse(true);
}

