/*
 * Decompiled with CFR 0.152.
 */
package fs2;

import cats.effect.Sync;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Pull;
import fs2.Pull$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import fs2.Stream$InvariantOps$;
import fs2.Stream$ToPull$;
import fs2.compression;
import fs2.compression$DeflateParams$;
import fs2.compression$DeflateParams$FlushMode$DEFAULT$;
import fs2.compression$DeflateParams$FlushMode$NO_FLUSH$;
import fs2.compression$DeflateParams$Level$;
import fs2.compression$DeflateParams$Level$DEFAULT$;
import fs2.compression$DeflateParams$Strategy$;
import fs2.compression$DeflateParams$Strategy$DEFAULT$;
import fs2.compression$GunzipResult$;
import fs2.compression$InflateParams$;
import fs2.compression$ZLibParams$Header$;
import fs2.compression$ZLibParams$Header$GZIP$;
import fs2.compression$gzipCompressionMethod$;
import fs2.compression$gzipExtraFlag$;
import fs2.compression$gzipFlag$;
import fs2.compression$gzipOperatingSystem$;
import fs2.internal.FreeC;
import java.io.EOFException;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Array$UnapplySeqWrapper$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class compression$ {
    public static final compression$ MODULE$ = new compression$();
    private static final int gzipHeaderBytes = 10;
    private static final byte gzipMagicFirstByte = (byte)31;
    private static final byte gzipMagicSecondByte = (byte)139;
    private static final int gzipOptionalExtraFieldLengthBytes = 2;
    private static final int gzipHeaderCrcBytes = 2;
    private static final int gzipInputCrcBytes = 4;
    private static final int gzipInputSizeBytes = 4;
    private static final int gzipTrailerBytes = MODULE$.gzipInputCrcBytes() + MODULE$.gzipInputSizeBytes();
    private static final byte zeroByte = 0;
    private static final int fileNameBytesSoftLimit = 1024;
    private static final int fileCommentBytesSoftLimit = 0x100000;

    public <F> Function1<Stream<F, Object>, Stream<F, Object>> deflate(int level, boolean nowrap, int bufferSize, int strategy, Sync<F> SyncF) {
        return this.deflate(compression$DeflateParams$.MODULE$.apply(bufferSize, compression$ZLibParams$Header$.MODULE$.apply(nowrap), compression$DeflateParams$Level$.MODULE$.apply(level), compression$DeflateParams$Strategy$.MODULE$.apply(strategy), compression$DeflateParams$FlushMode$NO_FLUSH$.MODULE$), SyncF);
    }

    public <F> Function1<Stream<F, Object>, Stream<F, Object>> deflate(compression.DeflateParams deflateParams, Sync<F> SyncF) {
        return (Function1<Object, Object> & Serializable)stream -> new Stream(Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.bracket(SyncF.delay((Function0<Deflater> & Serializable)() -> {
            void var1_1;
            Deflater deflater = new Deflater(deflateParams$1.level().juzDeflaterLevel(), deflateParams$1.header().juzDeflaterNoWrap());
            deflater.setStrategy(deflateParams$1.strategy().juzDeflaterStrategy());
            return var1_1;
        }), (Function1<Deflater, Object> & Serializable)deflater -> SyncF$1.delay(() -> deflater.end())), (Function1<Deflater, Object> & Serializable)deflater -> new Stream(compression$.$anonfun$deflate$5(deflateParams$1, stream, deflater))));
    }

    public <F> int deflate$default$1() {
        return -1;
    }

    public <F> boolean deflate$default$2() {
        return false;
    }

    public <F> int deflate$default$3() {
        return 32768;
    }

    public <F> int deflate$default$4() {
        return 0;
    }

    private <F> Function1<Stream<F, Object>, Stream<F, Object>> _deflate(compression.DeflateParams deflateParams, Deflater deflater, Option<CRC32> crc32) {
        return (Function1<Object, Object> & Serializable)in -> new Stream(Stream$.MODULE$.suspend((Function0<Object> & Serializable)() -> new Stream(compression$.$anonfun$_deflate$2(deflateParams$2, deflater$2, crc32$1, in))));
    }

    private <F> FreeC<F, Object, BoxedUnit> _deflate_chunk(compression.DeflateParams deflateParams, Deflater deflater, Option<CRC32> crc32, Chunk<Object> chunk, byte[] deflatedBuffer, boolean isFinalChunk) {
        Chunk.Bytes bytesChunk = chunk.toBytes($less$colon$less$.MODULE$.refl());
        deflater.setInput(bytesChunk.values(), bytesChunk.offset(), bytesChunk.length());
        if (isFinalChunk) {
            deflater.finish();
        }
        crc32.foreach((Function1<CRC32, Object> & Serializable)x$1 -> {
            x$1.update(bytesChunk.values(), bytesChunk.offset(), bytesChunk.length());
            return BoxedUnit.UNIT;
        });
        return this.pull$1(deflatedBuffer, deflater, deflateParams, isFinalChunk);
    }

    private <F> Function1<Stream<F, Object>, Pull<F, Object, BoxedUnit>> _deflate_stream(compression.DeflateParams deflateParams, Deflater deflater, Option<CRC32> crc32, byte[] deflatedBuffer) {
        return (Function1<Object, Object> & Serializable)x$2 -> new Pull(Pull$.MODULE$.flatMap$extension(Stream$ToPull$.MODULE$.unconsNonEmpty$extension(Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(((Stream)x$2).fs2$Stream$$free()))), (Function1<Option, Object> & Serializable)x0$1 -> new Pull(compression$.$anonfun$_deflate_stream$2(deflateParams$4, deflater$4, crc32$2, deflatedBuffer$2, x0$1))));
    }

    public <F> Function1<Stream<F, Object>, Stream<F, Object>> inflate(boolean nowrap, int bufferSize, Sync<F> SyncF) {
        return this.inflate(compression$InflateParams$.MODULE$.apply(bufferSize, compression$ZLibParams$Header$.MODULE$.apply(nowrap)), SyncF);
    }

    public <F> Function1<Stream<F, Object>, Stream<F, Object>> inflate(compression.InflateParams inflateParams, Sync<F> SyncF) {
        return (Function1<Object, Object> & Serializable)stream -> new Stream(Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.bracket(SyncF.delay((Function0<Inflater> & Serializable)() -> new Inflater(inflateParams$1.header().juzDeflaterNoWrap())), (Function1<Inflater, Object> & Serializable)inflater -> SyncF$2.delay(() -> inflater.end())), (Function1<Inflater, Object> & Serializable)inflater -> new Stream(compression$.$anonfun$inflate$5(inflateParams$1, SyncF$2, stream, inflater))));
    }

    public <F> boolean inflate$default$1() {
        return false;
    }

    public <F> int inflate$default$2() {
        return 32768;
    }

    private <F> Function1<Stream<F, Object>, Stream<F, Object>> _inflate(compression.InflateParams inflateParams, Inflater inflater, Option<CRC32> crc32, Sync<F> SyncF) {
        return (Function1<Object, Object> & Serializable)in -> new Stream(Stream$.MODULE$.suspend((Function0<Object> & Serializable)() -> new Stream(compression$.$anonfun$_inflate$2(inflateParams$2, in, inflater$2, crc32$3, SyncF$3))));
    }

    private <F> FreeC<F, Object, BoxedUnit> _inflate_chunk(Inflater inflater, Option<CRC32> crc32, Chunk<Object> chunk, byte[] inflatedBuffer) {
        Chunk.Bytes bytesChunk = chunk.toBytes($less$colon$less$.MODULE$.refl());
        inflater.setInput(bytesChunk.values(), bytesChunk.offset(), bytesChunk.length());
        return this.pull$2(inflater, bytesChunk, inflatedBuffer, crc32);
    }

    private <F> Function1<Stream<F, Object>, Pull<F, Object, BoxedUnit>> _inflate_stream(compression.InflateParams inflateParams, Inflater inflater, Option<CRC32> crc32, byte[] inflatedBuffer, Sync<F> SyncF) {
        return (Function1<Object, Object> & Serializable)x$4 -> new Pull(Pull$.MODULE$.flatMap$extension(Stream$ToPull$.MODULE$.unconsNonEmpty$extension(Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(((Stream)x$4).fs2$Stream$$free()))), (Function1<Option, Object> & Serializable)x0$1 -> new Pull(compression$.$anonfun$_inflate_stream$2(inflater$4, crc32$5, inflatedBuffer$3, inflateParams$3, SyncF$4, x0$1))));
    }

    public <F> Function1<Stream<F, Object>, Stream<F, Object>> gzip(int bufferSize, Option<Object> deflateLevel, Option<Object> deflateStrategy, Option<Instant> modificationTime, Option<String> fileName, Option<String> comment, Sync<F> SyncF) {
        return this.gzip(fileName, modificationTime, comment, compression$DeflateParams$.MODULE$.apply(bufferSize, compression$ZLibParams$Header$GZIP$.MODULE$, (compression.DeflateParams.Level)deflateLevel.map((Function1<Object, compression.DeflateParams.Level> & Serializable)level -> compression$DeflateParams$Level$.MODULE$.apply(BoxesRunTime.unboxToInt(level))).getOrElse((Function0<compression$DeflateParams$Level$DEFAULT$> & Serializable)() -> compression$DeflateParams$Level$DEFAULT$.MODULE$), (compression.DeflateParams.Strategy)deflateStrategy.map((Function1<Object, compression.DeflateParams.Strategy> & Serializable)strategy -> compression$DeflateParams$Strategy$.MODULE$.apply(BoxesRunTime.unboxToInt(strategy))).getOrElse((Function0<compression$DeflateParams$Strategy$DEFAULT$> & Serializable)() -> compression$DeflateParams$Strategy$DEFAULT$.MODULE$), compression$DeflateParams$FlushMode$DEFAULT$.MODULE$), SyncF);
    }

    public <F> Function1<Stream<F, Object>, Stream<F, Object>> gzip(Option<String> fileName, Option<Instant> modificationTime, Option<String> comment, compression.DeflateParams deflateParams, Sync<F> SyncF) {
        return (Function1<Object, Object> & Serializable)stream -> new Stream(compression$.$anonfun$gzip$5(deflateParams, SyncF, fileName, modificationTime, comment, ((Stream)stream).fs2$Stream$$free()));
    }

    public <F> int gzip$default$1() {
        return 32768;
    }

    public <F> Option<Object> gzip$default$2() {
        return None$.MODULE$;
    }

    public <F> Option<Object> gzip$default$3() {
        return None$.MODULE$;
    }

    public <F> Option<Instant> gzip$default$4() {
        return None$.MODULE$;
    }

    public <F> Option<String> gzip$default$5() {
        return None$.MODULE$;
    }

    public <F> Option<String> gzip$default$6() {
        return None$.MODULE$;
    }

    private <F> FreeC<F, Object, BoxedUnit> _gzip_header(Option<String> fileName, Option<Instant> modificationTime, Option<String> comment, int deflateLevel) {
        byte by;
        long secondsSince197001010000 = BoxesRunTime.unboxToLong(modificationTime.map((Function1<Instant, Object> & Serializable)x$5 -> BoxesRunTime.boxToLong(x$5.getEpochSecond())).getOrElse(() -> 0L));
        byte[] byArray = new byte[10];
        byArray[0] = this.gzipMagicFirstByte();
        byArray[1] = this.gzipMagicSecondByte();
        byArray[2] = compression$gzipCompressionMethod$.MODULE$.DEFLATE();
        byArray[3] = (byte)(compression$gzipFlag$.MODULE$.FHCRC() + BoxesRunTime.unboxToByte(fileName.map((Function1<String, Object> & Serializable)x$6 -> BoxesRunTime.boxToByte(compression$gzipFlag$.MODULE$.FNAME())).getOrElse(() -> MODULE$.zeroByte())) + BoxesRunTime.unboxToByte(comment.map((Function1<String, Object> & Serializable)x$7 -> BoxesRunTime.boxToByte(compression$gzipFlag$.MODULE$.FCOMMENT())).getOrElse(() -> MODULE$.zeroByte())));
        byArray[4] = (byte)(secondsSince197001010000 & 0xFFL);
        byArray[5] = (byte)(secondsSince197001010000 >> 8 & 0xFFL);
        byArray[6] = (byte)(secondsSince197001010000 >> 16 & 0xFFL);
        byArray[7] = (byte)(secondsSince197001010000 >> 24 & 0xFFL);
        int n = deflateLevel;
        switch (n) {
            case 9: {
                by = compression$gzipExtraFlag$.MODULE$.DEFLATE_MAX_COMPRESSION_SLOWEST_ALGO();
                break;
            }
            case 1: {
                by = compression$gzipExtraFlag$.MODULE$.DEFLATE_FASTEST_ALGO();
                break;
            }
            default: {
                by = this.zeroByte();
                break;
            }
        }
        byArray[8] = by;
        byArray[9] = compression$gzipOperatingSystem$.MODULE$.THIS();
        byte[] header = byArray;
        CRC32 crc32 = new CRC32();
        crc32.update(header);
        Option fileNameEncoded = fileName.map((Function1<String, byte[]> & Serializable)string2 -> {
            void var2_2;
            byte[] bytes = string2.replaceAll("\u0000", "_").getBytes(StandardCharsets.ISO_8859_1);
            crc32.update(bytes);
            crc32.update(MODULE$.zeroByte());
            return var2_2;
        });
        Option commentEncoded = comment.map((Function1<String, byte[]> & Serializable)string2 -> {
            void var2_2;
            byte[] bytes = string2.replaceAll("\u0000", " ").getBytes(StandardCharsets.ISO_8859_1);
            crc32.update(bytes);
            crc32.update(MODULE$.zeroByte());
            return var2_2;
        });
        long crc32Value = crc32.getValue();
        byte[] crc16 = new byte[]{(byte)(crc32Value & 0xFFL), (byte)(crc32Value >> 8 & 0xFFL)};
        return Stream$.MODULE$.$plus$plus$extension(Stream$.MODULE$.$plus$plus$extension(Stream$.MODULE$.$plus$plus$extension(Stream$.MODULE$.chunk(this.moveAsChunkBytes(header)), (Function0<Object> & Serializable)() -> new Stream(compression$.$anonfun$_gzip_header$9(fileNameEncoded))), (Function0<Object> & Serializable)() -> new Stream(compression$.$anonfun$_gzip_header$13(commentEncoded))), (Function0<Object> & Serializable)() -> new Stream(Stream$.MODULE$.chunk(compression$.MODULE$.moveAsChunkBytes(crc16))));
    }

    private <F> FreeC<F, Object, BoxedUnit> _gzip_trailer(Deflater deflater, CRC32 crc32) {
        long crc32Value = crc32.getValue();
        int bytesIn = deflater.getTotalIn();
        byte[] trailer = new byte[]{(byte)(crc32Value & 0xFFL), (byte)(crc32Value >> 8 & 0xFFL), (byte)(crc32Value >> 16 & 0xFFL), (byte)(crc32Value >> 24 & 0xFFL), (byte)(bytesIn & 0xFF), (byte)(bytesIn >> 8 & 0xFF), (byte)(bytesIn >> 16 & 0xFF), (byte)(bytesIn >> 24 & 0xFF)};
        return Stream$.MODULE$.chunk(this.moveAsChunkBytes(trailer));
    }

    public <F> Function1<Stream<F, Object>, Stream<F, compression.GunzipResult<F>>> gunzip(int bufferSize, Sync<F> SyncF) {
        return this.gunzip(compression$InflateParams$.MODULE$.apply(bufferSize, compression$ZLibParams$Header$GZIP$.MODULE$), SyncF);
    }

    public <F> Function1<Stream<F, Object>, Stream<F, compression.GunzipResult<F>>> gunzip(compression.InflateParams inflateParams, Sync<F> SyncF) {
        return (Function1<Object, Object> & Serializable)stream -> new Stream(compression$.$anonfun$gunzip$1(inflateParams, SyncF, ((Stream)stream).fs2$Stream$$free()));
    }

    public <F> int gunzip$default$1() {
        return 32768;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private <F> FreeC<?, compression.GunzipResult<?>, BoxedUnit> _gunzip_matchMandatoryHeader(compression.InflateParams inflateParams, Chunk<Object> mandatoryHeaderChunk, FreeC<F, Object, BoxedUnit> streamAfterMandatoryHeader, CRC32 headerCrc32, CRC32 contentCrc32, Inflater inflater, Sync<F> SyncF) {
        void var8_22;
        Tuple2<Integer, byte[]> tuple2 = new Tuple2<Integer, byte[]>(BoxesRunTime.boxToInteger(mandatoryHeaderChunk.size()), mandatoryHeaderChunk.toBytes($less$colon$less$.MODULE$.refl()).values());
        if (tuple2 != null) {
            Object object;
            int n = tuple2._1$mcI$sp();
            byte[] byArray = tuple2._2();
            if (this.gzipHeaderBytes() == n && byArray != null && !Array$UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq(byArray)) && new Array.UnapplySeqWrapper(Array$UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 9) == 0) {
                byte by = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 0));
                byte by2 = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 1));
                byte by3 = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 2));
                byte flags = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 3));
                if (this.gzipMagicFirstByte() == by && this.gzipMagicSecondByte() == by2 && compression$gzipCompressionMethod$.MODULE$.DEFLATE() == by3 && compression$gzipFlag$.MODULE$.reserved5(flags)) {
                    FreeC freeC = Pull$.MODULE$.output1(new compression.GunzipResult(Stream$.MODULE$.raiseError(new ZipException("Unsupported gzip flag reserved bit 5 is non-zero"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF)), compression$GunzipResult$.MODULE$.apply$default$2(), compression$GunzipResult$.MODULE$.apply$default$3(), compression$GunzipResult$.MODULE$.apply$default$4()));
                    return var8_22;
                }
            }
        }
        if (tuple2 != null) {
            Object object;
            int n = tuple2._1$mcI$sp();
            byte[] byArray = tuple2._2();
            if (this.gzipHeaderBytes() == n && byArray != null && !Array$UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq(byArray)) && new Array.UnapplySeqWrapper(Array$UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 9) == 0) {
                byte by = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 0));
                byte by4 = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 1));
                byte by5 = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 2));
                byte flags = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 3));
                if (this.gzipMagicFirstByte() == by && this.gzipMagicSecondByte() == by4 && compression$gzipCompressionMethod$.MODULE$.DEFLATE() == by5 && compression$gzipFlag$.MODULE$.reserved6(flags)) {
                    FreeC freeC = Pull$.MODULE$.output1(new compression.GunzipResult(Stream$.MODULE$.raiseError(new ZipException("Unsupported gzip flag reserved bit 6 is non-zero"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF)), compression$GunzipResult$.MODULE$.apply$default$2(), compression$GunzipResult$.MODULE$.apply$default$3(), compression$GunzipResult$.MODULE$.apply$default$4()));
                    return var8_22;
                }
            }
        }
        if (tuple2 != null) {
            Object object;
            int n = tuple2._1$mcI$sp();
            byte[] byArray = tuple2._2();
            if (this.gzipHeaderBytes() == n && byArray != null && !Array$UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq(byArray)) && new Array.UnapplySeqWrapper(Array$UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 9) == 0) {
                byte by = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 0));
                byte by6 = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 1));
                byte by7 = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 2));
                byte flags = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 3));
                if (this.gzipMagicFirstByte() == by && this.gzipMagicSecondByte() == by6 && compression$gzipCompressionMethod$.MODULE$.DEFLATE() == by7 && compression$gzipFlag$.MODULE$.reserved7(flags)) {
                    FreeC freeC = Pull$.MODULE$.output1(new compression.GunzipResult(Stream$.MODULE$.raiseError(new ZipException("Unsupported gzip flag reserved bit 7 is non-zero"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF)), compression$GunzipResult$.MODULE$.apply$default$2(), compression$GunzipResult$.MODULE$.apply$default$3(), compression$GunzipResult$.MODULE$.apply$default$4()));
                    return var8_22;
                }
            }
        }
        if (tuple2 != null) {
            Object object;
            int n = tuple2._1$mcI$sp();
            byte[] header = tuple2._2();
            if (this.gzipHeaderBytes() == n && header != null && !Array$UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq(header)) && new Array.UnapplySeqWrapper(Array$UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 10) == 0) {
                byte by = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 0));
                byte by8 = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 1));
                byte by9 = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 2));
                byte flags = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 3));
                if (this.gzipMagicFirstByte() == by && this.gzipMagicSecondByte() == by8 && compression$gzipCompressionMethod$.MODULE$.DEFLATE() == by9) {
                    headerCrc32.update(header);
                    long secondsSince197001010000 = this.unsignedToLong(header[4], header[5], header[6], header[7]);
                    FreeC freeC = Pull$.MODULE$.flatMap$extension(Stream$ToPull$.MODULE$.uncons1$extension(Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(this._gunzip_readOptionalHeader(inflateParams, streamAfterMandatoryHeader, flags, headerCrc32, contentCrc32, secondsSince197001010000, inflater, SyncF)))), (Function1<Option, Object> & Serializable)x0$1 -> new Pull(compression$.$anonfun$_gunzip_matchMandatoryHeader$1(SyncF, x0$1)));
                    return var8_22;
                }
            }
        }
        if (tuple2 != null) {
            Object object;
            int n = tuple2._1$mcI$sp();
            byte[] byArray = tuple2._2();
            if (this.gzipHeaderBytes() == n && byArray != null && !Array$UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq(byArray)) && new Array.UnapplySeqWrapper(Array$UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 10) == 0) {
                byte by = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 0));
                byte by10 = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 1));
                byte compressionMethod = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 2));
                if (this.gzipMagicFirstByte() == by && this.gzipMagicSecondByte() == by10) {
                    FreeC freeC = Pull$.MODULE$.output1(new compression.GunzipResult(Stream$.MODULE$.raiseError(new ZipException(new StringBuilder(37).append("Unsupported gzip compression method: ").append(compressionMethod).toString()), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF)), compression$GunzipResult$.MODULE$.apply$default$2(), compression$GunzipResult$.MODULE$.apply$default$3(), compression$GunzipResult$.MODULE$.apply$default$4()));
                    return var8_22;
                }
            }
        }
        FreeC freeC = Pull$.MODULE$.output1(new compression.GunzipResult(Stream$.MODULE$.raiseError(new ZipException("Not in gzip format"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF)), compression$GunzipResult$.MODULE$.apply$default$2(), compression$GunzipResult$.MODULE$.apply$default$3(), compression$GunzipResult$.MODULE$.apply$default$4()));
        return var8_22;
    }

    private <F> FreeC<F, compression.GunzipResult<F>, BoxedUnit> _gunzip_readOptionalHeader(compression.InflateParams inflateParams, FreeC<F, Object, BoxedUnit> streamAfterMandatoryHeader, byte flags, CRC32 headerCrc32, CRC32 contentCrc32, long secondsSince197001010000, Inflater inflater, Sync<F> SyncF) {
        return Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.through$extension(Stream$.MODULE$.through$extension(streamAfterMandatoryHeader, this._gunzip_skipOptionalExtraField(compression$gzipFlag$.MODULE$.fextra(flags), headerCrc32, SyncF)), this._gunzip_readOptionalStringField(compression$gzipFlag$.MODULE$.fname(flags), headerCrc32, "file name", this.fileNameBytesSoftLimit(), SyncF)), (Function1<Tuple2, Object> & Serializable)x0$1 -> new Stream(compression$.$anonfun$_gunzip_readOptionalHeader$1(flags, headerCrc32, SyncF, secondsSince197001010000, inflateParams, inflater, contentCrc32, x0$1)));
    }

    private <F> Function1<Stream<F, Object>, Stream<F, Object>> _gunzip_skipOptionalExtraField(boolean isPresent, CRC32 crc32, Sync<F> Sync2) {
        return (Function1<Object, Object> & Serializable)stream -> new Stream(compression$.$anonfun$_gunzip_skipOptionalExtraField$1(isPresent, crc32, Sync2, ((Stream)stream).fs2$Stream$$free()));
    }

    private <F> Function1<Stream<F, Object>, Stream<F, Tuple2<Option<String>, Stream<F, Object>>>> _gunzip_readOptionalStringField(boolean isPresent, CRC32 crc32, String fieldName, int fieldBytesSoftLimit, Sync<F> SyncF) {
        return (Function1<Object, Object> & Serializable)stream -> new Stream(compression$.$anonfun$_gunzip_readOptionalStringField$1(isPresent, fieldBytesSoftLimit, crc32, fieldName, SyncF, ((Stream)stream).fs2$Stream$$free()));
    }

    private <F> Function1<Stream<F, Object>, Stream<F, Object>> _gunzip_validateHeader(boolean isPresent, CRC32 crc32, Sync<F> SyncF) {
        return (Function1<Object, Object> & Serializable)stream -> new Stream(compression$.$anonfun$_gunzip_validateHeader$1(isPresent, crc32, SyncF, ((Stream)stream).fs2$Stream$$free()));
    }

    private <F> Function1<Stream<F, Object>, Stream<F, Object>> _gunzip_validateTrailer(CRC32 crc32, Inflater inflater, Sync<F> SyncF) {
        return (Function1<Object, Object> & Serializable)stream -> new Stream(Pull$.MODULE$.stream$extension(((Pull)compression$.streamUntilTrailer$1(Chunk$.MODULE$.empty(), inflater, crc32, SyncF).apply(new Stream(((Stream)stream).fs2$Stream$$free()))).fs2$Pull$$free(), $less$colon$less$.MODULE$.refl()));
    }

    private <F, O> Function1<Stream<F, O>, Pull<F, Nothing$, Option<Tuple2<Chunk<O>, Stream<F, O>>>>> unconsUntil(Function1<O, Object> predicate, int softLimit) {
        return (Function1<Object, Object> & Serializable)stream -> new Pull(compression$.go$1(package$.MODULE$.Nil(), ((Stream)stream).fs2$Stream$$free(), compression$.go$default$3$1(), predicate, softLimit));
    }

    private int gzipHeaderBytes() {
        return gzipHeaderBytes;
    }

    private byte gzipMagicFirstByte() {
        return gzipMagicFirstByte;
    }

    private byte gzipMagicSecondByte() {
        return gzipMagicSecondByte;
    }

    private int gzipOptionalExtraFieldLengthBytes() {
        return gzipOptionalExtraFieldLengthBytes;
    }

    private int gzipHeaderCrcBytes() {
        return gzipHeaderCrcBytes;
    }

    private int gzipInputCrcBytes() {
        return gzipInputCrcBytes;
    }

    private int gzipInputSizeBytes() {
        return gzipInputSizeBytes;
    }

    private int gzipTrailerBytes() {
        return gzipTrailerBytes;
    }

    private byte zeroByte() {
        return zeroByte;
    }

    private int fileNameBytesSoftLimit() {
        return fileNameBytesSoftLimit;
    }

    private int fileCommentBytesSoftLimit() {
        return fileCommentBytesSoftLimit;
    }

    private Chunk<Object> moveAsChunkBytes(byte[] values2) {
        return this.moveAsChunkBytes(values2, values2.length);
    }

    private Chunk<Object> moveAsChunkBytes(byte[] values2, int length) {
        return length > 0 ? new Chunk.Bytes(values2, 0, length) : Chunk$.MODULE$.empty();
    }

    private Chunk<Object> copyAsChunkBytes(byte[] values2, int length) {
        Chunk.Bytes bytes;
        if (length > 0) {
            byte[] target = new byte[length];
            System.arraycopy(values2, 0, target, 0, length);
            bytes = new Chunk.Bytes(target, 0, length);
        } else {
            bytes = Chunk$.MODULE$.empty();
        }
        return bytes;
    }

    private int unsignedToInt(byte lsb, byte msb) {
        return (msb & 0xFF) << 8 | lsb & 0xFF;
    }

    private long unsignedToLong(byte lsb, byte byte2, byte byte3, byte msb) {
        return ((long)msb & 0xFFL) << 24 | (long)((byte3 & 0xFF) << 16) | (long)((byte2 & 0xFF) << 8) | (long)(lsb & 0xFF);
    }

    public static final /* synthetic */ FreeC $anonfun$deflate$5(compression.DeflateParams deflateParams$1, FreeC stream$1, Deflater deflater) {
        return MODULE$._deflate(deflateParams$1, deflater, None$.MODULE$).apply(new Stream(stream$1)).fs2$Stream$$free();
    }

    public static final /* synthetic */ FreeC $anonfun$_deflate$2(compression.DeflateParams deflateParams$2, Deflater deflater$2, Option crc32$1, FreeC in$1) {
        byte[] deflatedBuffer = new byte[deflateParams$2.bufferSizeOrMinimum()];
        return Pull$.MODULE$.stream$extension(MODULE$._deflate_stream(deflateParams$2, deflater$2, crc32$1, deflatedBuffer).apply(new Stream(in$1)).fs2$Pull$$free(), $less$colon$less$.MODULE$.refl());
    }

    private static final boolean isDone$1(boolean isFinalChunk$1, Deflater deflater$3) {
        return isFinalChunk$1 && deflater$3.finished() || !isFinalChunk$1 && deflater$3.needsInput();
    }

    private static final int runDeflate$1(Deflater deflater$3, byte[] deflatedBuffer$1, compression.DeflateParams deflateParams$3, boolean isFinalChunk$1) {
        return compression$.isDone$1(isFinalChunk$1, deflater$3) ? 0 : deflater$3.deflate(deflatedBuffer$1, 0, deflateParams$3.bufferSizeOrMinimum(), deflateParams$3.flushMode().juzDeflaterFlushMode());
    }

    private final FreeC pull$1(byte[] deflatedBuffer$1, Deflater deflater$3, compression.DeflateParams deflateParams$3, boolean isFinalChunk$1) {
        int deflatedBytes = compression$.runDeflate$1(deflater$3, deflatedBuffer$1, deflateParams$3, isFinalChunk$1);
        return compression$.isDone$1(isFinalChunk$1, deflater$3) ? Pull$.MODULE$.output(this.copyAsChunkBytes(deflatedBuffer$1, deflatedBytes)) : Pull$.MODULE$.$greater$greater$extension(Pull$.MODULE$.output(this.copyAsChunkBytes(deflatedBuffer$1, deflatedBytes)), (Function0<Object> & Serializable)() -> new Pull(this.pull$1(deflatedBuffer$1, deflater$3, deflateParams$3, isFinalChunk$1)));
    }

    public static final /* synthetic */ FreeC $anonfun$_deflate_stream$3(compression.DeflateParams deflateParams$4, Deflater deflater$4, Option crc32$2, byte[] deflatedBuffer$2, FreeC inflatedStream$1) {
        return MODULE$._deflate_stream(deflateParams$4, deflater$4, crc32$2, deflatedBuffer$2).apply(new Stream(inflatedStream$1)).fs2$Pull$$free();
    }

    public static final /* synthetic */ FreeC $anonfun$_deflate_stream$2(compression.DeflateParams deflateParams$4, Deflater deflater$4, Option crc32$2, byte[] deflatedBuffer$2, Option x0$1) {
        FreeC<Object, Object, BoxedUnit> freeC;
        Some some;
        Tuple2 tuple2;
        Option option = x0$1;
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            Chunk inflatedChunk = (Chunk)tuple2._1();
            FreeC inflatedStream = ((Stream)tuple2._2()).fs2$Stream$$free();
            freeC = Pull$.MODULE$.$greater$greater$extension(MODULE$._deflate_chunk(deflateParams$4, deflater$4, crc32$2, inflatedChunk, deflatedBuffer$2, false), (Function0<Object> & Serializable)() -> new Pull(compression$.$anonfun$_deflate_stream$3(deflateParams$4, deflater$4, crc32$2, deflatedBuffer$2, inflatedStream)));
        } else if (None$.MODULE$.equals(option)) {
            freeC = MODULE$._deflate_chunk(deflateParams$4, deflater$4, crc32$2, Chunk$.MODULE$.empty(), deflatedBuffer$2, true);
        } else {
            throw new MatchError(option);
        }
        return freeC;
    }

    public static final /* synthetic */ FreeC $anonfun$inflate$5(compression.InflateParams inflateParams$1, Sync SyncF$2, FreeC stream$2, Inflater inflater) {
        return MODULE$._inflate(inflateParams$1, inflater, None$.MODULE$, SyncF$2).apply(new Stream(stream$2)).fs2$Stream$$free();
    }

    public static final /* synthetic */ FreeC $anonfun$_inflate$4(compression.InflateParams inflateParams$2, Inflater inflater$2, Option crc32$3, byte[] inflatedBuffer$1, Sync SyncF$3, FreeC deflatedStream$1) {
        return MODULE$._inflate_stream(inflateParams$2, inflater$2, crc32$3, inflatedBuffer$1, SyncF$3).apply(new Stream(deflatedStream$1)).fs2$Pull$$free();
    }

    public static final /* synthetic */ FreeC $anonfun$_inflate$3(Inflater inflater$2, Option crc32$3, byte[] inflatedBuffer$1, compression.InflateParams inflateParams$2, Sync SyncF$3, Option x0$1) {
        FreeC<Nothing$, Nothing$, BoxedUnit> freeC;
        Some some;
        Tuple2 tuple2;
        Option option = x0$1;
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            Chunk deflatedChunk = (Chunk)tuple2._1();
            FreeC deflatedStream = ((Stream)tuple2._2()).fs2$Stream$$free();
            freeC = Pull$.MODULE$.$greater$greater$extension(MODULE$._inflate_chunk(inflater$2, crc32$3, deflatedChunk, inflatedBuffer$1), (Function0<Object> & Serializable)() -> new Pull(compression$.$anonfun$_inflate$4(inflateParams$2, inflater$2, crc32$3, inflatedBuffer$1, SyncF$3, deflatedStream)));
        } else if (None$.MODULE$.equals(option)) {
            freeC = Pull$.MODULE$.done();
        } else {
            throw new MatchError(option);
        }
        return freeC;
    }

    public static final /* synthetic */ FreeC $anonfun$_inflate$2(compression.InflateParams inflateParams$2, FreeC in$2, Inflater inflater$2, Option crc32$3, Sync SyncF$3) {
        byte[] inflatedBuffer = new byte[inflateParams$2.bufferSizeOrMinimum()];
        return Pull$.MODULE$.stream$extension(Pull$.MODULE$.flatMap$extension(Stream$ToPull$.MODULE$.unconsNonEmpty$extension(Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(in$2))), (Function1<Option, Object> & Serializable)x0$1 -> new Pull(compression$.$anonfun$_inflate$3(inflater$2, crc32$3, inflatedBuffer, inflateParams$2, SyncF$3, x0$1))), $less$colon$less$.MODULE$.refl());
    }

    /*
     * WARNING - void declaration
     */
    private static final int runInflate$1(Inflater inflater$3, byte[] inflatedBuffer$2, Option crc32$4) {
        int n;
        if (inflater$3.finished()) {
            n = -2;
        } else if (inflater$3.needsInput()) {
            n = -1;
        } else {
            void var3_3;
            int byteCount = inflater$3.inflate(inflatedBuffer$2);
            crc32$4.foreach((Function1<CRC32, Object> & Serializable)x$3 -> {
                x$3.update(inflatedBuffer$2, 0, byteCount);
                return BoxedUnit.UNIT;
            });
            n = var3_3;
        }
        return n;
    }

    private final FreeC pull$2(Inflater inflater$3, Chunk.Bytes bytesChunk$2, byte[] inflatedBuffer$2, Option crc32$4) {
        FreeC<Nothing$, Object, BoxedUnit> freeC;
        int n = compression$.runInflate$1(inflater$3, inflatedBuffer$2, crc32$4);
        switch (n) {
            default: 
        }
        if (n <= -2) {
            int n2 = inflater$3.getRemaining();
            switch (n2) {
                default: 
            }
            freeC = n2 > 0 ? Pull$.MODULE$.output(new Chunk.Bytes(bytesChunk$2.values(), bytesChunk$2.offset() + bytesChunk$2.length() - n2, n2)) : Pull$.MODULE$.done();
        } else if (n == -1) {
            freeC = Pull$.MODULE$.done();
        } else if (n < inflatedBuffer$2.length) {
            if (inflater$3.finished()) {
                int n3 = inflater$3.getRemaining();
                switch (n3) {
                    default: 
                }
                freeC = n3 > 0 ? Pull$.MODULE$.$greater$greater$extension(Pull$.MODULE$.output(this.copyAsChunkBytes(inflatedBuffer$2, n)), (Function0<Object> & Serializable)() -> new Pull(Pull$.MODULE$.output(new Chunk.Bytes(bytesChunk$2.values(), bytesChunk$2.offset() + bytesChunk$2.length() - n3, n3)))) : Pull$.MODULE$.output(this.copyAsChunkBytes(inflatedBuffer$2, n));
            } else {
                freeC = Pull$.MODULE$.output(this.copyAsChunkBytes(inflatedBuffer$2, n));
            }
        } else {
            freeC = Pull$.MODULE$.$greater$greater$extension(Pull$.MODULE$.output(this.copyAsChunkBytes(inflatedBuffer$2, n)), (Function0<Object> & Serializable)() -> new Pull(this.pull$2(inflater$3, bytesChunk$2, inflatedBuffer$2, crc32$4)));
        }
        return freeC;
    }

    public static final /* synthetic */ FreeC $anonfun$_inflate_stream$3(compression.InflateParams inflateParams$3, Inflater inflater$4, Option crc32$5, byte[] inflatedBuffer$3, Sync SyncF$4, FreeC deflatedStream$2) {
        return MODULE$._inflate_stream(inflateParams$3, inflater$4, crc32$5, inflatedBuffer$3, SyncF$4).apply(new Stream(deflatedStream$2)).fs2$Pull$$free();
    }

    public static final /* synthetic */ FreeC $anonfun$_inflate_stream$2(Inflater inflater$4, Option crc32$5, byte[] inflatedBuffer$3, compression.InflateParams inflateParams$3, Sync SyncF$4, Option x0$1) {
        FreeC<Nothing$, Nothing$, BoxedUnit> freeC;
        Some some;
        Tuple2 tuple2;
        Option option = x0$1;
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            Chunk deflatedChunk = (Chunk)tuple2._1();
            FreeC deflatedStream = ((Stream)tuple2._2()).fs2$Stream$$free();
            freeC = Pull$.MODULE$.$greater$greater$extension(MODULE$._inflate_chunk(inflater$4, crc32$5, deflatedChunk, inflatedBuffer$3), (Function0<Object> & Serializable)() -> new Pull(compression$.$anonfun$_inflate_stream$3(inflateParams$3, inflater$4, crc32$5, inflatedBuffer$3, SyncF$4, deflatedStream)));
        } else if (None$.MODULE$.equals(option)) {
            freeC = !inflater$4.finished() ? Pull$.MODULE$.raiseError(new DataFormatException("Insufficient data"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF$4)) : Pull$.MODULE$.done();
        } else {
            throw new MatchError(option);
        }
        return freeC;
    }

    public static final /* synthetic */ FreeC $anonfun$gzip$10(compression.DeflateParams x2$1, Deflater deflater$6, CRC32 crc32$6, FreeC stream$3) {
        return MODULE$._deflate(x2$1, deflater$6, new Some<CRC32>(crc32$6)).apply(new Stream(stream$3)).fs2$Stream$$free();
    }

    public static final /* synthetic */ FreeC $anonfun$gzip$9(Option fileName$1, Option modificationTime$1, Option comment$1, compression.DeflateParams x2$1, FreeC stream$3, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Deflater deflater = (Deflater)tuple2._1();
        CRC32 crc32 = (CRC32)tuple2._2();
        FreeC freeC = Stream$.MODULE$.$plus$plus$extension(Stream$.MODULE$.$plus$plus$extension(MODULE$._gzip_header(fileName$1, modificationTime$1, comment$1, x2$1.level().juzDeflaterLevel()), (Function0<Object> & Serializable)() -> new Stream(compression$.$anonfun$gzip$10(x2$1, deflater, crc32, stream$3))), (Function0<Object> & Serializable)() -> new Stream(compression$.MODULE$._gzip_trailer(deflater, crc32)));
        return freeC;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ FreeC $anonfun$gzip$5(compression.DeflateParams deflateParams$5, Sync SyncF$5, Option fileName$1, Option modificationTime$1, Option comment$1, FreeC stream) {
        void var6_11;
        compression.DeflateParams deflateParams = deflateParams$5;
        if (deflateParams != null) {
            compression.DeflateParams deflateParams2 = deflateParams;
            compression.ZLibParams.Header header = deflateParams2.header();
            compression$ZLibParams$Header$GZIP$ compression$ZLibParams$Header$GZIP$2 = compression$ZLibParams$Header$GZIP$.MODULE$;
            if (!(header != null ? !header.equals(compression$ZLibParams$Header$GZIP$2) : compression$ZLibParams$Header$GZIP$2 != null)) {
                FreeC freeC = Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.bracket(SyncF$5.delay((Function0<Tuple2> & Serializable)() -> {
                    Deflater deflater = new Deflater(deflateParams2.level().juzDeflaterLevel(), true);
                    deflater.setStrategy(deflateParams2.strategy().juzDeflaterStrategy());
                    return new Tuple2<Deflater, CRC32>(deflater, new CRC32());
                }), (Function1<Tuple2, Object> & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    Deflater deflater = (Deflater)tuple2._1();
                    Object f = SyncF$5.delay(() -> deflater.end());
                    return f;
                }), (Function1<Tuple2, Object> & Serializable)x0$2 -> new Stream(compression$.$anonfun$gzip$9(fileName$1, modificationTime$1, comment$1, deflateParams2, stream, x0$2)));
                return var6_11;
            }
        }
        if (deflateParams == null) throw new MatchError(deflateParams);
        compression.DeflateParams deflateParams3 = deflateParams;
        FreeC freeC = Stream$.MODULE$.raiseError(new ZipException(new StringBuilder(28).append(compression$ZLibParams$Header$GZIP$.MODULE$).append(" header type required, not ").append(deflateParams3.header()).append(".").toString()), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF$5));
        return var6_11;
    }

    public static final /* synthetic */ FreeC $anonfun$_gzip_header$9(Option fileNameEncoded$1) {
        return ((Stream)fileNameEncoded$1.map((Function1<byte[], Object> & Serializable)bytes -> new Stream(Stream$.MODULE$.$plus$plus$extension(Stream$.MODULE$.chunk(compression$.MODULE$.moveAsChunkBytes(bytes)), (Function0<Object> & Serializable)() -> new Stream(Stream$.MODULE$.emit(BoxesRunTime.boxToByte(compression$.MODULE$.zeroByte())))))).getOrElse((Function0<Object> & Serializable)() -> new Stream(Stream$.MODULE$.empty()))).fs2$Stream$$free();
    }

    public static final /* synthetic */ FreeC $anonfun$_gzip_header$13(Option commentEncoded$1) {
        return ((Stream)commentEncoded$1.map((Function1<byte[], Object> & Serializable)bytes -> new Stream(Stream$.MODULE$.$plus$plus$extension(Stream$.MODULE$.chunk(compression$.MODULE$.moveAsChunkBytes(bytes)), (Function0<Object> & Serializable)() -> new Stream(Stream$.MODULE$.emit(BoxesRunTime.boxToByte(compression$.MODULE$.zeroByte())))))).getOrElse((Function0<Object> & Serializable)() -> new Stream(Stream$.MODULE$.empty()))).fs2$Stream$$free();
    }

    public static final /* synthetic */ FreeC $anonfun$gunzip$6(compression.InflateParams x2$2, CRC32 headerCrc32$1, CRC32 contentCrc32$1, Inflater inflater$6, Sync SyncF$6, Option x0$3) {
        FreeC<Object, compression.GunzipResult<Object>, BoxedUnit> freeC;
        Some some;
        Tuple2 tuple2;
        Option option = x0$3;
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            Chunk mandatoryHeaderChunk = (Chunk)tuple2._1();
            FreeC streamAfterMandatoryHeader = ((Stream)tuple2._2()).fs2$Stream$$free();
            freeC = MODULE$._gunzip_matchMandatoryHeader(x2$2, mandatoryHeaderChunk, streamAfterMandatoryHeader, headerCrc32$1, contentCrc32$1, inflater$6, SyncF$6);
        } else if (None$.MODULE$.equals(option)) {
            freeC = Pull$.MODULE$.output1(new compression.GunzipResult(Stream$.MODULE$.raiseError(new EOFException(), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF$6)), compression$GunzipResult$.MODULE$.apply$default$2(), compression$GunzipResult$.MODULE$.apply$default$3(), compression$GunzipResult$.MODULE$.apply$default$4()));
        } else {
            throw new MatchError(option);
        }
        return freeC;
    }

    public static final /* synthetic */ FreeC $anonfun$gunzip$5(FreeC stream$4, compression.InflateParams x2$2, Sync SyncF$6, Tuple3 x0$2) {
        Tuple3 tuple3 = x0$2;
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Inflater inflater = (Inflater)tuple3._1();
        CRC32 headerCrc32 = (CRC32)tuple3._2();
        CRC32 contentCrc32 = (CRC32)tuple3._3();
        FreeC qual$1 = Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(stream$4));
        int x$1 = MODULE$.gzipHeaderBytes();
        boolean x$2 = Stream$ToPull$.MODULE$.unconsN$default$2$extension(qual$1);
        FreeC freeC = Pull$.MODULE$.stream$extension(Pull$.MODULE$.flatMap$extension(Stream$ToPull$.MODULE$.unconsN$extension(qual$1, x$1, x$2), (Function1<Option, Object> & Serializable)x0$3 -> new Pull(compression$.$anonfun$gunzip$6(x2$2, headerCrc32, contentCrc32, inflater, SyncF$6, x0$3))), $less$colon$less$.MODULE$.refl());
        return freeC;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ FreeC $anonfun$gunzip$1(compression.InflateParams inflateParams$4, Sync SyncF$6, FreeC stream) {
        void var3_8;
        compression.InflateParams inflateParams = inflateParams$4;
        if (inflateParams != null) {
            compression.InflateParams inflateParams2 = inflateParams;
            compression.ZLibParams.Header header = inflateParams2.header();
            compression$ZLibParams$Header$GZIP$ compression$ZLibParams$Header$GZIP$2 = compression$ZLibParams$Header$GZIP$.MODULE$;
            if (!(header != null ? !header.equals(compression$ZLibParams$Header$GZIP$2) : compression$ZLibParams$Header$GZIP$2 != null)) {
                FreeC freeC = Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.bracket(SyncF$6.delay((Function0<Tuple3> & Serializable)() -> new Tuple3<Inflater, CRC32, CRC32>(new Inflater(true), new CRC32(), new CRC32())), (Function1<Tuple3, Object> & Serializable)x0$1 -> {
                    Tuple3 tuple3 = x0$1;
                    if (tuple3 == null) {
                        throw new MatchError(tuple3);
                    }
                    Inflater inflater = (Inflater)tuple3._1();
                    Object f = SyncF$6.delay(() -> inflater.end());
                    return f;
                }), (Function1<Tuple3, Object> & Serializable)x0$2 -> new Stream(compression$.$anonfun$gunzip$5(stream, inflateParams2, SyncF$6, x0$2)));
                return var3_8;
            }
        }
        if (inflateParams == null) throw new MatchError(inflateParams);
        compression.InflateParams inflateParams3 = inflateParams;
        FreeC freeC = Stream$.MODULE$.raiseError(new ZipException(new StringBuilder(28).append(compression$ZLibParams$Header$GZIP$.MODULE$).append(" header type required, not ").append(inflateParams3.header()).append(".").toString()), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF$6));
        return var3_8;
    }

    public static final /* synthetic */ FreeC $anonfun$_gunzip_matchMandatoryHeader$1(Sync SyncF$7, Option x0$1) {
        FreeC freeC;
        Some some;
        Tuple2 tuple2;
        Option option = x0$1;
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            compression.GunzipResult gunzipResult = (compression.GunzipResult)tuple2._1();
            freeC = Pull$.MODULE$.output1(gunzipResult);
        } else if (None$.MODULE$.equals(option)) {
            freeC = Pull$.MODULE$.output1(new compression.GunzipResult(Stream$.MODULE$.raiseError(new EOFException(), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF$7)), compression$GunzipResult$.MODULE$.apply$default$2(), compression$GunzipResult$.MODULE$.apply$default$3(), compression$GunzipResult$.MODULE$.apply$default$4()));
        } else {
            throw new MatchError(option);
        }
        return freeC;
    }

    public static final /* synthetic */ FreeC $anonfun$_gunzip_readOptionalHeader$2(long secondsSince197001010000$1, Option fileName$2, byte flags$1, CRC32 headerCrc32$2, Sync SyncF$8, compression.InflateParams inflateParams$5, Inflater inflater$7, CRC32 contentCrc32$2, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option comment = (Option)tuple2._1();
        FreeC streamAfterComment = ((Stream)tuple2._2()).fs2$Stream$$free();
        Option x$1 = secondsSince197001010000$1 != 0L ? new Some<Instant>(Instant.ofEpochSecond(secondsSince197001010000$1)) : None$.MODULE$;
        Option x$2 = fileName$2;
        Option x$3 = comment;
        FreeC x$4 = Stream$.MODULE$.through$extension(Stream$.MODULE$.through$extension(Stream$.MODULE$.through$extension(streamAfterComment, MODULE$._gunzip_validateHeader((byte)(flags$1 & compression$gzipFlag$.MODULE$.FHCRC()) == compression$gzipFlag$.MODULE$.FHCRC(), headerCrc32$2, SyncF$8)), MODULE$._inflate(inflateParams$5, inflater$7, new Some<CRC32>(contentCrc32$2), SyncF$8)), MODULE$._gunzip_validateTrailer(contentCrc32$2, inflater$7, SyncF$8));
        FreeC freeC = Stream$.MODULE$.emit(new compression.GunzipResult(x$4, x$1, x$2, x$3));
        return freeC;
    }

    public static final /* synthetic */ FreeC $anonfun$_gunzip_readOptionalHeader$1(byte flags$1, CRC32 headerCrc32$2, Sync SyncF$8, long secondsSince197001010000$1, compression.InflateParams inflateParams$5, Inflater inflater$7, CRC32 contentCrc32$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option fileName = (Option)tuple2._1();
        FreeC streamAfterFileName = ((Stream)tuple2._2()).fs2$Stream$$free();
        FreeC freeC = Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.through$extension(streamAfterFileName, MODULE$._gunzip_readOptionalStringField(compression$gzipFlag$.MODULE$.fcomment(flags$1), headerCrc32$2, "file comment", MODULE$.fileCommentBytesSoftLimit(), SyncF$8)), (Function1<Tuple2, Object> & Serializable)x0$2 -> new Stream(compression$.$anonfun$_gunzip_readOptionalHeader$2(secondsSince197001010000$1, fileName, flags$1, headerCrc32$2, SyncF$8, inflateParams$5, inflater$7, contentCrc32$2, x0$2)));
        return freeC;
    }

    public static final /* synthetic */ FreeC $anonfun$_gunzip_skipOptionalExtraField$3(CRC32 crc32$8, Sync Sync$1, Option x0$2) {
        FreeC freeC;
        Some some;
        Tuple2 tuple2;
        Option option = x0$2;
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            Chunk optionalExtraFieldChunk = (Chunk)tuple2._1();
            FreeC streamAfterOptionalExtraField = ((Stream)tuple2._2()).fs2$Stream$$free();
            Chunk.Bytes fieldBytes = optionalExtraFieldChunk.toBytes($less$colon$less$.MODULE$.refl());
            crc32$8.update(fieldBytes.values(), fieldBytes.offset(), fieldBytes.length());
            freeC = Pull$.MODULE$.output1(new Stream(streamAfterOptionalExtraField));
        } else if (None$.MODULE$.equals(option)) {
            freeC = Pull$.MODULE$.raiseError(new ZipException("Failed to read optional extra field header"), RaiseThrowable$.MODULE$.fromApplicativeError(Sync$1));
        } else {
            throw new MatchError(option);
        }
        return freeC;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static final /* synthetic */ FreeC $anonfun$_gunzip_skipOptionalExtraField$2(CRC32 crc32$8, Sync Sync$1, Option x0$1) {
        block5: {
            block4: {
                var5_3 = x0$1;
                if (!(var5_3 instanceof Some) || (var7_5 = (Tuple2)(var6_4 = (Some)var5_3).value()) == null) break block4;
                optionalExtraFieldLengthChunk = (Chunk)var7_5._1();
                streamAfterOptionalExtraFieldLength = ((Stream)var7_5._2()).fs2$Stream$$free();
                var10_8 = new Tuple2<Integer, byte[]>(BoxesRunTime.boxToInteger(optionalExtraFieldLengthChunk.size()), optionalExtraFieldLengthChunk.toBytes($less$colon$less$.MODULE$.refl()).values());
                if (var10_8 == null) ** GOTO lbl-1000
                var11_9 = var10_8._1$mcI$sp();
                lengthBytes = var10_8._2();
                if (compression$.MODULE$.gzipOptionalExtraFieldLengthBytes() == var11_9 && lengthBytes != null && !Array$UnapplySeqWrapper$.MODULE$.isEmpty$extension(var13_11 = Array$.MODULE$.unapplySeq(lengthBytes)) && new Array.UnapplySeqWrapper<T>(Array$UnapplySeqWrapper$.MODULE$.get$extension(var13_11)) != null && Array$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(var13_11), 2) == 0) {
                    firstByte = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(var13_11), 0));
                    secondByte = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(var13_11), 1));
                    crc32$8.update(lengthBytes);
                    optionalExtraFieldLength = compression$.MODULE$.unsignedToInt(firstByte, secondByte);
                    qual$2 = Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(streamAfterOptionalExtraFieldLength));
                    x$3 = optionalExtraFieldLength;
                    x$4 = Stream$ToPull$.MODULE$.unconsN$default$2$extension(qual$2);
                    var4_18 /* !! */  = Pull$.MODULE$.flatMap$extension(Stream$ToPull$.MODULE$.unconsN$extension(qual$2, x$3, x$4), (Function1<Option, Object> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$_gunzip_skipOptionalExtraField$3$adapted(java.util.zip.CRC32 cats.effect.Sync scala.Option ), (Lscala/Option;)Ljava/lang/Object;)((CRC32)crc32$8, (Sync)Sync$1));
                } else lbl-1000:
                // 2 sources

                {
                    var4_18 /* !! */  = Pull$.MODULE$.raiseError(new ZipException("Failed to read optional extra field header length"), RaiseThrowable$.MODULE$.fromApplicativeError(Sync$1));
                }
                var3_19 = var4_18 /* !! */ ;
                break block5;
            }
            if (None$.MODULE$.equals(var5_3)) {
                var3_19 = Pull$.MODULE$.raiseError(new EOFException(), RaiseThrowable$.MODULE$.fromApplicativeError(Sync$1));
            } else {
                throw new MatchError(var5_3);
            }
        }
        return var3_19;
    }

    public static final /* synthetic */ FreeC $anonfun$_gunzip_skipOptionalExtraField$1(boolean isPresent$1, CRC32 crc32$8, Sync Sync$1, FreeC stream) {
        FreeC freeC;
        if (isPresent$1) {
            FreeC qual$1 = Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(stream));
            int x$1 = MODULE$.gzipOptionalExtraFieldLengthBytes();
            boolean x$2 = Stream$ToPull$.MODULE$.unconsN$default$2$extension(qual$1);
            freeC = Stream$.MODULE$.flatten$extension(Pull$.MODULE$.stream$extension(Pull$.MODULE$.flatMap$extension(Stream$ToPull$.MODULE$.unconsN$extension(qual$1, x$1, x$2), (Function1<Option, Object> & Serializable)x0$1 -> new Pull(compression$.$anonfun$_gunzip_skipOptionalExtraField$2(crc32$8, Sync$1, x0$1))), $less$colon$less$.MODULE$.refl()), $less$colon$less$.MODULE$.refl());
        } else {
            freeC = stream;
        }
        return freeC;
    }

    public static final /* synthetic */ boolean $anonfun$_gunzip_readOptionalStringField$2(byte x$8) {
        return x$8 == MODULE$.zeroByte();
    }

    public static final /* synthetic */ boolean $anonfun$_gunzip_readOptionalStringField$4(CRC32 crc32$9, byte by) {
        crc32$9.update(by);
        return by != MODULE$.zeroByte();
    }

    public static final /* synthetic */ FreeC $anonfun$_gunzip_readOptionalStringField$3(CRC32 crc32$9, String fieldName$1, Sync SyncF$9, Option x0$1) {
        FreeC freeC;
        Some some;
        Tuple2 tuple2;
        Option option = x0$1;
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            Some<String> some2;
            Chunk chunk = (Chunk)tuple2._1();
            FreeC rest = ((Stream)tuple2._2()).fs2$Stream$$free();
            if (chunk.isEmpty()) {
                some2 = new Some<String>("");
            } else {
                Chunk.Bytes bytesChunk = chunk.toBytes($less$colon$less$.MODULE$.refl());
                crc32$9.update(bytesChunk.values(), bytesChunk.offset(), bytesChunk.length());
                some2 = new Some<String>(new String(bytesChunk.values(), bytesChunk.offset(), bytesChunk.length(), StandardCharsets.ISO_8859_1));
            }
            freeC = Pull$.MODULE$.output1(new Tuple2(some2, new Stream(Stream$.MODULE$.drop$extension(Stream$.MODULE$.dropWhile$extension(rest, (Function1<Object, Object> & Serializable)object -> BoxesRunTime.boxToBoolean(compression$.$anonfun$_gunzip_readOptionalStringField$4(crc32$9, BoxesRunTime.unboxToByte(object)))), 1L))));
        } else if (None$.MODULE$.equals(option)) {
            freeC = Pull$.MODULE$.output1(new Tuple2(Option$.MODULE$.empty(), new Stream(Stream$.MODULE$.raiseError(new ZipException(new StringBuilder(21).append("Failed to read ").append(fieldName$1).append(" field").toString()), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF$9)))));
        } else {
            throw new MatchError(option);
        }
        return freeC;
    }

    public static final /* synthetic */ FreeC $anonfun$_gunzip_readOptionalStringField$1(boolean isPresent$2, int fieldBytesSoftLimit$1, CRC32 crc32$9, String fieldName$1, Sync SyncF$9, FreeC stream) {
        return isPresent$2 ? Pull$.MODULE$.stream$extension(Pull$.MODULE$.flatMap$extension(MODULE$.unconsUntil((Function1<Object, Object> & Serializable)x$8 -> BoxesRunTime.boxToBoolean(compression$.$anonfun$_gunzip_readOptionalStringField$2(BoxesRunTime.unboxToByte(x$8))), fieldBytesSoftLimit$1).apply(new Stream(stream)).fs2$Pull$$free(), (Function1<Option, Object> & Serializable)x0$1 -> new Pull(compression$.$anonfun$_gunzip_readOptionalStringField$3(crc32$9, fieldName$1, SyncF$9, x0$1))), $less$colon$less$.MODULE$.refl()) : Stream$.MODULE$.emit(new Tuple2(Option$.MODULE$.empty(), new Stream(stream)));
    }

    public static final /* synthetic */ FreeC $anonfun$_gunzip_validateHeader$2(CRC32 crc32$10, Sync SyncF$10, Option x0$1) {
        FreeC freeC;
        Some some;
        Tuple2 tuple2;
        Option option = x0$1;
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            long actualHeaderCrc16;
            Chunk headerCrcChunk = (Chunk)tuple2._1();
            FreeC streamAfterHeaderCrc = ((Stream)tuple2._2()).fs2$Stream$$free();
            int expectedHeaderCrc16 = MODULE$.unsignedToInt(BoxesRunTime.unboxToByte(headerCrcChunk.apply(0)), BoxesRunTime.unboxToByte(headerCrcChunk.apply(1)));
            freeC = (long)expectedHeaderCrc16 != (actualHeaderCrc16 = crc32$10.getValue() & 0xFFFFL) ? Pull$.MODULE$.raiseError(new ZipException("Header failed CRC validation"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF$10)) : Pull$.MODULE$.output1(new Stream(streamAfterHeaderCrc));
        } else if (None$.MODULE$.equals(option)) {
            freeC = Pull$.MODULE$.raiseError(new ZipException("Failed to read header CRC"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF$10));
        } else {
            throw new MatchError(option);
        }
        return freeC;
    }

    public static final /* synthetic */ FreeC $anonfun$_gunzip_validateHeader$1(boolean isPresent$3, CRC32 crc32$10, Sync SyncF$10, FreeC stream) {
        FreeC freeC;
        if (isPresent$3) {
            FreeC qual$1 = Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(stream));
            int x$1 = MODULE$.gzipHeaderCrcBytes();
            boolean x$2 = Stream$ToPull$.MODULE$.unconsN$default$2$extension(qual$1);
            freeC = Stream$.MODULE$.flatten$extension(Pull$.MODULE$.stream$extension(Pull$.MODULE$.flatMap$extension(Stream$ToPull$.MODULE$.unconsN$extension(qual$1, x$1, x$2), (Function1<Option, Object> & Serializable)x0$1 -> new Pull(compression$.$anonfun$_gunzip_validateHeader$2(crc32$10, SyncF$10, x0$1))), $less$colon$less$.MODULE$.refl()), $less$colon$less$.MODULE$.refl());
        } else {
            freeC = stream;
        }
        return freeC;
    }

    private static final FreeC validateTrailer$1(Chunk trailerChunk, CRC32 crc32$11, Inflater inflater$8, Sync SyncF$11) {
        FreeC<Object, Nothing$, Serializable> freeC;
        if (trailerChunk.size() == MODULE$.gzipTrailerBytes()) {
            long expectedInputCrc32 = MODULE$.unsignedToLong(BoxesRunTime.unboxToByte(trailerChunk.apply(0)), BoxesRunTime.unboxToByte(trailerChunk.apply(1)), BoxesRunTime.unboxToByte(trailerChunk.apply(2)), BoxesRunTime.unboxToByte(trailerChunk.apply(3)));
            long actualInputCrc32 = crc32$11.getValue();
            long expectedInputSize = MODULE$.unsignedToLong(BoxesRunTime.unboxToByte(trailerChunk.apply(4)), BoxesRunTime.unboxToByte(trailerChunk.apply(5)), BoxesRunTime.unboxToByte(trailerChunk.apply(6)), BoxesRunTime.unboxToByte(trailerChunk.apply(7)));
            long actualInputSize = inflater$8.getBytesWritten() & 0xFFFFFFFFL;
            freeC = expectedInputCrc32 != actualInputCrc32 ? Pull$.MODULE$.raiseError(new ZipException("Content failed CRC validation"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF$11)) : (expectedInputSize != actualInputSize ? Pull$.MODULE$.raiseError(new ZipException("Content failed size validation"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF$11)) : Pull$.MODULE$.done());
        } else {
            freeC = Pull$.MODULE$.raiseError(new ZipException("Failed to read trailer (1)"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF$11));
        }
        return freeC;
    }

    public static final /* synthetic */ FreeC $anonfun$_gunzip_validateTrailer$4(Chunk next$1, FreeC rest$1, Inflater inflater$8, CRC32 crc32$11, Sync SyncF$11) {
        return ((Pull)compression$.streamUntilTrailer$1(next$1, inflater$8, crc32$11, SyncF$11).apply(new Stream(rest$1))).fs2$Pull$$free();
    }

    public static final /* synthetic */ FreeC $anonfun$_gunzip_validateTrailer$6(FreeC rest$1, Inflater inflater$8, CRC32 crc32$11, Sync SyncF$11) {
        return ((Pull)compression$.streamUntilTrailer$1(Chunk$.MODULE$.empty(), inflater$8, crc32$11, SyncF$11).apply(new Stream(rest$1))).fs2$Pull$$free();
    }

    public static final /* synthetic */ FreeC $anonfun$_gunzip_validateTrailer$7(FreeC rest$1, Inflater inflater$8, CRC32 crc32$11, Sync SyncF$11) {
        return ((Pull)compression$.streamUntilTrailer$1(Chunk$.MODULE$.empty(), inflater$8, crc32$11, SyncF$11).apply(new Stream(rest$1))).fs2$Pull$$free();
    }

    public static final /* synthetic */ FreeC $anonfun$_gunzip_validateTrailer$3(Inflater inflater$8, Chunk last$1, CRC32 crc32$11, Sync SyncF$11, Option x0$1) {
        FreeC freeC;
        Some some;
        Tuple2 tuple2;
        Option option = x0$1;
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            Chunk next = (Chunk)tuple2._1();
            FreeC rest = ((Stream)tuple2._2()).fs2$Stream$$free();
            freeC = inflater$8.finished() ? (next.size() >= MODULE$.gzipTrailerBytes() ? (last$1.nonEmpty() ? Pull$.MODULE$.$greater$greater$extension(Pull$.MODULE$.output(last$1), (Function0<Object> & Serializable)() -> new Pull(compression$.$anonfun$_gunzip_validateTrailer$4(next, rest, inflater$8, crc32$11, SyncF$11))) : ((Pull)compression$.streamUntilTrailer$1(next, inflater$8, crc32$11, SyncF$11).apply(new Stream(rest))).fs2$Pull$$free()) : ((Pull)compression$.streamUntilTrailer$1(Chunk$.MODULE$.concatBytes((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Chunk.Bytes[]{last$1.toBytes($less$colon$less$.MODULE$.refl()), next.toBytes($less$colon$less$.MODULE$.refl())}))), inflater$8, crc32$11, SyncF$11).apply(new Stream(rest))).fs2$Pull$$free()) : (last$1.nonEmpty() ? Pull$.MODULE$.$greater$greater$extension(Pull$.MODULE$.$greater$greater$extension(Pull$.MODULE$.output(last$1), (Function0<Object> & Serializable)() -> new Pull(Pull$.MODULE$.output(next))), (Function0<Object> & Serializable)() -> new Pull(compression$.$anonfun$_gunzip_validateTrailer$6(rest, inflater$8, crc32$11, SyncF$11))) : Pull$.MODULE$.$greater$greater$extension(Pull$.MODULE$.output(next), (Function0<Object> & Serializable)() -> new Pull(compression$.$anonfun$_gunzip_validateTrailer$7(rest, inflater$8, crc32$11, SyncF$11))));
        } else if (None$.MODULE$.equals(option)) {
            int preTrailerBytes = last$1.size() - MODULE$.gzipTrailerBytes();
            freeC = preTrailerBytes > 0 ? Pull$.MODULE$.$greater$greater$extension(Pull$.MODULE$.output(last$1.take(preTrailerBytes)), (Function0<Object> & Serializable)() -> new Pull(compression$.validateTrailer$1(last$1.drop(preTrailerBytes), crc32$11, inflater$8, SyncF$11))) : compression$.validateTrailer$1(last$1, crc32$11, inflater$8, SyncF$11);
        } else {
            throw new MatchError(option);
        }
        return freeC;
    }

    private static final Function1 streamUntilTrailer$1(Chunk last, Inflater inflater$8, CRC32 crc32$11, Sync SyncF$11) {
        return (Function1<Object, Object> & Serializable)x$9 -> new Pull(Pull$.MODULE$.flatMap$extension(Stream$ToPull$.MODULE$.unconsNonEmpty$extension(Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(((Stream)x$9).fs2$Stream$$free()))), (Function1<Option, Object> & Serializable)x0$1 -> new Pull(compression$.$anonfun$_gunzip_validateTrailer$3(inflater$8, last$1, crc32$11, SyncF$11, x0$1))));
    }

    public static final /* synthetic */ FreeC $anonfun$unconsUntil$2(Function1 predicate$1, List acc$1, int size$1, int softLimit$1, Option x0$1) {
        Some some;
        Tuple2 tuple2;
        FreeC freeC;
        Option option = x0$1;
        if (None$.MODULE$.equals(option)) {
            freeC = Pull$.MODULE$.pure(None$.MODULE$);
        } else if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            FreeC freeC2;
            Chunk hd = (Chunk)tuple2._1();
            FreeC tl = ((Stream)tuple2._2()).fs2$Stream$$free();
            Option<Object> option2 = hd.indexWhere(predicate$1);
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                int i = BoxesRunTime.unboxToInt(some2.value());
                Tuple2 tuple22 = hd.splitAt(i);
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                Chunk pfx = tuple22._1();
                Chunk sfx = tuple22._2();
                Tuple2 tuple23 = new Tuple2(pfx, sfx);
                Tuple2 tuple24 = tuple23;
                Chunk pfx2 = tuple24._1();
                Chunk sfx2 = tuple24._2();
                Chunk chunk = pfx2;
                freeC2 = Pull$.MODULE$.pure(new Some(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Chunk$.MODULE$.concat(acc$1.$colon$colon(chunk).reverse())), new Stream(Stream$.MODULE$.cons$extension(tl, sfx2)))));
            } else if (None$.MODULE$.equals(option2)) {
                FreeC freeC3;
                int newSize = size$1 + hd.size();
                if (newSize < softLimit$1) {
                    Chunk chunk = hd;
                    freeC3 = compression$.go$1(acc$1.$colon$colon(chunk), tl, newSize, predicate$1, softLimit$1);
                } else {
                    Chunk chunk = hd;
                    freeC3 = Pull$.MODULE$.pure(new Some(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Chunk$.MODULE$.concat(acc$1.$colon$colon(chunk).reverse())), new Stream(tl))));
                }
                freeC2 = freeC3;
            } else {
                throw new MatchError(option2);
            }
            freeC = freeC2;
        } else {
            throw new MatchError(option);
        }
        return freeC;
    }

    private static final FreeC go$1(List acc, FreeC rest, int size, Function1 predicate$1, int softLimit$1) {
        return Pull$.MODULE$.flatMap$extension(Stream$ToPull$.MODULE$.uncons$extension(Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(rest))), (Function1<Option, Object> & Serializable)x0$1 -> new Pull(compression$.$anonfun$unconsUntil$2(predicate$1, acc, size, softLimit$1, x0$1)));
    }

    private static final int go$default$3$1() {
        return 0;
    }

    private compression$() {
    }

    public static final /* synthetic */ Object $anonfun$_gunzip_skipOptionalExtraField$3$adapted(CRC32 crc32$8, Sync Sync$1, Option x0$2) {
        return new Pull(compression$.$anonfun$_gunzip_skipOptionalExtraField$3(crc32$8, Sync$1, x0$2));
    }
}

