/*
 * Decompiled with CFR 0.152.
 */
package fs2.io.file;

import cats.effect.Blocker$;
import cats.effect.ContextShift;
import cats.effect.Resource;
import cats.effect.Resource$;
import cats.effect.Sync;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.io.file.FileHandle;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.reflect.ClassTag$;
import scala.runtime.LambdaDeserialize;

public final class FileHandle$ {
    public static final FileHandle$ MODULE$ = new FileHandle$();

    public <F> Resource<F, FileHandle<F>> fromPath(Path path, ExecutionContext blocker, Seq<OpenOption> flags, Sync<F> F, ContextShift<F> cs) {
        return this.fromFileChannel(Blocker$.MODULE$.delay$extension(blocker, (Function0<FileChannel> & Serializable)() -> FileChannel.open(path, (OpenOption[])flags.toArray(ClassTag$.MODULE$.apply(OpenOption.class))), F, cs), blocker, F, cs);
    }

    public <F> Resource<F, FileHandle<F>> fromFileChannel(F channel, ExecutionContext blocker, Sync<F> F, ContextShift<F> cs) {
        return Resource$.MODULE$.make(channel, (Function1<FileChannel, Object> & Serializable)ch -> Blocker$.MODULE$.delay$extension(blocker, () -> ch.close(), F, cs), F).map((Function1<FileChannel, FileHandle> & Serializable)ch -> MODULE$.mk((FileChannel)ch, blocker, F, cs), F);
    }

    private <F> FileHandle<F> mk(FileChannel chan, ExecutionContext blocker, Sync<F> F, ContextShift<F> cs) {
        return new FileHandle<F>(blocker, chan, F, cs){
            private final ExecutionContext blocker$2;
            private final FileChannel chan$1;
            private final Sync F$2;
            private final ContextShift cs$2;

            public F force(boolean metaData) {
                return Blocker$.MODULE$.delay$extension(this.blocker$2, () -> $this.chan$1.force(metaData), this.F$2, this.cs$2);
            }

            public F lock() {
                return Blocker$.MODULE$.delay$extension(this.blocker$2, (Function0<FileLock> & Serializable)() -> $this.chan$1.lock(), this.F$2, this.cs$2);
            }

            public F lock(long position, long size, boolean shared) {
                return Blocker$.MODULE$.delay$extension(this.blocker$2, (Function0<FileLock> & Serializable)() -> $this.chan$1.lock(position, size, shared), this.F$2, this.cs$2);
            }

            public F read(int numBytes, long offset) {
                return Blocker$.MODULE$.delay$extension(this.blocker$2, (Function0<Option> & Serializable)() -> {
                    ByteBuffer buf = ByteBuffer.allocate(numBytes);
                    int len = $this.chan$1.read(buf, offset);
                    return len < 0 ? None$.MODULE$ : (len == 0 ? new Some<Chunk<A>>(Chunk$.MODULE$.empty()) : new Some<Chunk<Object>>(Chunk$.MODULE$.bytes(buf.array(), 0, len)));
                }, this.F$2, this.cs$2);
            }

            public F size() {
                return Blocker$.MODULE$.delay$extension(this.blocker$2, () -> $this.chan$1.size(), this.F$2, this.cs$2);
            }

            public F truncate(long size) {
                return Blocker$.MODULE$.delay$extension(this.blocker$2, () -> $this.chan$1.truncate(size), this.F$2, this.cs$2);
            }

            public F tryLock() {
                return Blocker$.MODULE$.delay$extension(this.blocker$2, (Function0<Option> & Serializable)() -> Option$.MODULE$.apply($this.chan$1.tryLock()), this.F$2, this.cs$2);
            }

            public F tryLock(long position, long size, boolean shared) {
                return Blocker$.MODULE$.delay$extension(this.blocker$2, (Function0<Option> & Serializable)() -> Option$.MODULE$.apply($this.chan$1.tryLock(position, size, shared)), this.F$2, this.cs$2);
            }

            public F unlock(FileLock f) {
                return Blocker$.MODULE$.delay$extension(this.blocker$2, () -> f.release(), this.F$2, this.cs$2);
            }

            public F write(Chunk<Object> bytes, long offset) {
                return Blocker$.MODULE$.delay$extension(this.blocker$2, () -> $this.chan$1.write(bytes.toBytes($less$colon$less$.MODULE$.refl()).toByteBuffer($less$colon$less$.MODULE$.refl()), offset), this.F$2, this.cs$2);
            }
            {
                this.blocker$2 = blocker$2;
                this.chan$1 = chan$1;
                this.F$2 = F$2;
                this.cs$2 = cs$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$force$1(fs2.io.file.FileHandle$$anon$1 boolean ), $anonfun$lock$1(fs2.io.file.FileHandle$$anon$1 ), $anonfun$lock$2(fs2.io.file.FileHandle$$anon$1 long long boolean ), $anonfun$read$1(fs2.io.file.FileHandle$$anon$1 int long ), $anonfun$size$1(fs2.io.file.FileHandle$$anon$1 ), $anonfun$truncate$1(fs2.io.file.FileHandle$$anon$1 long ), $anonfun$tryLock$1(fs2.io.file.FileHandle$$anon$1 ), $anonfun$tryLock$2(fs2.io.file.FileHandle$$anon$1 long long boolean ), $anonfun$unlock$1(java.nio.channels.FileLock ), $anonfun$write$1(fs2.io.file.FileHandle$$anon$1 fs2.Chunk long )}, serializedLambda);
            }
        };
    }

    private FileHandle$() {
    }
}

