/*
 * Decompiled with CFR 0.152.
 */
package fs2.io.tls;

import cats.Applicative$;
import cats.effect.Concurrent;
import cats.effect.Resource;
import cats.effect.Resource$;
import cats.effect.Sync$;
import cats.syntax.package$all$;
import fs2.Chunk;
import fs2.Stream;
import fs2.Stream$;
import fs2.internal.FreeC;
import fs2.io.tls.DTLSSocket;
import fs2.io.tls.DTLSSocket$;
import fs2.io.tls.TLSEngine;
import fs2.io.udp.Packet;
import fs2.io.udp.Socket;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;

public final class DTLSSocket$ {
    public static final DTLSSocket$ MODULE$ = new DTLSSocket$();

    public <F> Resource<F, DTLSSocket<F>> apply(Socket<F> socket, InetSocketAddress remoteAddress, TLSEngine<F> engine, Concurrent<F> evidence$1) {
        return Resource$.MODULE$.make(this.mk(socket, remoteAddress, engine, evidence$1), (Function1<DTLSSocket, Object> & Serializable)x$1 -> x$1.close(), evidence$1);
    }

    private <F> F mk(Socket<F> socket, InetSocketAddress remoteAddress, TLSEngine<F> engine, Concurrent<F> evidence$2) {
        return Applicative$.MODULE$.apply(evidence$2).pure(new DTLSSocket<F>(engine, evidence$2, remoteAddress, socket){
            private final TLSEngine engine$1;
            private final Concurrent evidence$2$1;
            private final InetSocketAddress remoteAddress$1;
            private final Socket socket$1;

            public F read(Option<FiniteDuration> timeout) {
                return package$all$.MODULE$.toFlatMapOps(this.engine$1.read(Integer.MAX_VALUE, timeout), this.evidence$2$1).flatMap((Function1<Option, Object> & Serializable)x0$1 -> {
                    F f;
                    Option option = x0$1;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Chunk bytes = (Chunk)some.value();
                        f = Applicative$.MODULE$.apply($this.evidence$2$1).pure(new Packet($this.remoteAddress$1, bytes));
                    } else if (None$.MODULE$.equals(option)) {
                        f = this.read(timeout);
                    } else {
                        throw new MatchError(option);
                    }
                    return f;
                });
            }

            public Option<FiniteDuration> read$default$1() {
                return None$.MODULE$;
            }

            public FreeC<F, Packet, BoxedUnit> reads(Option<FiniteDuration> timeout) {
                return Stream$.MODULE$.repeatEval(this.read(timeout));
            }

            public Option<FiniteDuration> reads$default$1() {
                return None$.MODULE$;
            }

            public F write(Packet packet, Option<FiniteDuration> timeout) {
                return this.engine$1.write(packet.bytes(), timeout);
            }

            public Option<FiniteDuration> write$default$2() {
                return None$.MODULE$;
            }

            public Function1<Stream<F, Packet>, Stream<F, BoxedUnit>> writes(Option<FiniteDuration> timeout) {
                return (Function1<Object, Object> & Serializable)x$2 -> new Stream<F, O>(anon.1.$anonfun$writes$1(this, timeout, ((Stream)x$2).fs2$Stream$$free()));
            }

            public Option<FiniteDuration> writes$default$1() {
                return None$.MODULE$;
            }

            public F localAddress() {
                return this.socket$1.localAddress();
            }

            public F close() {
                return this.socket$1.close();
            }

            public F join(InetAddress group, NetworkInterface networkInterface) {
                return Sync$.MODULE$.apply(this.evidence$2$1).raiseError(new RuntimeException("DTLSSocket does not support multicast"));
            }

            public F join(InetAddress group, NetworkInterface networkInterface, InetAddress source) {
                return Sync$.MODULE$.apply(this.evidence$2$1).raiseError(new RuntimeException("DTLSSocket does not support multicast"));
            }

            public F beginHandshake() {
                return this.engine$1.beginHandshake();
            }

            public F session() {
                return this.engine$1.session();
            }

            public static final /* synthetic */ FreeC $anonfun$writes$2(anon.1 $this, Option timeout$2, Packet p) {
                return Stream$.MODULE$.eval($this.write(p, timeout$2));
            }

            public static final /* synthetic */ FreeC $anonfun$writes$1(anon.1 $this, Option timeout$2, FreeC x$2) {
                return Stream$.MODULE$.flatMap$extension(x$2, (Function1<Packet, Object> & Serializable)p -> new Stream<F, O>(anon.1.$anonfun$writes$2($this, timeout$2, p)));
            }
            {
                this.engine$1 = engine$1;
                this.evidence$2$1 = evidence$2$1;
                this.remoteAddress$1 = remoteAddress$1;
                this.socket$1 = socket$1;
                Socket.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$1(fs2.io.tls.DTLSSocket$$anon$1 scala.Option scala.Option ), $anonfun$writes$1$adapted(fs2.io.tls.DTLSSocket$$anon$1 scala.Option java.lang.Object ), $anonfun$writes$2$adapted(fs2.io.tls.DTLSSocket$$anon$1 scala.Option fs2.io.udp.Packet )}, serializedLambda);
            }
        });
    }

    private DTLSSocket$() {
    }
}

