/*
 * Decompiled with CFR 0.152.
 */
package org.http4s;

import cats.Invariant$;
import cats.Semigroupal$;
import cats.UnorderedFoldable$;
import cats.data.NonEmptyList;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.effect.Blocker$;
import cats.effect.ContextShift;
import cats.effect.IO$;
import cats.effect.Sync;
import cats.effect.Sync$;
import cats.kernel.Eq$;
import cats.kernel.Semigroup;
import cats.kernel.Semigroup$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.EitherOps$;
import cats.syntax.package$all$;
import fs2.Stream;
import fs2.Stream$;
import fs2.Stream$PureOps$;
import fs2.internal.FreeC;
import io.chrisdavenport.vault.Key;
import io.chrisdavenport.vault.Key$;
import io.chrisdavenport.vault.Vault;
import io.chrisdavenport.vault.Vault$;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import org.http4s.ContentCoding$;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.HttpDate;
import org.http4s.HttpDate$;
import org.http4s.HttpVersion;
import org.http4s.MediaType;
import org.http4s.MediaType$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.TransferCoding$;
import org.http4s.headers.Accept$minusEncoding;
import org.http4s.headers.Accept$minusEncoding$;
import org.http4s.headers.Content$minusEncoding;
import org.http4s.headers.Content$minusLength;
import org.http4s.headers.Content$minusLength$;
import org.http4s.headers.Content$minusType;
import org.http4s.headers.Content$minusType$;
import org.http4s.headers.ETag;
import org.http4s.headers.ETag$;
import org.http4s.headers.If$minusModified$minusSince;
import org.http4s.headers.If$minusModified$minusSince$;
import org.http4s.headers.If$minusNone$minusMatch;
import org.http4s.headers.If$minusNone$minusMatch$;
import org.http4s.headers.Last$minusModified;
import org.http4s.headers.Transfer$minusEncoding$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

public final class StaticFile$ {
    public static final StaticFile$ MODULE$ = new StaticFile$();
    private static final Logger logger = LoggerFactory.getLogger("org.http4s.StaticFile");
    private static final int DefaultBufferSize = 10240;
    private static final Key<File> staticFileKey = (Key)Key$.MODULE$.newKey(IO$.MODULE$.ioEffect()).unsafeRunSync();

    public int DefaultBufferSize() {
        return DefaultBufferSize;
    }

    public <F> OptionT<F, Response<F>> fromString(String url, ExecutionContext blocker, Option<Request<F>> req, Sync<F> evidence$1, ContextShift<F> evidence$2) {
        return this.fromFile(new File(url), blocker, req, evidence$1, evidence$2);
    }

    public <F> None$ fromString$default$3() {
        return None$.MODULE$;
    }

    public <F> OptionT<F, Response<F>> fromResource(String name, ExecutionContext blocker, Option<Request<F>> req, boolean preferGzipped, Option<ClassLoader> classloader, Sync<F> evidence$3, ContextShift<F> evidence$4) {
        ClassLoader loader = (ClassLoader)classloader.getOrElse((Function0<ClassLoader> & Serializable)() -> MODULE$.getClass().getClassLoader());
        boolean tryGzipped = preferGzipped && req.flatMap((Function1<Request, Option> & Serializable)x$1 -> Headers$.MODULE$.get$extension((List<Header>)x$1.headers(), Accept$minusEncoding$.MODULE$)).exists((Function1<Accept$minusEncoding, Object> & Serializable)acceptEncoding -> BoxesRunTime.boxToBoolean(StaticFile$.$anonfun$fromResource$3(acceptEncoding)));
        String normalizedName = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps(name.split("/")), (Function1<String, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2))))).mkString("/");
        OptionT gzUrl = tryGzipped ? StaticFile$.getResource$1(new StringBuilder(3).append(normalizedName).append(".gz").toString(), evidence$3, loader) : OptionT$.MODULE$.none(evidence$3);
        return gzUrl.flatMap((Function1<URL, OptionT> & Serializable)url -> {
            Option<Content$minusType> contentType = MODULE$.nameToContentType(normalizedName);
            Content$minusEncoding content$minusEncoding = new Content$minusEncoding(ContentCoding$.MODULE$.gzip());
            List<Content$minusEncoding> headers = contentType.toList().$colon$colon(content$minusEncoding);
            return MODULE$.fromURL((URL)url, blocker, req, evidence$3, evidence$4).map((Function1<Response, Response> & Serializable)x$3 -> (Response)x$3.removeHeader(Content$minusType$.MODULE$).putHeaders(headers), evidence$3);
        }, evidence$3).orElse((Function0<OptionT> & Serializable)() -> StaticFile$.getResource$1(normalizedName, evidence$3, loader).flatMap((Function1<URL, OptionT> & Serializable)x$4 -> MODULE$.fromURL((URL)x$4, blocker, req, evidence$3, evidence$4), evidence$3), evidence$3);
    }

    public <F> None$ fromResource$default$3() {
        return None$.MODULE$;
    }

    public <F> boolean fromResource$default$4() {
        return false;
    }

    public <F> Option<ClassLoader> fromResource$default$5() {
        return None$.MODULE$;
    }

    public <F> OptionT<F, Response<F>> fromURL(URL url, ExecutionContext blocker, Option<Request<F>> req, Sync<F> F, ContextShift<F> cs) {
        String fileUrl = url.getFile();
        File file = new File(fileUrl);
        return new OptionT(F.defer((Function0<Object> & Serializable)() -> {
            Object f;
            if (package$all$.MODULE$.catsSyntaxEq(url.getProtocol(), Eq$.MODULE$.catsKernelInstancesForString()).$eq$eq$eq("file") && file.isDirectory()) {
                f = F.pure(None$.MODULE$);
            } else {
                URLConnection urlConn = url.openConnection();
                Option<HttpDate> lastmod = HttpDate$.MODULE$.fromEpochSecond(urlConn.getLastModified() / 1000L).toOption();
                Option ifModifiedSince = req.flatMap((Function1<Request, Option> & Serializable)x$5 -> Headers$.MODULE$.get$extension((List<Header>)x$5.headers(), If$minusModified$minusSince$.MODULE$));
                boolean expired = BoxesRunTime.unboxToBoolean(package$all$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2(ifModifiedSince, lastmod)).mapN((Function2<If$minusModified$minusSince, HttpDate, Object> & Serializable)(x$6, x$7) -> BoxesRunTime.boxToBoolean(StaticFile$.$anonfun$fromURL$3(x$6, x$7)), Invariant$.MODULE$.catsInstancesForOption(), Semigroupal$.MODULE$.catsSemigroupalForOption()).getOrElse(() -> true));
                if (expired) {
                    Content$minusLength lenHeader;
                    List lastModHeader = lastmod.map((Function1<HttpDate, Last$minusModified> & Serializable)x$8 -> new Last$minusModified((HttpDate)x$8)).toList();
                    List<Content$minusType> contentType = MODULE$.nameToContentType(url.getPath()).toList();
                    long len = urlConn.getContentLengthLong();
                    Content$minusLength content$minusLength = lenHeader = len >= 0L ? Content$minusLength$.MODULE$.unsafeFromLong(len) : Transfer$minusEncoding$.MODULE$.apply(TransferCoding$.MODULE$.chunked(), Nil$.MODULE$);
                    List list = lastModHeader;
                    List<Header> headers = Headers$.MODULE$.apply(contentType.$colon$colon$colon(list).$colon$colon(content$minusLength));
                    f = ApplicativeErrorOps$.MODULE$.redeem$extension(package$all$.MODULE$.catsSyntaxApplicativeError(Blocker$.MODULE$.delay$extension(blocker, (Function0<InputStream> & Serializable)() -> urlConn.getInputStream(), F, cs), F), (Function1<Throwable, Option> & Serializable)x0$1 -> {
                        Throwable throwable = x0$1;
                        if (!(throwable instanceof FileNotFoundException)) {
                            throw throwable;
                        }
                        None$ none$ = None$.MODULE$;
                        return none$;
                    }, (Function1<InputStream, Some> & Serializable)inputStream2 -> {
                        List x$1 = headers;
                        FreeC x$2 = fs2.io.package$.MODULE$.readInputStream(F.pure(inputStream2), MODULE$.DefaultBufferSize(), blocker, fs2.io.package$.MODULE$.readInputStream$default$4(), F, cs);
                        Status x$3 = Response$.MODULE$.apply$default$1();
                        HttpVersion x$4 = Response$.MODULE$.apply$default$2();
                        Vault x$5 = Response$.MODULE$.apply$default$5();
                        return new Some(new Response(x$3, x$4, x$1, x$2, x$5));
                    }, F);
                } else {
                    f = package$all$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.handleError$extension(package$all$.MODULE$.catsSyntaxApplicativeError(Blocker$.MODULE$.delay$extension(blocker, () -> urlConn.getInputStream().close(), F, cs), F), (Function1<Throwable, Object> & Serializable)x$9 -> {
                        StaticFile$.$anonfun$fromURL$10(x$9);
                        return BoxedUnit.UNIT;
                    }, F), F).as(new Some<Response<Nothing$>>(new Response<Nothing$>(Status$.MODULE$.NotModified(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5())));
                }
            }
            return f;
        }));
    }

    public <F> None$ fromURL$default$3() {
        return None$.MODULE$;
    }

    public <F> Function1<File, F> calcETag(Sync<F> evidence$5) {
        return (Function1<File, Object> & Serializable)f -> Sync$.MODULE$.apply(evidence$5).delay((Function0<String> & Serializable)() -> f.isFile() ? new StringBuilder(1).append(RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(f.lastModified()))).append("-").append(RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(f.length()))).toString() : "");
    }

    public <F> OptionT<F, Response<F>> fromFile(File f, ExecutionContext blocker, Option<Request<F>> req, Sync<F> evidence$6, ContextShift<F> evidence$7) {
        return this.fromFile(f, this.DefaultBufferSize(), blocker, req, this.calcETag(evidence$6), evidence$6, evidence$7);
    }

    public <F> OptionT<F, Response<F>> fromFile(File f, ExecutionContext blocker, Option<Request<F>> req, Function1<File, F> etagCalculator, Sync<F> evidence$8, ContextShift<F> evidence$9) {
        return this.fromFile(f, this.DefaultBufferSize(), blocker, req, etagCalculator, evidence$8, evidence$9);
    }

    public <F> OptionT<F, Response<F>> fromFile(File f, int buffsize, ExecutionContext blocker, Option<Request<F>> req, Function1<File, F> etagCalculator, Sync<F> evidence$10, ContextShift<F> evidence$11) {
        return this.fromFile(f, 0L, f.length(), buffsize, blocker, req, etagCalculator, evidence$10, evidence$11);
    }

    public <F> OptionT<F, Response<F>> fromFile(File f, long start, long end, int buffsize, ExecutionContext blocker, Option<Request<F>> req, Function1<File, F> etagCalculator, Sync<F> F, ContextShift<F> cs) {
        return new OptionT(package$all$.MODULE$.toFlatMapOps(package$all$.MODULE$.toFunctorOps(etagCalculator.apply(f), F).map((Function1<String, ETag> & Serializable)et -> ETag$.MODULE$.apply((String)et, ETag$.MODULE$.apply$default$2())), F).flatMap((Function1<ETag, Object> & Serializable)etagCalc -> F.delay((Function0<Option> & Serializable)() -> {
            Option option;
            if (f.isFile()) {
                Predef$.MODULE$.require(start >= 0L && end >= start && buffsize > 0, (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(26).append("start: ").append(start).append(", end: ").append(end).append(", buffsize: ").append(buffsize).toString());
                Option<HttpDate> lastModified = HttpDate$.MODULE$.fromEpochSecond(f.lastModified() / 1000L).toOption();
                option = MODULE$.notModified(req, (ETag)etagCalc, lastModified).orElse((Function0<Some> & Serializable)() -> {
                    Tuple2 tuple2;
                    Tuple2 tuple22 = tuple2 = f.length() < end ? new Tuple2(new Stream(Stream$PureOps$.MODULE$.covary$extension(Stream$.MODULE$.PureOps(Stream$.MODULE$.empty()))), BoxesRunTime.boxToLong(0L)) : new Tuple2(new Stream(MODULE$.fileToBody(f, start, end, blocker, F, cs)), BoxesRunTime.boxToLong(end - start));
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    FreeC body = tuple2._1().fs2$Stream$$free();
                    long contentLength = tuple2._2$mcJ$sp();
                    Tuple2 tuple23 = new Tuple2(new Stream(body), BoxesRunTime.boxToLong(contentLength));
                    Tuple2 tuple24 = tuple23;
                    FreeC body2 = tuple24._1().fs2$Stream$$free();
                    long contentLength2 = tuple24._2$mcJ$sp();
                    Option<Content$minusType> contentType = MODULE$.nameToContentType(f.getName());
                    List list = lastModified.map((Function1<HttpDate, Last$minusModified> & Serializable)lm -> new Last$minusModified((HttpDate)lm)).toList();
                    List<Content$minusLength> list2 = EitherOps$.MODULE$.toList$extension(package$all$.MODULE$.catsSyntaxEither(Content$minusLength$.MODULE$.fromLong(contentLength2)));
                    List<Content$minusType> list3 = contentType.toList();
                    List<Header> hs = ((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ETag[]{etagCalc}))).$colon$colon$colon(list3).$colon$colon$colon(list2).$colon$colon$colon(list);
                    List<Header> x$1 = Headers$.MODULE$.apply(hs);
                    FreeC x$2 = body2;
                    Vault x$3 = Vault$.MODULE$.empty().insert(MODULE$.staticFileKey(), f);
                    Status x$4 = Response$.MODULE$.apply$default$1();
                    HttpVersion x$5 = Response$.MODULE$.apply$default$2();
                    Response r = new Response(x$4, x$5, x$1, x$2, x$3);
                    if (logger.isTraceEnabled()) {
                        logger.trace(new StringBuilder(32).append("Static file generated response: ").append(r).toString());
                    }
                    return new Some(r);
                });
            } else {
                option = None$.MODULE$;
            }
            return option;
        })));
    }

    public <F> None$ fromFile$default$3() {
        return None$.MODULE$;
    }

    private <F> Option<Response<F>> notModified(Option<Request<F>> req, ETag etagCalc, Option<HttpDate> lastModified) {
        Semigroup<Object> conjunction = new Semigroup<Object>(){

            public double combine$mcD$sp(double x2, double y) {
                return Semigroup.combine$mcD$sp$(this, x2, y);
            }

            public float combine$mcF$sp(float x2, float y) {
                return Semigroup.combine$mcF$sp$(this, x2, y);
            }

            public int combine$mcI$sp(int x2, int y) {
                return Semigroup.combine$mcI$sp$(this, x2, y);
            }

            public long combine$mcJ$sp(long x2, long y) {
                return Semigroup.combine$mcJ$sp$(this, x2, y);
            }

            public Object combineN(Object a, int n) {
                return Semigroup.combineN$(this, a, n);
            }

            public double combineN$mcD$sp(double a, int n) {
                return Semigroup.combineN$mcD$sp$(this, a, n);
            }

            public float combineN$mcF$sp(float a, int n) {
                return Semigroup.combineN$mcF$sp$(this, a, n);
            }

            public int combineN$mcI$sp(int a, int n) {
                return Semigroup.combineN$mcI$sp$(this, a, n);
            }

            public long combineN$mcJ$sp(long a, int n) {
                return Semigroup.combineN$mcJ$sp$(this, a, n);
            }

            public Object repeatedCombineN(Object a, int n) {
                return Semigroup.repeatedCombineN$(this, a, n);
            }

            public double repeatedCombineN$mcD$sp(double a, int n) {
                return Semigroup.repeatedCombineN$mcD$sp$(this, a, n);
            }

            public float repeatedCombineN$mcF$sp(float a, int n) {
                return Semigroup.repeatedCombineN$mcF$sp$(this, a, n);
            }

            public int repeatedCombineN$mcI$sp(int a, int n) {
                return Semigroup.repeatedCombineN$mcI$sp$(this, a, n);
            }

            public long repeatedCombineN$mcJ$sp(long a, int n) {
                return Semigroup.repeatedCombineN$mcJ$sp$(this, a, n);
            }

            public Option<Object> combineAllOption(IterableOnce<Object> as) {
                return Semigroup.combineAllOption$(this, as);
            }

            public Semigroup<Object> reverse() {
                return Semigroup.reverse$(this);
            }

            public Semigroup<Object> reverse$mcD$sp() {
                return Semigroup.reverse$mcD$sp$(this);
            }

            public Semigroup<Object> reverse$mcF$sp() {
                return Semigroup.reverse$mcF$sp$(this);
            }

            public Semigroup<Object> reverse$mcI$sp() {
                return Semigroup.reverse$mcI$sp$(this);
            }

            public Semigroup<Object> reverse$mcJ$sp() {
                return Semigroup.reverse$mcJ$sp$(this);
            }

            public Semigroup intercalate(Object middle) {
                return Semigroup.intercalate$(this, middle);
            }

            public Semigroup<Object> intercalate$mcD$sp(double middle) {
                return Semigroup.intercalate$mcD$sp$(this, middle);
            }

            public Semigroup<Object> intercalate$mcF$sp(float middle) {
                return Semigroup.intercalate$mcF$sp$(this, middle);
            }

            public Semigroup<Object> intercalate$mcI$sp(int middle) {
                return Semigroup.intercalate$mcI$sp$(this, middle);
            }

            public Semigroup<Object> intercalate$mcJ$sp(long middle) {
                return Semigroup.intercalate$mcJ$sp$(this, middle);
            }

            public boolean combine(boolean x2, boolean y) {
                return x2 && y;
            }
            {
                Semigroup.$init$(this);
            }
        };
        return package$all$.MODULE$.toFoldableOps(package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{this.etagMatch(req, etagCalc), this.notModifiedSince(req, lastModified)})), UnorderedFoldable$.MODULE$.catsTraverseForList()).combineAll(Semigroup$.MODULE$.catsKernelMonoidForOption(conjunction)).filter((Function1<Object, Object> & Serializable)x2 -> BoxesRunTime.boxToBoolean(StaticFile$.$anonfun$notModified$1(BoxesRunTime.unboxToBoolean(x2)))).map((Function1<Object, Response> & Serializable)x$11 -> StaticFile$.$anonfun$notModified$2(BoxesRunTime.unboxToBoolean(x$11)));
    }

    private <F> Option<Object> etagMatch(Option<Request<F>> req, ETag etagCalc) {
        return req.flatMap((Function1<Request, Option> & Serializable)r -> Headers$.MODULE$.get$extension((List<Header>)r.headers(), If$minusNone$minusMatch$.MODULE$).map((Function1<If$minusNone$minusMatch, Object> & Serializable)etagHeader -> BoxesRunTime.boxToBoolean(StaticFile$.$anonfun$etagMatch$2(etagCalc, etagHeader))));
    }

    private <F> Option<Object> notModifiedSince(Option<Request<F>> req, Option<HttpDate> lastModified) {
        return req.flatMap((Function1<Request, Option> & Serializable)r -> Headers$.MODULE$.get$extension((List<Header>)r.headers(), If$minusModified$minusSince$.MODULE$).flatMap((Function1<If$minusModified$minusSince, Option> & Serializable)h -> lastModified.map((Function1<HttpDate, Object> & Serializable)lm -> BoxesRunTime.boxToBoolean(StaticFile$.$anonfun$notModifiedSince$3(h, lm)))));
    }

    private <F> FreeC<F, Object, BoxedUnit> fileToBody(File f, long start, long end, ExecutionContext blocker, Sync<F> evidence$12, ContextShift<F> evidence$13) {
        return fs2.io.file.package$.MODULE$.readRange(f.toPath(), blocker, this.DefaultBufferSize(), start, end, evidence$12, evidence$13);
    }

    private Option<Content$minusType> nameToContentType(String name) {
        Option option;
        int n = name.lastIndexOf(46);
        switch (n) {
            case -1: {
                option = None$.MODULE$;
                break;
            }
            default: {
                option = MediaType$.MODULE$.forExtension(name.substring(n + 1)).map((Function1<MediaType, Content$minusType> & Serializable)x$18 -> Content$minusType$.MODULE$.apply((MediaType)x$18));
                break;
            }
        }
        return option;
    }

    public Key<File> staticFileKey() {
        return staticFileKey;
    }

    public static final /* synthetic */ boolean $anonfun$fromResource$3(Accept$minusEncoding acceptEncoding) {
        return acceptEncoding.satisfiedBy(ContentCoding$.MODULE$.gzip()) || acceptEncoding.satisfiedBy(ContentCoding$.MODULE$.x$minusgzip());
    }

    private static final OptionT getResource$1(String name, Sync evidence$3$1, ClassLoader loader$1) {
        return new OptionT(Sync$.MODULE$.apply(evidence$3$1).delay((Function0<Option> & Serializable)() -> Option$.MODULE$.apply(loader$1.getResource(name))));
    }

    public static final /* synthetic */ boolean $anonfun$fromURL$3(If$minusModified$minusSince x$6, HttpDate x$7) {
        return x$6.date().$less(x$7);
    }

    public static final /* synthetic */ void $anonfun$fromURL$10(Throwable x$9) {
    }

    public static final /* synthetic */ boolean $anonfun$notModified$1(boolean x2) {
        return BoxesRunTime.unboxToBoolean(Predef$.MODULE$.identity(BoxesRunTime.boxToBoolean(x2)));
    }

    public static final /* synthetic */ Response $anonfun$notModified$2(boolean x$11) {
        return new Response<Nothing$>(Status$.MODULE$.NotModified(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5());
    }

    public static final /* synthetic */ boolean $anonfun$etagMatch$4(ETag etagCalc$2, ETag.EntityTag x$13) {
        ETag.EntityTag entityTag = x$13;
        ETag.EntityTag entityTag2 = etagCalc$2.tag();
        return !(entityTag != null ? !((Object)entityTag).equals(entityTag2) : entityTag2 != null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$etagMatch$2(ETag etagCalc$2, If$minusNone$minusMatch etagHeader) {
        void var2_2;
        BoxedUnit boxedUnit;
        boolean etagMatch = etagHeader.tags().exists((Function1<NonEmptyList<ETag.EntityTag>, Object>)(Function1<NonEmptyList, Object> & Serializable)x$12 -> BoxesRunTime.boxToBoolean(x$12.exists((Function1<ETag.EntityTag, Object> & Serializable)x$13 -> BoxesRunTime.boxToBoolean(StaticFile$.$anonfun$etagMatch$4(etagCalc$2, x$13)))));
        if (logger.isTraceEnabled()) {
            logger.trace(new StringBuilder(53).append("Matches `If-None-Match`: ").append(etagMatch).append(" Previous ETag: ").append(etagHeader.value()).append(", New ETag: ").append(etagCalc$2).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit2 = boxedUnit;
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$notModifiedSince$3(If$minusModified$minusSince h$1, HttpDate lm) {
        void var2_2;
        BoxedUnit boxedUnit;
        boolean notModified = h$1.date().$greater$eq(lm);
        if (logger.isTraceEnabled()) {
            logger.trace(new StringBuilder(56).append("Matches `If-Modified-Since`: ").append(notModified).append(". Request age: ").append(h$1.date()).append(", Modified: ").append(lm).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit2 = boxedUnit;
        return (boolean)var2_2;
    }

    private StaticFile$() {
    }
}

