/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.middleware.authentication;

import cats.Applicative;
import cats.data.Kleisli;
import cats.data.NonEmptyList;
import cats.effect.Sync;
import cats.syntax.EitherObjectOps$;
import cats.syntax.package$all$;
import java.io.Serializable;
import org.http4s.AuthScheme$;
import org.http4s.AuthedRequest$;
import org.http4s.Challenge;
import org.http4s.ContextRequest;
import org.http4s.Credentials;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.headers.Authorization;
import org.http4s.headers.Authorization$;
import org.http4s.server.middleware.authentication.DigestAuth;
import org.http4s.server.middleware.authentication.DigestAuth$BadNC$;
import org.http4s.server.middleware.authentication.DigestAuth$BadParameters$;
import org.http4s.server.middleware.authentication.DigestAuth$NoAuthorizationHeader$;
import org.http4s.server.middleware.authentication.DigestAuth$NoCredentials$;
import org.http4s.server.middleware.authentication.DigestAuth$StaleNonce$;
import org.http4s.server.middleware.authentication.DigestAuth$UserUnknown$;
import org.http4s.server.middleware.authentication.DigestAuth$WrongResponse$;
import org.http4s.server.middleware.authentication.DigestUtil$;
import org.http4s.server.middleware.authentication.NonceKeeper;
import org.http4s.server.middleware.authentication.NonceKeeper$BadNCReply$;
import org.http4s.server.middleware.authentication.NonceKeeper$OKReply$;
import org.http4s.server.middleware.authentication.NonceKeeper$StaleReply$;
import org.http4s.server.middleware.authentication.package$;
import org.http4s.util.CaseInsensitiveString;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.SetOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class DigestAuth$ {
    public static final DigestAuth$ MODULE$ = new DigestAuth$();

    public <F, A> Function1<Kleisli<?, ContextRequest<F, A>, Response<F>>, Kleisli<?, Request<F>, Response<F>>> apply(String realm, Function1<String, F> store, Duration nonceCleanupInterval, Duration nonceStaleTime, int nonceBits, Sync<F> evidence$1) {
        NonceKeeper nonceKeeper = new NonceKeeper(nonceStaleTime.toMillis(), nonceCleanupInterval.toMillis(), nonceBits);
        Kleisli kleisli = this.challenge(realm, store, nonceKeeper, evidence$1);
        return (Function1<Kleisli, Kleisli> & Serializable)routes -> package$.MODULE$.challenged(kleisli, routes, evidence$1);
    }

    public <F, A> Duration apply$default$3() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).hour();
    }

    public <F, A> Duration apply$default$4() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).hour();
    }

    public <F, A> int apply$default$5() {
        return 160;
    }

    public <F, A> Kleisli<F, Request<F>, Either<Challenge, ContextRequest<F, A>>> challenge(String realm, Function1<String, F> store, NonceKeeper nonceKeeper, Sync<F> F) {
        return new Kleisli((Function1<Request, Object> & Serializable)req -> package$all$.MODULE$.toFlatMapOps(MODULE$.checkAuth(realm, store, nonceKeeper, (Request)req, F), F).flatMap((Function1<DigestAuth.AuthReply, Object> & Serializable)x0$1 -> {
            Object f;
            DigestAuth.AuthReply authReply = x0$1;
            if (authReply instanceof DigestAuth.OK) {
                DigestAuth.OK oK = (DigestAuth.OK)authReply;
                Object authInfo = oK.authInfo();
                f = F.pure(EitherObjectOps$.MODULE$.right$extension(package$all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), AuthedRequest$.MODULE$.apply(authInfo, req)));
            } else {
                f = DigestAuth$StaleNonce$.MODULE$.equals(authReply) ? package$all$.MODULE$.toFunctorOps(MODULE$.getChallengeParams(nonceKeeper, true, F), F).map((Function1<Map, Either> & Serializable)params -> DigestAuth$.paramsToChallenge$1(params, realm)) : package$all$.MODULE$.toFunctorOps(MODULE$.getChallengeParams(nonceKeeper, false, F), F).map((Function1<Map, Either> & Serializable)params -> DigestAuth$.paramsToChallenge$1(params, realm));
            }
            return f;
        }));
    }

    /*
     * Enabled aggressive block sorting
     */
    private <F, A> F checkAuth(String realm, Function1<String, F> store, NonceKeeper nonceKeeper, Request<F> req, Applicative<F> F) {
        F f;
        boolean bl = false;
        Some some = null;
        Option<Header> option = Headers$.MODULE$.get$extension((List<Header>)req.headers(), Authorization$.MODULE$);
        if (option instanceof Some) {
            Credentials credentials;
            bl = true;
            some = (Some)option;
            Authorization authorization = (Authorization)some.value();
            if (authorization != null && (credentials = authorization.credentials()) instanceof Credentials.AuthParams) {
                Credentials.AuthParams authParams = (Credentials.AuthParams)credentials;
                CaseInsensitiveString caseInsensitiveString = authParams.authScheme();
                NonEmptyList<Tuple2<String, String>> params = authParams.params();
                CaseInsensitiveString caseInsensitiveString2 = AuthScheme$.MODULE$.Digest();
                CaseInsensitiveString caseInsensitiveString3 = caseInsensitiveString;
                if (!(caseInsensitiveString2 != null ? !((Object)caseInsensitiveString2).equals(caseInsensitiveString3) : caseInsensitiveString3 != null)) {
                    f = this.checkAuthParams(realm, store, nonceKeeper, req, params, F);
                    return f;
                }
            }
        }
        if (bl) {
            f = F.pure(DigestAuth$NoCredentials$.MODULE$);
            return f;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        f = F.pure(DigestAuth$NoAuthorizationHeader$.MODULE$);
        return f;
    }

    private <F> F getChallengeParams(NonceKeeper nonceKeeper, boolean staleNonce, Sync<F> F) {
        return F.delay((Function0<Map> & Serializable)() -> {
            void var3_3;
            String nonce = nonceKeeper.newNonce();
            Map m = (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("qop"), "auth"), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("nonce"), nonce)}));
            return staleNonce ? (Map)m.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("stale"), "TRUE")) : var3_3;
        });
    }

    private <F, A> F checkAuthParams(String realm, Function1<String, F> store, NonceKeeper nonceKeeper, Request<F> req, NonEmptyList<Tuple2<String, String>> paramsNel, Applicative<F> F) {
        F f;
        String nc;
        Map params = paramsNel.toList().toMap($less$colon$less$.MODULE$.refl());
        if (!((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"realm", "nonce", "nc", "username", "cnonce", "qop"}))).subsetOf(params.keySet())) {
            return F.pure(DigestAuth$BadParameters$.MODULE$);
        }
        String method = req.method().toString();
        String uri = req.uri().toString();
        Option option = params.get("realm");
        Some<String> some = new Some<String>(realm);
        if (option == null ? some != null : !option.equals(some)) {
            return F.pure(DigestAuth$BadParameters$.MODULE$);
        }
        String nonce = (String)params.apply("nonce");
        NonceKeeper.Reply reply = nonceKeeper.receiveNonce(nonce, Integer.parseInt(nc = (String)params.apply("nc"), 16));
        if (NonceKeeper$StaleReply$.MODULE$.equals(reply)) {
            f = F.pure(DigestAuth$StaleNonce$.MODULE$);
        } else if (NonceKeeper$BadNCReply$.MODULE$.equals(reply)) {
            f = F.pure(DigestAuth$BadNC$.MODULE$);
        } else if (NonceKeeper$OKReply$.MODULE$.equals(reply)) {
            f = package$all$.MODULE$.toFunctorOps(store.apply((String)params.apply("username")), F).map((Function1<Option, DigestAuth.AuthReply> & Serializable)x0$1 -> {
                Some some;
                Tuple2 tuple2;
                DigestAuth.AuthReply<Nothing$> authReply;
                Option option = x0$1;
                if (None$.MODULE$.equals(option)) {
                    authReply = DigestAuth$UserUnknown$.MODULE$;
                } else if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                    String resp;
                    Object authInfo = tuple2._1();
                    String password = (String)tuple2._2();
                    String string2 = resp = DigestUtil$.MODULE$.computeResponse(method, (String)params.apply("username"), realm, password, uri, nonce, nc, (String)params.apply("cnonce"), (String)params.apply("qop"));
                    Object v = params.apply("response");
                    authReply = !(string2 != null ? !string2.equals(v) : v != null) ? new DigestAuth.OK(authInfo) : DigestAuth$WrongResponse$.MODULE$;
                } else {
                    throw new MatchError(option);
                }
                return authReply;
            });
        } else {
            throw new MatchError(reply);
        }
        return f;
    }

    private static final Either paramsToChallenge$1(Map params, String realm$1) {
        return EitherObjectOps$.MODULE$.left$extension(package$all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), new Challenge("Digest", realm$1, params));
    }

    private DigestAuth$() {
    }
}

