/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;

public abstract class LogMergePolicy
extends MergePolicy {
    public static final double LEVEL_LOG_SPAN = 0.75;
    public static final int DEFAULT_MERGE_FACTOR = 10;
    public static final int DEFAULT_MAX_MERGE_DOCS = Integer.MAX_VALUE;
    public static final double DEFAULT_NO_CFS_RATIO = 0.1;
    protected int mergeFactor = 10;
    protected long minMergeSize;
    protected long maxMergeSize;
    protected long maxMergeSizeForForcedMerge = Long.MAX_VALUE;
    protected int maxMergeDocs = Integer.MAX_VALUE;
    protected boolean calibrateSizeByDeletes = true;

    public LogMergePolicy() {
        super(0.1, Long.MAX_VALUE);
    }

    public int getMergeFactor() {
        return this.mergeFactor;
    }

    public void setMergeFactor(int mergeFactor) {
        if (mergeFactor < 2) {
            throw new IllegalArgumentException("mergeFactor cannot be less than 2");
        }
        this.mergeFactor = mergeFactor;
    }

    public void setCalibrateSizeByDeletes(boolean calibrateSizeByDeletes) {
        this.calibrateSizeByDeletes = calibrateSizeByDeletes;
    }

    public boolean getCalibrateSizeByDeletes() {
        return this.calibrateSizeByDeletes;
    }

    protected long sizeDocs(SegmentCommitInfo info, MergePolicy.MergeContext mergeContext) throws IOException {
        if (this.calibrateSizeByDeletes) {
            int delCount = mergeContext.numDeletesToMerge(info);
            assert (this.assertDelCount(delCount, info));
            return (long)info.info.maxDoc() - (long)delCount;
        }
        return info.info.maxDoc();
    }

    protected long sizeBytes(SegmentCommitInfo info, MergePolicy.MergeContext mergeContext) throws IOException {
        if (this.calibrateSizeByDeletes) {
            return super.size(info, mergeContext);
        }
        return info.sizeInBytes();
    }

    protected boolean isMerged(SegmentInfos infos, int maxNumSegments, Map<SegmentCommitInfo, Boolean> segmentsToMerge, MergePolicy.MergeContext mergeContext) throws IOException {
        int numSegments = infos.size();
        int numToMerge = 0;
        SegmentCommitInfo mergeInfo = null;
        boolean segmentIsOriginal = false;
        for (int i = 0; i < numSegments && numToMerge <= maxNumSegments; ++i) {
            SegmentCommitInfo info = infos.info(i);
            Boolean isOriginal = segmentsToMerge.get(info);
            if (isOriginal == null) continue;
            segmentIsOriginal = isOriginal;
            ++numToMerge;
            mergeInfo = info;
        }
        return numToMerge <= maxNumSegments && (numToMerge != 1 || !segmentIsOriginal || this.isMerged(infos, mergeInfo, mergeContext));
    }

    private MergePolicy.MergeSpecification findForcedMergesSizeLimit(SegmentInfos infos, int last2, MergePolicy.MergeContext mergeContext) throws IOException {
        int start;
        MergePolicy.MergeSpecification spec = new MergePolicy.MergeSpecification();
        List<SegmentCommitInfo> segments = infos.asList();
        for (start = last2 - 1; start >= 0; --start) {
            SegmentCommitInfo info = infos.info(start);
            if (this.size(info, mergeContext) > this.maxMergeSizeForForcedMerge || this.sizeDocs(info, mergeContext) > (long)this.maxMergeDocs) {
                if (this.verbose(mergeContext)) {
                    this.message("findForcedMergesSizeLimit: skip segment=" + info + ": size is > maxMergeSize (" + this.maxMergeSizeForForcedMerge + ") or sizeDocs is > maxMergeDocs (" + this.maxMergeDocs + ")", mergeContext);
                }
                if (last2 - start - 1 > 1 || start != last2 - 1 && !this.isMerged(infos, infos.info(start + 1), mergeContext)) {
                    spec.add(new MergePolicy.OneMerge(segments.subList(start + 1, last2)));
                }
                last2 = start;
                continue;
            }
            if (last2 - start != this.mergeFactor) continue;
            spec.add(new MergePolicy.OneMerge(segments.subList(start, last2)));
            last2 = start;
        }
        if (!(last2 <= 0 || ++start + 1 >= last2 && this.isMerged(infos, infos.info(start), mergeContext))) {
            spec.add(new MergePolicy.OneMerge(segments.subList(start, last2)));
        }
        return spec.merges.size() == 0 ? null : spec;
    }

    private MergePolicy.MergeSpecification findForcedMergesMaxNumSegments(SegmentInfos infos, int maxNumSegments, int last2, MergePolicy.MergeContext mergeContext) throws IOException {
        MergePolicy.MergeSpecification spec = new MergePolicy.MergeSpecification();
        List<SegmentCommitInfo> segments = infos.asList();
        while (last2 - maxNumSegments + 1 >= this.mergeFactor) {
            spec.add(new MergePolicy.OneMerge(segments.subList(last2 - this.mergeFactor, last2)));
            last2 -= this.mergeFactor;
        }
        if (0 == spec.merges.size()) {
            if (maxNumSegments == 1) {
                if (last2 > 1 || !this.isMerged(infos, infos.info(0), mergeContext)) {
                    spec.add(new MergePolicy.OneMerge(segments.subList(0, last2)));
                }
            } else if (last2 > maxNumSegments) {
                int finalMergeSize = last2 - maxNumSegments + 1;
                long bestSize = 0L;
                int bestStart = 0;
                for (int i = 0; i < last2 - finalMergeSize + 1; ++i) {
                    long sumSize = 0L;
                    for (int j = 0; j < finalMergeSize; ++j) {
                        sumSize += this.size(infos.info(j + i), mergeContext);
                    }
                    if (i != 0 && (sumSize >= 2L * this.size(infos.info(i - 1), mergeContext) || sumSize >= bestSize)) continue;
                    bestStart = i;
                    bestSize = sumSize;
                }
                spec.add(new MergePolicy.OneMerge(segments.subList(bestStart, bestStart + finalMergeSize)));
            }
        }
        return spec.merges.size() == 0 ? null : spec;
    }

    @Override
    public MergePolicy.MergeSpecification findForcedMerges(SegmentInfos infos, int maxNumSegments, Map<SegmentCommitInfo, Boolean> segmentsToMerge, MergePolicy.MergeContext mergeContext) throws IOException {
        assert (maxNumSegments > 0);
        if (this.verbose(mergeContext)) {
            this.message("findForcedMerges: maxNumSegs=" + maxNumSegments + " segsToMerge=" + segmentsToMerge, mergeContext);
        }
        if (this.isMerged(infos, maxNumSegments, segmentsToMerge, mergeContext)) {
            if (this.verbose(mergeContext)) {
                this.message("already merged; skip", mergeContext);
            }
            return null;
        }
        int last2 = infos.size();
        while (last2 > 0) {
            SegmentCommitInfo info;
            if (segmentsToMerge.get(info = infos.info(--last2)) == null) continue;
            ++last2;
            break;
        }
        if (last2 == 0) {
            if (this.verbose(mergeContext)) {
                this.message("last == 0; skip", mergeContext);
            }
            return null;
        }
        if (maxNumSegments == 1 && last2 == 1 && this.isMerged(infos, infos.info(0), mergeContext)) {
            if (this.verbose(mergeContext)) {
                this.message("already 1 seg; skip", mergeContext);
            }
            return null;
        }
        boolean anyTooLarge = false;
        for (int i = 0; i < last2; ++i) {
            SegmentCommitInfo info = infos.info(i);
            if (this.size(info, mergeContext) <= this.maxMergeSizeForForcedMerge && this.sizeDocs(info, mergeContext) <= (long)this.maxMergeDocs) continue;
            anyTooLarge = true;
            break;
        }
        if (anyTooLarge) {
            return this.findForcedMergesSizeLimit(infos, last2, mergeContext);
        }
        return this.findForcedMergesMaxNumSegments(infos, maxNumSegments, last2, mergeContext);
    }

    @Override
    public MergePolicy.MergeSpecification findForcedDeletesMerges(SegmentInfos segmentInfos, MergePolicy.MergeContext mergeContext) throws IOException {
        List<SegmentCommitInfo> segments = segmentInfos.asList();
        int numSegments = segments.size();
        if (this.verbose(mergeContext)) {
            this.message("findForcedDeleteMerges: " + numSegments + " segments", mergeContext);
        }
        MergePolicy.MergeSpecification spec = new MergePolicy.MergeSpecification();
        int firstSegmentWithDeletions = -1;
        assert (mergeContext != null);
        for (int i = 0; i < numSegments; ++i) {
            SegmentCommitInfo info = segmentInfos.info(i);
            int delCount = mergeContext.numDeletesToMerge(info);
            assert (this.assertDelCount(delCount, info));
            if (delCount > 0) {
                if (this.verbose(mergeContext)) {
                    this.message("  segment " + info.info.name + " has deletions", mergeContext);
                }
                if (firstSegmentWithDeletions == -1) {
                    firstSegmentWithDeletions = i;
                    continue;
                }
                if (i - firstSegmentWithDeletions != this.mergeFactor) continue;
                if (this.verbose(mergeContext)) {
                    this.message("  add merge " + firstSegmentWithDeletions + " to " + (i - 1) + " inclusive", mergeContext);
                }
                spec.add(new MergePolicy.OneMerge(segments.subList(firstSegmentWithDeletions, i)));
                firstSegmentWithDeletions = i;
                continue;
            }
            if (firstSegmentWithDeletions == -1) continue;
            if (this.verbose(mergeContext)) {
                this.message("  add merge " + firstSegmentWithDeletions + " to " + (i - 1) + " inclusive", mergeContext);
            }
            spec.add(new MergePolicy.OneMerge(segments.subList(firstSegmentWithDeletions, i)));
            firstSegmentWithDeletions = -1;
        }
        if (firstSegmentWithDeletions != -1) {
            if (this.verbose(mergeContext)) {
                this.message("  add merge " + firstSegmentWithDeletions + " to " + (numSegments - 1) + " inclusive", mergeContext);
            }
            spec.add(new MergePolicy.OneMerge(segments.subList(firstSegmentWithDeletions, numSegments)));
        }
        return spec;
    }

    @Override
    public MergePolicy.MergeSpecification findMerges(MergeTrigger mergeTrigger, SegmentInfos infos, MergePolicy.MergeContext mergeContext) throws IOException {
        int numSegments = infos.size();
        if (this.verbose(mergeContext)) {
            this.message("findMerges: " + numSegments + " segments", mergeContext);
        }
        ArrayList<SegmentInfoAndLevel> levels = new ArrayList<SegmentInfoAndLevel>(numSegments);
        float norm = (float)Math.log(this.mergeFactor);
        Set<SegmentCommitInfo> mergingSegments = mergeContext.getMergingSegments();
        for (int i = 0; i < numSegments; ++i) {
            String extra;
            SegmentCommitInfo info = infos.info(i);
            long size = this.size(info, mergeContext);
            if (size < 1L) {
                size = 1L;
            }
            SegmentInfoAndLevel infoLevel = new SegmentInfoAndLevel(info, (float)Math.log(size) / norm);
            levels.add(infoLevel);
            if (!this.verbose(mergeContext)) continue;
            long segBytes = this.sizeBytes(info, mergeContext);
            String string = extra = mergingSegments.contains(info) ? " [merging]" : "";
            if (size >= this.maxMergeSize) {
                extra = extra + " [skip: too large]";
            }
            this.message("seg=" + this.segString(mergeContext, Collections.singleton(info)) + " level=" + infoLevel.level + " size=" + String.format(Locale.ROOT, "%.3f MB", (double)(segBytes / 1024L) / 1024.0) + extra, mergeContext);
        }
        float levelFloor = this.minMergeSize <= 0L ? 0.0f : (float)(Math.log(this.minMergeSize) / (double)norm);
        MergePolicy.MergeSpecification spec = null;
        int numMergeableSegments = levels.size();
        int start = 0;
        while (start < numMergeableSegments) {
            int upto;
            float levelBottom;
            float maxLevel = ((SegmentInfoAndLevel)levels.get((int)start)).level;
            for (int i = 1 + start; i < numMergeableSegments; ++i) {
                float level = ((SegmentInfoAndLevel)levels.get((int)i)).level;
                if (!(level > maxLevel)) continue;
                maxLevel = level;
            }
            if (maxLevel <= levelFloor) {
                levelBottom = -1.0f;
            } else {
                levelBottom = (float)((double)maxLevel - 0.75);
                if (levelBottom < levelFloor && maxLevel >= levelFloor) {
                    levelBottom = levelFloor;
                }
            }
            for (upto = numMergeableSegments - 1; upto >= start && !(((SegmentInfoAndLevel)levels.get((int)upto)).level >= levelBottom); --upto) {
            }
            if (this.verbose(mergeContext)) {
                this.message("  level " + levelBottom + " to " + maxLevel + ": " + (1 + upto - start) + " segments", mergeContext);
            }
            int end = start + this.mergeFactor;
            while (end <= 1 + upto) {
                boolean anyTooLarge = false;
                boolean anyMerging = false;
                for (int i = start; i < end; ++i) {
                    SegmentCommitInfo info = ((SegmentInfoAndLevel)levels.get((int)i)).info;
                    anyTooLarge |= this.size(info, mergeContext) >= this.maxMergeSize || this.sizeDocs(info, mergeContext) >= (long)this.maxMergeDocs;
                    if (!mergingSegments.contains(info)) continue;
                    anyMerging = true;
                    break;
                }
                if (!anyMerging) {
                    if (!anyTooLarge) {
                        if (spec == null) {
                            spec = new MergePolicy.MergeSpecification();
                        }
                        ArrayList<SegmentCommitInfo> mergeInfos = new ArrayList<SegmentCommitInfo>(end - start);
                        for (int i = start; i < end; ++i) {
                            mergeInfos.add(((SegmentInfoAndLevel)levels.get((int)i)).info);
                            assert (infos.contains(((SegmentInfoAndLevel)levels.get((int)i)).info));
                        }
                        if (this.verbose(mergeContext)) {
                            this.message("  add merge=" + this.segString(mergeContext, mergeInfos) + " start=" + start + " end=" + end, mergeContext);
                        }
                        spec.add(new MergePolicy.OneMerge(mergeInfos));
                    } else if (this.verbose(mergeContext)) {
                        this.message("    " + start + " to " + end + ": contains segment over maxMergeSize or maxMergeDocs; skipping", mergeContext);
                    }
                }
                start = end;
                end = start + this.mergeFactor;
            }
            start = 1 + upto;
        }
        return spec;
    }

    public void setMaxMergeDocs(int maxMergeDocs) {
        this.maxMergeDocs = maxMergeDocs;
    }

    public int getMaxMergeDocs() {
        return this.maxMergeDocs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[" + this.getClass().getSimpleName() + ": ");
        sb.append("minMergeSize=").append(this.minMergeSize).append(", ");
        sb.append("mergeFactor=").append(this.mergeFactor).append(", ");
        sb.append("maxMergeSize=").append(this.maxMergeSize).append(", ");
        sb.append("maxMergeSizeForForcedMerge=").append(this.maxMergeSizeForForcedMerge).append(", ");
        sb.append("calibrateSizeByDeletes=").append(this.calibrateSizeByDeletes).append(", ");
        sb.append("maxMergeDocs=").append(this.maxMergeDocs).append(", ");
        sb.append("maxCFSSegmentSizeMB=").append(this.getMaxCFSSegmentSizeMB()).append(", ");
        sb.append("noCFSRatio=").append(this.noCFSRatio);
        sb.append("]");
        return sb.toString();
    }

    private static class SegmentInfoAndLevel
    implements Comparable<SegmentInfoAndLevel> {
        SegmentCommitInfo info;
        float level;

        public SegmentInfoAndLevel(SegmentCommitInfo info, float level) {
            this.info = info;
            this.level = level;
        }

        @Override
        public int compareTo(SegmentInfoAndLevel other) {
            return Float.compare(other.level, this.level);
        }
    }
}

