/*
 * Decompiled with CFR 0.152.
 */
package org.http4s;

import cats.ApplicativeError;
import cats.Functor;
import cats.Invariant$;
import cats.MonadError;
import cats.Semigroupal$;
import cats.UnorderedFoldable$;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.effect.SyncIO;
import cats.effect.SyncIO$;
import cats.effect.kernel.Sync;
import cats.effect.package$;
import cats.kernel.Eq$;
import cats.kernel.Semigroup;
import cats.kernel.Semigroup$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package$all$;
import fs2.Stream;
import fs2.Stream$;
import fs2.io.file.BasicFileAttributes;
import fs2.io.file.Files;
import fs2.io.file.Files$;
import fs2.io.file.Path;
import fs2.io.file.Path$;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.NoSuchFileException;
import org.http4s.ContentCoding$;
import org.http4s.EntityTag;
import org.http4s.Header;
import org.http4s.Header$Select$;
import org.http4s.Header$ToRaw$;
import org.http4s.Headers$;
import org.http4s.HttpDate;
import org.http4s.HttpDate$;
import org.http4s.HttpVersion;
import org.http4s.MediaType;
import org.http4s.MediaType$;
import org.http4s.Platform$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.TransferCoding$;
import org.http4s.headers.Accept$minusEncoding;
import org.http4s.headers.Accept$minusEncoding$;
import org.http4s.headers.Content$minusEncoding;
import org.http4s.headers.Content$minusEncoding$;
import org.http4s.headers.Content$minusLength;
import org.http4s.headers.Content$minusLength$;
import org.http4s.headers.Content$minusType;
import org.http4s.headers.Content$minusType$;
import org.http4s.headers.ETag;
import org.http4s.headers.ETag$;
import org.http4s.headers.If$minusModified$minusSince;
import org.http4s.headers.If$minusModified$minusSince$;
import org.http4s.headers.If$minusNone$minusMatch;
import org.http4s.headers.If$minusNone$minusMatch$;
import org.http4s.headers.Last$minusModified;
import org.http4s.headers.Last$minusModified$;
import org.http4s.headers.Transfer$minusEncoding;
import org.http4s.headers.Transfer$minusEncoding$;
import org.http4s.syntax.package$header$;
import org.typelevel.log4cats.SelfAwareStructuredLogger;
import org.typelevel.vault.Key;
import org.typelevel.vault.Key$;
import org.typelevel.vault.Vault;
import org.typelevel.vault.Vault$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

public final class StaticFile$ {
    public static final StaticFile$ MODULE$ = new StaticFile$();
    private static Key<File> staticFileKey;
    private static final SelfAwareStructuredLogger<SyncIO> logger;
    private static final int DefaultBufferSize;
    private static final Key<Path> staticPathKey;
    private static volatile boolean bitmap$0;

    static {
        logger = (SelfAwareStructuredLogger)Platform$.MODULE$.loggerFactory().getLogger("org.http4s.StaticFile");
        DefaultBufferSize = 10240;
        staticPathKey = (Key)Key$.MODULE$.newKey(SyncIO$.MODULE$.syncForSyncIO(), SyncIO$.MODULE$.syncForSyncIO()).unsafeRunSync();
    }

    public int DefaultBufferSize() {
        return DefaultBufferSize;
    }

    public <F> OptionT<F, Response<F>> fromString(String url, Option<Request<F>> req, Files<F> evidence$1, MonadError<F, Throwable> evidence$2) {
        return this.fromPath(Path$.MODULE$.apply(url), req, evidence$1, evidence$2);
    }

    public <F> None$ fromString$default$2() {
        return None$.MODULE$;
    }

    public <F> OptionT<F, Response<F>> fromResource(String name, Option<Request<F>> req, boolean preferGzipped, Option<ClassLoader> classloader, Sync<F> evidence$3) {
        ClassLoader loader = (ClassLoader)classloader.getOrElse((Function0<ClassLoader> & Serializable)() -> MODULE$.getClass().getClassLoader());
        Option acceptEncodingHeader = req.flatMap((Function1<Request, Option> & Serializable)x$1 -> Headers$.MODULE$.get$extension((List<Header.Raw>)x$1.headers(), Header$Select$.MODULE$.recurringHeadersWithMerge(Accept$minusEncoding$.MODULE$.headerSemigroupInstance(), Accept$minusEncoding$.MODULE$.headerInstance())));
        boolean tryGzipped = preferGzipped && acceptEncodingHeader.exists((Function1<Accept$minusEncoding, Object> & Serializable)acceptEncoding -> BoxesRunTime.boxToBoolean(StaticFile$.$anonfun$fromResource$3(acceptEncoding)));
        String normalizedName = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps(name.split("/")), (Function1<String, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2))))).mkString("/");
        OptionT gzUrl = tryGzipped ? StaticFile$.getResource$1(new StringBuilder(3).append(normalizedName).append(".gz").toString(), evidence$3, loader) : OptionT$.MODULE$.none(evidence$3);
        return gzUrl.flatMap((Function1<URL, OptionT> & Serializable)url -> MODULE$.fromURL((URL)url, req, evidence$3).map((Function1<Response, Response> & Serializable)x$3 -> (Response)x$3.removeHeader(Content$minusType$.MODULE$.headerInstance()).putHeaders(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header$ToRaw$.MODULE$.modelledHeadersToRaw(new Content$minusEncoding(ContentCoding$.MODULE$.gzip()), Content$minusEncoding$.MODULE$.headerInstance()), Header$ToRaw$.MODULE$.foldablesToRaw(MODULE$.nameToContentType(normalizedName), UnorderedFoldable$.MODULE$.catsTraverseForOption(), (Function1<Content$minusType, Header.ToRaw> & Serializable)h -> Header$ToRaw$.MODULE$.modelledHeadersToRaw(h, Content$minusType$.MODULE$.headerInstance()))})), evidence$3), evidence$3).orElse((Function0<OptionT> & Serializable)() -> StaticFile$.getResource$1(normalizedName, evidence$3, loader).flatMap((Function1<URL, OptionT> & Serializable)x$4 -> MODULE$.fromURL((URL)x$4, req, evidence$3), evidence$3), evidence$3);
    }

    public <F> None$ fromResource$default$2() {
        return None$.MODULE$;
    }

    public <F> boolean fromResource$default$3() {
        return false;
    }

    public <F> Option<ClassLoader> fromResource$default$4() {
        return None$.MODULE$;
    }

    public <F> OptionT<F, Response<F>> fromURL(URL url, Option<Request<F>> req, Sync<F> F) {
        String fileUrl = url.getFile();
        File file = new File(fileUrl);
        return new OptionT(F.defer((Function0<Object> & Serializable)() -> {
            if (package$all$.MODULE$.catsSyntaxEq(url.getProtocol(), Eq$.MODULE$.catsKernelInstancesForString()).$eq$eq$eq("file") && file.isDirectory()) {
                return F.pure(package$all$.MODULE$.none());
            }
            URLConnection urlConn = url.openConnection();
            Option<HttpDate> lastmod = HttpDate$.MODULE$.fromEpochSecond(urlConn.getLastModified() / 1000L).toOption();
            Option ifModifiedSince = req.flatMap((Function1<Request, Option> & Serializable)x$5 -> Headers$.MODULE$.get$extension((List<Header.Raw>)x$5.headers(), Header$Select$.MODULE$.singleHeaders(If$minusModified$minusSince$.MODULE$.headerInstance())));
            boolean expired = BoxesRunTime.unboxToBoolean(package$all$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2(ifModifiedSince, lastmod)).mapN((Function2<If$minusModified$minusSince, HttpDate, Object> & Serializable)(x$6, x$7) -> BoxesRunTime.boxToBoolean(StaticFile$.$anonfun$fromURL$3(x$6, x$7)), Invariant$.MODULE$.catsInstancesForOption(), Semigroupal$.MODULE$.catsSemigroupalForOption()).getOrElse(() -> true));
            if (expired) {
                long len = urlConn.getContentLengthLong();
                List<Header.Raw> headers = Headers$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header$ToRaw$.MODULE$.foldablesToRaw(lastmod.map((Function1<HttpDate, Last$minusModified> & Serializable)x$8 -> new Last$minusModified((HttpDate)x$8)), UnorderedFoldable$.MODULE$.catsTraverseForOption(), (Function1<Last$minusModified, Header.ToRaw> & Serializable)h -> Header$ToRaw$.MODULE$.modelledHeadersToRaw(h, Last$minusModified$.MODULE$.headerInstance())), Header$ToRaw$.MODULE$.foldablesToRaw(MODULE$.nameToContentType(url.getPath()), UnorderedFoldable$.MODULE$.catsTraverseForOption(), (Function1<Content$minusType, Header.ToRaw> & Serializable)h -> Header$ToRaw$.MODULE$.modelledHeadersToRaw(h, Content$minusType$.MODULE$.headerInstance())), len >= 0L ? Header$ToRaw$.MODULE$.modelledHeadersToRaw(Content$minusLength$.MODULE$.unsafeFromLong(len), Content$minusLength$.MODULE$.headerInstance()) : Header$ToRaw$.MODULE$.modelledHeadersToRaw(new Transfer$minusEncoding(ApplicativeIdOps$.MODULE$.pure$extension(package$all$.MODULE$.catsSyntaxApplicativeId(TransferCoding$.MODULE$.chunked()), NonEmptyList$.MODULE$.catsDataInstancesForNonEmptyListBinCompat1())), Transfer$minusEncoding$.MODULE$.headerInstance())}));
                return ApplicativeErrorOps$.MODULE$.redeem$extension(package$all$.MODULE$.catsSyntaxApplicativeError(F.blocking((Function0<InputStream> & Serializable)() -> urlConn.getInputStream()), F), (Function1<Throwable, Option> & Serializable)x0$1 -> {
                    Throwable throwable = x0$1;
                    if (throwable instanceof FileNotFoundException) {
                        return None$.MODULE$;
                    }
                    throw throwable;
                }, (Function1<InputStream, Some> & Serializable)inputStream2 -> {
                    List x$1 = headers;
                    Stream x$2 = fs2.io.package$.MODULE$.readInputStream(F.pure(inputStream2), MODULE$.DefaultBufferSize(), fs2.io.package$.MODULE$.readInputStream$default$3(), F);
                    Status x$3 = Response$.MODULE$.apply$default$1();
                    HttpVersion x$4 = Response$.MODULE$.apply$default$2();
                    Vault x$5 = Response$.MODULE$.apply$default$5();
                    return new Some(Response$.MODULE$.apply(x$3, x$4, x$1, x$2, x$5));
                }, F);
            }
            return package$all$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.handleError$extension(package$all$.MODULE$.catsSyntaxApplicativeError(F.blocking(() -> urlConn.getInputStream().close()), F), (Function1<Throwable, Object> & Serializable)x$9 -> {
                StaticFile$.$anonfun$fromURL$12(x$9);
                return BoxedUnit.UNIT;
            }, F), F).as(new Some<Response<Nothing$>>(Response$.MODULE$.apply(Status$.MODULE$.NotModified(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5())));
        }));
    }

    public <F> None$ fromURL$default$2() {
        return None$.MODULE$;
    }

    public <F> Function1<File, F> calcETag(Files<F> evidence$4, Functor<F> evidence$5) {
        return (Function1<File, Object> & Serializable)f -> package$all$.MODULE$.toFunctorOps(Files$.MODULE$.apply(evidence$4).isRegularFile(Path$.MODULE$.fromNioPath(f.toPath())), evidence$5).map((Function1<Object, String> & Serializable)isFile -> StaticFile$.$anonfun$calcETag$2(f, BoxesRunTime.unboxToBoolean(isFile)));
    }

    public <F> Function1<Path, F> calculateETag(Files<F> evidence$6, ApplicativeError<F, Throwable> evidence$7) {
        return (Function1<Path, Object> & Serializable)f -> package$all$.MODULE$.toFunctorOps(Files$.MODULE$.apply(evidence$6).getBasicFileAttributes((Path)f, true), evidence$7).map((Function1<BasicFileAttributes, String> & Serializable)attr -> {
            if (attr.isRegularFile()) {
                return new StringBuilder(1).append(RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(attr.lastModifiedTime().toMillis()))).append("-").append(RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(attr.size()))).toString();
            }
            return "";
        });
    }

    public <F> OptionT<F, Response<F>> fromFile(File f, Option<Request<F>> req, Files<F> evidence$8, MonadError<F, Throwable> evidence$9) {
        return this.fromPath(Path$.MODULE$.fromNioPath(f.toPath()), this.DefaultBufferSize(), req, this.calculateETag(evidence$8, evidence$9), evidence$8, evidence$9);
    }

    public <F> OptionT<F, Response<F>> fromPath(Path f, Option<Request<F>> req, Files<F> evidence$10, MonadError<F, Throwable> evidence$11) {
        return this.fromPath(f, this.DefaultBufferSize(), req, this.calculateETag(evidence$10, evidence$11), evidence$10, evidence$11);
    }

    public <F> OptionT<F, Response<F>> fromFile(File f, Option<Request<F>> req, Function1<File, F> etagCalculator, Files<F> evidence$12, MonadError<F, Throwable> evidence$13) {
        return this.fromPath(Path$.MODULE$.fromNioPath(f.toPath()), this.DefaultBufferSize(), req, etagCalculator.compose((Function1<Path, File> & Serializable)x$10 -> x$10.toNioPath().toFile()), evidence$12, evidence$13);
    }

    public <F> OptionT<F, Response<F>> fromPath(Path f, Option<Request<F>> req, Function1<Path, F> etagCalculator, Files<F> evidence$14, MonadError<F, Throwable> evidence$15) {
        return this.fromPath(f, this.DefaultBufferSize(), req, etagCalculator, evidence$14, evidence$15);
    }

    public <F> OptionT<F, Response<F>> fromFile(File f, int buffsize, Option<Request<F>> req, Function1<File, F> etagCalculator, Files<F> evidence$16, MonadError<F, Throwable> evidence$17) {
        return this.fromPath(Path$.MODULE$.fromNioPath(f.toPath()), 0L, f.length(), buffsize, req, etagCalculator.compose((Function1<Path, File> & Serializable)x$11 -> x$11.toNioPath().toFile()), evidence$16, evidence$17);
    }

    public <F> OptionT<F, Response<F>> fromPath(Path f, int buffsize, Option<Request<F>> req, Function1<Path, F> etagCalculator, Files<F> evidence$18, MonadError<F, Throwable> evidence$19) {
        return ApplicativeErrorOps$.MODULE$.recoverWith$extension(package$all$.MODULE$.catsSyntaxApplicativeError(OptionT$.MODULE$.liftF(package$all$.MODULE$.toFunctorOps(Files$.MODULE$.apply(evidence$18).getBasicFileAttributes(f, true), evidence$19).map((Function1<BasicFileAttributes, Object> & Serializable)x$12 -> BoxesRunTime.boxToLong(x$12.size())), evidence$19).flatMap((Function1<Object, OptionT> & Serializable)size -> StaticFile$.MODULE$.fromPath(f, 0L, BoxesRunTime.unboxToLong(size), buffsize, req, etagCalculator, evidence$18, evidence$19), evidence$19), OptionT$.MODULE$.catsDataMonadErrorForOptionT(evidence$19)), new Serializable(evidence$19){
            private static final long serialVersionUID = 0L;
            private final MonadError evidence$19$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof NoSuchFileException) {
                    return (B1)OptionT$.MODULE$.none(this.evidence$19$1);
                }
                return function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable instanceof NoSuchFileException;
            }
            {
                this.evidence$19$1 = evidence$19$1;
            }
        }, OptionT$.MODULE$.catsDataMonadErrorForOptionT(evidence$19));
    }

    public <F> OptionT<F, Response<F>> fromFile(File f, long start, long end, int buffsize, Option<Request<F>> req, Function1<File, F> etagCalculator, Files<F> evidence$20, MonadError<F, Throwable> F) {
        return this.fromPath(Path$.MODULE$.fromNioPath(f.toPath()), start, end, buffsize, req, etagCalculator.compose((Function1<Path, File> & Serializable)x$13 -> x$13.toNioPath().toFile()), evidence$20, F);
    }

    public <F> None$ fromFile$default$2() {
        return None$.MODULE$;
    }

    public <F> OptionT<F, Response<F>> fromPath(Path f, long start, long end, int buffsize, Option<Request<F>> req, Function1<Path, F> etagCalculator, Files<F> evidence$21, MonadError<F, Throwable> F) {
        return new OptionT(package$all$.MODULE$.toFlatMapOps(package$all$.MODULE$.toFunctorOps(etagCalculator.apply(f), F).map((Function1<String, ETag> & Serializable)et -> ETag$.MODULE$.apply((String)et, ETag$.MODULE$.apply$default$2())), F).flatMap((Function1<ETag, Object> & Serializable)etagCalc -> package$all$.MODULE$.toFlatMapOps(Files$.MODULE$.apply(evidence$21).isRegularFile(f), F).flatMap((Function1<Object, Object> & Serializable)isFile -> StaticFile$.$anonfun$fromPath$6(start, end, buffsize, evidence$21, f, F, req, etagCalc, BoxesRunTime.unboxToBoolean(isFile)))));
    }

    public <F> None$ fromPath$default$2() {
        return None$.MODULE$;
    }

    private <F> Option<Response<F>> notModified(Option<Request<F>> req, ETag etagCalc, Option<HttpDate> lastModified) {
        Semigroup<Object> conjunction = new Semigroup<Object>(){

            public double combine$mcD$sp(double x2, double y) {
                return Semigroup.combine$mcD$sp$(this, x2, y);
            }

            public float combine$mcF$sp(float x2, float y) {
                return Semigroup.combine$mcF$sp$(this, x2, y);
            }

            public int combine$mcI$sp(int x2, int y) {
                return Semigroup.combine$mcI$sp$(this, x2, y);
            }

            public long combine$mcJ$sp(long x2, long y) {
                return Semigroup.combine$mcJ$sp$(this, x2, y);
            }

            public Object combineN(Object a, int n) {
                return Semigroup.combineN$(this, a, n);
            }

            public double combineN$mcD$sp(double a, int n) {
                return Semigroup.combineN$mcD$sp$(this, a, n);
            }

            public float combineN$mcF$sp(float a, int n) {
                return Semigroup.combineN$mcF$sp$(this, a, n);
            }

            public int combineN$mcI$sp(int a, int n) {
                return Semigroup.combineN$mcI$sp$(this, a, n);
            }

            public long combineN$mcJ$sp(long a, int n) {
                return Semigroup.combineN$mcJ$sp$(this, a, n);
            }

            public Object repeatedCombineN(Object a, int n) {
                return Semigroup.repeatedCombineN$(this, a, n);
            }

            public double repeatedCombineN$mcD$sp(double a, int n) {
                return Semigroup.repeatedCombineN$mcD$sp$(this, a, n);
            }

            public float repeatedCombineN$mcF$sp(float a, int n) {
                return Semigroup.repeatedCombineN$mcF$sp$(this, a, n);
            }

            public int repeatedCombineN$mcI$sp(int a, int n) {
                return Semigroup.repeatedCombineN$mcI$sp$(this, a, n);
            }

            public long repeatedCombineN$mcJ$sp(long a, int n) {
                return Semigroup.repeatedCombineN$mcJ$sp$(this, a, n);
            }

            public Option<Object> combineAllOption(IterableOnce<Object> as) {
                return Semigroup.combineAllOption$(this, as);
            }

            public Semigroup<Object> reverse() {
                return Semigroup.reverse$(this);
            }

            public Semigroup<Object> reverse$mcD$sp() {
                return Semigroup.reverse$mcD$sp$(this);
            }

            public Semigroup<Object> reverse$mcF$sp() {
                return Semigroup.reverse$mcF$sp$(this);
            }

            public Semigroup<Object> reverse$mcI$sp() {
                return Semigroup.reverse$mcI$sp$(this);
            }

            public Semigroup<Object> reverse$mcJ$sp() {
                return Semigroup.reverse$mcJ$sp$(this);
            }

            public Semigroup intercalate(Object middle) {
                return Semigroup.intercalate$(this, middle);
            }

            public Semigroup<Object> intercalate$mcD$sp(double middle) {
                return Semigroup.intercalate$mcD$sp$(this, middle);
            }

            public Semigroup<Object> intercalate$mcF$sp(float middle) {
                return Semigroup.intercalate$mcF$sp$(this, middle);
            }

            public Semigroup<Object> intercalate$mcI$sp(int middle) {
                return Semigroup.intercalate$mcI$sp$(this, middle);
            }

            public Semigroup<Object> intercalate$mcJ$sp(long middle) {
                return Semigroup.intercalate$mcJ$sp$(this, middle);
            }

            public boolean combine(boolean x2, boolean y) {
                return x2 && y;
            }
            {
                Semigroup.$init$(this);
            }
        };
        return package$all$.MODULE$.toFoldableOps(new $colon$colon<Nothing$>((Nothing$)((Object)this.etagMatch(req, etagCalc)), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.notModifiedSince(req, lastModified)), Nil$.MODULE$)), UnorderedFoldable$.MODULE$.catsTraverseForList()).combineAll(Semigroup$.MODULE$.catsKernelMonoidForOption(conjunction)).filter((Function1<Object, Object> & Serializable)x2 -> BoxesRunTime.boxToBoolean(StaticFile$.$anonfun$notModified$1(BoxesRunTime.unboxToBoolean(x2)))).map((Function1<Object, Response> & Serializable)x$16 -> Response$.MODULE$.apply(Status$.MODULE$.NotModified(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()));
    }

    private <F> Option<Object> etagMatch(Option<Request<F>> req, ETag etagCalc) {
        return req.flatMap((Function1<Request, Option> & Serializable)r -> Headers$.MODULE$.get$extension((List<Header.Raw>)r.headers(), Header$Select$.MODULE$.singleHeaders(If$minusNone$minusMatch$.MODULE$.headerInstance())).map((Function1<If$minusNone$minusMatch, Object> & Serializable)etagHeader -> BoxesRunTime.boxToBoolean(StaticFile$.$anonfun$etagMatch$2(etagCalc, etagHeader))));
    }

    private <F> Option<Object> notModifiedSince(Option<Request<F>> req, Option<HttpDate> lastModified) {
        return req.flatMap((Function1<Request, Option> & Serializable)r -> Headers$.MODULE$.get$extension((List<Header.Raw>)r.headers(), Header$Select$.MODULE$.singleHeaders(If$minusModified$minusSince$.MODULE$.headerInstance())).flatMap((Function1<If$minusModified$minusSince, Option> & Serializable)h -> lastModified.map((Function1<HttpDate, Object> & Serializable)lm -> BoxesRunTime.boxToBoolean(StaticFile$.$anonfun$notModifiedSince$3(h, lm)))));
    }

    private <F> Stream<F, Object> fileToBody(Path f, long start, long end, Files<F> evidence$22) {
        return Files$.MODULE$.apply(evidence$22).readRange(f, this.DefaultBufferSize(), start, end);
    }

    private Option<Content$minusType> nameToContentType(String name) {
        int n = name.lastIndexOf(46);
        switch (n) {
            case -1: {
                return None$.MODULE$;
            }
        }
        return MediaType$.MODULE$.forExtension(name.substring(n + 1)).map((Function1<MediaType, Content$minusType> & Serializable)x$23 -> Content$minusType$.MODULE$.apply((MediaType)x$23));
    }

    public Key<Path> staticPathKey() {
        return staticPathKey;
    }

    private Key<File> staticFileKey$lzycompute() {
        StaticFile$ staticFile$ = this;
        synchronized (staticFile$) {
            if (!bitmap$0) {
                staticFileKey = this.staticPathKey().imap((Function1<Path, File> & Serializable)x$24 -> x$24.toNioPath().toFile(), (Function1<File, Path> & Serializable)f -> Path$.MODULE$.fromNioPath(f.toPath()));
                bitmap$0 = true;
            }
        }
        return staticFileKey;
    }

    public Key<File> staticFileKey() {
        if (!bitmap$0) {
            return this.staticFileKey$lzycompute();
        }
        return staticFileKey;
    }

    public static final /* synthetic */ boolean $anonfun$fromResource$3(Accept$minusEncoding acceptEncoding) {
        return acceptEncoding.satisfiedBy(ContentCoding$.MODULE$.gzip()) || acceptEncoding.satisfiedBy(ContentCoding$.MODULE$.x$minusgzip());
    }

    private static final OptionT getResource$1(String name, Sync evidence$3$1, ClassLoader loader$1) {
        return new OptionT(package$.MODULE$.Sync().apply(evidence$3$1).blocking((Function0<Option> & Serializable)() -> Option$.MODULE$.apply(loader$1.getResource(name))));
    }

    public static final /* synthetic */ boolean $anonfun$fromURL$3(If$minusModified$minusSince x$6, HttpDate x$7) {
        return x$6.date().$less(x$7);
    }

    public static final /* synthetic */ void $anonfun$fromURL$12(Throwable x$9) {
    }

    public static final /* synthetic */ String $anonfun$calcETag$2(File f$1, boolean isFile) {
        if (isFile) {
            return new StringBuilder(1).append(RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(f$1.lastModified()))).append("-").append(RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(f$1.length()))).toString();
        }
        return "";
    }

    public static final /* synthetic */ Object $anonfun$fromPath$6(long start$1, long end$1, int buffsize$2, Files evidence$21$1, Path f$3, MonadError F$2, Option req$4, ETag etagCalc$1, boolean isFile) {
        if (isFile) {
            if (start$1 >= 0L && end$1 >= start$1 && buffsize$2 > 0) {
                return package$all$.MODULE$.toFlatMapOps(Files$.MODULE$.apply(evidence$21$1).getBasicFileAttributes(f$3, true), F$2).flatMap((Function1<BasicFileAttributes, Object> & Serializable)attr -> {
                    Option<HttpDate> lastModified = HttpDate$.MODULE$.fromEpochSecond(attr.lastModifiedTime().toSeconds()).toOption();
                    return F$2.pure(MODULE$.notModified(req$4, etagCalc$1, lastModified).orElse((Function0<Option> & Serializable)() -> {
                        List<Header.Raw> hs;
                        Tuple2<Stream<Nothing$, Nothing$>, Long> tuple2;
                        Tuple2<Stream<Nothing$, Object>, Long> tuple22 = tuple2 = attr.size() < end$1 ? new Tuple2<Stream<Nothing$, Nothing$>, Long>(Stream$.MODULE$.empty(), BoxesRunTime.boxToLong(0L)) : new Tuple2(MODULE$.fileToBody(f$3, start$1, end$1, evidence$21$1), BoxesRunTime.boxToLong(end$1 - start$1));
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        Stream<Nothing$, Nothing$> body = tuple2._1();
                        long contentLength = tuple2._2$mcJ$sp();
                        Tuple2<Stream<Nothing$, Nothing$>, Long> tuple23 = new Tuple2<Stream<Nothing$, Nothing$>, Long>(body, BoxesRunTime.boxToLong(contentLength));
                        Stream<Nothing$, Nothing$> body2 = tuple23._1();
                        long contentLength2 = tuple23._2$mcJ$sp();
                        Option<Content$minusType> contentType = MODULE$.nameToContentType(f$3.fileName().toString());
                        List<Header.Raw> x$1 = hs = Headers$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header$ToRaw$.MODULE$.foldablesToRaw(lastModified.map((Function1<HttpDate, Last$minusModified> & Serializable)x$15 -> new Last$minusModified((HttpDate)x$15)), UnorderedFoldable$.MODULE$.catsTraverseForOption(), (Function1<Last$minusModified, Header.ToRaw> & Serializable)h -> Header$ToRaw$.MODULE$.modelledHeadersToRaw(h, Last$minusModified$.MODULE$.headerInstance())), Header$ToRaw$.MODULE$.foldablesToRaw(Content$minusLength$.MODULE$.fromLong(contentLength2).toOption(), UnorderedFoldable$.MODULE$.catsTraverseForOption(), (Function1<Content$minusLength, Header.ToRaw> & Serializable)h -> Header$ToRaw$.MODULE$.modelledHeadersToRaw(h, Content$minusLength$.MODULE$.headerInstance())), Header$ToRaw$.MODULE$.foldablesToRaw(contentType, UnorderedFoldable$.MODULE$.catsTraverseForOption(), (Function1<Content$minusType, Header.ToRaw> & Serializable)h -> Header$ToRaw$.MODULE$.modelledHeadersToRaw(h, Content$minusType$.MODULE$.headerInstance())), Header$ToRaw$.MODULE$.modelledHeadersToRaw(etagCalc$1, ETag$.MODULE$.headerInstance())}));
                        Stream<Nothing$, Nothing$> x$2 = body2;
                        Vault x$3 = Vault$.MODULE$.empty().insert(MODULE$.staticPathKey(), f$3);
                        Status x$4 = Response$.MODULE$.apply$default$1();
                        HttpVersion x$5 = Response$.MODULE$.apply$default$2();
                        Response<Nothing$> r = Response$.MODULE$.apply(x$4, x$5, x$1, x$2, x$3);
                        ((SyncIO)logger.trace((Function0<String> & Serializable)() -> new StringBuilder(32).append("Static file generated response: ").append(r).toString())).unsafeRunSync();
                        return OptionIdOps$.MODULE$.some$extension(package$all$.MODULE$.catsSyntaxOptionId(r));
                    }));
                });
            }
            return F$2.raiseError(new IllegalArgumentException(new StringBuilder(46).append("requirement failed: start: ").append(start$1).append(", end: ").append(end$1).append(", buffsize: ").append(buffsize$2).toString()));
        }
        return F$2.pure(package$all$.MODULE$.none());
    }

    public static final /* synthetic */ boolean $anonfun$notModified$1(boolean x2) {
        return BoxesRunTime.unboxToBoolean(Predef$.MODULE$.identity(BoxesRunTime.boxToBoolean(x2)));
    }

    public static final /* synthetic */ boolean $anonfun$etagMatch$4(ETag etagCalc$2, EntityTag x$18) {
        EntityTag entityTag = x$18;
        EntityTag entityTag2 = etagCalc$2.tag();
        return !(entityTag != null ? !((Object)entityTag).equals(entityTag2) : entityTag2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$etagMatch$2(ETag etagCalc$2, If$minusNone$minusMatch etagHeader) {
        boolean etagMatch = etagHeader.tags().exists((Function1<NonEmptyList<EntityTag>, Object>)(Function1<NonEmptyList, Object> & Serializable)x$17 -> BoxesRunTime.boxToBoolean(x$17.exists((Function1<EntityTag, Object> & Serializable)x$18 -> BoxesRunTime.boxToBoolean(StaticFile$.$anonfun$etagMatch$4(etagCalc$2, x$18)))));
        SyncIO syncIO = (SyncIO)logger.trace((Function0<String> & Serializable)() -> new StringBuilder(53).append("Matches `If-None-Match`: ").append(etagMatch).append(" Previous ETag: ").append(package$header$.MODULE$.http4sHeaderSyntax(etagHeader, If$minusNone$minusMatch$.MODULE$.headerInstance()).value()).append(", New ETag: ").append(etagCalc$2).toString());
        return etagMatch;
    }

    public static final /* synthetic */ boolean $anonfun$notModifiedSince$3(If$minusModified$minusSince h$1, HttpDate lm) {
        boolean notModified = h$1.date().$greater$eq(lm);
        SyncIO syncIO = (SyncIO)logger.trace((Function0<String> & Serializable)() -> new StringBuilder(56).append("Matches `If-Modified-Since`: ").append(notModified).append(". Request age: ").append(h$1.date()).append(", Modified: ").append(lm).toString());
        return notModified;
    }

    private StaticFile$() {
    }
}

