/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.middleware.authentication;

import cats.Functor;
import cats.Monad;
import cats.data.Kleisli;
import cats.data.NonEmptyList;
import cats.effect.kernel.Async;
import cats.effect.kernel.Sync;
import cats.syntax.EitherObjectOps$;
import cats.syntax.package$all$;
import java.io.Serializable;
import org.http4s.AuthScheme$;
import org.http4s.AuthedRequest$;
import org.http4s.Challenge;
import org.http4s.ContextRequest;
import org.http4s.Credentials;
import org.http4s.Header;
import org.http4s.Header$Select$;
import org.http4s.Headers$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.crypto.Hash;
import org.http4s.crypto.Hash$;
import org.http4s.headers.Authorization;
import org.http4s.headers.Authorization$;
import org.http4s.server.middleware.authentication.DigestAuth;
import org.http4s.server.middleware.authentication.DigestAuth$BadNC$;
import org.http4s.server.middleware.authentication.DigestAuth$BadParameters$;
import org.http4s.server.middleware.authentication.DigestAuth$NoAuthorizationHeader$;
import org.http4s.server.middleware.authentication.DigestAuth$NoCredentials$;
import org.http4s.server.middleware.authentication.DigestAuth$PlainTextAuthStore$;
import org.http4s.server.middleware.authentication.DigestAuth$StaleNonce$;
import org.http4s.server.middleware.authentication.DigestAuth$UserUnknown$;
import org.http4s.server.middleware.authentication.DigestAuth$WrongResponse$;
import org.http4s.server.middleware.authentication.DigestUtil$;
import org.http4s.server.middleware.authentication.NonceKeeper;
import org.http4s.server.middleware.authentication.NonceKeeper$BadNCReply$;
import org.http4s.server.middleware.authentication.NonceKeeper$OKReply$;
import org.http4s.server.middleware.authentication.NonceKeeper$StaleReply$;
import org.http4s.server.middleware.authentication.NonceKeeperF;
import org.http4s.server.middleware.authentication.NonceKeeperF$;
import org.http4s.server.middleware.authentication.package$;
import org.typelevel.ci.CIString;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.SetOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class DigestAuth$ {
    public static final DigestAuth$ MODULE$ = new DigestAuth$();

    public <F, A> Function1<Kleisli<?, ContextRequest<F, A>, Response<F>>, Kleisli<?, Request<F>, Response<F>>> apply(String realm, Function1<String, F> store, Duration nonceCleanupInterval, Duration nonceStaleTime, int nonceBits, Sync<F> evidence$3) {
        NonceKeeper nonceKeeper = new NonceKeeper(nonceStaleTime.toMillis(), nonceCleanupInterval.toMillis(), nonceBits);
        Kleisli kleisli = this.challenge(realm, store, nonceKeeper, evidence$3);
        return (Function1<Kleisli, Kleisli> & Serializable)routes -> package$.MODULE$.challenged(kleisli, routes, evidence$3);
    }

    public <F, A> Duration apply$default$3() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).hour();
    }

    public <F, A> Duration apply$default$4() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).hour();
    }

    public <F, A> int apply$default$5() {
        return 160;
    }

    public <F, A> F applyF(String realm, DigestAuth.AuthStore<F, A> store, Duration nonceCleanupInterval, Duration nonceStaleTime, int nonceBits, Async<F> F) {
        return package$all$.MODULE$.toFunctorOps(this.challenge(realm, store, nonceCleanupInterval, nonceStaleTime, nonceBits, F), F).map((Function1<Kleisli, Function1> & Serializable)runChallenge -> (Function1<Kleisli, Kleisli> & Serializable)routes -> package$.MODULE$.challenged(runChallenge, routes, F));
    }

    public <F, A> Duration applyF$default$3() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).hour();
    }

    public <F, A> Duration applyF$default$4() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).hour();
    }

    public <F, A> int applyF$default$5() {
        return 160;
    }

    public <F, A> Kleisli<F, Request<F>, Either<Challenge, ContextRequest<F, A>>> challenge(String realm, Function1<String, F> store, NonceKeeper nonceKeeper, Sync<F> F) {
        return this.challengeInterop(realm, DigestAuth$PlainTextAuthStore$.MODULE$.apply(store), F.delay((Function0<String> & Serializable)() -> nonceKeeper.newNonce()), (Function2<String, Object, Object> & Serializable)(data, nc) -> F.delay((Function0<NonceKeeper.Reply> & Serializable)() -> nonceKeeper$1.receiveNonce(data, nc)), F);
    }

    public <F, A> F challenge(String realm, DigestAuth.AuthStore<F, A> store, Duration nonceCleanupInterval, Duration nonceStaleTime, int nonceBits, Async<F> F) {
        return package$all$.MODULE$.toFunctorOps(NonceKeeperF$.MODULE$.apply(nonceStaleTime, nonceCleanupInterval, nonceBits, F), F).map((Function1<NonceKeeperF, Kleisli> & Serializable)nonceKeeper -> MODULE$.challengeInterop(realm, store, nonceKeeper.newNonce(), (Function2<String, Object, Object> & Serializable)(data, nc) -> nonceKeeper.receiveNonce(data, BoxesRunTime.unboxToInt(nc)), F));
    }

    public <F, A> Duration challenge$default$3() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).hour();
    }

    public <F, A> Duration challenge$default$4() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).hour();
    }

    public <F, A> int challenge$default$5() {
        return 160;
    }

    private <F, A> Kleisli<F, Request<F>, Either<Challenge, ContextRequest<F, A>>> challengeInterop(String realm, DigestAuth.AuthStore<F, A> store, F newNonce, Function2<String, Object, F> receiveNonce, Sync<F> F) {
        return new Kleisli((Function1<Request, Object> & Serializable)req -> package$all$.MODULE$.toFlatMapOps(MODULE$.checkAuth(realm, store, receiveNonce, (Request)req, Hash$.MODULE$.forApplicativeThrow(F), F), F).flatMap((Function1<DigestAuth.AuthReply, Object> & Serializable)x0$1 -> {
            DigestAuth.AuthReply authReply = x0$1;
            if (authReply instanceof DigestAuth.OK) {
                DigestAuth.OK oK = (DigestAuth.OK)authReply;
                Object authInfo = oK.authInfo();
                return F.pure(EitherObjectOps$.MODULE$.right$extension(package$all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), AuthedRequest$.MODULE$.apply(authInfo, req)));
            }
            if (DigestAuth$StaleNonce$.MODULE$.equals(authReply)) {
                return package$all$.MODULE$.toFunctorOps(MODULE$.getChallengeParams(newNonce, true, F), F).map((Function1<Map, Either> & Serializable)params -> DigestAuth$.paramsToChallenge$1(params, realm));
            }
            return package$all$.MODULE$.toFunctorOps(MODULE$.getChallengeParams(newNonce, false, F), F).map((Function1<Map, Either> & Serializable)params -> DigestAuth$.paramsToChallenge$1(params, realm));
        }));
    }

    private <F, A> F checkAuth(String realm, DigestAuth.AuthStore<F, A> store, Function2<String, Object, F> receiveNonce, Request<F> req, Hash<F> evidence$4, Monad<F> F) {
        boolean bl = false;
        Some some = null;
        Option<Object> option = Headers$.MODULE$.get$extension((List<Header.Raw>)req.headers(), Header$Select$.MODULE$.singleHeaders(Authorization$.MODULE$.headerInstance()));
        if (option instanceof Some) {
            Credentials credentials;
            bl = true;
            some = (Some)option;
            Authorization authorization = (Authorization)some.value();
            if (authorization != null && (credentials = authorization.credentials()) instanceof Credentials.AuthParams) {
                Credentials.AuthParams authParams = (Credentials.AuthParams)credentials;
                CIString cIString = authParams.authScheme();
                NonEmptyList<Tuple2<String, String>> params = authParams.params();
                CIString cIString2 = AuthScheme$.MODULE$.Digest();
                CIString cIString3 = cIString;
                if (!(cIString2 != null ? !((Object)cIString2).equals(cIString3) : cIString3 != null)) {
                    return this.checkAuthParams(realm, store, receiveNonce, req, params, evidence$4, F);
                }
            }
        }
        if (bl) {
            return F.pure(DigestAuth$NoCredentials$.MODULE$);
        }
        if (None$.MODULE$.equals(option)) {
            return F.pure(DigestAuth$NoAuthorizationHeader$.MODULE$);
        }
        throw new MatchError(option);
    }

    private <F> F getChallengeParams(F newNonce, boolean staleNonce, Functor<F> F) {
        return package$all$.MODULE$.toFunctorOps(newNonce, F).map((Function1<String, Map> & Serializable)nonce -> {
            Map m = (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("qop"), "auth"), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("nonce"), nonce)}));
            if (staleNonce) {
                return (Map)m.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("stale"), "TRUE"));
            }
            return m;
        });
    }

    private <F, A> F checkAuthParams(String realm, DigestAuth.AuthStore<F, A> store, Function2<String, Object, F> receiveNonce, Request<F> req, NonEmptyList<Tuple2<String, String>> paramsNel, Hash<F> evidence$5, Monad<F> F) {
        Map params = paramsNel.toList().toMap($less$colon$less$.MODULE$.refl());
        if (!((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"realm", "nonce", "nc", "username", "cnonce", "qop"}))).subsetOf(params.keySet())) {
            return F.pure(DigestAuth$BadParameters$.MODULE$);
        }
        String method = req.method().toString();
        if (!params.get("realm").contains(realm)) {
            return F.pure(DigestAuth$BadParameters$.MODULE$);
        }
        String nonce = (String)params.apply("nonce");
        String nc = (String)params.apply("nc");
        return package$all$.MODULE$.toFlatMapOps(receiveNonce.apply(nonce, BoxesRunTime.boxToInteger(Integer.parseInt(nc, 16))), F).flatMap((Function1<NonceKeeper.Reply, Object> & Serializable)x0$1 -> {
            NonceKeeper.Reply reply = x0$1;
            if (NonceKeeper$StaleReply$.MODULE$.equals(reply)) {
                return F.pure(DigestAuth$StaleNonce$.MODULE$);
            }
            if (NonceKeeper$BadNCReply$.MODULE$.equals(reply)) {
                return F.pure(DigestAuth$BadNC$.MODULE$);
            }
            if (NonceKeeper$OKReply$.MODULE$.equals(reply)) {
                DigestAuth.AuthStore authStore = store;
                if (authStore instanceof DigestAuth.PlainTextAuthStore) {
                    DigestAuth.PlainTextAuthStore plainTextAuthStore = (DigestAuth.PlainTextAuthStore)authStore;
                    return package$all$.MODULE$.toFlatMapOps(plainTextAuthStore.func().apply((String)params.apply("username")), F).flatMap((Function1<Option, Object> & Serializable)x0$2 -> {
                        Some some;
                        Tuple2 tuple2;
                        Option option = x0$2;
                        if (None$.MODULE$.equals(option)) {
                            return F.pure(DigestAuth$UserUnknown$.MODULE$);
                        }
                        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                            Object authInfo = tuple2._1();
                            String password = (String)tuple2._2();
                            return package$all$.MODULE$.toFunctorOps(DigestUtil$.MODULE$.computeResponse(method, (String)params.apply("username"), realm, password, req.uri(), nonce, nc, (String)params.apply("cnonce"), (String)params.apply("qop"), F, evidence$5), F).map((Function1<String, DigestAuth.AuthReply> & Serializable)resp -> {
                                String string = resp;
                                Object v = params.apply("response");
                                if (!(string != null ? !string.equals(v) : v != null)) {
                                    return new DigestAuth.OK<Object>(authInfo);
                                }
                                return DigestAuth$WrongResponse$.MODULE$;
                            });
                        }
                        throw new MatchError(option);
                    });
                }
                if (authStore instanceof DigestAuth.Md5HashedAuthStore) {
                    DigestAuth.Md5HashedAuthStore md5HashedAuthStore = (DigestAuth.Md5HashedAuthStore)authStore;
                    return package$all$.MODULE$.toFlatMapOps(md5HashedAuthStore.func().apply((String)params.apply("username")), F).flatMap((Function1<Option, Object> & Serializable)x0$3 -> {
                        Some some;
                        Tuple2 tuple2;
                        Option option = x0$3;
                        if (None$.MODULE$.equals(option)) {
                            return F.pure(DigestAuth$UserUnknown$.MODULE$);
                        }
                        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                            Object authInfo = tuple2._1();
                            String ha1Hash = (String)tuple2._2();
                            return package$all$.MODULE$.toFunctorOps(DigestUtil$.MODULE$.computeHashedResponse(method, ha1Hash, req.uri(), nonce, nc, (String)params.apply("cnonce"), (String)params.apply("qop"), F, evidence$5), F).map((Function1<String, DigestAuth.AuthReply> & Serializable)resp -> {
                                String string = resp;
                                Object v = params.apply("response");
                                if (!(string != null ? !string.equals(v) : v != null)) {
                                    return new DigestAuth.OK<Object>(authInfo);
                                }
                                return DigestAuth$WrongResponse$.MODULE$;
                            });
                        }
                        throw new MatchError(option);
                    });
                }
                throw new MatchError(authStore);
            }
            throw new MatchError(reply);
        });
    }

    private static final Either paramsToChallenge$1(Map params, String realm$2) {
        return EitherObjectOps$.MODULE$.left$extension(package$all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), new Challenge("Digest", realm$2, params));
    }

    private DigestAuth$() {
    }
}

