/*
 * Decompiled with CFR 0.152.
 */
package fs2.io.tls;

import cats.Applicative$;
import cats.effect.Concurrent;
import cats.effect.ContextShift;
import cats.effect.Sync$;
import cats.effect.concurrent.Semaphore;
import cats.effect.concurrent.Semaphore$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.IfMOps$;
import cats.syntax.package$all$;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.io.tls.InputOutputBuffer;
import fs2.io.tls.InputOutputBuffer$;
import fs2.io.tls.SSLEngineTaskRunner;
import fs2.io.tls.SSLEngineTaskRunner$;
import fs2.io.tls.TLSEngine;
import fs2.io.tls.TLSEngine$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;

public final class TLSEngine$ {
    public static final TLSEngine$ MODULE$ = new TLSEngine$();

    public <F> F apply(SSLEngine engine, TLSEngine.Binding<F> binding, ExecutionContext blocker, Option<Function1<String, F>> logger, Concurrent<F> evidence$1, ContextShift<F> evidence$2) {
        return package$all$.MODULE$.toFlatMapOps(InputOutputBuffer$.MODULE$.apply(engine.getSession().getApplicationBufferSize(), engine.getSession().getPacketBufferSize(), evidence$1), evidence$1).flatMap((Function1<InputOutputBuffer, Object> & Serializable)wrapBuffer -> package$all$.MODULE$.toFlatMapOps(InputOutputBuffer$.MODULE$.apply(engine.getSession().getPacketBufferSize(), engine.getSession().getApplicationBufferSize(), evidence$1), evidence$1).flatMap((Function1<InputOutputBuffer, Object> & Serializable)unwrapBuffer -> package$all$.MODULE$.toFlatMapOps(Semaphore$.MODULE$.apply(1L, evidence$1), evidence$1).flatMap((Function1<Semaphore, Object> & Serializable)readSemaphore -> package$all$.MODULE$.toFlatMapOps(Semaphore$.MODULE$.apply(1L, evidence$1), evidence$1).flatMap((Function1<Semaphore, Object> & Serializable)writeSemaphore -> package$all$.MODULE$.toFunctorOps(Semaphore$.MODULE$.apply(1L, evidence$1), evidence$1).map((Function1<Semaphore, TLSEngine> & Serializable)handshakeSemaphore -> {
            SSLEngineTaskRunner sslEngineTaskRunner = SSLEngineTaskRunner$.MODULE$.apply(engine, blocker, evidence$1, evidence$2);
            return new TLSEngine<F>(logger, evidence$1, engine, (Semaphore)writeSemaphore, (InputOutputBuffer)wrapBuffer, (Semaphore)handshakeSemaphore, binding, (Semaphore)readSemaphore, (InputOutputBuffer)unwrapBuffer, sslEngineTaskRunner){
                private final Option logger$1;
                private final Concurrent evidence$1$1;
                private final SSLEngine engine$1;
                private final Semaphore writeSemaphore$1;
                private final InputOutputBuffer wrapBuffer$1;
                private final Semaphore handshakeSemaphore$1;
                private final TLSEngine.Binding binding$1;
                private final Semaphore readSemaphore$1;
                private final InputOutputBuffer unwrapBuffer$1;
                private final SSLEngineTaskRunner sslEngineTaskRunner$1;

                private F log(String msg) {
                    return (F)this.logger$1.map((Function1<Function1, Object> & Serializable)x$1 -> x$1.apply(msg)).getOrElse((Function0<Object> & Serializable)() -> Applicative$.MODULE$.apply($this.evidence$1$1).unit());
                }

                public F beginHandshake() {
                    return Sync$.MODULE$.apply(this.evidence$1$1).delay(() -> $this.engine$1.beginHandshake());
                }

                public F session() {
                    return Sync$.MODULE$.apply(this.evidence$1$1).delay((Function0<SSLSession> & Serializable)() -> $this.engine$1.getSession());
                }

                public F applicationProtocol() {
                    return Sync$.MODULE$.apply(this.evidence$1$1).delay((Function0<String> & Serializable)() -> $this.engine$1.getApplicationProtocol());
                }

                public F stopWrap() {
                    return Sync$.MODULE$.apply(this.evidence$1$1).delay(() -> $this.engine$1.closeOutbound());
                }

                public F stopUnwrap() {
                    return package$all$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.attempt$extension(package$all$.MODULE$.catsSyntaxApplicativeError(Sync$.MODULE$.apply(this.evidence$1$1).delay(() -> $this.engine$1.closeInbound()), this.evidence$1$1), this.evidence$1$1), this.evidence$1$1).void();
                }

                public F write(Chunk<Object> data, Option<FiniteDuration> timeout) {
                    return this.writeSemaphore$1.withPermit(this.write0(data, timeout));
                }

                private F write0(Chunk<Object> data, Option<FiniteDuration> timeout) {
                    return FlatMapOps$.MODULE$.$greater$greater$extension(package$all$.MODULE$.catsSyntaxFlatMapOps(this.wrapBuffer$1.input(data), this.evidence$1$1), (Function0<Object> & Serializable)() -> this.wrap(timeout), this.evidence$1$1);
                }

                private F wrap(Option<FiniteDuration> timeout) {
                    return package$all$.MODULE$.toFlatMapOps(package$all$.MODULE$.toFlatMapOps(this.wrapBuffer$1.perform((Function2<ByteBuffer, ByteBuffer, SSLEngineResult> & Serializable)(x$2, x$3) -> $this.engine$1.wrap((ByteBuffer)x$2, (ByteBuffer)x$3)), this.evidence$1$1).flatTap((Function1<SSLEngineResult, Object> & Serializable)result2 -> this.log(new StringBuilder(13).append("wrap result: ").append(result2).toString())), this.evidence$1$1).flatMap((Function1<SSLEngineResult, Object> & Serializable)result2 -> {
                        F f;
                        SSLEngineResult.Status status = result2.getStatus();
                        if (((Object)((Object)((Object)SSLEngineResult.Status.OK))).equals((Object)((Object)status))) {
                            f = FlatMapOps$.MODULE$.$greater$greater$extension(package$all$.MODULE$.catsSyntaxFlatMapOps(this.doWrite(timeout), $this.evidence$1$1), (Function0<Object> & Serializable)() -> {
                                SSLEngineResult.HandshakeStatus handshakeStatus = result2.getHandshakeStatus();
                                F f = ((Object)((Object)((Object)SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING))).equals((Object)((Object)handshakeStatus)) ? package$all$.MODULE$.toFlatMapOps($this.wrapBuffer$1.inputRemains(), $this.evidence$1$1).flatMap((Function1<Object, Object> & Serializable)x2 -> anon.1.$anonfun$wrap$5(this, timeout, result2, BoxesRunTime.unboxToInt(x2))) : FlatMapOps$.MODULE$.$greater$greater$extension(package$all$.MODULE$.catsSyntaxFlatMapOps($this.handshakeSemaphore$1.withPermit(this.stepHandshake((SSLEngineResult)result2, true, timeout)), $this.evidence$1$1), (Function0<Object> & Serializable)() -> this.wrap(timeout), $this.evidence$1$1);
                                return f;
                            }, $this.evidence$1$1);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_UNDERFLOW))).equals((Object)((Object)status))) {
                            f = this.doWrite(timeout);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_OVERFLOW))).equals((Object)((Object)status))) {
                            f = FlatMapOps$.MODULE$.$greater$greater$extension(package$all$.MODULE$.catsSyntaxFlatMapOps($this.wrapBuffer$1.expandOutput(), $this.evidence$1$1), (Function0<Object> & Serializable)() -> this.wrap(timeout), $this.evidence$1$1);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.CLOSED))).equals((Object)((Object)status))) {
                            f = this.stopWrap();
                        } else {
                            throw new MatchError((Object)((Object)status));
                        }
                        return f;
                    });
                }

                private F doWrite(Option<FiniteDuration> timeout) {
                    return package$all$.MODULE$.toFlatMapOps(this.wrapBuffer$1.output(Integer.MAX_VALUE), this.evidence$1$1).flatMap((Function1<Chunk, Object> & Serializable)out -> out.isEmpty() ? Applicative$.MODULE$.apply($this.evidence$1$1).unit() : $this.binding$1.write((Chunk<Object>)out, timeout));
                }

                public F read(int maxBytes, Option<FiniteDuration> timeout) {
                    return this.readSemaphore$1.withPermit(this.read0(maxBytes, timeout));
                }

                private F initialHandshakeDone() {
                    return Sync$.MODULE$.apply(this.evidence$1$1).delay(() -> {
                        String string2 = $this.engine$1.getSession().getCipherSuite();
                        String string3 = "SSL_NULL_WITH_NULL_NULL";
                        return string2 == null ? string3 != null : !string2.equals(string3);
                    });
                }

                private F read0(int maxBytes, Option<FiniteDuration> timeout) {
                    return package$all$.MODULE$.toFlatMapOps(this.unwrapThenTakeUnwrapped(maxBytes, timeout), this.evidence$1$1).flatMap((Function1<Option, Object> & Serializable)out -> out.isEmpty() ? IfMOps$.MODULE$.ifM$extension(package$all$.MODULE$.catsSyntaxIfM(this.initialHandshakeDone(), $this.evidence$1$1), (Function0<Object> & Serializable)() -> this.read1(maxBytes, timeout), (Function0<Object> & Serializable)() -> FlatMapOps$.MODULE$.$greater$greater$extension(package$all$.MODULE$.catsSyntaxFlatMapOps(this.write(Chunk$.MODULE$.empty(), None$.MODULE$), $this.evidence$1$1), (Function0<Object> & Serializable)() -> package$all$.MODULE$.toFlatMapOps(this.unwrapThenTakeUnwrapped(maxBytes, timeout), $this.evidence$1$1).flatMap((Function1<Option, Object> & Serializable)out -> out.isEmpty() ? this.read1(maxBytes, timeout) : Applicative$.MODULE$.apply($this.evidence$1$1).pure(out)), $this.evidence$1$1), $this.evidence$1$1) : Applicative$.MODULE$.apply($this.evidence$1$1).pure(out));
                }

                private F read1(int maxBytes, Option<FiniteDuration> timeout) {
                    return package$all$.MODULE$.toFlatMapOps(this.binding$1.read(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(maxBytes), this.engine$1.getSession().getPacketBufferSize()), timeout), this.evidence$1$1).flatMap((Function1<Option, Object> & Serializable)x0$1 -> {
                        F f;
                        Option option = x0$1;
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            Chunk c = (Chunk)some.value();
                            f = FlatMapOps$.MODULE$.$greater$greater$extension(package$all$.MODULE$.catsSyntaxFlatMapOps($this.unwrapBuffer$1.input(c), $this.evidence$1$1), (Function0<Object> & Serializable)() -> package$all$.MODULE$.toFlatMapOps(this.unwrap(maxBytes, timeout), $this.evidence$1$1).flatMap((Function1<Option, Object> & Serializable)x0$2 -> {
                                F f;
                                Option option = x0$2;
                                if (option instanceof Some) {
                                    Some some = (Some)option;
                                    f = Applicative$.MODULE$.apply($this.evidence$1$1).pure(some);
                                } else if (None$.MODULE$.equals(option)) {
                                    f = this.read1(maxBytes, timeout);
                                } else {
                                    throw new MatchError(option);
                                }
                                return f;
                            }), $this.evidence$1$1);
                        } else if (None$.MODULE$.equals(option)) {
                            f = Applicative$.MODULE$.apply($this.evidence$1$1).pure(None$.MODULE$);
                        } else {
                            throw new MatchError(option);
                        }
                        return f;
                    });
                }

                private F unwrap(int maxBytes, Option<FiniteDuration> timeout) {
                    return package$all$.MODULE$.toFlatMapOps(package$all$.MODULE$.toFlatMapOps(this.unwrapBuffer$1.perform((Function2<ByteBuffer, ByteBuffer, SSLEngineResult> & Serializable)(x$4, x$5) -> $this.engine$1.unwrap((ByteBuffer)x$4, (ByteBuffer)x$5)), this.evidence$1$1).flatTap((Function1<SSLEngineResult, Object> & Serializable)result2 -> this.log(new StringBuilder(15).append("unwrap result: ").append(result2).toString())), this.evidence$1$1).flatMap((Function1<SSLEngineResult, Object> & Serializable)result2 -> {
                        F f;
                        SSLEngineResult.Status status = result2.getStatus();
                        if (((Object)((Object)((Object)SSLEngineResult.Status.OK))).equals((Object)((Object)status))) {
                            SSLEngineResult.HandshakeStatus handshakeStatus = result2.getHandshakeStatus();
                            F f2 = ((Object)((Object)((Object)SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING))).equals((Object)((Object)handshakeStatus)) ? IfMOps$.MODULE$.ifM$extension(package$all$.MODULE$.catsSyntaxIfM(package$all$.MODULE$.toFunctorOps($this.unwrapBuffer$1.inputRemains(), $this.evidence$1$1).map(x$6 -> x$6 > 0 && result2.bytesConsumed() > 0), $this.evidence$1$1), (Function0<Object> & Serializable)() -> this.unwrap(maxBytes, timeout), (Function0<Object> & Serializable)() -> this.takeUnwrapped(maxBytes), $this.evidence$1$1) : (((Object)((Object)((Object)SSLEngineResult.HandshakeStatus.FINISHED))).equals((Object)((Object)handshakeStatus)) ? this.unwrap(maxBytes, timeout) : FlatMapOps$.MODULE$.$greater$greater$extension(package$all$.MODULE$.catsSyntaxFlatMapOps($this.handshakeSemaphore$1.withPermit(this.stepHandshake((SSLEngineResult)result2, false, timeout)), $this.evidence$1$1), (Function0<Object> & Serializable)() -> this.unwrap(maxBytes, timeout), $this.evidence$1$1));
                            f = f2;
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_UNDERFLOW))).equals((Object)((Object)status))) {
                            f = this.takeUnwrapped(maxBytes);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_OVERFLOW))).equals((Object)((Object)status))) {
                            f = FlatMapOps$.MODULE$.$greater$greater$extension(package$all$.MODULE$.catsSyntaxFlatMapOps($this.unwrapBuffer$1.expandOutput(), $this.evidence$1$1), (Function0<Object> & Serializable)() -> this.unwrap(maxBytes, timeout), $this.evidence$1$1);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.CLOSED))).equals((Object)((Object)status))) {
                            f = FlatMapOps$.MODULE$.$greater$greater$extension(package$all$.MODULE$.catsSyntaxFlatMapOps(FlatMapOps$.MODULE$.$greater$greater$extension(package$all$.MODULE$.catsSyntaxFlatMapOps(this.stopWrap(), $this.evidence$1$1), (Function0<Object> & Serializable)() -> this.stopUnwrap(), $this.evidence$1$1), $this.evidence$1$1), (Function0<Object> & Serializable)() -> this.takeUnwrapped(maxBytes), $this.evidence$1$1);
                        } else {
                            throw new MatchError((Object)((Object)status));
                        }
                        return f;
                    });
                }

                private F takeUnwrapped(int maxBytes) {
                    return package$all$.MODULE$.toFunctorOps(this.unwrapBuffer$1.output(maxBytes), this.evidence$1$1).map((Function1<Chunk, Option> & Serializable)out -> out.isEmpty() ? None$.MODULE$ : new Some<Chunk>((Chunk)out));
                }

                private F unwrapThenTakeUnwrapped(int maxBytes, Option<FiniteDuration> timeout) {
                    return IfMOps$.MODULE$.ifM$extension(package$all$.MODULE$.catsSyntaxIfM(package$all$.MODULE$.toFunctorOps(this.unwrapBuffer$1.inputRemains(), this.evidence$1$1).map(x$7 -> x$7 > 0), this.evidence$1$1), (Function0<Object> & Serializable)() -> this.unwrap(maxBytes, timeout), (Function0<Object> & Serializable)() -> this.takeUnwrapped(maxBytes), this.evidence$1$1);
                }

                private F stepHandshake(SSLEngineResult result2, boolean lastOperationWrap, Option<FiniteDuration> timeout) {
                    F f;
                    SSLEngineResult.HandshakeStatus handshakeStatus = result2.getHandshakeStatus();
                    if (((Object)((Object)SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING)).equals((Object)((Object)handshakeStatus))) {
                        f = Applicative$.MODULE$.apply(this.evidence$1$1).unit();
                    } else if (((Object)((Object)SSLEngineResult.HandshakeStatus.FINISHED)).equals((Object)((Object)handshakeStatus))) {
                        f = package$all$.MODULE$.toFlatMapOps(this.unwrapBuffer$1.inputRemains(), this.evidence$1$1).flatMap((Function1<Object, Object> & Serializable)remaining -> anon.1.$anonfun$stepHandshake$1(this, timeout, BoxesRunTime.unboxToInt(remaining)));
                    } else if (((Object)((Object)SSLEngineResult.HandshakeStatus.NEED_TASK)).equals((Object)((Object)handshakeStatus))) {
                        f = FlatMapOps$.MODULE$.$greater$greater$extension(package$all$.MODULE$.catsSyntaxFlatMapOps(this.sslEngineTaskRunner$1.runDelegatedTasks(), this.evidence$1$1), (Function0<Object> & Serializable)() -> lastOperationWrap ? this.wrapHandshake(timeout) : this.unwrapHandshake(timeout), this.evidence$1$1);
                    } else if (((Object)((Object)SSLEngineResult.HandshakeStatus.NEED_WRAP)).equals((Object)((Object)handshakeStatus))) {
                        f = this.wrapHandshake(timeout);
                    } else if (((Object)((Object)SSLEngineResult.HandshakeStatus.NEED_UNWRAP)).equals((Object)((Object)handshakeStatus))) {
                        f = package$all$.MODULE$.toFlatMapOps(this.unwrapBuffer$1.inputRemains(), this.evidence$1$1).flatMap((Function1<Object, Object> & Serializable)remaining -> anon.1.$anonfun$stepHandshake$3(this, result2, timeout, BoxesRunTime.unboxToInt(remaining)));
                    } else if (((Object)((Object)SSLEngineResult.HandshakeStatus.NEED_UNWRAP_AGAIN)).equals((Object)((Object)handshakeStatus))) {
                        f = this.unwrapHandshake(timeout);
                    } else {
                        throw new MatchError((Object)((Object)handshakeStatus));
                    }
                    return f;
                }

                private F wrapHandshake(Option<FiniteDuration> timeout) {
                    return package$all$.MODULE$.toFlatMapOps(package$all$.MODULE$.toFlatMapOps(this.wrapBuffer$1.perform((Function2<ByteBuffer, ByteBuffer, SSLEngineResult> & Serializable)(x$8, x$9) -> $this.engine$1.wrap((ByteBuffer)x$8, (ByteBuffer)x$9)), this.evidence$1$1).flatTap((Function1<SSLEngineResult, Object> & Serializable)result2 -> this.log(new StringBuilder(22).append("wrapHandshake result: ").append(result2).toString())), this.evidence$1$1).flatMap((Function1<SSLEngineResult, Object> & Serializable)result2 -> {
                        F f;
                        SSLEngineResult.Status status = result2.getStatus();
                        boolean bl = ((Object)((Object)((Object)SSLEngineResult.Status.OK))).equals((Object)((Object)status)) ? true : ((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_UNDERFLOW))).equals((Object)((Object)status));
                        if (bl) {
                            f = FlatMapOps$.MODULE$.$greater$greater$extension(package$all$.MODULE$.catsSyntaxFlatMapOps(this.doWrite(timeout), $this.evidence$1$1), (Function0<Object> & Serializable)() -> this.stepHandshake((SSLEngineResult)result2, true, timeout), $this.evidence$1$1);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_OVERFLOW))).equals((Object)((Object)status))) {
                            f = FlatMapOps$.MODULE$.$greater$greater$extension(package$all$.MODULE$.catsSyntaxFlatMapOps($this.wrapBuffer$1.expandOutput(), $this.evidence$1$1), (Function0<Object> & Serializable)() -> this.wrapHandshake(timeout), $this.evidence$1$1);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.CLOSED))).equals((Object)((Object)status))) {
                            f = FlatMapOps$.MODULE$.$greater$greater$extension(package$all$.MODULE$.catsSyntaxFlatMapOps(this.stopWrap(), $this.evidence$1$1), (Function0<Object> & Serializable)() -> this.stopUnwrap(), $this.evidence$1$1);
                        } else {
                            throw new MatchError((Object)((Object)status));
                        }
                        return f;
                    });
                }

                private F unwrapHandshake(Option<FiniteDuration> timeout) {
                    return package$all$.MODULE$.toFlatMapOps(package$all$.MODULE$.toFlatMapOps(this.unwrapBuffer$1.perform((Function2<ByteBuffer, ByteBuffer, SSLEngineResult> & Serializable)(x$10, x$11) -> $this.engine$1.unwrap((ByteBuffer)x$10, (ByteBuffer)x$11)), this.evidence$1$1).flatTap((Function1<SSLEngineResult, Object> & Serializable)result2 -> this.log(new StringBuilder(24).append("unwrapHandshake result: ").append(result2).toString())), this.evidence$1$1).flatMap((Function1<SSLEngineResult, Object> & Serializable)result2 -> {
                        F f;
                        SSLEngineResult.Status status = result2.getStatus();
                        if (((Object)((Object)((Object)SSLEngineResult.Status.OK))).equals((Object)((Object)status))) {
                            f = this.stepHandshake((SSLEngineResult)result2, false, timeout);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_UNDERFLOW))).equals((Object)((Object)status))) {
                            f = this.stepHandshake((SSLEngineResult)result2, false, timeout);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_OVERFLOW))).equals((Object)((Object)status))) {
                            f = FlatMapOps$.MODULE$.$greater$greater$extension(package$all$.MODULE$.catsSyntaxFlatMapOps($this.unwrapBuffer$1.expandOutput(), $this.evidence$1$1), (Function0<Object> & Serializable)() -> this.unwrapHandshake(timeout), $this.evidence$1$1);
                        } else if (((Object)((Object)((Object)SSLEngineResult.Status.CLOSED))).equals((Object)((Object)status))) {
                            f = FlatMapOps$.MODULE$.$greater$greater$extension(package$all$.MODULE$.catsSyntaxFlatMapOps(this.stopWrap(), $this.evidence$1$1), (Function0<Object> & Serializable)() -> this.stopUnwrap(), $this.evidence$1$1);
                        } else {
                            throw new MatchError((Object)((Object)status));
                        }
                        return f;
                    });
                }

                public static final /* synthetic */ Object $anonfun$wrap$5(anon.1 $this, Option timeout$2, SSLEngineResult result$1, int x2) {
                    return ApplicativeOps$.MODULE$.whenA$extension(package$all$.MODULE$.catsSyntaxApplicative($this.wrap(timeout$2)), x2 > 0 && result$1.bytesConsumed() > 0, $this.evidence$1$1);
                }

                public static final /* synthetic */ Object $anonfun$stepHandshake$1(anon.1 $this, Option timeout$8, int remaining) {
                    return remaining > 0 ? $this.unwrapHandshake(timeout$8) : Applicative$.MODULE$.apply($this.evidence$1$1).unit();
                }

                public static final /* synthetic */ Object $anonfun$stepHandshake$6(anon.1 $this, int x2) {
                    return x2 > 0 ? Applicative$.MODULE$.apply($this.evidence$1$1).unit() : $this.stopUnwrap();
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public static final /* synthetic */ Object $anonfun$stepHandshake$3(anon.1 $this, SSLEngineResult result$3, Option timeout$8, int remaining) {
                    F f;
                    if (remaining > 0) {
                        SSLEngineResult.Status status = result$3.getStatus();
                        SSLEngineResult.Status status2 = SSLEngineResult.Status.BUFFER_UNDERFLOW;
                        if (status == null ? status2 != null : !((Object)((Object)status)).equals((Object)((Object)status2))) {
                            f = $this.unwrapHandshake(timeout$8);
                            return f;
                        }
                    }
                    f = package$all$.MODULE$.toFlatMapOps($this.binding$1.read($this.engine$1.getSession().getPacketBufferSize(), timeout$8), $this.evidence$1$1).flatMap((Function1<Option, Object> & Serializable)x0$1 -> {
                        F f;
                        Option option = x0$1;
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            Chunk c = (Chunk)some.value();
                            f = FlatMapOps$.MODULE$.$greater$greater$extension(package$all$.MODULE$.catsSyntaxFlatMapOps($this.unwrapBuffer$1.input(c), $this.evidence$1$1), (Function0<Object> & Serializable)() -> $this.unwrapHandshake(timeout$8), $this.evidence$1$1);
                        } else if (None$.MODULE$.equals(option)) {
                            f = package$all$.MODULE$.toFlatMapOps($this.unwrapBuffer$1.inputRemains(), $this.evidence$1$1).flatMap((Function1<Object, Object> & Serializable)x2 -> anon.1.$anonfun$stepHandshake$6($this, BoxesRunTime.unboxToInt(x2)));
                        } else {
                            throw new MatchError(option);
                        }
                        return f;
                    });
                    return f;
                }
                {
                    this.logger$1 = logger$1;
                    this.evidence$1$1 = evidence$1$1;
                    this.engine$1 = engine$1;
                    this.writeSemaphore$1 = writeSemaphore$1;
                    this.wrapBuffer$1 = wrapBuffer$1;
                    this.handshakeSemaphore$1 = handshakeSemaphore$1;
                    this.binding$1 = binding$1;
                    this.readSemaphore$1 = readSemaphore$1;
                    this.unwrapBuffer$1 = unwrapBuffer$1;
                    this.sslEngineTaskRunner$1 = sslEngineTaskRunner$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applicationProtocol$1(fs2.io.tls.TLSEngine$$anon$1 ), $anonfun$beginHandshake$1(fs2.io.tls.TLSEngine$$anon$1 ), $anonfun$doWrite$1(fs2.io.tls.TLSEngine$$anon$1 scala.Option fs2.Chunk ), $anonfun$initialHandshakeDone$1(fs2.io.tls.TLSEngine$$anon$1 ), $anonfun$log$1(java.lang.String scala.Function1 ), $anonfun$log$2(fs2.io.tls.TLSEngine$$anon$1 ), $anonfun$read0$1(fs2.io.tls.TLSEngine$$anon$1 int scala.Option scala.Option ), $anonfun$read0$2(fs2.io.tls.TLSEngine$$anon$1 int scala.Option ), $anonfun$read0$3(fs2.io.tls.TLSEngine$$anon$1 int scala.Option ), $anonfun$read0$4(fs2.io.tls.TLSEngine$$anon$1 int scala.Option ), $anonfun$read0$5(fs2.io.tls.TLSEngine$$anon$1 int scala.Option scala.Option ), $anonfun$read1$1(fs2.io.tls.TLSEngine$$anon$1 int scala.Option scala.Option ), $anonfun$read1$2(fs2.io.tls.TLSEngine$$anon$1 int scala.Option ), $anonfun$read1$3(fs2.io.tls.TLSEngine$$anon$1 int scala.Option scala.Option ), $anonfun$session$1(fs2.io.tls.TLSEngine$$anon$1 ), $anonfun$stepHandshake$1$adapted(fs2.io.tls.TLSEngine$$anon$1 scala.Option java.lang.Object ), $anonfun$stepHandshake$2(fs2.io.tls.TLSEngine$$anon$1 boolean scala.Option ), $anonfun$stepHandshake$3$adapted(fs2.io.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult scala.Option java.lang.Object ), $anonfun$stepHandshake$4(fs2.io.tls.TLSEngine$$anon$1 scala.Option scala.Option ), $anonfun$stepHandshake$5(fs2.io.tls.TLSEngine$$anon$1 scala.Option ), $anonfun$stepHandshake$6$adapted(fs2.io.tls.TLSEngine$$anon$1 java.lang.Object ), $anonfun$stopUnwrap$1(fs2.io.tls.TLSEngine$$anon$1 ), $anonfun$stopWrap$1(fs2.io.tls.TLSEngine$$anon$1 ), $anonfun$takeUnwrapped$1(fs2.Chunk ), $anonfun$unwrap$1(fs2.io.tls.TLSEngine$$anon$1 java.nio.ByteBuffer java.nio.ByteBuffer ), $anonfun$unwrap$10(fs2.io.tls.TLSEngine$$anon$1 int ), $anonfun$unwrap$2(fs2.io.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult ), $anonfun$unwrap$3(fs2.io.tls.TLSEngine$$anon$1 int scala.Option javax.net.ssl.SSLEngineResult ), $anonfun$unwrap$4(javax.net.ssl.SSLEngineResult int ), $anonfun$unwrap$5(fs2.io.tls.TLSEngine$$anon$1 int scala.Option ), $anonfun$unwrap$6(fs2.io.tls.TLSEngine$$anon$1 int ), $anonfun$unwrap$7(fs2.io.tls.TLSEngine$$anon$1 int scala.Option ), $anonfun$unwrap$8(fs2.io.tls.TLSEngine$$anon$1 int scala.Option ), $anonfun$unwrap$9(fs2.io.tls.TLSEngine$$anon$1 ), $anonfun$unwrapHandshake$1(fs2.io.tls.TLSEngine$$anon$1 java.nio.ByteBuffer java.nio.ByteBuffer ), $anonfun$unwrapHandshake$2(fs2.io.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult ), $anonfun$unwrapHandshake$3(fs2.io.tls.TLSEngine$$anon$1 scala.Option javax.net.ssl.SSLEngineResult ), $anonfun$unwrapHandshake$4(fs2.io.tls.TLSEngine$$anon$1 scala.Option ), $anonfun$unwrapHandshake$5(fs2.io.tls.TLSEngine$$anon$1 ), $anonfun$unwrapThenTakeUnwrapped$1(int ), $anonfun$unwrapThenTakeUnwrapped$2(fs2.io.tls.TLSEngine$$anon$1 int scala.Option ), $anonfun$unwrapThenTakeUnwrapped$3(fs2.io.tls.TLSEngine$$anon$1 int ), $anonfun$wrap$1(fs2.io.tls.TLSEngine$$anon$1 java.nio.ByteBuffer java.nio.ByteBuffer ), $anonfun$wrap$2(fs2.io.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult ), $anonfun$wrap$3(fs2.io.tls.TLSEngine$$anon$1 scala.Option javax.net.ssl.SSLEngineResult ), $anonfun$wrap$4(fs2.io.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult scala.Option ), $anonfun$wrap$5$adapted(fs2.io.tls.TLSEngine$$anon$1 scala.Option javax.net.ssl.SSLEngineResult java.lang.Object ), $anonfun$wrap$6(fs2.io.tls.TLSEngine$$anon$1 scala.Option ), $anonfun$wrap$7(fs2.io.tls.TLSEngine$$anon$1 scala.Option ), $anonfun$wrapHandshake$1(fs2.io.tls.TLSEngine$$anon$1 java.nio.ByteBuffer java.nio.ByteBuffer ), $anonfun$wrapHandshake$2(fs2.io.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult ), $anonfun$wrapHandshake$3(fs2.io.tls.TLSEngine$$anon$1 scala.Option javax.net.ssl.SSLEngineResult ), $anonfun$wrapHandshake$4(fs2.io.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult scala.Option ), $anonfun$wrapHandshake$5(fs2.io.tls.TLSEngine$$anon$1 scala.Option ), $anonfun$wrapHandshake$6(fs2.io.tls.TLSEngine$$anon$1 ), $anonfun$write0$1(fs2.io.tls.TLSEngine$$anon$1 scala.Option )}, serializedLambda);
                }
            };
        })))));
    }

    public <F> None$ apply$default$4() {
        return None$.MODULE$;
    }

    private TLSEngine$() {
    }
}

