/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.Arrays;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.document.ShapeQuery;
import org.apache.lucene.geo.Line2D;
import org.apache.lucene.geo.XYEncodingUtils;
import org.apache.lucene.geo.XYLine;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.util.NumericUtils;

final class XYShapeLineQuery
extends ShapeQuery {
    final XYLine[] lines;
    private final Line2D line2D;

    public XYShapeLineQuery(String field2, ShapeField.QueryRelation queryRelation, XYLine ... lines) {
        super(field2, queryRelation);
        if (queryRelation == ShapeField.QueryRelation.WITHIN) {
            throw new IllegalArgumentException("XYShapeLineQuery does not support " + (Object)((Object)ShapeField.QueryRelation.WITHIN) + " queries");
        }
        if (lines == null) {
            throw new IllegalArgumentException("lines must not be null");
        }
        if (lines.length == 0) {
            throw new IllegalArgumentException("lines must not be empty");
        }
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i] == null) {
                throw new IllegalArgumentException("line[" + i + "] must not be null");
            }
            if (lines[i].minX > lines[i].maxX) {
                throw new IllegalArgumentException("XYShapeLineQuery: minX cannot be greater than maxX.");
            }
            if (!(lines[i].minY > lines[i].maxY)) continue;
            throw new IllegalArgumentException("XYShapeLineQuery: minY cannot be greater than maxY.");
        }
        this.lines = (XYLine[])lines.clone();
        this.line2D = Line2D.create(lines);
    }

    @Override
    protected PointValues.Relation relateRangeBBoxToQuery(int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
        double minLat = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt(minTriangle, minYOffset));
        double minLon = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt(minTriangle, minXOffset));
        double maxLat = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt(maxTriangle, maxYOffset));
        double maxLon = XYEncodingUtils.decode(NumericUtils.sortableBytesToInt(maxTriangle, maxXOffset));
        return this.line2D.relate(minLat, maxLat, minLon, maxLon);
    }

    @Override
    protected boolean queryMatches(byte[] t, int[] scratchTriangle, ShapeField.QueryRelation queryRelation) {
        ShapeField.decodeTriangle(t, scratchTriangle);
        double alat = XYEncodingUtils.decode(scratchTriangle[0]);
        double alon = XYEncodingUtils.decode(scratchTriangle[1]);
        double blat = XYEncodingUtils.decode(scratchTriangle[2]);
        double blon = XYEncodingUtils.decode(scratchTriangle[3]);
        double clat = XYEncodingUtils.decode(scratchTriangle[4]);
        double clon = XYEncodingUtils.decode(scratchTriangle[5]);
        if (queryRelation == ShapeField.QueryRelation.WITHIN) {
            return this.line2D.relateTriangle(alon, alat, blon, blat, clon, clat) == PointValues.Relation.CELL_INSIDE_QUERY;
        }
        return this.line2D.relateTriangle(alon, alat, blon, blat, clon, clat) != PointValues.Relation.CELL_OUTSIDE_QUERY;
    }

    @Override
    public String toString(String field2) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field2)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        sb.append("XYLine(").append(this.lines[0].toGeoJSON()).append(")");
        return sb.toString();
    }

    @Override
    protected boolean equalsTo(Object o) {
        return super.equalsTo(o) && Arrays.equals(this.lines, ((XYShapeLineQuery)o).lines);
    }

    @Override
    public int hashCode() {
        int hash2 = super.hashCode();
        hash2 = 31 * hash2 + Arrays.hashCode(this.lines);
        return hash2;
    }
}

