/*
 * Decompiled with CFR 0.152.
 */
package fs2.io.net.tls;

import cats.Applicative$;
import cats.effect.kernel.Async;
import cats.effect.kernel.Sync$;
import cats.effect.std.Mutex;
import cats.effect.std.Mutex$;
import cats.syntax.ApplicativeByNameOps$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.IfMOps$;
import cats.syntax.package$all$;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.io.net.tls.InputOutputBuffer;
import fs2.io.net.tls.InputOutputBuffer$;
import fs2.io.net.tls.SSLEngineTaskRunner;
import fs2.io.net.tls.SSLEngineTaskRunner$;
import fs2.io.net.tls.TLSEngine;
import fs2.io.net.tls.TLSEngine$;
import fs2.io.net.tls.TLSLogger;
import fs2.io.net.tls.TLSLogger$Disabled$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;

public final class TLSEngine$ {
    public static final TLSEngine$ MODULE$ = new TLSEngine$();

    public <F> F apply(SSLEngine engine, TLSEngine.Binding<F> binding, TLSLogger<F> logger, Async<F> evidence$1) {
        return package$all$.MODULE$.toFlatMapOps(InputOutputBuffer$.MODULE$.apply(engine.getSession().getApplicationBufferSize(), engine.getSession().getPacketBufferSize(), evidence$1), evidence$1).flatMap((Function1<InputOutputBuffer, Object> & Serializable)wrapBuffer -> package$all$.MODULE$.toFlatMapOps(InputOutputBuffer$.MODULE$.apply(engine.getSession().getPacketBufferSize(), engine.getSession().getApplicationBufferSize(), evidence$1), evidence$1).flatMap((Function1<InputOutputBuffer, Object> & Serializable)unwrapBuffer -> package$all$.MODULE$.toFlatMapOps(Mutex$.MODULE$.apply(evidence$1), evidence$1).flatMap((Function1<Mutex, Object> & Serializable)readMutex -> package$all$.MODULE$.toFlatMapOps(Mutex$.MODULE$.apply(evidence$1), evidence$1).flatMap((Function1<Mutex, Object> & Serializable)writeMutex -> package$all$.MODULE$.toFunctorOps(Mutex$.MODULE$.apply(evidence$1), evidence$1).map((Function1<Mutex, TLSEngine> & Serializable)handshakeMutex -> {
            SSLEngineTaskRunner sslEngineTaskRunner = SSLEngineTaskRunner$.MODULE$.apply(engine, evidence$1);
            return new TLSEngine<F>(logger, evidence$1, engine, (Mutex)writeMutex, (InputOutputBuffer)wrapBuffer, (Mutex)handshakeMutex, binding, (Mutex)readMutex, (InputOutputBuffer)unwrapBuffer, sslEngineTaskRunner){
                private final Function1<Function0<String>, F> doLog;
                private final Async evidence$1$1;
                private final SSLEngine engine$1;
                private final Mutex writeMutex$1;
                private final InputOutputBuffer wrapBuffer$1;
                private final Mutex handshakeMutex$1;
                private final TLSEngine.Binding binding$1;
                private final Mutex readMutex$1;
                private final InputOutputBuffer unwrapBuffer$1;
                private final SSLEngineTaskRunner sslEngineTaskRunner$1;

                private Function1<Function0<String>, F> doLog() {
                    return this.doLog;
                }

                private F log(Function0<String> msg) {
                    return this.doLog().apply(msg);
                }

                public F beginHandshake() {
                    return Sync$.MODULE$.apply(this.evidence$1$1).delay(() -> $this.engine$1.beginHandshake());
                }

                public F session() {
                    return Sync$.MODULE$.apply(this.evidence$1$1).delay((Function0<SSLSession> & Serializable)() -> $this.engine$1.getSession());
                }

                public F applicationProtocol() {
                    return Sync$.MODULE$.apply(this.evidence$1$1).delay((Function0<String> & Serializable)() -> Option$.MODULE$.apply($this.engine$1.getApplicationProtocol()).get());
                }

                public F stopWrap() {
                    return Sync$.MODULE$.apply(this.evidence$1$1).delay(() -> $this.engine$1.closeOutbound());
                }

                public F stopUnwrap() {
                    return package$all$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.attempt$extension(package$all$.MODULE$.catsSyntaxApplicativeError(Sync$.MODULE$.apply(this.evidence$1$1).delay(() -> $this.engine$1.closeInbound()), this.evidence$1$1), this.evidence$1$1), this.evidence$1$1).void();
                }

                public F write(Chunk<Object> data) {
                    return this.writeMutex$1.lock().surround(this.write0(data), this.evidence$1$1);
                }

                private F write0(Chunk<Object> data) {
                    return FlatMapOps$.MODULE$.$greater$greater$extension(package$all$.MODULE$.catsSyntaxFlatMapOps(this.wrapBuffer$1.input(data), this.evidence$1$1), (Function0<Object> & Serializable)() -> this.wrap(), this.evidence$1$1);
                }

                private F wrap() {
                    return package$all$.MODULE$.toFlatMapOps(package$all$.MODULE$.toFlatMapOps(this.wrapBuffer$1.perform((Function2<ByteBuffer, ByteBuffer, SSLEngineResult> & Serializable)(x$2, x$3) -> $this.engine$1.wrap((ByteBuffer)x$2, (ByteBuffer)x$3)), this.evidence$1$1).flatTap((Function1<SSLEngineResult, Object> & Serializable)result2 -> this.log((Function0<String> & Serializable)() -> new StringBuilder(13).append("wrap result: ").append(result2).toString())), this.evidence$1$1).flatMap((Function1<SSLEngineResult, Object> & Serializable)result2 -> {
                        SSLEngineResult.Status status = result2.getStatus();
                        if (((Object)((Object)((Object)SSLEngineResult.Status.OK))).equals((Object)((Object)status))) {
                            return FlatMapOps$.MODULE$.$greater$greater$extension(package$all$.MODULE$.catsSyntaxFlatMapOps(this.doWrite(), $this.evidence$1$1), (Function0<Object> & Serializable)() -> {
                                SSLEngineResult.HandshakeStatus handshakeStatus = result2.getHandshakeStatus();
                                if (((Object)((Object)((Object)SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING))).equals((Object)((Object)handshakeStatus))) {
                                    return package$all$.MODULE$.toFlatMapOps($this.wrapBuffer$1.inputRemains(), $this.evidence$1$1).flatMap((Function1<Object, Object> & Serializable)x2 -> anon.1.$anonfun$wrap$6(this, result2, BoxesRunTime.unboxToInt(x2)));
                                }
                                return FlatMapOps$.MODULE$.$greater$greater$extension(package$all$.MODULE$.catsSyntaxFlatMapOps($this.handshakeMutex$1.lock().surround(this.stepHandshake((SSLEngineResult)result2, true), $this.evidence$1$1), $this.evidence$1$1), (Function0<Object> & Serializable)() -> this.wrap(), $this.evidence$1$1);
                            }, $this.evidence$1$1);
                        }
                        if (((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_UNDERFLOW))).equals((Object)((Object)status))) {
                            return this.doWrite();
                        }
                        if (((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_OVERFLOW))).equals((Object)((Object)status))) {
                            return FlatMapOps$.MODULE$.$greater$greater$extension(package$all$.MODULE$.catsSyntaxFlatMapOps($this.wrapBuffer$1.expandOutput(), $this.evidence$1$1), (Function0<Object> & Serializable)() -> this.wrap(), $this.evidence$1$1);
                        }
                        if (((Object)((Object)((Object)SSLEngineResult.Status.CLOSED))).equals((Object)((Object)status))) {
                            return this.stopWrap();
                        }
                        throw new MatchError((Object)((Object)status));
                    });
                }

                private F doWrite() {
                    return package$all$.MODULE$.toFlatMapOps(this.wrapBuffer$1.output(Integer.MAX_VALUE), this.evidence$1$1).flatMap((Function1<Chunk, Object> & Serializable)out -> {
                        if (out.isEmpty()) {
                            return Applicative$.MODULE$.apply($this.evidence$1$1).unit();
                        }
                        return $this.binding$1.write((Chunk<Object>)out);
                    });
                }

                public F read(int maxBytes) {
                    return this.readMutex$1.lock().surround(this.read0(maxBytes), this.evidence$1$1);
                }

                private F initialHandshakeDone() {
                    return Sync$.MODULE$.apply(this.evidence$1$1).delay(() -> {
                        String string = $this.engine$1.getSession().getCipherSuite();
                        String string2 = "SSL_NULL_WITH_NULL_NULL";
                        return string == null ? string2 != null : !string.equals(string2);
                    });
                }

                private F read0(int maxBytes) {
                    return package$all$.MODULE$.toFlatMapOps(this.unwrapThenTakeUnwrapped(maxBytes), this.evidence$1$1).flatMap((Function1<Option, Object> & Serializable)out -> {
                        if (out.isEmpty()) {
                            return IfMOps$.MODULE$.ifM$extension(package$all$.MODULE$.catsSyntaxIfM(this.initialHandshakeDone(), $this.evidence$1$1), (Function0<Object> & Serializable)() -> this.read1(maxBytes), (Function0<Object> & Serializable)() -> FlatMapOps$.MODULE$.$greater$greater$extension(package$all$.MODULE$.catsSyntaxFlatMapOps(this.write(Chunk$.MODULE$.empty()), $this.evidence$1$1), (Function0<Object> & Serializable)() -> package$all$.MODULE$.toFlatMapOps(this.unwrapThenTakeUnwrapped(maxBytes), $this.evidence$1$1).flatMap((Function1<Option, Object> & Serializable)out -> {
                                if (out.isEmpty()) {
                                    return this.read1(maxBytes);
                                }
                                return Applicative$.MODULE$.apply($this.evidence$1$1).pure(out);
                            }), $this.evidence$1$1), $this.evidence$1$1);
                        }
                        return Applicative$.MODULE$.apply($this.evidence$1$1).pure(out);
                    });
                }

                private F read1(int maxBytes) {
                    return package$all$.MODULE$.toFlatMapOps(this.binding$1.read(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(maxBytes), this.engine$1.getSession().getPacketBufferSize())), this.evidence$1$1).flatMap((Function1<Option, Object> & Serializable)x0$1 -> {
                        Option option = x0$1;
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            Chunk c = (Chunk)some.value();
                            return FlatMapOps$.MODULE$.$greater$greater$extension(package$all$.MODULE$.catsSyntaxFlatMapOps($this.unwrapBuffer$1.input(c), $this.evidence$1$1), (Function0<Object> & Serializable)() -> package$all$.MODULE$.toFlatMapOps(this.unwrap(maxBytes), $this.evidence$1$1).flatMap((Function1<Option, Object> & Serializable)x0$2 -> {
                                Option option = x0$2;
                                if (option instanceof Some) {
                                    Some some = (Some)option;
                                    return Applicative$.MODULE$.apply($this.evidence$1$1).pure(some);
                                }
                                if (None$.MODULE$.equals(option)) {
                                    return this.read1(maxBytes);
                                }
                                throw new MatchError(option);
                            }), $this.evidence$1$1);
                        }
                        if (None$.MODULE$.equals(option)) {
                            return Applicative$.MODULE$.apply($this.evidence$1$1).pure(None$.MODULE$);
                        }
                        throw new MatchError(option);
                    });
                }

                private F unwrap(int maxBytes) {
                    return package$all$.MODULE$.toFlatMapOps(package$all$.MODULE$.toFlatMapOps(this.unwrapBuffer$1.perform((Function2<ByteBuffer, ByteBuffer, SSLEngineResult> & Serializable)(x$4, x$5) -> $this.engine$1.unwrap((ByteBuffer)x$4, (ByteBuffer)x$5)), this.evidence$1$1).flatTap((Function1<SSLEngineResult, Object> & Serializable)result2 -> this.log((Function0<String> & Serializable)() -> new StringBuilder(15).append("unwrap result: ").append(result2).toString())), this.evidence$1$1).flatMap((Function1<SSLEngineResult, Object> & Serializable)result2 -> {
                        SSLEngineResult.Status status = result2.getStatus();
                        if (((Object)((Object)((Object)SSLEngineResult.Status.OK))).equals((Object)((Object)status))) {
                            SSLEngineResult.HandshakeStatus handshakeStatus = result2.getHandshakeStatus();
                            if (((Object)((Object)((Object)SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING))).equals((Object)((Object)handshakeStatus))) {
                                return IfMOps$.MODULE$.ifM$extension(package$all$.MODULE$.catsSyntaxIfM(package$all$.MODULE$.toFunctorOps($this.unwrapBuffer$1.inputRemains(), $this.evidence$1$1).map(x$6 -> x$6 > 0 && result2.bytesConsumed() > 0), $this.evidence$1$1), (Function0<Object> & Serializable)() -> this.unwrap(maxBytes), (Function0<Object> & Serializable)() -> this.takeUnwrapped(maxBytes), $this.evidence$1$1);
                            }
                            if (((Object)((Object)((Object)SSLEngineResult.HandshakeStatus.FINISHED))).equals((Object)((Object)handshakeStatus))) {
                                return this.unwrap(maxBytes);
                            }
                            return FlatMapOps$.MODULE$.$greater$greater$extension(package$all$.MODULE$.catsSyntaxFlatMapOps($this.handshakeMutex$1.lock().surround(this.stepHandshake((SSLEngineResult)result2, false), $this.evidence$1$1), $this.evidence$1$1), (Function0<Object> & Serializable)() -> this.unwrap(maxBytes), $this.evidence$1$1);
                        }
                        if (((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_UNDERFLOW))).equals((Object)((Object)status))) {
                            return this.takeUnwrapped(maxBytes);
                        }
                        if (((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_OVERFLOW))).equals((Object)((Object)status))) {
                            return FlatMapOps$.MODULE$.$greater$greater$extension(package$all$.MODULE$.catsSyntaxFlatMapOps($this.unwrapBuffer$1.expandOutput(), $this.evidence$1$1), (Function0<Object> & Serializable)() -> this.unwrap(maxBytes), $this.evidence$1$1);
                        }
                        if (((Object)((Object)((Object)SSLEngineResult.Status.CLOSED))).equals((Object)((Object)status))) {
                            return FlatMapOps$.MODULE$.$greater$greater$extension(package$all$.MODULE$.catsSyntaxFlatMapOps(FlatMapOps$.MODULE$.$greater$greater$extension(package$all$.MODULE$.catsSyntaxFlatMapOps(this.stopWrap(), $this.evidence$1$1), (Function0<Object> & Serializable)() -> this.stopUnwrap(), $this.evidence$1$1), $this.evidence$1$1), (Function0<Object> & Serializable)() -> this.takeUnwrapped(maxBytes), $this.evidence$1$1);
                        }
                        throw new MatchError((Object)((Object)status));
                    });
                }

                private F takeUnwrapped(int maxBytes) {
                    return package$all$.MODULE$.toFunctorOps(this.unwrapBuffer$1.output(maxBytes), this.evidence$1$1).map((Function1<Chunk, Option> & Serializable)out -> {
                        if (out.isEmpty()) {
                            return None$.MODULE$;
                        }
                        return new Some<Chunk>((Chunk)out);
                    });
                }

                private F unwrapThenTakeUnwrapped(int maxBytes) {
                    return IfMOps$.MODULE$.ifM$extension(package$all$.MODULE$.catsSyntaxIfM(package$all$.MODULE$.toFunctorOps(this.unwrapBuffer$1.inputRemains(), this.evidence$1$1).map(x$7 -> x$7 > 0), this.evidence$1$1), (Function0<Object> & Serializable)() -> this.unwrap(maxBytes), (Function0<Object> & Serializable)() -> this.takeUnwrapped(maxBytes), this.evidence$1$1);
                }

                private F stepHandshake(SSLEngineResult result2, boolean lastOperationWrap) {
                    SSLEngineResult.HandshakeStatus handshakeStatus = result2.getHandshakeStatus();
                    if (((Object)((Object)SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING)).equals((Object)((Object)handshakeStatus))) {
                        return Applicative$.MODULE$.apply(this.evidence$1$1).unit();
                    }
                    if (((Object)((Object)SSLEngineResult.HandshakeStatus.FINISHED)).equals((Object)((Object)handshakeStatus))) {
                        return package$all$.MODULE$.toFlatMapOps(this.unwrapBuffer$1.inputRemains(), this.evidence$1$1).flatMap((Function1<Object, Object> & Serializable)remaining -> anon.1.$anonfun$stepHandshake$1(this, BoxesRunTime.unboxToInt(remaining)));
                    }
                    if (((Object)((Object)SSLEngineResult.HandshakeStatus.NEED_TASK)).equals((Object)((Object)handshakeStatus))) {
                        return FlatMapOps$.MODULE$.$greater$greater$extension(package$all$.MODULE$.catsSyntaxFlatMapOps(this.sslEngineTaskRunner$1.runDelegatedTasks(), this.evidence$1$1), (Function0<Object> & Serializable)() -> {
                            if (lastOperationWrap) {
                                return this.wrapHandshake();
                            }
                            return this.unwrapHandshake();
                        }, this.evidence$1$1);
                    }
                    if (((Object)((Object)SSLEngineResult.HandshakeStatus.NEED_WRAP)).equals((Object)((Object)handshakeStatus))) {
                        return this.wrapHandshake();
                    }
                    if (((Object)((Object)SSLEngineResult.HandshakeStatus.NEED_UNWRAP)).equals((Object)((Object)handshakeStatus))) {
                        return package$all$.MODULE$.toFlatMapOps(this.unwrapBuffer$1.inputRemains(), this.evidence$1$1).flatMap((Function1<Object, Object> & Serializable)remaining -> anon.1.$anonfun$stepHandshake$3(this, result2, BoxesRunTime.unboxToInt(remaining)));
                    }
                    if (((Object)((Object)SSLEngineResult.HandshakeStatus.NEED_UNWRAP_AGAIN)).equals((Object)((Object)handshakeStatus))) {
                        return this.unwrapHandshake();
                    }
                    throw new MatchError((Object)((Object)handshakeStatus));
                }

                private F wrapHandshake() {
                    return package$all$.MODULE$.toFlatMapOps(package$all$.MODULE$.toFlatMapOps(this.wrapBuffer$1.perform((Function2<ByteBuffer, ByteBuffer, SSLEngineResult> & Serializable)(x$8, x$9) -> $this.engine$1.wrap((ByteBuffer)x$8, (ByteBuffer)x$9)), this.evidence$1$1).flatTap((Function1<SSLEngineResult, Object> & Serializable)result2 -> this.log((Function0<String> & Serializable)() -> new StringBuilder(22).append("wrapHandshake result: ").append(result2).toString())), this.evidence$1$1).flatMap((Function1<SSLEngineResult, Object> & Serializable)result2 -> {
                        SSLEngineResult.Status status = result2.getStatus();
                        if (((Object)((Object)((Object)SSLEngineResult.Status.OK))).equals((Object)((Object)status)) ? true : ((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_UNDERFLOW))).equals((Object)((Object)status))) {
                            return FlatMapOps$.MODULE$.$greater$greater$extension(package$all$.MODULE$.catsSyntaxFlatMapOps(this.doWrite(), $this.evidence$1$1), (Function0<Object> & Serializable)() -> this.stepHandshake((SSLEngineResult)result2, true), $this.evidence$1$1);
                        }
                        if (((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_OVERFLOW))).equals((Object)((Object)status))) {
                            return FlatMapOps$.MODULE$.$greater$greater$extension(package$all$.MODULE$.catsSyntaxFlatMapOps($this.wrapBuffer$1.expandOutput(), $this.evidence$1$1), (Function0<Object> & Serializable)() -> this.wrapHandshake(), $this.evidence$1$1);
                        }
                        if (((Object)((Object)((Object)SSLEngineResult.Status.CLOSED))).equals((Object)((Object)status))) {
                            return FlatMapOps$.MODULE$.$greater$greater$extension(package$all$.MODULE$.catsSyntaxFlatMapOps(this.stopWrap(), $this.evidence$1$1), (Function0<Object> & Serializable)() -> this.stopUnwrap(), $this.evidence$1$1);
                        }
                        throw new MatchError((Object)((Object)status));
                    });
                }

                private F unwrapHandshake() {
                    return package$all$.MODULE$.toFlatMapOps(package$all$.MODULE$.toFlatMapOps(this.unwrapBuffer$1.perform((Function2<ByteBuffer, ByteBuffer, SSLEngineResult> & Serializable)(x$10, x$11) -> $this.engine$1.unwrap((ByteBuffer)x$10, (ByteBuffer)x$11)), this.evidence$1$1).flatTap((Function1<SSLEngineResult, Object> & Serializable)result2 -> this.log((Function0<String> & Serializable)() -> new StringBuilder(24).append("unwrapHandshake result: ").append(result2).toString())), this.evidence$1$1).flatMap((Function1<SSLEngineResult, Object> & Serializable)result2 -> {
                        SSLEngineResult.Status status = result2.getStatus();
                        if (((Object)((Object)((Object)SSLEngineResult.Status.OK))).equals((Object)((Object)status))) {
                            return this.stepHandshake((SSLEngineResult)result2, false);
                        }
                        if (((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_UNDERFLOW))).equals((Object)((Object)status))) {
                            return this.stepHandshake((SSLEngineResult)result2, false);
                        }
                        if (((Object)((Object)((Object)SSLEngineResult.Status.BUFFER_OVERFLOW))).equals((Object)((Object)status))) {
                            return FlatMapOps$.MODULE$.$greater$greater$extension(package$all$.MODULE$.catsSyntaxFlatMapOps($this.unwrapBuffer$1.expandOutput(), $this.evidence$1$1), (Function0<Object> & Serializable)() -> this.unwrapHandshake(), $this.evidence$1$1);
                        }
                        if (((Object)((Object)((Object)SSLEngineResult.Status.CLOSED))).equals((Object)((Object)status))) {
                            return FlatMapOps$.MODULE$.$greater$greater$extension(package$all$.MODULE$.catsSyntaxFlatMapOps(this.stopWrap(), $this.evidence$1$1), (Function0<Object> & Serializable)() -> this.stopUnwrap(), $this.evidence$1$1);
                        }
                        throw new MatchError((Object)((Object)status));
                    });
                }

                public static final /* synthetic */ Object $anonfun$wrap$6(anon.1 $this, SSLEngineResult result$2, int x2) {
                    return ApplicativeByNameOps$.MODULE$.whenA$extension(package$all$.MODULE$.catsSyntaxApplicativeByName((Function0<Object> & Serializable)() -> $this.wrap()), x2 > 0 && result$2.bytesConsumed() > 0, $this.evidence$1$1);
                }

                public static final /* synthetic */ Object $anonfun$stepHandshake$1(anon.1 $this, int remaining) {
                    if (remaining > 0) {
                        return $this.unwrapHandshake();
                    }
                    return Applicative$.MODULE$.apply($this.evidence$1$1).unit();
                }

                public static final /* synthetic */ Object $anonfun$stepHandshake$6(anon.1 $this, int x2) {
                    if (x2 > 0) {
                        return Applicative$.MODULE$.apply($this.evidence$1$1).unit();
                    }
                    return $this.stopUnwrap();
                }

                public static final /* synthetic */ Object $anonfun$stepHandshake$3(anon.1 $this, SSLEngineResult result$5, int remaining) {
                    if (remaining > 0) {
                        SSLEngineResult.Status status = result$5.getStatus();
                        SSLEngineResult.Status status2 = SSLEngineResult.Status.BUFFER_UNDERFLOW;
                        if (status == null ? status2 != null : !((Object)((Object)status)).equals((Object)((Object)status2))) {
                            return $this.unwrapHandshake();
                        }
                    }
                    return package$all$.MODULE$.toFlatMapOps($this.binding$1.read($this.engine$1.getSession().getPacketBufferSize()), $this.evidence$1$1).flatMap((Function1<Option, Object> & Serializable)x0$1 -> {
                        Option option = x0$1;
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            Chunk c = (Chunk)some.value();
                            return FlatMapOps$.MODULE$.$greater$greater$extension(package$all$.MODULE$.catsSyntaxFlatMapOps($this.unwrapBuffer$1.input(c), $this.evidence$1$1), (Function0<Object> & Serializable)() -> $this.unwrapHandshake(), $this.evidence$1$1);
                        }
                        if (None$.MODULE$.equals(option)) {
                            return package$all$.MODULE$.toFlatMapOps($this.unwrapBuffer$1.inputRemains(), $this.evidence$1$1).flatMap((Function1<Object, Object> & Serializable)x2 -> anon.1.$anonfun$stepHandshake$6($this, BoxesRunTime.unboxToInt(x2)));
                        }
                        throw new MatchError(option);
                    });
                }
                {
                    Function1<Function0, Object> & Serializable intersect;
                    this.evidence$1$1 = evidence$1$1;
                    this.engine$1 = engine$1;
                    this.writeMutex$1 = writeMutex$1;
                    this.wrapBuffer$1 = wrapBuffer$1;
                    this.handshakeMutex$1 = handshakeMutex$1;
                    this.binding$1 = binding$1;
                    this.readMutex$1 = readMutex$1;
                    this.unwrapBuffer$1 = unwrapBuffer$1;
                    this.sslEngineTaskRunner$1 = sslEngineTaskRunner$1;
                    TLSLogger tLSLogger = logger$1;
                    if (tLSLogger instanceof TLSLogger.Enabled) {
                        TLSLogger.Enabled enabled = (TLSLogger.Enabled)tLSLogger;
                        intersect = (Function1<Function0, Object> & Serializable)msg -> enabled.log().apply((Function0<String>)msg);
                    } else if (TLSLogger$Disabled$.MODULE$.equals(tLSLogger)) {
                        intersect = (Function1<Function0, Object> & Serializable)x$1 -> Applicative$.MODULE$.apply($this.evidence$1$1).unit();
                    } else {
                        throw new MatchError(tLSLogger);
                    }
                    this.doLog = intersect;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applicationProtocol$1(fs2.io.net.tls.TLSEngine$$anon$1 ), $anonfun$beginHandshake$1(fs2.io.net.tls.TLSEngine$$anon$1 ), $anonfun$doLog$1(fs2.io.net.tls.TLSLogger$Enabled scala.Function0 ), $anonfun$doLog$2(fs2.io.net.tls.TLSEngine$$anon$1 scala.Function0 ), $anonfun$doWrite$1(fs2.io.net.tls.TLSEngine$$anon$1 fs2.Chunk ), $anonfun$initialHandshakeDone$1(fs2.io.net.tls.TLSEngine$$anon$1 ), $anonfun$read0$1(fs2.io.net.tls.TLSEngine$$anon$1 int scala.Option ), $anonfun$read0$2(fs2.io.net.tls.TLSEngine$$anon$1 int ), $anonfun$read0$3(fs2.io.net.tls.TLSEngine$$anon$1 int ), $anonfun$read0$4(fs2.io.net.tls.TLSEngine$$anon$1 int ), $anonfun$read0$5(fs2.io.net.tls.TLSEngine$$anon$1 int scala.Option ), $anonfun$read1$1(fs2.io.net.tls.TLSEngine$$anon$1 int scala.Option ), $anonfun$read1$2(fs2.io.net.tls.TLSEngine$$anon$1 int ), $anonfun$read1$3(fs2.io.net.tls.TLSEngine$$anon$1 int scala.Option ), $anonfun$session$1(fs2.io.net.tls.TLSEngine$$anon$1 ), $anonfun$stepHandshake$1$adapted(fs2.io.net.tls.TLSEngine$$anon$1 java.lang.Object ), $anonfun$stepHandshake$2(fs2.io.net.tls.TLSEngine$$anon$1 boolean ), $anonfun$stepHandshake$3$adapted(fs2.io.net.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult java.lang.Object ), $anonfun$stepHandshake$4(fs2.io.net.tls.TLSEngine$$anon$1 scala.Option ), $anonfun$stepHandshake$5(fs2.io.net.tls.TLSEngine$$anon$1 ), $anonfun$stepHandshake$6$adapted(fs2.io.net.tls.TLSEngine$$anon$1 java.lang.Object ), $anonfun$stopUnwrap$1(fs2.io.net.tls.TLSEngine$$anon$1 ), $anonfun$stopWrap$1(fs2.io.net.tls.TLSEngine$$anon$1 ), $anonfun$takeUnwrapped$1(fs2.Chunk ), $anonfun$unwrap$1(fs2.io.net.tls.TLSEngine$$anon$1 java.nio.ByteBuffer java.nio.ByteBuffer ), $anonfun$unwrap$10(fs2.io.net.tls.TLSEngine$$anon$1 ), $anonfun$unwrap$11(fs2.io.net.tls.TLSEngine$$anon$1 int ), $anonfun$unwrap$2(fs2.io.net.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult ), $anonfun$unwrap$3(javax.net.ssl.SSLEngineResult ), $anonfun$unwrap$4(fs2.io.net.tls.TLSEngine$$anon$1 int javax.net.ssl.SSLEngineResult ), $anonfun$unwrap$5(javax.net.ssl.SSLEngineResult int ), $anonfun$unwrap$6(fs2.io.net.tls.TLSEngine$$anon$1 int ), $anonfun$unwrap$7(fs2.io.net.tls.TLSEngine$$anon$1 int ), $anonfun$unwrap$8(fs2.io.net.tls.TLSEngine$$anon$1 int ), $anonfun$unwrap$9(fs2.io.net.tls.TLSEngine$$anon$1 int ), $anonfun$unwrapHandshake$1(fs2.io.net.tls.TLSEngine$$anon$1 java.nio.ByteBuffer java.nio.ByteBuffer ), $anonfun$unwrapHandshake$2(fs2.io.net.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult ), $anonfun$unwrapHandshake$3(javax.net.ssl.SSLEngineResult ), $anonfun$unwrapHandshake$4(fs2.io.net.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult ), $anonfun$unwrapHandshake$5(fs2.io.net.tls.TLSEngine$$anon$1 ), $anonfun$unwrapHandshake$6(fs2.io.net.tls.TLSEngine$$anon$1 ), $anonfun$unwrapThenTakeUnwrapped$1(int ), $anonfun$unwrapThenTakeUnwrapped$2(fs2.io.net.tls.TLSEngine$$anon$1 int ), $anonfun$unwrapThenTakeUnwrapped$3(fs2.io.net.tls.TLSEngine$$anon$1 int ), $anonfun$wrap$1(fs2.io.net.tls.TLSEngine$$anon$1 java.nio.ByteBuffer java.nio.ByteBuffer ), $anonfun$wrap$2(fs2.io.net.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult ), $anonfun$wrap$3(javax.net.ssl.SSLEngineResult ), $anonfun$wrap$4(fs2.io.net.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult ), $anonfun$wrap$5(fs2.io.net.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult ), $anonfun$wrap$6$adapted(fs2.io.net.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult java.lang.Object ), $anonfun$wrap$7(fs2.io.net.tls.TLSEngine$$anon$1 ), $anonfun$wrap$8(fs2.io.net.tls.TLSEngine$$anon$1 ), $anonfun$wrap$9(fs2.io.net.tls.TLSEngine$$anon$1 ), $anonfun$wrapHandshake$1(fs2.io.net.tls.TLSEngine$$anon$1 java.nio.ByteBuffer java.nio.ByteBuffer ), $anonfun$wrapHandshake$2(fs2.io.net.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult ), $anonfun$wrapHandshake$3(javax.net.ssl.SSLEngineResult ), $anonfun$wrapHandshake$4(fs2.io.net.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult ), $anonfun$wrapHandshake$5(fs2.io.net.tls.TLSEngine$$anon$1 javax.net.ssl.SSLEngineResult ), $anonfun$wrapHandshake$6(fs2.io.net.tls.TLSEngine$$anon$1 ), $anonfun$wrapHandshake$7(fs2.io.net.tls.TLSEngine$$anon$1 ), $anonfun$write0$1(fs2.io.net.tls.TLSEngine$$anon$1 )}, serializedLambda);
                }
            };
        })))));
    }

    private TLSEngine$() {
    }
}

