/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.FixedBitSet;

abstract class ShapeQuery
extends Query {
    final String field;
    final ShapeField.QueryRelation queryRelation;

    protected ShapeQuery(String field2, ShapeField.QueryRelation queryType) {
        if (field2 == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        this.field = field2;
        this.queryRelation = queryType;
    }

    protected abstract PointValues.Relation relateRangeBBoxToQuery(int var1, int var2, byte[] var3, int var4, int var5, byte[] var6);

    protected abstract boolean queryMatches(byte[] var1, int[] var2, ShapeField.QueryRelation var3);

    protected PointValues.Relation relateRangeToQuery(byte[] minTriangle, byte[] maxTriangle, ShapeField.QueryRelation queryRelation) {
        PointValues.Relation r = this.relateRangeBBoxToQuery(4, 0, minTriangle, 12, 8, maxTriangle);
        if (queryRelation == ShapeField.QueryRelation.DISJOINT) {
            return ShapeQuery.transposeRelation(r);
        }
        return r;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public final Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            protected PointValues.IntersectVisitor getSparseIntersectVisitor(final DocIdSetBuilder result2) {
                return new PointValues.IntersectVisitor(){
                    final int[] scratchTriangle = new int[6];
                    DocIdSetBuilder.BulkAdder adder;

                    @Override
                    public void grow(int count) {
                        this.adder = result2.grow(count);
                    }

                    @Override
                    public void visit(int docID) throws IOException {
                        this.adder.add(docID);
                    }

                    @Override
                    public void visit(int docID, byte[] t) throws IOException {
                        if (ShapeQuery.this.queryMatches(t, this.scratchTriangle, ShapeField.QueryRelation.INTERSECTS)) {
                            this.visit(docID);
                        }
                    }

                    @Override
                    public void visit(DocIdSetIterator iterator, byte[] t) throws IOException {
                        if (ShapeQuery.this.queryMatches(t, this.scratchTriangle, ShapeField.QueryRelation.INTERSECTS)) {
                            int docID;
                            while ((docID = iterator.nextDoc()) != Integer.MAX_VALUE) {
                                this.visit(docID);
                            }
                        }
                    }

                    @Override
                    public PointValues.Relation compare(byte[] minTriangle, byte[] maxTriangle) {
                        return ShapeQuery.this.relateRangeToQuery(minTriangle, maxTriangle, ShapeField.QueryRelation.INTERSECTS);
                    }
                };
            }

            protected PointValues.IntersectVisitor getDenseIntersectVisitor(final FixedBitSet intersect, final FixedBitSet disjoint, final ShapeField.QueryRelation queryRelation) {
                return new PointValues.IntersectVisitor(){
                    final int[] scratchTriangle = new int[6];

                    @Override
                    public void visit(int docID) throws IOException {
                        if (queryRelation == ShapeField.QueryRelation.DISJOINT) {
                            disjoint.set(docID);
                        } else {
                            intersect.set(docID);
                        }
                    }

                    @Override
                    public void visit(int docID, byte[] t) throws IOException {
                        if (ShapeQuery.this.queryMatches(t, this.scratchTriangle, queryRelation)) {
                            intersect.set(docID);
                        } else {
                            disjoint.set(docID);
                        }
                    }

                    @Override
                    public void visit(DocIdSetIterator iterator, byte[] t) throws IOException {
                        int docID;
                        boolean queryMatches = ShapeQuery.this.queryMatches(t, this.scratchTriangle, queryRelation);
                        while ((docID = iterator.nextDoc()) != Integer.MAX_VALUE) {
                            if (queryMatches) {
                                intersect.set(docID);
                                continue;
                            }
                            disjoint.set(docID);
                        }
                    }

                    @Override
                    public PointValues.Relation compare(byte[] minTriangle, byte[] maxTriangle) {
                        return ShapeQuery.this.relateRangeToQuery(minTriangle, maxTriangle, queryRelation);
                    }
                };
            }

            protected ScorerSupplier getIntersectScorerSupplier(final LeafReader reader, PointValues values2, final Weight weight, final ScoreMode scoreMode2) throws IOException {
                final DocIdSetBuilder result2 = new DocIdSetBuilder(reader.maxDoc(), values2, ShapeQuery.this.field);
                PointValues.IntersectVisitor visitor = this.getSparseIntersectVisitor(result2);
                return new RelationScorerSupplier(values2, visitor, null, ShapeQuery.this.queryRelation){

                    @Override
                    public Scorer get(long leadCost) throws IOException {
                        return this.getIntersectsScorer(ShapeQuery.this, reader, weight, result2, this.score(), scoreMode2);
                    }
                };
            }

            protected ScorerSupplier getScorerSupplier(LeafReader reader, PointValues values2, final Weight weight, final ScoreMode scoreMode2) throws IOException {
                if (ShapeQuery.this.queryRelation == ShapeField.QueryRelation.INTERSECTS) {
                    return this.getIntersectScorerSupplier(reader, values2, weight, scoreMode2);
                }
                final FixedBitSet within = new FixedBitSet(reader.maxDoc());
                final FixedBitSet disjoint = new FixedBitSet(reader.maxDoc());
                PointValues.IntersectVisitor withinVisitor = this.getDenseIntersectVisitor(within, disjoint, ShapeField.QueryRelation.WITHIN);
                PointValues.IntersectVisitor disjointVisitor = this.getDenseIntersectVisitor(within, disjoint, ShapeField.QueryRelation.DISJOINT);
                return new RelationScorerSupplier(values2, withinVisitor, disjointVisitor, ShapeQuery.this.queryRelation){

                    @Override
                    public Scorer get(long leadCost) throws IOException {
                        return this.getScorer(ShapeQuery.this, weight, within, disjoint, this.score(), scoreMode2);
                    }
                };
            }

            @Override
            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                final LeafReader reader = context.reader();
                PointValues values2 = reader.getPointValues(ShapeQuery.this.field);
                if (values2 == null) {
                    return null;
                }
                FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(ShapeQuery.this.field);
                if (fieldInfo == null) {
                    return null;
                }
                boolean allDocsMatch = true;
                if (values2.getDocCount() != reader.maxDoc() || ShapeQuery.this.relateRangeToQuery(values2.getMinPackedValue(), values2.getMaxPackedValue(), ShapeQuery.this.queryRelation) != PointValues.Relation.CELL_INSIDE_QUERY) {
                    allDocsMatch = false;
                }
                final 1 weight = this;
                if (allDocsMatch) {
                    return new ScorerSupplier(){

                        @Override
                        public Scorer get(long leadCost) throws IOException {
                            return new ConstantScoreScorer(weight, this.score(), scoreMode, DocIdSetIterator.all(reader.maxDoc()));
                        }

                        @Override
                        public long cost() {
                            return reader.maxDoc();
                        }
                    };
                }
                return this.getScorerSupplier(reader, values2, weight, scoreMode);
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                ScorerSupplier scorerSupplier = this.scorerSupplier(context);
                if (scorerSupplier == null) {
                    return null;
                }
                return scorerSupplier.get(Long.MAX_VALUE);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    public String getField() {
        return this.field;
    }

    public ShapeField.QueryRelation getQueryRelation() {
        return this.queryRelation;
    }

    @Override
    public int hashCode() {
        int hash2 = this.classHash();
        hash2 = 31 * hash2 + this.field.hashCode();
        hash2 = 31 * hash2 + this.queryRelation.hashCode();
        return hash2;
    }

    @Override
    public boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo(o);
    }

    protected boolean equalsTo(Object o) {
        return Objects.equals(this.field, ((ShapeQuery)o).field) && this.queryRelation == ((ShapeQuery)o).queryRelation;
    }

    private static PointValues.Relation transposeRelation(PointValues.Relation r) {
        if (r == PointValues.Relation.CELL_INSIDE_QUERY) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (r == PointValues.Relation.CELL_OUTSIDE_QUERY) {
            return PointValues.Relation.CELL_INSIDE_QUERY;
        }
        return PointValues.Relation.CELL_CROSSES_QUERY;
    }

    private static abstract class RelationScorerSupplier
    extends ScorerSupplier {
        PointValues values;
        PointValues.IntersectVisitor visitor;
        PointValues.IntersectVisitor disjointVisitor;
        ShapeField.QueryRelation queryRelation;
        long cost = -1L;

        RelationScorerSupplier(PointValues values2, PointValues.IntersectVisitor visitor, PointValues.IntersectVisitor disjointVisitor, ShapeField.QueryRelation queryRelation) {
            this.values = values2;
            this.visitor = visitor;
            this.disjointVisitor = disjointVisitor;
            this.queryRelation = queryRelation;
        }

        private PointValues.IntersectVisitor getInverseIntersectVisitor(final ShapeQuery query, final FixedBitSet result2, final int[] cost) {
            return new PointValues.IntersectVisitor(){
                int[] scratchTriangle = new int[6];

                @Override
                public void visit(int docID) {
                    result2.clear(docID);
                    cost[0] = cost[0] - 1;
                }

                @Override
                public void visit(int docID, byte[] packedTriangle) {
                    if (!query.queryMatches(packedTriangle, this.scratchTriangle, ShapeField.QueryRelation.INTERSECTS)) {
                        this.visit(docID);
                    }
                }

                @Override
                public void visit(DocIdSetIterator iterator, byte[] t) throws IOException {
                    if (!query.queryMatches(t, this.scratchTriangle, ShapeField.QueryRelation.INTERSECTS)) {
                        int docID;
                        while ((docID = iterator.nextDoc()) != Integer.MAX_VALUE) {
                            this.visit(docID);
                        }
                    }
                }

                @Override
                public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                    return ShapeQuery.transposeRelation(query.relateRangeToQuery(minPackedValue, maxPackedValue, ShapeField.QueryRelation.INTERSECTS));
                }
            };
        }

        protected Scorer getIntersectsScorer(ShapeQuery query, LeafReader reader, Weight weight, DocIdSetBuilder docIdSetBuilder, float boost, ScoreMode scoreMode) throws IOException {
            if (this.values.getDocCount() == reader.maxDoc() && (long)this.values.getDocCount() == this.values.size() && this.cost() > (long)(reader.maxDoc() / 2)) {
                FixedBitSet result2 = new FixedBitSet(reader.maxDoc());
                result2.set(0, reader.maxDoc());
                int[] cost = new int[]{reader.maxDoc()};
                this.values.intersect(this.getInverseIntersectVisitor(query, result2, cost));
                BitSetIterator iterator = new BitSetIterator(result2, cost[0]);
                return new ConstantScoreScorer(weight, boost, scoreMode, iterator);
            }
            this.values.intersect(this.visitor);
            DocIdSetIterator iterator = docIdSetBuilder.build().iterator();
            return new ConstantScoreScorer(weight, boost, scoreMode, iterator);
        }

        protected Scorer getScorer(ShapeQuery query, Weight weight, FixedBitSet intersect, FixedBitSet disjoint, float boost, ScoreMode scoreMode) throws IOException {
            BitSetIterator iterator;
            this.values.intersect(this.visitor);
            if (this.disjointVisitor != null) {
                this.values.intersect(this.disjointVisitor);
            }
            if (query.queryRelation == ShapeField.QueryRelation.DISJOINT) {
                disjoint.andNot(intersect);
                iterator = new BitSetIterator(disjoint, this.cost());
            } else if (query.queryRelation == ShapeField.QueryRelation.WITHIN) {
                intersect.andNot(disjoint);
                iterator = new BitSetIterator(intersect, this.cost());
            } else {
                iterator = new BitSetIterator(intersect, this.cost());
            }
            return new ConstantScoreScorer(weight, boost, scoreMode, iterator);
        }

        @Override
        public long cost() {
            if (this.cost == -1L) {
                this.cost = this.queryRelation == ShapeField.QueryRelation.DISJOINT ? this.values.estimatePointCount(this.disjointVisitor) : this.values.estimatePointCount(this.visitor);
                assert (this.cost >= 0L);
            }
            return this.cost;
        }
    }
}

