/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.document.ShapeField;
import org.apache.lucene.document.ShapeQuery;
import org.apache.lucene.geo.XYRectangle;
import org.apache.lucene.geo.XYRectangle2D;
import org.apache.lucene.index.PointValues;

public class XYShapeBoundingBoxQuery
extends ShapeQuery {
    final XYRectangle2D rectangle2D;

    public XYShapeBoundingBoxQuery(String field2, ShapeField.QueryRelation queryRelation, double minX, double maxX, double minY, double maxY) {
        super(field2, queryRelation);
        XYRectangle rectangle = new XYRectangle(minX, maxX, minY, maxY);
        this.rectangle2D = XYRectangle2D.create(rectangle);
    }

    @Override
    protected PointValues.Relation relateRangeBBoxToQuery(int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
        return this.rectangle2D.relateRangeBBox(minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle);
    }

    @Override
    protected boolean queryMatches(byte[] t, int[] scratchTriangle, ShapeField.QueryRelation queryRelation) {
        ShapeField.decodeTriangle(t, scratchTriangle);
        int aY = scratchTriangle[0];
        int aX = scratchTriangle[1];
        int bY = scratchTriangle[2];
        int bX = scratchTriangle[3];
        int cY = scratchTriangle[4];
        int cX = scratchTriangle[5];
        if (queryRelation == ShapeField.QueryRelation.WITHIN) {
            return this.rectangle2D.containsTriangle(aX, aY, bX, bY, cX, cY);
        }
        return this.rectangle2D.intersectsTriangle(aX, aY, bX, bY, cX, cY);
    }

    @Override
    public boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo(this.getClass().cast(o));
    }

    @Override
    protected boolean equalsTo(Object o) {
        return super.equalsTo(o) && this.rectangle2D.equals(((XYShapeBoundingBoxQuery)o).rectangle2D);
    }

    @Override
    public int hashCode() {
        int hash2 = super.hashCode();
        hash2 = 31 * hash2 + this.rectangle2D.hashCode();
        return hash2;
    }

    @Override
    public String toString(String field2) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field2)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        sb.append(this.rectangle2D.toString());
        return sb.toString();
    }
}

