/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.middleware;

import cats.Monad;
import cats.arrow.FunctionK;
import cats.data.Chain;
import cats.data.Kleisli;
import cats.data.NonEmptyList;
import cats.effect.SyncIO$;
import cats.effect.kernel.GenConcurrent;
import cats.syntax.package$flatMap$;
import cats.syntax.package$functor$;
import java.io.Serializable;
import org.http4s.Header;
import org.http4s.Header$ToRaw$;
import org.http4s.Headers$;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.Status$;
import org.http4s.UrlForm;
import org.http4s.UrlForm$;
import org.http4s.server.middleware.HttpMethodOverrider;
import org.http4s.server.middleware.HttpMethodOverrider$HttpMethodOverriderConfig$;
import org.typelevel.ci.CIString;
import org.typelevel.ci.package$;
import org.typelevel.vault.Key;
import org.typelevel.vault.Key$;
import org.typelevel.vault.Vault;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class HttpMethodOverrider$ {
    public static final HttpMethodOverrider$ MODULE$ = new HttpMethodOverrider$();
    private static final Key<Method> overriddenMethodAttrKey = (Key)Key$.MODULE$.newKey(SyncIO$.MODULE$.syncForSyncIO(), SyncIO$.MODULE$.syncForSyncIO()).unsafeRunSync();

    public <F, G> HttpMethodOverrider.HttpMethodOverriderConfig<F, G> defaultConfig() {
        return HttpMethodOverrider$HttpMethodOverriderConfig$.MODULE$.apply(new HttpMethodOverrider.HeaderOverrideStrategy(package$.MODULE$.CIStringSyntax(new StringContext(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"X-HTTP-Method-Override"}))).ci(Nil$.MODULE$)), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Method[]{Method$.MODULE$.POST()})));
    }

    public Key<Method> overriddenMethodAttrKey() {
        return overriddenMethodAttrKey;
    }

    public <F, G> Kleisli<F, Request<G>, Response<G>> apply(Kleisli<F, Request<G>, Response<G>> http, HttpMethodOverrider.HttpMethodOverriderConfig<F, G> config, Monad<F> F, GenConcurrent<G, Throwable> S) {
        Function1<String, Either> & Serializable parseMethod = (Function1<String, Either> & Serializable)m -> Method$.MODULE$.fromString(m.toUpperCase());
        return new Kleisli((Function1<Request, Object> & Serializable)req -> {
            boolean isOverridden = config.overridableMethods().contains(req.method());
            if (isOverridden) {
                return this.processRequest$1((Request)req, F, parseMethod, http, config, S);
            }
            return http.apply((Request)req);
        });
    }

    private final Object processRequestWithMethod$1(Request req, Either parseResult, Monad F$1, Kleisli http$1, HttpMethodOverrider.HttpMethodOverriderConfig config$1) {
        Either either2 = parseResult;
        if (either2 instanceof Left) {
            return F$1.pure(Response$.MODULE$.apply(Status$.MODULE$.BadRequest(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()));
        }
        if (either2 instanceof Right) {
            Right right = (Right)either2;
            Method om = (Method)right.value();
            return package$functor$.MODULE$.toFunctorOps(http$1.apply(this.updateRequestWithMethod$1(req, om)), F$1).map((Function1<Response, Response> & Serializable)resp -> HttpMethodOverrider$.updateVaryHeader$1(resp, config$1));
        }
        throw new MatchError(either2);
    }

    private static final Response updateVaryHeader$1(Response resp, HttpMethodOverrider.HttpMethodOverriderConfig config$1) {
        CIString varyHeaderName = package$.MODULE$.CIStringSyntax(new StringContext(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Vary"}))).ci(Nil$.MODULE$);
        HttpMethodOverrider.OverrideStrategy overrideStrategy = config$1.overrideStrategy();
        if (overrideStrategy instanceof HttpMethodOverrider.HeaderOverrideStrategy) {
            HttpMethodOverrider.HeaderOverrideStrategy headerOverrideStrategy = (HttpMethodOverrider.HeaderOverrideStrategy)overrideStrategy;
            CIString headerName = headerOverrideStrategy.headerName();
            Header.Raw updatedVaryHeader = (Header.Raw)Headers$.MODULE$.get$extension((List<Header.Raw>)resp.headers(), varyHeaderName).map((Function1<NonEmptyList, Header.Raw> & Serializable)x$1 -> (Header.Raw)x$1.head()).map((Function1<Header.Raw, Header.Raw> & Serializable)h -> new Header.Raw(h.name(), new StringBuilder(2).append(h.value()).append(", ").append(headerName.toString()).toString())).getOrElse((Function0<Header.Raw> & Serializable)() -> new Header.Raw(varyHeaderName, headerName.toString()));
            return (Response)resp.withHeaders(Headers$.MODULE$.put$extension(resp.headers(), ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header$ToRaw$.MODULE$.rawToRaw(updatedVaryHeader)})));
        }
        return resp;
    }

    private final Request updateRequestWithMethod$1(Request req, Method om) {
        Vault attrs = req.attributes().insert(this.overriddenMethodAttrKey(), req.method());
        return ((Request)req.withAttributes(attrs)).withMethod(om);
    }

    private static final Object getUnsafeOverrideMethod$1(Request req, HttpMethodOverrider.HttpMethodOverriderConfig config$1, Monad F$1, GenConcurrent S$1) {
        HttpMethodOverrider.OverrideStrategy overrideStrategy = config$1.overrideStrategy();
        if (overrideStrategy instanceof HttpMethodOverrider.HeaderOverrideStrategy) {
            HttpMethodOverrider.HeaderOverrideStrategy headerOverrideStrategy = (HttpMethodOverrider.HeaderOverrideStrategy)overrideStrategy;
            CIString headerName = headerOverrideStrategy.headerName();
            return F$1.pure(Headers$.MODULE$.get$extension((List<Header.Raw>)req.headers(), headerName).map((Function1<NonEmptyList, String> & Serializable)x$2 -> ((Header.Raw)x$2.head()).value()));
        }
        if (overrideStrategy instanceof HttpMethodOverrider.QueryOverrideStrategy) {
            HttpMethodOverrider.QueryOverrideStrategy queryOverrideStrategy = (HttpMethodOverrider.QueryOverrideStrategy)overrideStrategy;
            String parameter = queryOverrideStrategy.paramName();
            return F$1.pure(req.params().get(parameter));
        }
        if (overrideStrategy instanceof HttpMethodOverrider.FormOverrideStrategy) {
            HttpMethodOverrider.FormOverrideStrategy formOverrideStrategy = (HttpMethodOverrider.FormOverrideStrategy)overrideStrategy;
            String field2 = formOverrideStrategy.fieldName();
            FunctionK f = formOverrideStrategy.naturalTransformation();
            return package$functor$.MODULE$.toFunctorOps(f.apply(package$functor$.MODULE$.toFunctorOps(UrlForm$.MODULE$.entityDecoder(S$1, UrlForm$.MODULE$.entityDecoder$default$2()).decode(req, true).value(), S$1).map((Function1<Either, Option> & Serializable)x$3 -> x$3.toOption().map((Function1<Object, Map> & Serializable)x$4 -> ((UrlForm)x$4).values()))), F$1).map((Function1<Option, Option> & Serializable)formFields -> formFields.flatMap((Function1<Map, Option> & Serializable)x$5 -> x$5.get(field2).flatMap((Function1<Chain, Option> & Serializable)x$6 -> x$6.uncons().map((Function1<Tuple2, String> & Serializable)x$7 -> (String)x$7._1()))));
        }
        throw new MatchError(overrideStrategy);
    }

    private final Object processRequest$1(Request req, Monad F$1, Function1 parseMethod$1, Kleisli http$1, HttpMethodOverrider.HttpMethodOverriderConfig config$1, GenConcurrent S$1) {
        return package$flatMap$.MODULE$.toFlatMapOps(HttpMethodOverrider$.getUnsafeOverrideMethod$1(req, config$1, F$1, S$1), F$1).flatMap((Function1<Option, Object> & Serializable)x0$1 -> {
            Some some;
            String m;
            Option option = x0$1;
            if (option instanceof Some && (m = (String)(some = (Some)option).value()) != null) {
                String string = m;
                return parseMethod$1.andThen((Function1<Either, Object> & Serializable)x$8 -> this.processRequestWithMethod$1(req, (Either)x$8, F$1, http$1, config$1)).apply(string);
            }
            if (None$.MODULE$.equals(option)) {
                return http$1.apply(req);
            }
            throw new MatchError(option);
        });
    }

    private HttpMethodOverrider$() {
    }
}

