/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.locale.converters;

import java.math.BigInteger;
import java.text.ParseException;
import java.util.Locale;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.locale.converters.DecimalLocaleConverter;

public class BigIntegerLocaleConverter
extends DecimalLocaleConverter {
    public BigIntegerLocaleConverter() {
        this(false);
    }

    public BigIntegerLocaleConverter(boolean locPattern) {
        this(Locale.getDefault(), locPattern);
    }

    public BigIntegerLocaleConverter(Locale locale) {
        this(locale, false);
    }

    public BigIntegerLocaleConverter(Locale locale, boolean locPattern) {
        this(locale, (String)null, locPattern);
    }

    public BigIntegerLocaleConverter(Locale locale, String pattern) {
        this(locale, pattern, false);
    }

    public BigIntegerLocaleConverter(Locale locale, String pattern, boolean locPattern) {
        super(locale, pattern, locPattern);
    }

    public BigIntegerLocaleConverter(Object defaultValue2) {
        this(defaultValue2, false);
    }

    public BigIntegerLocaleConverter(Object defaultValue2, boolean locPattern) {
        this(defaultValue2, Locale.getDefault(), locPattern);
    }

    public BigIntegerLocaleConverter(Object defaultValue2, Locale locale) {
        this(defaultValue2, locale, false);
    }

    public BigIntegerLocaleConverter(Object defaultValue2, Locale locale, boolean locPattern) {
        this(defaultValue2, locale, null, locPattern);
    }

    public BigIntegerLocaleConverter(Object defaultValue2, Locale locale, String pattern) {
        this(defaultValue2, locale, pattern, false);
    }

    public BigIntegerLocaleConverter(Object defaultValue2, Locale locale, String pattern, boolean locPattern) {
        super(defaultValue2, locale, pattern, locPattern);
    }

    @Override
    protected Object parse(Object value, String pattern) throws ParseException {
        Object result2 = super.parse(value, pattern);
        if (result2 == null || result2 instanceof BigInteger) {
            return result2;
        }
        if (result2 instanceof Number) {
            return BigInteger.valueOf(((Number)result2).longValue());
        }
        try {
            return new BigInteger(result2.toString());
        }
        catch (NumberFormatException ex) {
            throw new ConversionException("Suplied number is not of type BigInteger: " + result2);
        }
    }
}

