/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.websocket;

import cats.effect.SyncIO;
import cats.effect.SyncIO$;
import java.io.Serializable;
import java.nio.charset.CharacterCodingException;
import java.util.Base64;
import org.http4s.crypto.Hash$;
import org.http4s.crypto.HashAlgorithm$SHA1$;
import org.http4s.websocket.WebSocketHandshake;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public final class WebSocketHandshake$ {
    public static final WebSocketHandshake$ MODULE$ = new WebSocketHandshake$();
    private static final ByteVector magicString = (ByteVector)ByteVector$.MODULE$.encodeAscii(new StringBuilder().append("258EAFA5-E914-47DA-95CA-C5AB0DC85B11").toString()).fold((Function1<CharacterCodingException, Nothing$> & Serializable)x$1 -> {
        throw x$1;
    }, (Function1<ByteVector, ByteVector> & Serializable)x2 -> Predef$.MODULE$.identity(x2));
    private static final List<Tuple2<String, String>> org$http4s$websocket$WebSocketHandshake$$clientBaseHeaders = new $colon$colon<Nothing$>((Nothing$)((Object)new Tuple2<String, String>("Connection", "Upgrade")), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new Tuple2<String, String>("Upgrade", "websocket")), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new Tuple2<String, String>("Sec-WebSocket-Version", "13")), Nil$.MODULE$)));

    public WebSocketHandshake.ClientHandshaker clientHandshaker(String host) {
        return new WebSocketHandshake.ClientHandshaker(host);
    }

    public Either<Tuple2<Object, String>, Seq<Tuple2<String, String>>> serverHandshake(Iterable<Tuple2<String, String>> headers) {
        if (!headers.exists((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(WebSocketHandshake$.$anonfun$serverHandshake$1(x0$1)))) {
            return package$.MODULE$.Left().apply(new Tuple2<Integer, String>(BoxesRunTime.boxToInteger(-1), "Missing Host Header"));
        }
        if (!headers.exists((Function1<Tuple2, Object> & Serializable)x0$2 -> BoxesRunTime.boxToBoolean(WebSocketHandshake$.$anonfun$serverHandshake$2(x0$2)))) {
            return package$.MODULE$.Left().apply(new Tuple2<Integer, String>(BoxesRunTime.boxToInteger(-1), "Bad Connection header"));
        }
        if (!headers.exists((Function1<Tuple2, Object> & Serializable)x0$3 -> BoxesRunTime.boxToBoolean(WebSocketHandshake$.$anonfun$serverHandshake$3(x0$3)))) {
            return package$.MODULE$.Left().apply(new Tuple2<Integer, String>(BoxesRunTime.boxToInteger(-1), "Bad Upgrade header"));
        }
        if (!headers.exists((Function1<Tuple2, Object> & Serializable)x0$4 -> BoxesRunTime.boxToBoolean(WebSocketHandshake$.$anonfun$serverHandshake$4(x0$4)))) {
            return package$.MODULE$.Left().apply(new Tuple2<Integer, String>(BoxesRunTime.boxToInteger(-1), "Bad Websocket Version header"));
        }
        return (Either)headers.find((Function1<Tuple2, Object> & Serializable)x0$5 -> BoxesRunTime.boxToBoolean(WebSocketHandshake$.$anonfun$serverHandshake$5(x0$5))).map((Function1<Tuple2, Right> & Serializable)x0$6 -> {
            Tuple2 tuple2 = x0$6;
            if (tuple2 != null) {
                String v = (String)tuple2._2();
                $colon$colon<Nothing$> respHeaders = new $colon$colon<Nothing$>((Nothing$)((Object)new Tuple2<String, String>("Upgrade", "websocket")), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new Tuple2<String, String>("Connection", "Upgrade")), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new Tuple2<String, String>("Sec-WebSocket-Accept", MODULE$.org$http4s$websocket$WebSocketHandshake$$genAcceptKey(v))), Nil$.MODULE$)));
                return package$.MODULE$.Right().apply(respHeaders);
            }
            throw new MatchError(tuple2);
        }).getOrElse((Function0<Left> & Serializable)() -> package$.MODULE$.Left().apply(new Tuple2<Integer, String>(BoxesRunTime.boxToInteger(-1), "Bad Sec-WebSocket-Key header")));
    }

    public boolean isWebSocketRequest(Iterable<Tuple2<String, String>> headers) {
        return headers.exists((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(WebSocketHandshake$.$anonfun$isWebSocketRequest$1(x0$1)));
    }

    private int decodeLen(String key) {
        return Base64.getDecoder().decode(key).length;
    }

    public String org$http4s$websocket$WebSocketHandshake$$genAcceptKey(String str) {
        return (String)SyncIO$.MODULE$.fromEither(ByteVector$.MODULE$.encodeAscii(str)).flatMap((Function1<ByteVector, SyncIO> & Serializable)data -> ((SyncIO)Hash$.MODULE$.apply(Hash$.MODULE$.forApplicativeThrow(SyncIO$.MODULE$.syncForSyncIO())).digest(HashAlgorithm$SHA1$.MODULE$, data.$plus$plus(MODULE$.magicString()))).map((Function1<ByteVector, String> & Serializable)digest -> digest.toBase64())).unsafeRunSync();
    }

    public boolean valueContains(String key, String value) {
        String[] parts = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(value.split(",")), (Function1<String, String> & Serializable)x$1 -> x$1.trim(), ClassTag$.MODULE$.apply(String.class));
        return BoxesRunTime.unboxToBoolean(ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps(parts), BoxesRunTime.boxToBoolean(false), (Function2<Object, String, Object> & Serializable)(b, s2) -> BoxesRunTime.boxToBoolean(WebSocketHandshake$.$anonfun$valueContains$2(key, BoxesRunTime.unboxToBoolean(b), s2))));
    }

    private ByteVector magicString() {
        return magicString;
    }

    public List<Tuple2<String, String>> org$http4s$websocket$WebSocketHandshake$$clientBaseHeaders() {
        return org$http4s$websocket$WebSocketHandshake$$clientBaseHeaders;
    }

    public static final /* synthetic */ boolean $anonfun$serverHandshake$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return k.equalsIgnoreCase("Host");
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$serverHandshake$2(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            return k.equalsIgnoreCase("Connection") && MODULE$.valueContains("Upgrade", v);
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$serverHandshake$3(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            return k.equalsIgnoreCase("Upgrade") && v.equalsIgnoreCase("websocket");
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$serverHandshake$4(Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            return k.equalsIgnoreCase("Sec-WebSocket-Version") && MODULE$.valueContains("13", v);
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$serverHandshake$5(Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            return k.equalsIgnoreCase("Sec-WebSocket-Key") && MODULE$.decodeLen(v) == 16;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$isWebSocketRequest$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            return k.equalsIgnoreCase("Upgrade") && v.equalsIgnoreCase("websocket");
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$valueContains$2(String key$1, boolean b, String s2) {
        return b || s2.equalsIgnoreCase(key$1) || s2.length() > 1 && s2.startsWith("\"") && s2.endsWith("\"") && s2.substring(1, s2.length() - 1).equalsIgnoreCase(key$1);
    }

    private WebSocketHandshake$() {
    }
}

