/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import net.shrine.config.AtomicConfigSource;
import net.shrine.config.package$;
import net.shrine.log.Log$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.UninitializedFieldError;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.javaapi.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public final class ConfigSource$ {
    public static final ConfigSource$ MODULE$ = new ConfigSource$();
    private static AtomicConfigSource atomicConfig;
    private static final String overrideConfigName;
    private static final String passwordConfigName;
    private static final String shrineConfigName;
    private static final String referenceConfigName;
    private static final List<String> configNames;
    private static volatile byte bitmap$init$0;
    private static volatile boolean bitmap$0;

    static {
        overrideConfigName = "override";
        bitmap$init$0 = (byte)(bitmap$init$0 | 1);
        passwordConfigName = "password";
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
        shrineConfigName = "shrine";
        bitmap$init$0 = (byte)(bitmap$init$0 | 4);
        referenceConfigName = "reference";
        bitmap$init$0 = (byte)(bitmap$init$0 | 8);
        configNames = new $colon$colon<Nothing$>((Nothing$)((Object)MODULE$.overrideConfigName()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)MODULE$.passwordConfigName()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)MODULE$.shrineConfigName()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)MODULE$.referenceConfigName()), Nil$.MODULE$))));
        bitmap$init$0 = (byte)(bitmap$init$0 | 0x10);
    }

    public String overrideConfigName() {
        if ((byte)(bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ConfigSource.scala: 17");
        }
        return overrideConfigName;
    }

    public String passwordConfigName() {
        if ((byte)(bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ConfigSource.scala: 18");
        }
        return passwordConfigName;
    }

    public String shrineConfigName() {
        if ((byte)(bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ConfigSource.scala: 19");
        }
        return shrineConfigName;
    }

    public String referenceConfigName() {
        if ((byte)(bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ConfigSource.scala: 20");
        }
        return referenceConfigName;
    }

    public List<String> configNames() {
        if ((byte)(bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: ConfigSource.scala: 21");
        }
        return configNames;
    }

    private AtomicConfigSource atomicConfig$lzycompute() {
        ConfigSource$ configSource$ = this;
        synchronized (configSource$) {
            if (!bitmap$0) {
                Config shrineConfig;
                Set passwordConfigInShrineConfig;
                Config defaultOverrides = ConfigFactory.defaultOverrides();
                Config qaConfig = ConfigFactory.parseResourcesAnySyntax(this.overrideConfigName());
                Set passwordKeys = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hiveCredentials.password", "aws.accessKeyId", "aws.secretAccessKey", "kafka.ssl.truststore.password", "kafka.sasl.jaas.password"}));
                Config passwordConfig = ConfigFactory.parseResourcesAnySyntax(this.passwordConfigName());
                Set nonPasswordConfigInPasswordConfig = (Set)ConfigSource$.getShrineConfigKeys$1(passwordConfig).filterNot((Function1<String, Object> & Serializable)config -> BoxesRunTime.boxToBoolean(ConfigSource$.isPassword$1(config, passwordKeys)));
                if (nonPasswordConfigInPasswordConfig.nonEmpty()) {
                    this.liftedTree1$1(nonPasswordConfigInPasswordConfig);
                }
                if ((passwordConfigInShrineConfig = (Set)ConfigSource$.getShrineConfigKeys$1(shrineConfig = (Config)package$.MODULE$.ConfigExtensions(defaultOverrides).getOption("shrine.conf.file", (Function1<Config, Function1> & Serializable)x$2 -> (Function1<String, String> & Serializable)x$1 -> x$2.getString((String)x$1)).map((Function1<String, Config> & Serializable)fileName -> ConfigFactory.parseFile(new File((String)fileName))).getOrElse((Function0<Config> & Serializable)() -> ConfigFactory.parseResourcesAnySyntax(MODULE$.shrineConfigName()))).filter((Function1<String, Object> & Serializable)config -> BoxesRunTime.boxToBoolean(ConfigSource$.isPassword$1(config, passwordKeys)))).nonEmpty()) {
                    this.liftedTree2$1(passwordConfigInShrineConfig);
                }
                Config referenceConfig = ConfigFactory.parseResourcesAnySyntax(this.referenceConfigName());
                Config finalConfig = defaultOverrides.withFallback(qaConfig).withFallback(passwordConfig).withFallback(shrineConfig).withFallback(referenceConfig).resolve();
                atomicConfig = new AtomicConfigSource(finalConfig);
                bitmap$0 = true;
            }
        }
        return atomicConfig;
    }

    public AtomicConfigSource atomicConfig() {
        if (!bitmap$0) {
            return this.atomicConfig$lzycompute();
        }
        return atomicConfig;
    }

    public Config config() {
        Config config;
        try {
            config = this.atomicConfig().config();
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable x2 = option.get();
                Log$.MODULE$.error((Function0<String> & Serializable)() -> new StringBuilder(47).append("Could not load configuration from ").append(MODULE$.configNames().mkString(".conf, ")).append(".conf due to ").toString(), x2);
                throw x2;
            }
            throw throwable;
        }
        return config;
    }

    public <T> T configForBlock(String key, Object value, String origin, Function0<T> block) {
        return this.atomicConfig().configForBlock(key, value, origin, block);
    }

    public <T> T configForBlock(Config config, String origin, Function0<T> block) {
        return this.atomicConfig().configForBlock(config, origin, block);
    }

    private static final Set getShrineConfigKeys$1(Config config) {
        String baseKey = "shrine";
        if (config.hasPath(baseKey)) {
            return ((IterableOnceOps)CollectionConverters$.MODULE$.asScala(config.getConfig(baseKey).entrySet()).map((Function1<Map.Entry, String> & Serializable)x$1 -> (String)x$1.getKey())).toSet();
        }
        return Predef$.MODULE$.Set().empty();
    }

    private static final boolean isPassword$1(String shrineConfigKey, Set passwordKeys$1) {
        return passwordKeys$1.contains(shrineConfigKey);
    }

    private final /* synthetic */ void liftedTree1$1(Set nonPasswordConfigInPasswordConfig$1) {
        try {
            throw new IllegalArgumentException(new StringBuilder(65).append(this.passwordConfigName()).append(".conf should not contain anything other than ").append("expected passwords: ").append(nonPasswordConfigInPasswordConfig$1.mkString(", ")).toString());
        }
        catch (Exception e) {
            Log$.MODULE$.error((Function0<String> & Serializable)() -> new StringBuilder(34).append("Password config exception caught: ").append(e).toString());
            return;
        }
    }

    private final /* synthetic */ void liftedTree2$1(Set passwordConfigInShrineConfig$1) {
        try {
            throw new IllegalArgumentException(new StringBuilder(35).append(this.shrineConfigName()).append(".conf should not contain ").append("password: ").append(passwordConfigInShrineConfig$1.mkString(", ")).toString());
        }
        catch (Exception e) {
            Log$.MODULE$.error((Function0<String> & Serializable)() -> new StringBuilder(34).append("Password config exception caught: ").append(e).toString());
            return;
        }
    }

    private ConfigSource$() {
    }
}

