/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import org.apache.lucene.util.NumericUtils;

public final class XYEncodingUtils {
    public static final double MIN_VAL_INCL = -3.4028234663852886E38;
    public static final double MAX_VAL_INCL = 3.4028234663852886E38;

    private XYEncodingUtils() {
    }

    public static void checkVal(double x2) {
        if (Double.isNaN(x2) || x2 < -3.4028234663852886E38 || x2 > 3.4028234663852886E38) {
            throw new IllegalArgumentException("invalid value " + x2 + "; must be between " + -3.4028234663852886E38 + " and " + 3.4028234663852886E38);
        }
    }

    public static int encode(double x2) {
        XYEncodingUtils.checkVal(x2);
        return NumericUtils.floatToSortableInt((float)x2);
    }

    public static double decode(int encoded) {
        double result2 = NumericUtils.sortableIntToFloat(encoded);
        assert (result2 >= -3.4028234663852886E38 && result2 <= 3.4028234663852886E38);
        return result2;
    }

    public static double decode(byte[] src, int offset) {
        return XYEncodingUtils.decode(NumericUtils.sortableBytesToInt(src, offset));
    }
}

