/*
 * Decompiled with CFR 0.152.
 */
package fs2.compression;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.LiftIO;
import cats.effect.LiftIO$;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Sync;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Pull;
import fs2.Pull$;
import fs2.Pull$StreamPullOps$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import fs2.Stream$InvariantOps$;
import fs2.Stream$ToPull$;
import fs2.compat.NotGiven$;
import fs2.compression.Compression;
import fs2.compression.CompressionCompanionPlatform$;
import fs2.compression.CompressionCompanionPlatform$$anon$1$gzipCompressionMethod$;
import fs2.compression.CompressionCompanionPlatform$$anon$1$gzipExtraFlag$;
import fs2.compression.CompressionCompanionPlatform$$anon$1$gzipFlag$;
import fs2.compression.CompressionCompanionPlatform$$anon$1$gzipOperatingSystem$;
import fs2.compression.CompressionCompanionPlatformLowPriority;
import fs2.compression.CompressionPlatform;
import fs2.compression.DeflateParams;
import fs2.compression.GunzipResult;
import fs2.compression.GunzipResult$;
import fs2.compression.InflateParams;
import fs2.compression.ZLibParams;
import fs2.compression.ZLibParams$Header$GZIP$;
import java.io.EOFException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Array$UnapplySeqWrapper$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0005M3\u0001\"\u0002\u0004\u0011\u0002\u0007\u0005aA\u0003\u0005\u0006+\u0001!\ta\u0006\u0005\u00067\u0001!\t\u0001\b\u0005\u0006Q\u0001!\u0019!\u000b\u0005\u0006\u000f\u0002!\t\u0001\u0013\u0002\u001d\u0007>l\u0007O]3tg&|gnQ8na\u0006t\u0017n\u001c8QY\u0006$hm\u001c:n\u0015\t9\u0001\"A\u0006d_6\u0004(/Z:tS>t'\"A\u0005\u0002\u0007\u0019\u001c(gE\u0002\u0001\u0017E\u0001\"\u0001D\b\u000e\u00035Q\u0011AD\u0001\u0006g\u000e\fG.Y\u0005\u0003!5\u0011a!\u00118z%\u00164\u0007C\u0001\n\u0014\u001b\u00051\u0011B\u0001\u000b\u0007\u0005\u001d\u001au.\u001c9sKN\u001c\u0018n\u001c8D_6\u0004\u0018M\\5p]Bc\u0017\r\u001e4pe6dun\u001e)sS>\u0014\u0018\u000e^=\u0002\r\u0011Jg.\u001b;%\u0007\u0001!\u0012\u0001\u0007\t\u0003\u0019eI!AG\u0007\u0003\tUs\u0017\u000e^\u0001\u0006M>\u0014\u0018jT\u000b\u0002;A\u0019!C\b\u0011\n\u0005}1!aC\"p[B\u0014Xm]:j_:\u0004\"!\t\u0014\u000e\u0003\tR!a\t\u0013\u0002\r\u00154g-Z2u\u0015\u0005)\u0013\u0001B2biNL!a\n\u0012\u0003\u0005%{\u0015!\u00034pe2Kg\r^%P+\tQc\u0006F\u0002,u\t\u00032A\u0005\u0010-!\tic\u0006\u0004\u0001\u0005\u000b=\u001a!\u0019\u0001\u0019\u0003\u0003\u0019+\"!\r\u001d\u0012\u0005I*\u0004C\u0001\u00074\u0013\t!TBA\u0004O_RD\u0017N\\4\u0011\u000511\u0014BA\u001c\u000e\u0005\r\te.\u001f\u0003\u0006s9\u0012\r!\r\u0002\u0005?\u0012\"3\u0007C\u0004<\u0007\u0005\u0005\t9\u0001\u001f\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$#\u0007E\u0002>\u00012j\u0011A\u0010\u0006\u0003\u007f\t\naa[3s]\u0016d\u0017BA!?\u0005\u0011\u0019\u0016P\\2\t\u000f\r\u001b\u0011\u0011!a\u0002\t\u0006QQM^5eK:\u001cW\rJ\u001a\u0011\u0007\u0005*E&\u0003\u0002GE\t1A*\u001b4u\u0013>\u000bqAZ8s'ft7-\u0006\u0002J\u0019R\u0011!\n\u0015\t\u0004%yY\u0005CA\u0017M\t\u0015yCA1\u0001N+\t\td\nB\u0003P\u0019\n\u0007\u0011G\u0001\u0003`I\u0011\"\u0004\"B)\u0005\u0001\b\u0011\u0016!\u0001$\u0011\u0007u\u00025\n")
public interface CompressionCompanionPlatform
extends CompressionCompanionPlatformLowPriority {
    public static /* synthetic */ Compression forIO$(CompressionCompanionPlatform $this) {
        return $this.forIO();
    }

    default public Compression<IO> forIO() {
        return this.forLiftIO(IO$.MODULE$.asyncForIO(), LiftIO$.MODULE$.ioLiftIO());
    }

    public static /* synthetic */ Compression forLiftIO$(CompressionCompanionPlatform $this, Sync evidence$2, LiftIO evidence$3) {
        return $this.forLiftIO(evidence$2, evidence$3);
    }

    default public <F> Compression<F> forLiftIO(Sync<F> evidence$2, LiftIO<F> evidence$3) {
        LiftIO<F> liftIO = LiftIO$.MODULE$.apply(evidence$3);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return this.forSync(evidence$2);
    }

    public static /* synthetic */ Compression forSync$(CompressionCompanionPlatform $this, Sync F) {
        return $this.forSync(F);
    }

    default public <F> Compression<F> forSync(Sync<F> F) {
        return new Compression.UnsealedCompression<F>(null, F){
            private volatile CompressionCompanionPlatform$$anon$1$gzipCompressionMethod$ gzipCompressionMethod$module;
            private volatile CompressionCompanionPlatform$$anon$1$gzipFlag$ gzipFlag$module;
            private volatile CompressionCompanionPlatform$$anon$1$gzipExtraFlag$ gzipExtraFlag$module;
            private volatile CompressionCompanionPlatform$$anon$1$gzipOperatingSystem$ gzipOperatingSystem$module;
            private final int gzipHeaderBytes;
            private final byte gzipMagicFirstByte;
            private final byte gzipMagicSecondByte;
            private final int gzipOptionalExtraFieldLengthBytes;
            private final int gzipHeaderCrcBytes;
            private final int gzipInputCrcBytes;
            private final int gzipInputSizeBytes;
            private final int gzipTrailerBytes;
            private final byte zeroByte;
            private final int fileNameBytesSoftLimit;
            private final int fileCommentBytesSoftLimit;
            private final Sync F$1;

            public Function1<Stream<F, Object>, Stream<F, GunzipResult<F>>> gunzip(int bufferSize) {
                return Compression.gunzip$(this, bufferSize);
            }

            public int gunzip$default$1() {
                return Compression.gunzip$default$1$(this);
            }

            public Function1<Stream<F, Object>, Stream<F, Object>> gzip(int bufferSize, Option<Object> deflateLevel, Option<Object> deflateStrategy, Option<Instant> modificationTime, Option<String> fileName, Option<String> comment) {
                return CompressionPlatform.gzip$(this, bufferSize, deflateLevel, deflateStrategy, modificationTime, fileName, comment);
            }

            public int gzip$default$1() {
                return CompressionPlatform.gzip$default$1$(this);
            }

            public Option<Object> gzip$default$2() {
                return CompressionPlatform.gzip$default$2$(this);
            }

            public Option<Object> gzip$default$3() {
                return CompressionPlatform.gzip$default$3$(this);
            }

            public Option<Instant> gzip$default$4() {
                return CompressionPlatform.gzip$default$4$(this);
            }

            public Option<String> gzip$default$5() {
                return CompressionPlatform.gzip$default$5$(this);
            }

            public Option<String> gzip$default$6() {
                return CompressionPlatform.gzip$default$6$(this);
            }

            private CompressionCompanionPlatform$$anon$1$gzipCompressionMethod$ gzipCompressionMethod() {
                if (this.gzipCompressionMethod$module == null) {
                    this.gzipCompressionMethod$lzycompute$1();
                }
                return this.gzipCompressionMethod$module;
            }

            private CompressionCompanionPlatform$$anon$1$gzipFlag$ gzipFlag() {
                if (this.gzipFlag$module == null) {
                    this.gzipFlag$lzycompute$1();
                }
                return this.gzipFlag$module;
            }

            private CompressionCompanionPlatform$$anon$1$gzipExtraFlag$ gzipExtraFlag() {
                if (this.gzipExtraFlag$module == null) {
                    this.gzipExtraFlag$lzycompute$1();
                }
                return this.gzipExtraFlag$module;
            }

            private CompressionCompanionPlatform$$anon$1$gzipOperatingSystem$ gzipOperatingSystem() {
                if (this.gzipOperatingSystem$module == null) {
                    this.gzipOperatingSystem$lzycompute$1();
                }
                return this.gzipOperatingSystem$module;
            }

            public Function1<Stream<F, Object>, Stream<F, Object>> deflate(DeflateParams deflateParams) {
                return (Function1<Stream, Stream> & Serializable)stream -> Stream$.MODULE$.bracket($this.F$1.delay((Function0<Deflater> & Serializable)() -> {
                    Deflater deflater = new Deflater(deflateParams.level().juzDeflaterLevel(), deflateParams.header().juzDeflaterNoWrap());
                    deflater.setStrategy(deflateParams.strategy().juzDeflaterStrategy());
                    return deflater;
                }), (Function1<Deflater, Object> & Serializable)deflater -> $this.F$1.delay(() -> deflater.end())).flatMap((Function1<Deflater, Stream> & Serializable)deflater -> this._deflate(deflateParams, (Deflater)deflater, None$.MODULE$).apply((Stream<F, Object>)stream), NotGiven$.MODULE$.default());
            }

            private Function1<Stream<F, Object>, Stream<F, Object>> _deflate(DeflateParams deflateParams, Deflater deflater, Option<CRC32> crc32) {
                return (Function1<Stream, Stream> & Serializable)in -> Stream$.MODULE$.suspend((Function0<Stream> & Serializable)() -> {
                    byte[] deflatedBuffer = new byte[deflateParams.bufferSizeOrMinimum()];
                    return Pull$StreamPullOps$.MODULE$.stream$extension(Pull$.MODULE$.StreamPullOps(this._deflate_stream(deflateParams, deflater, crc32, deflatedBuffer).apply((Stream<F, Object>)in)));
                });
            }

            private Pull<F, Object, BoxedUnit> _deflate_chunk(DeflateParams deflateParams, Deflater deflater, Option<CRC32> crc32, Chunk<Object> chunk, byte[] deflatedBuffer, boolean isFinalChunk) {
                Chunk.ArraySlice<Object> bytesChunk = chunk.toArraySlice(ClassTag$.MODULE$.Byte());
                deflater.setInput((byte[])bytesChunk.values(), bytesChunk.offset(), bytesChunk.length());
                if (isFinalChunk) {
                    deflater.finish();
                }
                crc32.foreach((Function1<CRC32, Object> & Serializable)x$2 -> {
                    $anon$1.$anonfun$_deflate_chunk$1(bytesChunk, x$2);
                    return BoxedUnit.UNIT;
                });
                return this.pull$1(deflatedBuffer, deflater, deflateParams, isFinalChunk);
            }

            private Function1<Stream<F, Object>, Pull<F, Object, BoxedUnit>> _deflate_stream(DeflateParams deflateParams, Deflater deflater, Option<CRC32> crc32, byte[] deflatedBuffer) {
                return (Function1<Stream, Pull> & Serializable)x$3 -> Stream$ToPull$.MODULE$.uncons$extension(Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(x$3))).flatMap((Function1<Option, Pull> & Serializable)x0$1 -> {
                    Some some;
                    Tuple2 tuple2;
                    Option option = x0$1;
                    if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                        Chunk inflatedChunk = (Chunk)tuple2._1();
                        Stream inflatedStream = (Stream)tuple2._2();
                        return this._deflate_chunk(deflateParams, deflater, crc32, inflatedChunk, deflatedBuffer, false).$greater$greater((Function0<Pull> & Serializable)() -> this._deflate_stream(deflateParams, deflater, crc32, deflatedBuffer).apply(inflatedStream));
                    }
                    if (None$.MODULE$.equals(option)) {
                        return this._deflate_chunk(deflateParams, deflater, crc32, Chunk$.MODULE$.empty(), deflatedBuffer, true);
                    }
                    throw new MatchError(option);
                });
            }

            public Function1<Stream<F, Object>, Stream<F, Object>> inflate(InflateParams inflateParams) {
                return (Function1<Stream, Stream> & Serializable)stream -> Pull$StreamPullOps$.MODULE$.stream$extension(Pull$.MODULE$.StreamPullOps(Pull$.MODULE$.bracketCase(Pull$.MODULE$.eval($this.F$1.delay((Function0<Inflater> & Serializable)() -> new Inflater(inflateParams.header().juzDeflaterNoWrap()))), (Function1<Inflater, Pull> & Serializable)inflater -> this._inflate(inflateParams, (Inflater)inflater, None$.MODULE$).apply((Stream<F, Object>)stream), (Function2<Inflater, Resource.ExitCase, Pull> & Serializable)(inflater, x$4) -> Pull$.MODULE$.eval($this.F$1.delay(() -> inflater.end())))));
            }

            private Function1<Stream<F, Object>, Pull<F, Object, BoxedUnit>> _inflate(InflateParams inflateParams, Inflater inflater, Option<CRC32> crc32) {
                return (Function1<Stream, Pull> & Serializable)in -> Pull$.MODULE$.suspend((Function0<Pull> & Serializable)() -> {
                    byte[] inflatedBuffer = new byte[inflateParams.bufferSizeOrMinimum()];
                    return Stream$ToPull$.MODULE$.uncons$extension(Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(in))).flatMap((Function1<Option, Pull> & Serializable)x0$1 -> {
                        Some some;
                        Tuple2 tuple2;
                        Option option = x0$1;
                        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                            Chunk deflatedChunk = (Chunk)tuple2._1();
                            Stream deflatedStream = (Stream)tuple2._2();
                            return this._inflate_chunk(inflater, crc32, deflatedChunk, inflatedBuffer).$greater$greater((Function0<Pull> & Serializable)() -> this._inflate_stream(inflateParams, inflater, crc32, inflatedBuffer).apply(deflatedStream));
                        }
                        if (None$.MODULE$.equals(option)) {
                            return Pull$.MODULE$.done();
                        }
                        throw new MatchError(option);
                    });
                });
            }

            private Pull<F, Object, BoxedUnit> _inflate_chunk(Inflater inflater, Option<CRC32> crc32, Chunk<Object> chunk, byte[] inflatedBuffer) {
                Chunk.ArraySlice<Object> bytesChunk = chunk.toArraySlice(ClassTag$.MODULE$.Byte());
                inflater.setInput((byte[])bytesChunk.values(), bytesChunk.offset(), bytesChunk.length());
                return this.pull$2(inflater, bytesChunk, inflatedBuffer, crc32);
            }

            private Function1<Stream<F, Object>, Pull<F, Object, BoxedUnit>> _inflate_stream(InflateParams inflateParams, Inflater inflater, Option<CRC32> crc32, byte[] inflatedBuffer) {
                return (Function1<Stream, Pull> & Serializable)x$6 -> Stream$ToPull$.MODULE$.uncons$extension(Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(x$6))).flatMap((Function1<Option, Pull> & Serializable)x0$1 -> {
                    Some some;
                    Tuple2 tuple2;
                    Option option = x0$1;
                    if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                        Chunk deflatedChunk = (Chunk)tuple2._1();
                        Stream deflatedStream = (Stream)tuple2._2();
                        return this._inflate_chunk(inflater, crc32, deflatedChunk, inflatedBuffer).$greater$greater((Function0<Pull> & Serializable)() -> this._inflate_stream(inflateParams, inflater, crc32, inflatedBuffer).apply(deflatedStream));
                    }
                    if (None$.MODULE$.equals(option)) {
                        if (!inflater.finished()) {
                            return Pull$.MODULE$.raiseError(new DataFormatException("Insufficient data"), RaiseThrowable$.MODULE$.fromApplicativeError($this.F$1));
                        }
                        return Pull$.MODULE$.done();
                    }
                    throw new MatchError(option);
                });
            }

            public Function1<Stream<F, Object>, Stream<F, Object>> gzip(Option<String> fileName, Option<Instant> modificationTime, Option<String> comment, DeflateParams deflateParams) {
                return (Function1<Stream, Stream> & Serializable)stream -> {
                    DeflateParams deflateParams = deflateParams;
                    if (deflateParams != null) {
                        DeflateParams deflateParams2 = deflateParams;
                        ZLibParams.Header header = deflateParams2.header();
                        ZLibParams$Header$GZIP$ zLibParams$Header$GZIP$ = ZLibParams$Header$GZIP$.MODULE$;
                        if (!(header != null ? !header.equals(zLibParams$Header$GZIP$) : zLibParams$Header$GZIP$ != null)) {
                            return Stream$.MODULE$.bracket($this.F$1.delay((Function0<Tuple2> & Serializable)() -> {
                                Deflater deflater = new Deflater(deflateParams2.level().juzDeflaterLevel(), true);
                                deflater.setStrategy(deflateParams2.strategy().juzDeflaterStrategy());
                                return new Tuple2<Deflater, CRC32>(deflater, new CRC32());
                            }), (Function1<Tuple2, Object> & Serializable)x0$1 -> {
                                Tuple2 tuple2 = x0$1;
                                if (tuple2 != null) {
                                    Deflater deflater = (Deflater)tuple2._1();
                                    return $this.F$1.delay(() -> deflater.end());
                                }
                                throw new MatchError(tuple2);
                            }).flatMap((Function1<Tuple2, Stream> & Serializable)x0$2 -> {
                                Tuple2 tuple2 = x0$2;
                                if (tuple2 != null) {
                                    Deflater deflater = (Deflater)tuple2._1();
                                    CRC32 crc32 = (CRC32)tuple2._2();
                                    return this._gzip_header(fileName, modificationTime, comment, deflateParams2.level().juzDeflaterLevel(), deflateParams2.fhCrcEnabled()).$plus$plus((Function0<Stream> & Serializable)() -> this._deflate(deflateParams2, deflater, new Some<CRC32>(crc32)).apply((Stream<F, Object>)stream)).$plus$plus((Function0<Stream> & Serializable)() -> this._gzip_trailer(deflater, crc32));
                                }
                                throw new MatchError(tuple2);
                            }, NotGiven$.MODULE$.default());
                        }
                    }
                    if (deflateParams != null) {
                        DeflateParams deflateParams3 = deflateParams;
                        return Stream$.MODULE$.raiseError(new ZipException(new StringBuilder(28).append(ZLibParams$Header$GZIP$.MODULE$).append(" header type required, not ").append(deflateParams3.header()).append(".").toString()), RaiseThrowable$.MODULE$.fromApplicativeError($this.F$1));
                    }
                    throw new MatchError(deflateParams);
                };
            }

            private Stream<F, Object> _gzip_header(Option<String> fileName, Option<Instant> modificationTime, Option<String> comment, int deflateLevel, boolean fhCrcEnabled) {
                byte by2;
                long secondsSince197001010000 = BoxesRunTime.unboxToLong(modificationTime.map((Function1<Instant, Object> & Serializable)x$7 -> BoxesRunTime.boxToLong($anon$1.$anonfun$_gzip_header$1(x$7))).getOrElse(() -> 0L));
                byte[] byArray = new byte[10];
                byArray[0] = this.gzipMagicFirstByte();
                byArray[1] = this.gzipMagicSecondByte();
                byArray[2] = this.gzipCompressionMethod().DEFLATE();
                byArray[3] = (byte)((fhCrcEnabled ? this.gzipFlag().FHCRC() : this.zeroByte()) + BoxesRunTime.unboxToByte(fileName.map((Function1<String, Object> & Serializable)x$8 -> BoxesRunTime.boxToByte($anon$1.$anonfun$_gzip_header$3(this, x$8))).getOrElse(() -> this.zeroByte())) + BoxesRunTime.unboxToByte(comment.map((Function1<String, Object> & Serializable)x$9 -> BoxesRunTime.boxToByte($anon$1.$anonfun$_gzip_header$5(this, x$9))).getOrElse(() -> this.zeroByte())));
                byArray[4] = (byte)(secondsSince197001010000 & 0xFFL);
                byArray[5] = (byte)(secondsSince197001010000 >> 8 & 0xFFL);
                byArray[6] = (byte)(secondsSince197001010000 >> 16 & 0xFFL);
                byArray[7] = (byte)(secondsSince197001010000 >> 24 & 0xFFL);
                int n = deflateLevel;
                switch (n) {
                    case 9: {
                        by2 = this.gzipExtraFlag().DEFLATE_MAX_COMPRESSION_SLOWEST_ALGO();
                        break;
                    }
                    case 1: {
                        by2 = this.gzipExtraFlag().DEFLATE_FASTEST_ALGO();
                        break;
                    }
                    default: {
                        by2 = this.zeroByte();
                        break;
                    }
                }
                byArray[8] = by2;
                byArray[9] = this.gzipOperatingSystem().THIS();
                byte[] header = byArray;
                CRC32 crc32 = new CRC32();
                crc32.update(header);
                Option<B> fileNameEncoded = fileName.map((Function1<String, byte[]> & Serializable)string -> {
                    byte[] bytes = string.replaceAll("\u0000", "_").getBytes(StandardCharsets.ISO_8859_1);
                    crc32.update(bytes);
                    crc32.update(this.zeroByte());
                    return bytes;
                });
                Option<B> commentEncoded = comment.map((Function1<String, byte[]> & Serializable)string -> {
                    byte[] bytes = string.replaceAll("\u0000", " ").getBytes(StandardCharsets.ISO_8859_1);
                    crc32.update(bytes);
                    crc32.update(this.zeroByte());
                    return bytes;
                });
                long crc32Value = crc32.getValue();
                byte[] crc16 = fhCrcEnabled ? new byte[]{(byte)(crc32Value & 0xFFL), (byte)(crc32Value >> 8 & 0xFFL)} : Array$.MODULE$.emptyByteArray();
                return Stream$.MODULE$.chunk(this.moveAsChunkBytes(header)).$plus$plus((Function0<Stream> & Serializable)() -> (Stream)fileNameEncoded.map((Function1<byte[], Stream> & Serializable)bytes -> Stream$.MODULE$.chunk(this.moveAsChunkBytes((byte[])bytes)).$plus$plus((Function0<Stream> & Serializable)() -> Stream$.MODULE$.emit(BoxesRunTime.boxToByte(this.zeroByte())))).getOrElse((Function0<Stream> & Serializable)() -> Stream$.MODULE$.empty())).$plus$plus((Function0<Stream> & Serializable)() -> (Stream)commentEncoded.map((Function1<byte[], Stream> & Serializable)bytes -> Stream$.MODULE$.chunk(this.moveAsChunkBytes((byte[])bytes)).$plus$plus((Function0<Stream> & Serializable)() -> Stream$.MODULE$.emit(BoxesRunTime.boxToByte(this.zeroByte())))).getOrElse((Function0<Stream> & Serializable)() -> Stream$.MODULE$.empty())).$plus$plus((Function0<Stream> & Serializable)() -> Stream$.MODULE$.chunk(this.moveAsChunkBytes(crc16)));
            }

            private Stream<F, Object> _gzip_trailer(Deflater deflater, CRC32 crc32) {
                long crc32Value = crc32.getValue();
                int bytesIn = deflater.getTotalIn();
                byte[] trailer = new byte[]{(byte)(crc32Value & 0xFFL), (byte)(crc32Value >> 8 & 0xFFL), (byte)(crc32Value >> 16 & 0xFFL), (byte)(crc32Value >> 24 & 0xFFL), (byte)(bytesIn & 0xFF), (byte)(bytesIn >> 8 & 0xFF), (byte)(bytesIn >> 16 & 0xFF), (byte)(bytesIn >> 24 & 0xFF)};
                return Stream$.MODULE$.chunk(this.moveAsChunkBytes(trailer));
            }

            public Function1<Stream<F, Object>, Stream<F, GunzipResult<F>>> gunzip(InflateParams inflateParams) {
                return (Function1<Stream, Stream> & Serializable)stream -> {
                    InflateParams inflateParams = inflateParams;
                    if (inflateParams != null) {
                        InflateParams inflateParams2 = inflateParams;
                        ZLibParams.Header header = inflateParams2.header();
                        ZLibParams$Header$GZIP$ zLibParams$Header$GZIP$ = ZLibParams$Header$GZIP$.MODULE$;
                        if (!(header != null ? !header.equals(zLibParams$Header$GZIP$) : zLibParams$Header$GZIP$ != null)) {
                            return Pull$StreamPullOps$.MODULE$.stream$extension(Pull$.MODULE$.StreamPullOps(Pull$.MODULE$.bracketCase(Pull$.MODULE$.eval($this.F$1.delay((Function0<Tuple3> & Serializable)() -> new Tuple3<Inflater, CRC32, CRC32>(new Inflater(true), new CRC32(), new CRC32()))), (Function1<Tuple3, Pull> & Serializable)x0$1 -> {
                                Tuple3 tuple3 = x0$1;
                                if (tuple3 != null) {
                                    Inflater inflater = (Inflater)tuple3._1();
                                    CRC32 headerCrc32 = (CRC32)tuple3._2();
                                    CRC32 contentCrc32 = (CRC32)tuple3._3();
                                    Stream<F, O> qual$1 = Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(stream));
                                    int x$1 = this.gzipHeaderBytes();
                                    boolean x$2 = Stream$ToPull$.MODULE$.unconsN$default$2$extension(qual$1);
                                    return Stream$ToPull$.MODULE$.unconsN$extension(qual$1, x$1, x$2).flatMap((Function1<Option, Pull> & Serializable)x0$2 -> {
                                        Some some;
                                        Tuple2 tuple2;
                                        Option option = x0$2;
                                        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                                            Chunk mandatoryHeaderChunk = (Chunk)tuple2._1();
                                            Stream streamAfterMandatoryHeader = (Stream)tuple2._2();
                                            return this._gunzip_matchMandatoryHeader(inflateParams2, mandatoryHeaderChunk, streamAfterMandatoryHeader, headerCrc32, contentCrc32, inflater);
                                        }
                                        if (None$.MODULE$.equals(option)) {
                                            return Pull$.MODULE$.output1(new GunzipResult<F>(Stream$.MODULE$.raiseError(new EOFException(), RaiseThrowable$.MODULE$.fromApplicativeError($this.F$1)), GunzipResult$.MODULE$.apply$default$2(), GunzipResult$.MODULE$.apply$default$3(), GunzipResult$.MODULE$.apply$default$4()));
                                        }
                                        throw new MatchError(option);
                                    });
                                }
                                throw new MatchError(tuple3);
                            }, (Function2<Tuple3, Resource.ExitCase, Pull> & Serializable)(x0$3, x1$1) -> {
                                Tuple3 tuple3;
                                Tuple2<Tuple3, Resource.ExitCase> tuple2 = new Tuple2<Tuple3, Resource.ExitCase>((Tuple3)x0$3, (Resource.ExitCase)x1$1);
                                if (tuple2 != null && (tuple3 = tuple2._1()) != null) {
                                    Inflater inflater = (Inflater)tuple3._1();
                                    return Pull$.MODULE$.eval($this.F$1.delay(() -> inflater.end()));
                                }
                                throw new MatchError(tuple2);
                            })));
                        }
                    }
                    if (inflateParams != null) {
                        InflateParams inflateParams3 = inflateParams;
                        return Stream$.MODULE$.raiseError(new ZipException(new StringBuilder(28).append(ZLibParams$Header$GZIP$.MODULE$).append(" header type required, not ").append(inflateParams3.header()).append(".").toString()), RaiseThrowable$.MODULE$.fromApplicativeError($this.F$1));
                    }
                    throw new MatchError(inflateParams);
                };
            }

            private Pull<?, GunzipResult<F>, BoxedUnit> _gunzip_matchMandatoryHeader(InflateParams inflateParams, Chunk<Object> mandatoryHeaderChunk, Stream<F, Object> streamAfterMandatoryHeader, CRC32 headerCrc32, CRC32 contentCrc32, Inflater inflater) {
                Chunk.ArraySlice<Object> mandatoryHeaderSlice = mandatoryHeaderChunk.toArraySlice(ClassTag$.MODULE$.Byte());
                byte[] mandatoryHeaderBytes = mandatoryHeaderSlice.offset() == 0 ? (byte[])mandatoryHeaderSlice.values() : (byte[])mandatoryHeaderSlice.compact(ClassTag$.MODULE$.Byte()).values();
                Tuple2<Integer, byte[]> tuple2 = new Tuple2<Integer, byte[]>(BoxesRunTime.boxToInteger(mandatoryHeaderChunk.size()), mandatoryHeaderBytes);
                if (tuple2 != null) {
                    Object object;
                    int n = tuple2._1$mcI$sp();
                    byte[] byArray = tuple2._2();
                    if (this.gzipHeaderBytes() == n && byArray != null && !Array$UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq(byArray)) && new Array.UnapplySeqWrapper<T>(Array$UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 4) >= 0) {
                        byte by2 = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 0));
                        byte by3 = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 1));
                        byte by4 = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 2));
                        byte flags = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 3));
                        if (this.gzipMagicFirstByte() == by2 && this.gzipMagicSecondByte() == by3 && this.gzipCompressionMethod().DEFLATE() == by4 && this.gzipFlag().reserved5(flags)) {
                            return Pull$.MODULE$.output1(new GunzipResult<F>(Stream$.MODULE$.raiseError(new ZipException("Unsupported gzip flag reserved bit 5 is non-zero"), RaiseThrowable$.MODULE$.fromApplicativeError(this.F$1)), GunzipResult$.MODULE$.apply$default$2(), GunzipResult$.MODULE$.apply$default$3(), GunzipResult$.MODULE$.apply$default$4()));
                        }
                    }
                }
                if (tuple2 != null) {
                    Object object;
                    int n = tuple2._1$mcI$sp();
                    byte[] byArray = tuple2._2();
                    if (this.gzipHeaderBytes() == n && byArray != null && !Array$UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq(byArray)) && new Array.UnapplySeqWrapper<T>(Array$UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 4) >= 0) {
                        byte by5 = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 0));
                        byte by6 = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 1));
                        byte by7 = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 2));
                        byte flags = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 3));
                        if (this.gzipMagicFirstByte() == by5 && this.gzipMagicSecondByte() == by6 && this.gzipCompressionMethod().DEFLATE() == by7 && this.gzipFlag().reserved6(flags)) {
                            return Pull$.MODULE$.output1(new GunzipResult<F>(Stream$.MODULE$.raiseError(new ZipException("Unsupported gzip flag reserved bit 6 is non-zero"), RaiseThrowable$.MODULE$.fromApplicativeError(this.F$1)), GunzipResult$.MODULE$.apply$default$2(), GunzipResult$.MODULE$.apply$default$3(), GunzipResult$.MODULE$.apply$default$4()));
                        }
                    }
                }
                if (tuple2 != null) {
                    Object object;
                    int n = tuple2._1$mcI$sp();
                    byte[] byArray = tuple2._2();
                    if (this.gzipHeaderBytes() == n && byArray != null && !Array$UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq(byArray)) && new Array.UnapplySeqWrapper<T>(Array$UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 4) >= 0) {
                        byte by8 = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 0));
                        byte by9 = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 1));
                        byte by10 = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 2));
                        byte flags = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 3));
                        if (this.gzipMagicFirstByte() == by8 && this.gzipMagicSecondByte() == by9 && this.gzipCompressionMethod().DEFLATE() == by10 && this.gzipFlag().reserved7(flags)) {
                            return Pull$.MODULE$.output1(new GunzipResult<F>(Stream$.MODULE$.raiseError(new ZipException("Unsupported gzip flag reserved bit 7 is non-zero"), RaiseThrowable$.MODULE$.fromApplicativeError(this.F$1)), GunzipResult$.MODULE$.apply$default$2(), GunzipResult$.MODULE$.apply$default$3(), GunzipResult$.MODULE$.apply$default$4()));
                        }
                    }
                }
                if (tuple2 != null) {
                    Object object;
                    int n = tuple2._1$mcI$sp();
                    byte[] header = tuple2._2();
                    if (this.gzipHeaderBytes() == n && header != null && !Array$UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq(header)) && new Array.UnapplySeqWrapper<T>(Array$UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 4) >= 0) {
                        byte by11 = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 0));
                        byte by12 = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 1));
                        byte by13 = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 2));
                        byte flags = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 3));
                        if (this.gzipMagicFirstByte() == by11 && this.gzipMagicSecondByte() == by12 && this.gzipCompressionMethod().DEFLATE() == by13) {
                            headerCrc32.update(header);
                            long secondsSince197001010000 = this.unsignedToLong(header[4], header[5], header[6], header[7]);
                            return Stream$ToPull$.MODULE$.uncons1$extension(Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(this._gunzip_readOptionalHeader(inflateParams, streamAfterMandatoryHeader, flags, headerCrc32, contentCrc32, secondsSince197001010000, inflater)))).flatMap((Function1<Option, Pull> & Serializable)x0$1 -> {
                                Some some;
                                Tuple2 tuple2;
                                Option option = x0$1;
                                if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                                    GunzipResult gunzipResult = (GunzipResult)tuple2._1();
                                    return Pull$.MODULE$.output1(gunzipResult);
                                }
                                if (None$.MODULE$.equals(option)) {
                                    return Pull$.MODULE$.output1(new GunzipResult<F>(Stream$.MODULE$.raiseError(new EOFException(), RaiseThrowable$.MODULE$.fromApplicativeError($this.F$1)), GunzipResult$.MODULE$.apply$default$2(), GunzipResult$.MODULE$.apply$default$3(), GunzipResult$.MODULE$.apply$default$4()));
                                }
                                throw new MatchError(option);
                            });
                        }
                    }
                }
                if (tuple2 != null) {
                    Object object;
                    int n = tuple2._1$mcI$sp();
                    byte[] byArray = tuple2._2();
                    if (this.gzipHeaderBytes() == n && byArray != null && !Array$UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq(byArray)) && new Array.UnapplySeqWrapper<T>(Array$UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 3) >= 0) {
                        byte by14 = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 0));
                        byte by15 = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 1));
                        byte compressionMethod = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 2));
                        if (this.gzipMagicFirstByte() == by14 && this.gzipMagicSecondByte() == by15) {
                            return Pull$.MODULE$.output1(new GunzipResult<F>(Stream$.MODULE$.raiseError(new ZipException(new StringBuilder(37).append("Unsupported gzip compression method: ").append(compressionMethod).toString()), RaiseThrowable$.MODULE$.fromApplicativeError(this.F$1)), GunzipResult$.MODULE$.apply$default$2(), GunzipResult$.MODULE$.apply$default$3(), GunzipResult$.MODULE$.apply$default$4()));
                        }
                    }
                }
                return Pull$.MODULE$.output1(new GunzipResult<F>(Stream$.MODULE$.raiseError(new ZipException("Not in gzip format"), RaiseThrowable$.MODULE$.fromApplicativeError(this.F$1)), GunzipResult$.MODULE$.apply$default$2(), GunzipResult$.MODULE$.apply$default$3(), GunzipResult$.MODULE$.apply$default$4()));
            }

            private Stream<F, GunzipResult<F>> _gunzip_readOptionalHeader(InflateParams inflateParams, Stream<F, Object> streamAfterMandatoryHeader, byte flags, CRC32 headerCrc32, CRC32 contentCrc32, long secondsSince197001010000, Inflater inflater) {
                return streamAfterMandatoryHeader.through(this._gunzip_skipOptionalExtraField(this.gzipFlag().fextra(flags), headerCrc32)).through(this._gunzip_readOptionalStringField(this.gzipFlag().fname(flags), headerCrc32, "file name", this.fileNameBytesSoftLimit())).flatMap((Function1<Tuple2, Stream> & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        Option fileName = (Option)tuple2._1();
                        Stream streamAfterFileName = (Stream)tuple2._2();
                        return streamAfterFileName.through(this._gunzip_readOptionalStringField(this.gzipFlag().fcomment(flags), headerCrc32, "file comment", this.fileCommentBytesSoftLimit())).flatMap((Function1<Tuple2, Stream> & Serializable)x0$2 -> {
                            Tuple2 tuple2 = x0$2;
                            if (tuple2 != null) {
                                Option comment = (Option)tuple2._1();
                                Stream streamAfterComment = (Stream)tuple2._2();
                                Option x$1 = secondsSince197001010000 != 0L ? new Some<Instant>(Instant.ofEpochSecond(secondsSince197001010000)) : None$.MODULE$;
                                Option x$2 = fileName;
                                Option x$3 = comment;
                                Stream<F2, O2> x$4 = streamAfterComment.through(this._gunzip_validateHeader((byte)(flags & this.gzipFlag().FHCRC()) == this.gzipFlag().FHCRC(), headerCrc32)).through((Function1<Stream, Stream> & Serializable)s2 -> Pull$StreamPullOps$.MODULE$.stream$extension(Pull$.MODULE$.StreamPullOps(this._inflate(inflateParams, inflater, new Some<CRC32>(contentCrc32)).apply((Stream<F, Object>)s2)))).through(this._gunzip_validateTrailer(contentCrc32, inflater));
                                return Stream$.MODULE$.emit(new GunzipResult<F2>(x$4, x$1, x$2, x$3));
                            }
                            throw new MatchError(tuple2);
                        }, NotGiven$.MODULE$.default());
                    }
                    throw new MatchError(tuple2);
                }, NotGiven$.MODULE$.default());
            }

            private Function1<Stream<F, Object>, Stream<F, Object>> _gunzip_skipOptionalExtraField(boolean isPresent, CRC32 crc32) {
                return (Function1<Stream, Stream> & Serializable)stream -> {
                    if (isPresent) {
                        Stream<F, O> qual$1 = Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(stream));
                        int x$1 = this.gzipOptionalExtraFieldLengthBytes();
                        boolean x$2 = Stream$ToPull$.MODULE$.unconsN$default$2$extension(qual$1);
                        return Pull$StreamPullOps$.MODULE$.stream$extension(Pull$.MODULE$.StreamPullOps(Stream$ToPull$.MODULE$.unconsN$extension(qual$1, x$1, x$2).flatMap((Function1<Option, Pull> & Serializable)x0$1 -> {
                            Some some;
                            Tuple2 tuple2;
                            Option option = x0$1;
                            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                                Chunk optionalExtraFieldLengthChunk = (Chunk)tuple2._1();
                                Stream streamAfterOptionalExtraFieldLength = (Stream)tuple2._2();
                                Tuple2<Integer, Object> tuple22 = new Tuple2<Integer, Object>(BoxesRunTime.boxToInteger(optionalExtraFieldLengthChunk.size()), optionalExtraFieldLengthChunk.toArraySlice(ClassTag$.MODULE$.Byte()).values());
                                if (tuple22 != null) {
                                    Object object;
                                    int n = tuple22._1$mcI$sp();
                                    byte[] lengthBytes = (byte[])tuple22._2();
                                    if (this.gzipOptionalExtraFieldLengthBytes() == n && lengthBytes != null && !Array$UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq(lengthBytes)) && new Array.UnapplySeqWrapper<T>(Array$UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array$UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 2) == 0) {
                                        byte firstByte = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 0));
                                        byte secondByte = BoxesRunTime.unboxToByte(Array$UnapplySeqWrapper$.MODULE$.apply$extension(Array$UnapplySeqWrapper$.MODULE$.get$extension(object), 1));
                                        crc32.update(lengthBytes);
                                        int optionalExtraFieldLength = this.unsignedToInt(firstByte, secondByte);
                                        Stream<F, O> qual$2 = Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(streamAfterOptionalExtraFieldLength));
                                        int x$3 = optionalExtraFieldLength;
                                        boolean x$4 = Stream$ToPull$.MODULE$.unconsN$default$2$extension(qual$2);
                                        return Stream$ToPull$.MODULE$.unconsN$extension(qual$2, x$3, x$4).flatMap((Function1<Option, Pull> & Serializable)x0$2 -> {
                                            Some some;
                                            Tuple2 tuple2;
                                            Option option = x0$2;
                                            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                                                Chunk optionalExtraFieldChunk = (Chunk)tuple2._1();
                                                Stream streamAfterOptionalExtraField = (Stream)tuple2._2();
                                                Chunk.ArraySlice<Object> fieldBytes = optionalExtraFieldChunk.toArraySlice(ClassTag$.MODULE$.Byte());
                                                crc32.update((byte[])fieldBytes.values(), fieldBytes.offset(), fieldBytes.length());
                                                return Pull$.MODULE$.output1(streamAfterOptionalExtraField);
                                            }
                                            if (None$.MODULE$.equals(option)) {
                                                return Pull$.MODULE$.raiseError(new ZipException("Failed to read optional extra field header"), RaiseThrowable$.MODULE$.fromApplicativeError($this.F$1));
                                            }
                                            throw new MatchError(option);
                                        });
                                    }
                                }
                                return Pull$.MODULE$.raiseError(new ZipException("Failed to read optional extra field header length"), RaiseThrowable$.MODULE$.fromApplicativeError($this.F$1));
                            }
                            if (None$.MODULE$.equals(option)) {
                                return Pull$.MODULE$.raiseError(new EOFException(), RaiseThrowable$.MODULE$.fromApplicativeError($this.F$1));
                            }
                            throw new MatchError(option);
                        }))).flatten($less$colon$less$.MODULE$.refl());
                    }
                    return stream;
                };
            }

            private Function1<Stream<F, Object>, Stream<F, Tuple2<Option<String>, Stream<F, Object>>>> _gunzip_readOptionalStringField(boolean isPresent, CRC32 crc32, String fieldName, int fieldBytesSoftLimit) {
                return (Function1<Stream, Stream> & Serializable)stream -> {
                    if (isPresent) {
                        return Pull$StreamPullOps$.MODULE$.stream$extension(Pull$.MODULE$.StreamPullOps(this.unconsUntil((Function1<Object, Object> & Serializable)x$10 -> BoxesRunTime.boxToBoolean($anon$1.$anonfun$_gunzip_readOptionalStringField$2(this, BoxesRunTime.unboxToByte(x$10))), fieldBytesSoftLimit, ClassTag$.MODULE$.Byte()).apply((Stream<F, Object>)stream).flatMap((Function1<Option, Pull> & Serializable)x0$1 -> {
                            Some some;
                            Tuple2 tuple2;
                            Option option = x0$1;
                            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                                Some<String> some2;
                                Chunk chunk = (Chunk)tuple2._1();
                                Stream rest = (Stream)tuple2._2();
                                if (chunk.isEmpty()) {
                                    some2 = new Some<String>("");
                                } else {
                                    Chunk.ArraySlice<Object> bytesChunk = chunk.toArraySlice(ClassTag$.MODULE$.Byte());
                                    crc32.update((byte[])bytesChunk.values(), bytesChunk.offset(), bytesChunk.length());
                                    some2 = new Some<String>(new String((byte[])bytesChunk.values(), bytesChunk.offset(), bytesChunk.length(), StandardCharsets.ISO_8859_1));
                                }
                                return Pull$.MODULE$.output1(new Tuple2<Some<String>, Stream<F, O>>(some2, rest.dropWhile((Function1<Object, Object> & Serializable)object -> BoxesRunTime.boxToBoolean($anon$1.$anonfun$_gunzip_readOptionalStringField$4(this, crc32, BoxesRunTime.unboxToByte(object)))).drop(1L)));
                            }
                            if (None$.MODULE$.equals(option)) {
                                return Pull$.MODULE$.output1(new Tuple2<Option<A>, Stream<F, Nothing$>>(Option$.MODULE$.empty(), Stream$.MODULE$.raiseError(new ZipException(new StringBuilder(21).append("Failed to read ").append(fieldName).append(" field").toString()), RaiseThrowable$.MODULE$.fromApplicativeError($this.F$1))));
                            }
                            throw new MatchError(option);
                        })));
                    }
                    return Stream$.MODULE$.emit(new Tuple2<Option<A>, Stream>(Option$.MODULE$.empty(), (Stream)stream));
                };
            }

            private Function1<Stream<F, Object>, Stream<F, Object>> _gunzip_validateHeader(boolean isPresent, CRC32 crc32) {
                return (Function1<Stream, Stream> & Serializable)stream -> {
                    if (isPresent) {
                        Stream<F, O> qual$1 = Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(stream));
                        int x$1 = this.gzipHeaderCrcBytes();
                        boolean x$2 = Stream$ToPull$.MODULE$.unconsN$default$2$extension(qual$1);
                        return Pull$StreamPullOps$.MODULE$.stream$extension(Pull$.MODULE$.StreamPullOps(Stream$ToPull$.MODULE$.unconsN$extension(qual$1, x$1, x$2).flatMap((Function1<Option, Pull> & Serializable)x0$1 -> {
                            Some some;
                            Tuple2 tuple2;
                            Option option = x0$1;
                            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                                long actualHeaderCrc16;
                                Chunk headerCrcChunk = (Chunk)tuple2._1();
                                Stream streamAfterHeaderCrc = (Stream)tuple2._2();
                                int expectedHeaderCrc16 = this.unsignedToInt(BoxesRunTime.unboxToByte(headerCrcChunk.apply(0)), BoxesRunTime.unboxToByte(headerCrcChunk.apply(1)));
                                if ((long)expectedHeaderCrc16 != (actualHeaderCrc16 = crc32.getValue() & 0xFFFFL)) {
                                    return Pull$.MODULE$.raiseError(new ZipException("Header failed CRC validation"), RaiseThrowable$.MODULE$.fromApplicativeError($this.F$1));
                                }
                                return Pull$.MODULE$.output1(streamAfterHeaderCrc);
                            }
                            if (None$.MODULE$.equals(option)) {
                                return Pull$.MODULE$.raiseError(new ZipException("Failed to read header CRC"), RaiseThrowable$.MODULE$.fromApplicativeError($this.F$1));
                            }
                            throw new MatchError(option);
                        }))).flatten($less$colon$less$.MODULE$.refl());
                    }
                    return stream;
                };
            }

            private Function1<Stream<F, Object>, Stream<F, Object>> _gunzip_validateTrailer(CRC32 crc32, Inflater inflater) {
                return (Function1<Stream, Stream> & Serializable)stream -> Pull$StreamPullOps$.MODULE$.stream$extension(Pull$.MODULE$.StreamPullOps((Pull)this.streamUntilTrailer$1(Chunk$.MODULE$.empty(), inflater, crc32).apply(stream)));
            }

            private <O> Function1<Stream<F, O>, Pull<F, Nothing$, Option<Tuple2<Chunk<O>, Stream<F, O>>>>> unconsUntil(Function1<O, Object> predicate, int softLimit, ClassTag<O> evidence$4) {
                return (Function1<Stream, Pull> & Serializable)stream -> $anon$1.go$1(Nil$.MODULE$, stream, $anon$1.go$default$3$1(), predicate, evidence$4, softLimit);
            }

            private int gzipHeaderBytes() {
                return this.gzipHeaderBytes;
            }

            private byte gzipMagicFirstByte() {
                return this.gzipMagicFirstByte;
            }

            private byte gzipMagicSecondByte() {
                return this.gzipMagicSecondByte;
            }

            private int gzipOptionalExtraFieldLengthBytes() {
                return this.gzipOptionalExtraFieldLengthBytes;
            }

            private int gzipHeaderCrcBytes() {
                return this.gzipHeaderCrcBytes;
            }

            private int gzipInputCrcBytes() {
                return this.gzipInputCrcBytes;
            }

            private int gzipInputSizeBytes() {
                return this.gzipInputSizeBytes;
            }

            private int gzipTrailerBytes() {
                return this.gzipTrailerBytes;
            }

            private byte zeroByte() {
                return this.zeroByte;
            }

            private int fileNameBytesSoftLimit() {
                return this.fileNameBytesSoftLimit;
            }

            private int fileCommentBytesSoftLimit() {
                return this.fileCommentBytesSoftLimit;
            }

            private Chunk<Object> moveAsChunkBytes(byte[] values2) {
                return this.moveAsChunkBytes(values2, values2.length);
            }

            private Chunk<Object> moveAsChunkBytes(byte[] values2, int length) {
                if (length > 0) {
                    return Chunk$.MODULE$.array(values2, 0, length, ClassTag$.MODULE$.Byte());
                }
                return Chunk$.MODULE$.empty();
            }

            private Chunk<Object> copyAsChunkBytes(byte[] values2, int length) {
                if (length > 0) {
                    byte[] target = new byte[length];
                    System.arraycopy(values2, 0, target, 0, length);
                    return Chunk$.MODULE$.array(target, 0, length, ClassTag$.MODULE$.Byte());
                }
                return Chunk$.MODULE$.empty();
            }

            private int unsignedToInt(byte lsb, byte msb) {
                return (msb & 0xFF) << 8 | lsb & 0xFF;
            }

            private long unsignedToLong(byte lsb, byte byte2, byte byte3, byte msb) {
                return ((long)msb & 0xFFL) << 24 | (long)((byte3 & 0xFF) << 16) | (long)((byte2 & 0xFF) << 8) | (long)(lsb & 0xFF);
            }

            private final void gzipCompressionMethod$lzycompute$1() {
                $anon$1 var1_1 = this;
                synchronized (var1_1) {
                    if (this.gzipCompressionMethod$module == null) {
                        this.gzipCompressionMethod$module = new CompressionCompanionPlatform$$anon$1$gzipCompressionMethod$(this);
                    }
                }
            }

            private final void gzipFlag$lzycompute$1() {
                $anon$1 var1_1 = this;
                synchronized (var1_1) {
                    if (this.gzipFlag$module == null) {
                        this.gzipFlag$module = new CompressionCompanionPlatform$$anon$1$gzipFlag$(this);
                    }
                }
            }

            private final void gzipExtraFlag$lzycompute$1() {
                $anon$1 var1_1 = this;
                synchronized (var1_1) {
                    if (this.gzipExtraFlag$module == null) {
                        this.gzipExtraFlag$module = new CompressionCompanionPlatform$$anon$1$gzipExtraFlag$(this);
                    }
                }
            }

            private final void gzipOperatingSystem$lzycompute$1() {
                $anon$1 var1_1 = this;
                synchronized (var1_1) {
                    if (this.gzipOperatingSystem$module == null) {
                        this.gzipOperatingSystem$module = new CompressionCompanionPlatform$$anon$1$gzipOperatingSystem$(this);
                    }
                }
            }

            public static final /* synthetic */ void $anonfun$_deflate_chunk$1(Chunk.ArraySlice bytesChunk$1, CRC32 x$2) {
                x$2.update((byte[])bytesChunk$1.values(), bytesChunk$1.offset(), bytesChunk$1.length());
            }

            private static final boolean isDone$1(boolean isFinalChunk$1, Deflater deflater$3) {
                return isFinalChunk$1 && deflater$3.finished() || !isFinalChunk$1 && deflater$3.needsInput();
            }

            private static final int runDeflate$1(Deflater deflater$3, byte[] deflatedBuffer$1, DeflateParams deflateParams$3, boolean isFinalChunk$1) {
                if ($anon$1.isDone$1(isFinalChunk$1, deflater$3)) {
                    return 0;
                }
                return deflater$3.deflate(deflatedBuffer$1, 0, deflateParams$3.bufferSizeOrMinimum(), deflateParams$3.flushMode().juzDeflaterFlushMode());
            }

            private final Pull pull$1(byte[] deflatedBuffer$1, Deflater deflater$3, DeflateParams deflateParams$3, boolean isFinalChunk$1) {
                int deflatedBytes = $anon$1.runDeflate$1(deflater$3, deflatedBuffer$1, deflateParams$3, isFinalChunk$1);
                if ($anon$1.isDone$1(isFinalChunk$1, deflater$3)) {
                    return Pull$.MODULE$.output(this.copyAsChunkBytes(deflatedBuffer$1, deflatedBytes));
                }
                return Pull$.MODULE$.output(this.copyAsChunkBytes(deflatedBuffer$1, deflatedBytes)).$greater$greater((Function0<Pull> & Serializable)() -> this.pull$1(deflatedBuffer$1, deflater$3, deflateParams$3, isFinalChunk$1));
            }

            public static final /* synthetic */ void $anonfun$_inflate_chunk$1(byte[] inflatedBuffer$2, int byteCount$1, CRC32 x$5) {
                x$5.update(inflatedBuffer$2, 0, byteCount$1);
            }

            private static final int runInflate$1(Inflater inflater$3, byte[] inflatedBuffer$2, Option crc32$4) {
                if (inflater$3.finished()) {
                    return -2;
                }
                if (inflater$3.needsInput()) {
                    return -1;
                }
                int byteCount = inflater$3.inflate(inflatedBuffer$2);
                crc32$4.foreach((Function1<CRC32, Object> & Serializable)x$5 -> {
                    $anon$1.$anonfun$_inflate_chunk$1(inflatedBuffer$2, byteCount, x$5);
                    return BoxedUnit.UNIT;
                });
                return byteCount;
            }

            private final Pull pull$2(Inflater inflater$3, Chunk.ArraySlice bytesChunk$2, byte[] inflatedBuffer$2, Option crc32$4) {
                int n = $anon$1.runInflate$1(inflater$3, inflatedBuffer$2, crc32$4);
                switch (n) {
                    default: 
                }
                if (n <= -2) {
                    int n2 = inflater$3.getRemaining();
                    switch (n2) {
                        default: 
                    }
                    if (n2 > 0) {
                        return Pull$.MODULE$.output(Chunk$.MODULE$.array(bytesChunk$2.values(), bytesChunk$2.offset() + bytesChunk$2.length() - n2, n2, ClassTag$.MODULE$.Byte()));
                    }
                    return Pull$.MODULE$.done();
                }
                if (n == -1) {
                    return Pull$.MODULE$.done();
                }
                if (n < inflatedBuffer$2.length) {
                    if (inflater$3.finished()) {
                        int n3 = inflater$3.getRemaining();
                        switch (n3) {
                            default: 
                        }
                        if (n3 > 0) {
                            return Pull$.MODULE$.output(this.copyAsChunkBytes(inflatedBuffer$2, n)).$greater$greater((Function0<Pull> & Serializable)() -> Pull$.MODULE$.output(Chunk$.MODULE$.array(bytesChunk$2.values(), bytesChunk$2.offset() + bytesChunk$2.length() - n3, n3, ClassTag$.MODULE$.Byte())));
                        }
                        return Pull$.MODULE$.output(this.copyAsChunkBytes(inflatedBuffer$2, n));
                    }
                    return Pull$.MODULE$.output(this.copyAsChunkBytes(inflatedBuffer$2, n));
                }
                return Pull$.MODULE$.output(this.copyAsChunkBytes(inflatedBuffer$2, n)).$greater$greater((Function0<Pull> & Serializable)() -> this.pull$2(inflater$3, bytesChunk$2, inflatedBuffer$2, crc32$4));
            }

            public static final /* synthetic */ long $anonfun$_gzip_header$1(Instant x$7) {
                return x$7.getEpochSecond();
            }

            public static final /* synthetic */ byte $anonfun$_gzip_header$3($anon$1 $this, String x$8) {
                return $this.gzipFlag().FNAME();
            }

            public static final /* synthetic */ byte $anonfun$_gzip_header$5($anon$1 $this, String x$9) {
                return $this.gzipFlag().FCOMMENT();
            }

            public static final /* synthetic */ boolean $anonfun$_gunzip_readOptionalStringField$2($anon$1 $this, byte x$10) {
                return x$10 == $this.zeroByte();
            }

            public static final /* synthetic */ boolean $anonfun$_gunzip_readOptionalStringField$4($anon$1 $this, CRC32 crc32$9, byte by2) {
                crc32$9.update(by2);
                return by2 != $this.zeroByte();
            }

            private final Pull validateTrailer$1(Chunk trailerChunk, CRC32 crc32$11, Inflater inflater$8) {
                if (trailerChunk.size() == this.gzipTrailerBytes()) {
                    long expectedInputCrc32 = this.unsignedToLong(BoxesRunTime.unboxToByte(trailerChunk.apply(0)), BoxesRunTime.unboxToByte(trailerChunk.apply(1)), BoxesRunTime.unboxToByte(trailerChunk.apply(2)), BoxesRunTime.unboxToByte(trailerChunk.apply(3)));
                    long actualInputCrc32 = crc32$11.getValue();
                    long expectedInputSize = this.unsignedToLong(BoxesRunTime.unboxToByte(trailerChunk.apply(4)), BoxesRunTime.unboxToByte(trailerChunk.apply(5)), BoxesRunTime.unboxToByte(trailerChunk.apply(6)), BoxesRunTime.unboxToByte(trailerChunk.apply(7)));
                    long actualInputSize = inflater$8.getBytesWritten() & 0xFFFFFFFFL;
                    if (expectedInputCrc32 != actualInputCrc32) {
                        return Pull$.MODULE$.raiseError(new ZipException("Content failed CRC validation"), RaiseThrowable$.MODULE$.fromApplicativeError(this.F$1));
                    }
                    if (expectedInputSize != actualInputSize) {
                        return Pull$.MODULE$.raiseError(new ZipException("Content failed size validation"), RaiseThrowable$.MODULE$.fromApplicativeError(this.F$1));
                    }
                    return Pull$.MODULE$.done();
                }
                return Pull$.MODULE$.raiseError(new ZipException("Failed to read trailer (1)"), RaiseThrowable$.MODULE$.fromApplicativeError(this.F$1));
            }

            private final Function1 streamUntilTrailer$1(Chunk last2, Inflater inflater$8, CRC32 crc32$11) {
                return (Function1<Stream, Pull> & Serializable)x$11 -> Stream$ToPull$.MODULE$.uncons$extension(Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(x$11))).flatMap((Function1<Option, Pull> & Serializable)x0$1 -> {
                    Some some;
                    Tuple2 tuple2;
                    Option option = x0$1;
                    if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                        Chunk next = (Chunk)tuple2._1();
                        Stream rest = (Stream)tuple2._2();
                        if (inflater$8.finished()) {
                            if (next.size() >= this.gzipTrailerBytes()) {
                                if (last2.nonEmpty()) {
                                    return Pull$.MODULE$.output(last2).$greater$greater((Function0<Pull> & Serializable)() -> (Pull)this.streamUntilTrailer$1(next, inflater$8, crc32$11).apply(rest));
                                }
                                return (Pull)this.streamUntilTrailer$1(next, inflater$8, crc32$11).apply(rest);
                            }
                            return (Pull)this.streamUntilTrailer$1(last2.$plus$plus(next), inflater$8, crc32$11).apply(rest);
                        }
                        if (last2.nonEmpty()) {
                            return Pull$.MODULE$.output(last2).$greater$greater((Function0<Pull> & Serializable)() -> Pull$.MODULE$.output(next)).$greater$greater((Function0<Pull> & Serializable)() -> (Pull)this.streamUntilTrailer$1(Chunk$.MODULE$.empty(), inflater$8, crc32$11).apply(rest));
                        }
                        return Pull$.MODULE$.output(next).$greater$greater((Function0<Pull> & Serializable)() -> (Pull)this.streamUntilTrailer$1(Chunk$.MODULE$.empty(), inflater$8, crc32$11).apply(rest));
                    }
                    if (None$.MODULE$.equals(option)) {
                        int preTrailerBytes = last2.size() - this.gzipTrailerBytes();
                        if (preTrailerBytes > 0) {
                            return Pull$.MODULE$.output(last2.take(preTrailerBytes)).$greater$greater((Function0<Pull> & Serializable)() -> this.validateTrailer$1(last2.drop(preTrailerBytes), crc32$11, inflater$8));
                        }
                        return this.validateTrailer$1(last2, crc32$11, inflater$8);
                    }
                    throw new MatchError(option);
                });
            }

            private static final Pull go$1(List acc, Stream rest, int size, Function1 predicate$1, ClassTag evidence$4$1, int softLimit$1) {
                return Stream$ToPull$.MODULE$.uncons$extension(Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(rest))).flatMap((Function1<Option, Pull> & Serializable)x0$1 -> {
                    Some some;
                    Tuple2 tuple2;
                    Option option = x0$1;
                    if (None$.MODULE$.equals(option)) {
                        return Pull$.MODULE$.pure(None$.MODULE$);
                    }
                    if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                        Chunk hd = (Chunk)tuple2._1();
                        Stream tl = (Stream)tuple2._2();
                        Option<Object> option2 = hd.indexWhere(predicate$1);
                        if (option2 instanceof Some) {
                            Some some2 = (Some)option2;
                            int i = BoxesRunTime.unboxToInt(some2.value());
                            Tuple2<Chunk<O>, Chunk<O>> tuple22 = hd.splitAt(i);
                            if (tuple22 == null) {
                                throw new MatchError(tuple22);
                            }
                            Chunk<O> pfx = tuple22._1();
                            Chunk<O> sfx = tuple22._2();
                            Tuple2<Chunk<O>, Chunk<O>> tuple23 = new Tuple2<Chunk<O>, Chunk<O>>(pfx, sfx);
                            Chunk<O> pfx2 = tuple23._1();
                            Chunk<O> sfx2 = tuple23._2();
                            Chunk<O> chunk = pfx2;
                            return Pull$.MODULE$.pure(new Some<Tuple2<Chunk<A>, Stream<F, O>>>(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Chunk$.MODULE$.concat(acc.$colon$colon(chunk).reverse(), evidence$4$1)), tl.cons(sfx2))));
                        }
                        if (None$.MODULE$.equals(option2)) {
                            int newSize = size + hd.size();
                            if (newSize < softLimit$1) {
                                Chunk chunk = hd;
                                return $anon$1.go$1(acc.$colon$colon(chunk), tl, newSize, predicate$1, evidence$4$1, softLimit$1);
                            }
                            Chunk chunk = hd;
                            return Pull$.MODULE$.pure(new Some<Tuple2<Chunk<A>, Stream>>(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Chunk$.MODULE$.concat(acc.$colon$colon(chunk).reverse(), evidence$4$1)), tl)));
                        }
                        throw new MatchError(option2);
                    }
                    throw new MatchError(option);
                });
            }

            private static final int go$default$3$1() {
                return 0;
            }
            {
                this.F$1 = F$1;
                CompressionPlatform.$init$(this);
                Compression.$init$(this);
                this.gzipHeaderBytes = 10;
                this.gzipMagicFirstByte = (byte)31;
                this.gzipMagicSecondByte = (byte)139;
                this.gzipOptionalExtraFieldLengthBytes = 2;
                this.gzipHeaderCrcBytes = 2;
                this.gzipInputCrcBytes = 4;
                this.gzipInputSizeBytes = 4;
                this.gzipTrailerBytes = this.gzipInputCrcBytes() + this.gzipInputSizeBytes();
                this.zeroByte = 0;
                this.fileNameBytesSoftLimit = 1024;
                this.fileCommentBytesSoftLimit = 0x100000;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$_deflate$1(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.compression.DeflateParams java.util.zip.Deflater scala.Option fs2.Stream ), $anonfun$_deflate$2(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.compression.DeflateParams java.util.zip.Deflater scala.Option fs2.Stream ), $anonfun$_deflate_chunk$1$adapted(fs2.Chunk$ArraySlice java.util.zip.CRC32 ), $anonfun$_deflate_chunk$2(fs2.compression.CompressionCompanionPlatform$$anon$1 byte[] java.util.zip.Deflater fs2.compression.DeflateParams boolean ), $anonfun$_deflate_stream$1(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.compression.DeflateParams java.util.zip.Deflater scala.Option byte[] fs2.Stream ), $anonfun$_deflate_stream$2(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.compression.DeflateParams java.util.zip.Deflater scala.Option byte[] scala.Option ), $anonfun$_deflate_stream$3(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.compression.DeflateParams java.util.zip.Deflater scala.Option byte[] fs2.Stream ), $anonfun$_gunzip_matchMandatoryHeader$1(fs2.compression.CompressionCompanionPlatform$$anon$1 scala.Option ), $anonfun$_gunzip_readOptionalHeader$1(fs2.compression.CompressionCompanionPlatform$$anon$1 byte java.util.zip.CRC32 long fs2.compression.InflateParams java.util.zip.Inflater java.util.zip.CRC32 scala.Tuple2 ), $anonfun$_gunzip_readOptionalHeader$2(fs2.compression.CompressionCompanionPlatform$$anon$1 long scala.Option byte java.util.zip.CRC32 fs2.compression.InflateParams java.util.zip.Inflater java.util.zip.CRC32 scala.Tuple2 ), $anonfun$_gunzip_readOptionalHeader$3(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.compression.InflateParams java.util.zip.Inflater java.util.zip.CRC32 fs2.Stream ), $anonfun$_gunzip_readOptionalStringField$1(fs2.compression.CompressionCompanionPlatform$$anon$1 boolean int java.util.zip.CRC32 java.lang.String fs2.Stream ), $anonfun$_gunzip_readOptionalStringField$2$adapted(fs2.compression.CompressionCompanionPlatform$$anon$1 java.lang.Object ), $anonfun$_gunzip_readOptionalStringField$3(fs2.compression.CompressionCompanionPlatform$$anon$1 java.util.zip.CRC32 java.lang.String scala.Option ), $anonfun$_gunzip_readOptionalStringField$4$adapted(fs2.compression.CompressionCompanionPlatform$$anon$1 java.util.zip.CRC32 java.lang.Object ), $anonfun$_gunzip_skipOptionalExtraField$1(fs2.compression.CompressionCompanionPlatform$$anon$1 boolean java.util.zip.CRC32 fs2.Stream ), $anonfun$_gunzip_skipOptionalExtraField$2(fs2.compression.CompressionCompanionPlatform$$anon$1 java.util.zip.CRC32 scala.Option ), $anonfun$_gunzip_skipOptionalExtraField$3(fs2.compression.CompressionCompanionPlatform$$anon$1 java.util.zip.CRC32 scala.Option ), $anonfun$_gunzip_validateHeader$1(fs2.compression.CompressionCompanionPlatform$$anon$1 boolean java.util.zip.CRC32 fs2.Stream ), $anonfun$_gunzip_validateHeader$2(fs2.compression.CompressionCompanionPlatform$$anon$1 java.util.zip.CRC32 scala.Option ), $anonfun$_gunzip_validateTrailer$1(fs2.compression.CompressionCompanionPlatform$$anon$1 java.util.zip.CRC32 java.util.zip.Inflater fs2.Stream ), $anonfun$_gunzip_validateTrailer$2(fs2.compression.CompressionCompanionPlatform$$anon$1 java.util.zip.Inflater fs2.Chunk java.util.zip.CRC32 fs2.Stream ), $anonfun$_gunzip_validateTrailer$3(fs2.compression.CompressionCompanionPlatform$$anon$1 java.util.zip.Inflater fs2.Chunk java.util.zip.CRC32 scala.Option ), $anonfun$_gunzip_validateTrailer$4(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.Chunk fs2.Stream java.util.zip.Inflater java.util.zip.CRC32 ), $anonfun$_gunzip_validateTrailer$5(fs2.Chunk ), $anonfun$_gunzip_validateTrailer$6(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.Stream java.util.zip.Inflater java.util.zip.CRC32 ), $anonfun$_gunzip_validateTrailer$7(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.Stream java.util.zip.Inflater java.util.zip.CRC32 ), $anonfun$_gunzip_validateTrailer$8(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.Chunk int java.util.zip.CRC32 java.util.zip.Inflater ), $anonfun$_gzip_header$1$adapted(java.time.Instant ), $anonfun$_gzip_header$10(fs2.compression.CompressionCompanionPlatform$$anon$1 byte[] ), $anonfun$_gzip_header$11(fs2.compression.CompressionCompanionPlatform$$anon$1 ), $anonfun$_gzip_header$12(), $anonfun$_gzip_header$13(fs2.compression.CompressionCompanionPlatform$$anon$1 scala.Option ), $anonfun$_gzip_header$14(fs2.compression.CompressionCompanionPlatform$$anon$1 byte[] ), $anonfun$_gzip_header$15(fs2.compression.CompressionCompanionPlatform$$anon$1 ), $anonfun$_gzip_header$16(), $anonfun$_gzip_header$17(fs2.compression.CompressionCompanionPlatform$$anon$1 byte[] ), $anonfun$_gzip_header$2(), $anonfun$_gzip_header$3$adapted(fs2.compression.CompressionCompanionPlatform$$anon$1 java.lang.String ), $anonfun$_gzip_header$4(fs2.compression.CompressionCompanionPlatform$$anon$1 ), $anonfun$_gzip_header$5$adapted(fs2.compression.CompressionCompanionPlatform$$anon$1 java.lang.String ), $anonfun$_gzip_header$6(fs2.compression.CompressionCompanionPlatform$$anon$1 ), $anonfun$_gzip_header$7(fs2.compression.CompressionCompanionPlatform$$anon$1 java.util.zip.CRC32 java.lang.String ), $anonfun$_gzip_header$8(fs2.compression.CompressionCompanionPlatform$$anon$1 java.util.zip.CRC32 java.lang.String ), $anonfun$_gzip_header$9(fs2.compression.CompressionCompanionPlatform$$anon$1 scala.Option ), $anonfun$_inflate$1(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.compression.InflateParams java.util.zip.Inflater scala.Option fs2.Stream ), $anonfun$_inflate$2(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.compression.InflateParams fs2.Stream java.util.zip.Inflater scala.Option ), $anonfun$_inflate$3(fs2.compression.CompressionCompanionPlatform$$anon$1 java.util.zip.Inflater scala.Option byte[] fs2.compression.InflateParams scala.Option ), $anonfun$_inflate$4(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.compression.InflateParams java.util.zip.Inflater scala.Option byte[] fs2.Stream ), $anonfun$_inflate_chunk$1$adapted(byte[] int java.util.zip.CRC32 ), $anonfun$_inflate_chunk$2(fs2.Chunk$ArraySlice int ), $anonfun$_inflate_chunk$3(fs2.compression.CompressionCompanionPlatform$$anon$1 java.util.zip.Inflater fs2.Chunk$ArraySlice byte[] scala.Option ), $anonfun$_inflate_stream$1(fs2.compression.CompressionCompanionPlatform$$anon$1 java.util.zip.Inflater scala.Option byte[] fs2.compression.InflateParams fs2.Stream ), $anonfun$_inflate_stream$2(fs2.compression.CompressionCompanionPlatform$$anon$1 java.util.zip.Inflater scala.Option byte[] fs2.compression.InflateParams scala.Option ), $anonfun$_inflate_stream$3(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.compression.InflateParams java.util.zip.Inflater scala.Option byte[] fs2.Stream ), $anonfun$deflate$1(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.compression.DeflateParams fs2.Stream ), $anonfun$deflate$2(fs2.compression.DeflateParams ), $anonfun$deflate$3(fs2.compression.CompressionCompanionPlatform$$anon$1 java.util.zip.Deflater ), $anonfun$deflate$4(java.util.zip.Deflater ), $anonfun$deflate$5(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.compression.DeflateParams fs2.Stream java.util.zip.Deflater ), $anonfun$gunzip$1(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.compression.InflateParams fs2.Stream ), $anonfun$gunzip$2(), $anonfun$gunzip$3(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.Stream fs2.compression.InflateParams scala.Tuple3 ), $anonfun$gunzip$4(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.compression.InflateParams java.util.zip.CRC32 java.util.zip.CRC32 java.util.zip.Inflater scala.Option ), $anonfun$gunzip$5(fs2.compression.CompressionCompanionPlatform$$anon$1 scala.Tuple3 cats.effect.kernel.Resource$ExitCase ), $anonfun$gunzip$6(java.util.zip.Inflater ), $anonfun$gzip$10(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.compression.DeflateParams java.util.zip.Deflater java.util.zip.CRC32 fs2.Stream ), $anonfun$gzip$11(fs2.compression.CompressionCompanionPlatform$$anon$1 java.util.zip.Deflater java.util.zip.CRC32 ), $anonfun$gzip$5(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.compression.DeflateParams scala.Option scala.Option scala.Option fs2.Stream ), $anonfun$gzip$6(fs2.compression.DeflateParams ), $anonfun$gzip$7(fs2.compression.CompressionCompanionPlatform$$anon$1 scala.Tuple2 ), $anonfun$gzip$8(java.util.zip.Deflater ), $anonfun$gzip$9(fs2.compression.CompressionCompanionPlatform$$anon$1 scala.Option scala.Option scala.Option fs2.compression.DeflateParams fs2.Stream scala.Tuple2 ), $anonfun$inflate$1(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.compression.InflateParams fs2.Stream ), $anonfun$inflate$2(fs2.compression.InflateParams ), $anonfun$inflate$3(fs2.compression.CompressionCompanionPlatform$$anon$1 fs2.compression.InflateParams fs2.Stream java.util.zip.Inflater ), $anonfun$inflate$4(fs2.compression.CompressionCompanionPlatform$$anon$1 java.util.zip.Inflater cats.effect.kernel.Resource$ExitCase ), $anonfun$inflate$5(java.util.zip.Inflater ), $anonfun$unconsUntil$1(scala.Function1 scala.reflect.ClassTag int fs2.Stream ), $anonfun$unconsUntil$2(scala.Function1 scala.collection.immutable.List scala.reflect.ClassTag int int scala.Option )}, serializedLambda);
            }
        };
    }

    public static void $init$(CompressionCompanionPlatform $this) {
    }
}

