/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.locale.converters;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Locale;
import org.apache.commons.beanutils.locale.BaseLocaleConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DecimalLocaleConverter
extends BaseLocaleConverter {
    private final Log log = LogFactory.getLog(DecimalLocaleConverter.class);

    public DecimalLocaleConverter() {
        this(false);
    }

    public DecimalLocaleConverter(boolean locPattern) {
        this(Locale.getDefault(), locPattern);
    }

    public DecimalLocaleConverter(Locale locale) {
        this(locale, false);
    }

    public DecimalLocaleConverter(Locale locale, boolean locPattern) {
        this(locale, (String)null, locPattern);
    }

    public DecimalLocaleConverter(Locale locale, String pattern) {
        this(locale, pattern, false);
    }

    public DecimalLocaleConverter(Locale locale, String pattern, boolean locPattern) {
        super(locale, pattern, locPattern);
    }

    public DecimalLocaleConverter(Object defaultValue2) {
        this(defaultValue2, false);
    }

    public DecimalLocaleConverter(Object defaultValue2, boolean locPattern) {
        this(defaultValue2, Locale.getDefault(), locPattern);
    }

    public DecimalLocaleConverter(Object defaultValue2, Locale locale) {
        this(defaultValue2, locale, false);
    }

    public DecimalLocaleConverter(Object defaultValue2, Locale locale, boolean locPattern) {
        this(defaultValue2, locale, null, locPattern);
    }

    public DecimalLocaleConverter(Object defaultValue2, Locale locale, String pattern) {
        this(defaultValue2, locale, pattern, false);
    }

    public DecimalLocaleConverter(Object defaultValue2, Locale locale, String pattern, boolean locPattern) {
        super(defaultValue2, locale, pattern, locPattern);
    }

    @Override
    protected Object parse(Object value, String pattern) throws ParseException {
        if (value instanceof Number) {
            return value;
        }
        DecimalFormat formatter = (DecimalFormat)DecimalFormat.getInstance(this.locale);
        if (pattern != null) {
            if (this.locPattern) {
                formatter.applyLocalizedPattern(pattern);
            } else {
                formatter.applyPattern(pattern);
            }
        } else {
            this.log.debug("No pattern provided, using default.");
        }
        return formatter.parse((String)value);
    }
}

