/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.TokenStreamToAutomaton;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeReflector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.LimitedFiniteStringsIterator;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.Transition;
import org.apache.lucene.util.fst.Util;

public final class ConcatenateGraphFilter
extends TokenStream {
    public static final int SEP_LABEL = 31;
    public static final int DEFAULT_MAX_GRAPH_EXPANSIONS = 10000;
    public static final boolean DEFAULT_PRESERVE_SEP = true;
    public static final boolean DEFAULT_PRESERVE_POSITION_INCREMENTS = true;
    private final BytesRefBuilderTermAttribute bytesAtt = this.addAttribute(BytesRefBuilderTermAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = this.addAttribute(PositionIncrementAttribute.class);
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);
    private final TokenStream inputTokenStream;
    private final boolean preserveSep;
    private final boolean preservePositionIncrements;
    private final int maxGraphExpansions;
    private LimitedFiniteStringsIterator finiteStrings;
    private CharTermAttribute charTermAttribute;
    private boolean wasReset = false;
    private int endOffset;

    public ConcatenateGraphFilter(TokenStream inputTokenStream) {
        this(inputTokenStream, true, true, 10000);
    }

    public ConcatenateGraphFilter(TokenStream inputTokenStream, boolean preserveSep, boolean preservePositionIncrements, int maxGraphExpansions) {
        this.inputTokenStream = inputTokenStream;
        this.preserveSep = preserveSep;
        this.preservePositionIncrements = preservePositionIncrements;
        this.maxGraphExpansions = maxGraphExpansions;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.charTermAttribute = this.getAttribute(CharTermAttribute.class);
        this.wasReset = true;
    }

    @Override
    public boolean incrementToken() throws IOException {
        IntsRef string;
        if (this.finiteStrings == null) {
            if (!this.wasReset) {
                throw new IllegalStateException("reset() missing before incrementToken");
            }
            Automaton automaton = this.toAutomaton();
            this.finiteStrings = new LimitedFiniteStringsIterator(automaton, this.maxGraphExpansions);
            this.endOffset = this.inputTokenStream.getAttribute(OffsetAttribute.class).endOffset();
        }
        if ((string = this.finiteStrings.next()) == null) {
            return false;
        }
        this.clearAttributes();
        if (this.finiteStrings.size() > 1) {
            this.posIncrAtt.setPositionIncrement(0);
        }
        this.offsetAtt.setOffset(0, this.endOffset);
        Util.toBytesRef(string, this.bytesAtt.builder());
        if (this.charTermAttribute != null) {
            this.charTermAttribute.setLength(0);
            this.charTermAttribute.append(this.bytesAtt.toUTF16());
        }
        return true;
    }

    @Override
    public void end() throws IOException {
        super.end();
        if (this.finiteStrings == null) {
            this.inputTokenStream.end();
        }
        if (this.endOffset != -1) {
            this.offsetAtt.setOffset(0, this.endOffset);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.inputTokenStream.close();
        this.finiteStrings = null;
        this.wasReset = false;
        this.endOffset = -1;
    }

    public Automaton toAutomaton() throws IOException {
        return this.toAutomaton(false);
    }

    public Automaton toAutomaton(boolean unicodeAware) throws IOException {
        TokenStreamToAutomaton tsta = this.preserveSep ? new EscapingTokenStreamToAutomaton(31) : new TokenStreamToAutomaton();
        tsta.setPreservePositionIncrements(this.preservePositionIncrements);
        tsta.setUnicodeArcs(unicodeAware);
        Automaton automaton = tsta.toAutomaton(this.inputTokenStream);
        automaton = ConcatenateGraphFilter.replaceSep(automaton, this.preserveSep, 31);
        return Operations.determinize(automaton, this.maxGraphExpansions);
    }

    private static Automaton replaceSep(Automaton a, boolean preserveSep, int sepLabel) {
        Automaton result2 = new Automaton();
        int numStates = a.getNumStates();
        for (int s2 = 0; s2 < numStates; ++s2) {
            result2.createState();
            result2.setAccept(s2, a.isAccept(s2));
        }
        Transition t = new Transition();
        int[] topoSortStates = Operations.topoSortStates(a);
        for (int i = 0; i < topoSortStates.length; ++i) {
            int state = topoSortStates[topoSortStates.length - 1 - i];
            int count = a.initTransition(state, t);
            for (int j = 0; j < count; ++j) {
                a.getNextTransition(t);
                if (t.min == 31) {
                    assert (t.max == 31);
                    if (preserveSep) {
                        result2.addTransition(state, t.dest, sepLabel);
                        continue;
                    }
                    result2.addEpsilon(state, t.dest);
                    continue;
                }
                if (t.min == 30) {
                    assert (t.max == 30);
                    result2.addEpsilon(state, t.dest);
                    continue;
                }
                result2.addTransition(state, t.dest, t.min, t.max);
            }
        }
        result2.finishState();
        return result2;
    }

    public static final class BytesRefBuilderTermAttributeImpl
    extends AttributeImpl
    implements BytesRefBuilderTermAttribute,
    TermToBytesRefAttribute {
        private final BytesRefBuilder bytes = new BytesRefBuilder();
        private transient CharsRefBuilder charsRef;

        @Override
        public BytesRefBuilder builder() {
            return this.bytes;
        }

        @Override
        public BytesRef getBytesRef() {
            return this.bytes.get();
        }

        @Override
        public void clear() {
            this.bytes.clear();
        }

        @Override
        public void copyTo(AttributeImpl target) {
            BytesRefBuilderTermAttributeImpl other = (BytesRefBuilderTermAttributeImpl)target;
            other.bytes.copyBytes(this.bytes);
        }

        @Override
        public AttributeImpl clone() {
            BytesRefBuilderTermAttributeImpl other = new BytesRefBuilderTermAttributeImpl();
            this.copyTo(other);
            return other;
        }

        @Override
        public void reflectWith(AttributeReflector reflector) {
            reflector.reflect(TermToBytesRefAttribute.class, "bytes", this.getBytesRef());
        }

        @Override
        public CharSequence toUTF16() {
            if (this.charsRef == null) {
                this.charsRef = new CharsRefBuilder();
            }
            this.charsRef.copyUTF8Bytes(this.getBytesRef());
            return this.charsRef.get();
        }
    }

    public static interface BytesRefBuilderTermAttribute
    extends TermToBytesRefAttribute {
        public BytesRefBuilder builder();

        public CharSequence toUTF16();
    }

    private static final class EscapingTokenStreamToAutomaton
    extends TokenStreamToAutomaton {
        final BytesRefBuilder spare = new BytesRefBuilder();
        final byte sepLabel;

        public EscapingTokenStreamToAutomaton(int sepLabel) {
            assert (sepLabel <= 127);
            this.sepLabel = (byte)sepLabel;
        }

        @Override
        protected BytesRef changeToken(BytesRef in) {
            int upto = 0;
            for (int i = 0; i < in.length; ++i) {
                byte b = in.bytes[in.offset + i];
                if (b == this.sepLabel) {
                    this.spare.grow(upto + 2);
                    this.spare.setByteAt(upto++, this.sepLabel);
                    this.spare.setByteAt(upto++, b);
                    continue;
                }
                this.spare.grow(upto + 1);
                this.spare.setByteAt(upto++, b);
            }
            this.spare.setLength(upto);
            return this.spare.get();
        }
    }
}

