/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.geo.XYEncodingUtils;
import org.apache.lucene.geo.XYPolygon;
import org.apache.lucene.util.BitUtil;

public final class Tessellator {
    private static final int VERTEX_THRESHOLD = 80;

    private Tessellator() {
    }

    public static final List<Triangle> tessellate(Polygon polygon) {
        List<Triangle> result2;
        boolean mortonOptimized;
        Node outerNode = Tessellator.createDoublyLinkedList(polygon.getPolyLons(), polygon.getPolyLats(), polygon.getWindingOrder(), true, 0, GeoUtils.WindingOrder.CW);
        if (outerNode == null) {
            throw new IllegalArgumentException("Malformed shape detected in Tessellator!");
        }
        if (polygon.numHoles() > 0) {
            outerNode = Tessellator.eliminateHoles(polygon, outerNode);
        }
        int threshold = 80 - polygon.numPoints();
        for (int i = 0; threshold >= 0 && i < polygon.numHoles(); threshold -= polygon.getHole(i).numPoints(), ++i) {
        }
        boolean bl = mortonOptimized = threshold < 0;
        if (mortonOptimized) {
            Tessellator.sortByMorton(outerNode);
        }
        if ((result2 = Tessellator.earcutLinkedList(polygon, outerNode, new ArrayList<Triangle>(), State.INIT, mortonOptimized)).size() == 0) {
            throw new IllegalArgumentException("Unable to Tessellate shape [" + polygon + "]. Possible malformed shape detected.");
        }
        return result2;
    }

    public static final List<Triangle> tessellate(XYPolygon polygon) {
        List<Triangle> result2;
        boolean mortonOptimized;
        Node outerNode = Tessellator.createDoublyLinkedList(polygon.getPolyX(), polygon.getPolyY(), polygon.getWindingOrder(), false, 0, GeoUtils.WindingOrder.CW);
        if (outerNode == null) {
            throw new IllegalArgumentException("Malformed shape detected in Tessellator!");
        }
        if (polygon.numHoles() > 0) {
            outerNode = Tessellator.eliminateHoles(polygon, outerNode);
        }
        int threshold = 80 - polygon.numPoints();
        for (int i = 0; threshold >= 0 && i < polygon.numHoles(); threshold -= polygon.getHole(i).numPoints(), ++i) {
        }
        boolean bl = mortonOptimized = threshold < 0;
        if (mortonOptimized) {
            Tessellator.sortByMorton(outerNode);
        }
        if ((result2 = Tessellator.earcutLinkedList(polygon, outerNode, new ArrayList<Triangle>(), State.INIT, mortonOptimized)).size() == 0) {
            throw new IllegalArgumentException("Unable to Tessellate shape [" + polygon + "]. Possible malformed shape detected.");
        }
        return result2;
    }

    private static final Node createDoublyLinkedList(double[] x2, double[] y, GeoUtils.WindingOrder polyWindingOrder, boolean isGeo, int startIndex, GeoUtils.WindingOrder windingOrder) {
        Node lastNode = null;
        if (windingOrder == polyWindingOrder) {
            for (int i = 0; i < x2.length; ++i) {
                lastNode = Tessellator.insertNode(x2, y, startIndex++, i, lastNode, isGeo);
            }
        } else {
            for (int i = x2.length - 1; i >= 0; --i) {
                lastNode = Tessellator.insertNode(x2, y, startIndex++, i, lastNode, isGeo);
            }
        }
        if (lastNode != null && Tessellator.isVertexEquals(lastNode, lastNode.next)) {
            Tessellator.removeNode(lastNode);
            lastNode = lastNode.next;
        }
        return Tessellator.filterPoints(lastNode, null);
    }

    private static final Node eliminateHoles(XYPolygon polygon, Node outerNode) {
        ArrayList<Node> holeList = new ArrayList<Node>();
        HashMap<Node, XYPolygon> holeListPolygons = new HashMap<Node, XYPolygon>();
        XYPolygon[] holes = polygon.getHoles();
        int nodeIndex = polygon.numPoints();
        for (int i = 0; i < polygon.numHoles(); ++i) {
            Node list = Tessellator.createDoublyLinkedList(holes[i].getPolyX(), holes[i].getPolyY(), holes[i].getWindingOrder(), false, nodeIndex, GeoUtils.WindingOrder.CCW);
            if (list != null) {
                Node leftMost = Tessellator.fetchLeftmost(list);
                holeList.add(leftMost);
                holeListPolygons.put(leftMost, holes[i]);
            }
            nodeIndex += holes[i].numPoints();
        }
        return Tessellator.eliminateHoles(holeList, holeListPolygons, outerNode);
    }

    private static final Node eliminateHoles(Polygon polygon, Node outerNode) {
        ArrayList<Node> holeList = new ArrayList<Node>();
        HashMap<Node, Polygon> holeListPolygons = new HashMap<Node, Polygon>();
        Polygon[] holes = polygon.getHoles();
        int nodeIndex = polygon.numPoints();
        for (int i = 0; i < polygon.numHoles(); ++i) {
            Node list = Tessellator.createDoublyLinkedList(holes[i].getPolyLons(), holes[i].getPolyLats(), holes[i].getWindingOrder(), true, nodeIndex, GeoUtils.WindingOrder.CCW);
            if (list == list.next) {
                throw new IllegalArgumentException("Points are all coplanar in hole: " + holes[i]);
            }
            if (list != null) {
                Node leftMost = Tessellator.fetchLeftmost(list);
                holeList.add(leftMost);
                holeListPolygons.put(leftMost, holes[i]);
            }
            nodeIndex += holes[i].numPoints();
        }
        return Tessellator.eliminateHoles(holeList, holeListPolygons, outerNode);
    }

    private static final Node eliminateHoles(List<Node> holeList, Map<Node, ?> holeListPolygons, Node outerNode) {
        holeList.sort((pNodeA, pNodeB) -> {
            double diff = pNodeA.getX() - pNodeB.getX();
            if (diff == 0.0 && (diff = pNodeA.getY() - pNodeB.getY()) == 0.0) {
                double a = Math.min(((Node)pNodeA).previous.getY(), ((Node)pNodeA).next.getY());
                double b = Math.min(((Node)pNodeB).previous.getY(), ((Node)pNodeB).next.getY());
                diff = a - b;
            }
            return diff < 0.0 ? -1 : (diff > 0.0 ? 1 : 0);
        });
        for (int i = 0; i < holeList.size(); ++i) {
            double holeMaxY;
            double holeMinY;
            double holeMaxX;
            double holeMinX;
            Object holePoly;
            Node holeNode = holeList.get(i);
            Object h = holeListPolygons.get(holeNode);
            if (h instanceof Polygon) {
                holePoly = (Polygon)h;
                holeMinX = ((Polygon)holePoly).minLon;
                holeMaxX = ((Polygon)holePoly).maxLon;
                holeMinY = ((Polygon)holePoly).minLat;
                holeMaxY = ((Polygon)holePoly).maxLat;
            } else {
                holePoly = (XYPolygon)h;
                holeMinX = ((XYPolygon)holePoly).minX;
                holeMaxX = ((XYPolygon)holePoly).maxX;
                holeMinY = ((XYPolygon)holePoly).minY;
                holeMaxY = ((XYPolygon)holePoly).maxY;
            }
            Tessellator.eliminateHole(holeNode, outerNode, holeMinX, holeMaxX, holeMinY, holeMaxY);
            outerNode = Tessellator.filterPoints(outerNode, outerNode.next);
        }
        return outerNode;
    }

    private static final void eliminateHole(Node holeNode, Node outerNode, double holeMinX, double holeMaxX, double holeMinY, double holeMaxY) {
        Node next = outerNode;
        do {
            Node sharedVertex;
            if (!Rectangle.containsPoint(next.getY(), next.getX(), holeMinY, holeMaxY, holeMinX, holeMaxX) || (sharedVertex = Tessellator.getSharedVertex(holeNode, next)) == null) continue;
            Node node = Tessellator.splitPolygon(next, sharedVertex);
            Tessellator.filterPoints(node, node.next);
            return;
        } while ((next = next.next) != outerNode);
        if ((outerNode = Tessellator.fetchHoleBridge(holeNode, outerNode)) != null) {
            Node node = Tessellator.splitPolygon(outerNode, holeNode);
            Tessellator.filterPoints(node, node.next);
        }
    }

    private static final Node fetchHoleBridge(Node holeNode, Node outerNode) {
        Node p = outerNode;
        double qx = Double.NEGATIVE_INFINITY;
        double hx = holeNode.getX();
        double hy = holeNode.getY();
        Node connection = null;
        do {
            double x2;
            if (!(hy <= p.getY()) || !(hy >= p.next.getY()) || p.next.getY() == p.getY() || !((x2 = p.getX() + (hy - p.getY()) * (p.next.getX() - p.getX()) / (p.next.getY() - p.getY())) <= hx) || !(x2 > qx)) continue;
            qx = x2;
            if (x2 == hx) {
                if (hy == p.getY()) {
                    return p;
                }
                if (hy == p.next.getY()) {
                    return p.next;
                }
            }
            Node node = connection = p.getX() < p.next.getX() ? p : p.next;
        } while ((p = p.next) != outerNode);
        if (connection == null) {
            return null;
        }
        if (hx == qx) {
            return connection.previous;
        }
        Node stop = connection;
        double mx = connection.getX();
        double my = connection.getY();
        double tanMin = Double.POSITIVE_INFINITY;
        p = connection.next;
        while (p != stop) {
            double tan;
            if (hx >= p.getX() && p.getX() >= mx && hx != p.getX() && Tessellator.pointInEar(p.getX(), p.getY(), hy < my ? hx : qx, hy, mx, my, hy < my ? qx : hx, hy) && ((tan = Math.abs(hy - p.getY()) / (hx - p.getX())) < tanMin || tan == tanMin && p.getX() > connection.getX()) && Tessellator.isLocallyInside(p, holeNode)) {
                connection = p;
                tanMin = tan;
            }
            p = p.next;
        }
        return connection;
    }

    private static Node getSharedVertex(Node polygon, Node vertex) {
        Node next = polygon;
        do {
            if (!Tessellator.isVertexEquals(next, vertex)) continue;
            return next;
        } while ((next = next.next) != polygon);
        return null;
    }

    private static final Node fetchLeftmost(Node start) {
        Node node = start;
        Node leftMost = start;
        do {
            if (!(node.getX() < leftMost.getX()) && (node.getX() != leftMost.getX() || !(node.getY() < leftMost.getY()))) continue;
            leftMost = node;
        } while ((node = node.next) != start);
        return leftMost;
    }

    private static final List<Triangle> earcutLinkedList(Object polygon, Node currEar, List<Triangle> tessellation, State state, boolean mortonOptimized) {
        block9: {
            block5: while (true) {
                if (currEar == null || currEar.previous == currEar.next) {
                    return tessellation;
                }
                Node stop = currEar;
                do {
                    boolean isReflex;
                    Node prevNode = currEar.previous;
                    Node nextNode = currEar.next;
                    boolean bl = isReflex = Tessellator.area(prevNode.getX(), prevNode.getY(), currEar.getX(), currEar.getY(), nextNode.getX(), nextNode.getY()) >= 0.0;
                    if (!isReflex && Tessellator.isEar(currEar, mortonOptimized)) {
                        tessellation.add(new Triangle(prevNode, currEar, nextNode));
                        Tessellator.removeNode(currEar);
                        currEar = nextNode.next;
                        stop = nextNode.next;
                        continue;
                    }
                    currEar = nextNode;
                    if (currEar != stop) continue;
                    switch (state) {
                        case INIT: {
                            currEar = Tessellator.filterPoints(currEar, null);
                            state = State.CURE;
                            continue block5;
                        }
                        case CURE: {
                            currEar = Tessellator.cureLocalIntersections(currEar, tessellation);
                            state = State.SPLIT;
                            continue block5;
                        }
                        case SPLIT: {
                            if (Tessellator.splitEarcut(polygon, currEar, tessellation, mortonOptimized)) break;
                            throw new IllegalArgumentException("Unable to Tessellate shape [" + polygon + "]. Possible malformed shape detected.");
                        }
                    }
                    break block9;
                } while (currEar.previous != currEar.next);
                break;
            }
        }
        return tessellation;
    }

    private static final boolean isEar(Node ear, boolean mortonOptimized) {
        if (mortonOptimized) {
            return Tessellator.mortonIsEar(ear);
        }
        Node node = ear.next.next;
        while (node != ear.previous) {
            if (Tessellator.pointInEar(node.getX(), node.getY(), ear.previous.getX(), ear.previous.getY(), ear.getX(), ear.getY(), ear.next.getX(), ear.next.getY()) && Tessellator.area(node.previous.getX(), node.previous.getY(), node.getX(), node.getY(), node.next.getX(), node.next.getY()) >= 0.0) {
                return false;
            }
            node = node.next;
        }
        return true;
    }

    private static final boolean mortonIsEar(Node ear) {
        int minTX = StrictMath.min(StrictMath.min(ear.previous.x, ear.x), ear.next.x) ^ Integer.MIN_VALUE;
        int minTY = StrictMath.min(StrictMath.min(ear.previous.y, ear.y), ear.next.y) ^ Integer.MIN_VALUE;
        int maxTX = StrictMath.max(StrictMath.max(ear.previous.x, ear.x), ear.next.x) ^ Integer.MIN_VALUE;
        int maxTY = StrictMath.max(StrictMath.max(ear.previous.y, ear.y), ear.next.y) ^ Integer.MIN_VALUE;
        long minZ = BitUtil.interleave(minTX, minTY);
        long maxZ = BitUtil.interleave(maxTX, maxTY);
        Node p = ear.previousZ;
        Node n = ear.nextZ;
        while (p != null && Long.compareUnsigned(p.morton, minZ) >= 0 && n != null && Long.compareUnsigned(n.morton, maxZ) <= 0) {
            if (p.idx != ear.previous.idx && p.idx != ear.next.idx && Tessellator.pointInEar(p.getX(), p.getY(), ear.previous.getX(), ear.previous.getY(), ear.getX(), ear.getY(), ear.next.getX(), ear.next.getY()) && Tessellator.area(p.previous.getX(), p.previous.getY(), p.getX(), p.getY(), p.next.getX(), p.next.getY()) >= 0.0) {
                return false;
            }
            p = p.previousZ;
            if (n.idx != ear.previous.idx && n.idx != ear.next.idx && Tessellator.pointInEar(n.getX(), n.getY(), ear.previous.getX(), ear.previous.getY(), ear.getX(), ear.getY(), ear.next.getX(), ear.next.getY()) && Tessellator.area(n.previous.getX(), n.previous.getY(), n.getX(), n.getY(), n.next.getX(), n.next.getY()) >= 0.0) {
                return false;
            }
            n = n.nextZ;
        }
        while (p != null && Long.compareUnsigned(p.morton, minZ) >= 0) {
            if (p.idx != ear.previous.idx && p.idx != ear.next.idx && Tessellator.pointInEar(p.getX(), p.getY(), ear.previous.getX(), ear.previous.getY(), ear.getX(), ear.getY(), ear.next.getX(), ear.next.getY()) && Tessellator.area(p.previous.getX(), p.previous.getY(), p.getX(), p.getY(), p.next.getX(), p.next.getY()) >= 0.0) {
                return false;
            }
            p = p.previousZ;
        }
        while (n != null && Long.compareUnsigned(n.morton, maxZ) <= 0) {
            if (n.idx != ear.previous.idx && n.idx != ear.next.idx && Tessellator.pointInEar(n.getX(), n.getY(), ear.previous.getX(), ear.previous.getY(), ear.getX(), ear.getY(), ear.next.getX(), ear.next.getY()) && Tessellator.area(n.previous.getX(), n.previous.getY(), n.getX(), n.getY(), n.next.getX(), n.next.getY()) >= 0.0) {
                return false;
            }
            n = n.nextZ;
        }
        return true;
    }

    private static final Node cureLocalIntersections(Node startNode, List<Triangle> tessellation) {
        Node node = startNode;
        do {
            Node b;
            Node nextNode = node.next;
            Node a = node.previous;
            if (Tessellator.isVertexEquals(a, b = nextNode.next) || Tessellator.isIntersectingPolygon(a, a.getX(), a.getY(), b.getX(), b.getY()) || !Tessellator.linesIntersect(a.getX(), a.getY(), node.getX(), node.getY(), nextNode.getX(), nextNode.getY(), b.getX(), b.getY()) || !Tessellator.isLocallyInside(a, b) || !Tessellator.isLocallyInside(b, a)) continue;
            tessellation.add(new Triangle(a, node, b));
            Tessellator.removeNode(node);
            Tessellator.removeNode(node.next);
            node = startNode = b;
        } while ((node = node.next) != startNode);
        return node;
    }

    private static final boolean splitEarcut(Object polygon, Node start, List<Triangle> tessellation, boolean mortonIndexed) {
        Node searchNode = start;
        do {
            Node nextNode = searchNode.next;
            Node diagonal = nextNode.next;
            while (diagonal != searchNode.previous) {
                if (searchNode.idx != diagonal.idx && Tessellator.isValidDiagonal(searchNode, diagonal)) {
                    Node splitNode = Tessellator.splitPolygon(searchNode, diagonal);
                    searchNode = Tessellator.filterPoints(searchNode, searchNode.next);
                    splitNode = Tessellator.filterPoints(splitNode, splitNode.next);
                    if (mortonIndexed) {
                        Tessellator.sortByMortonWithReset(searchNode);
                        Tessellator.sortByMortonWithReset(splitNode);
                    }
                    Tessellator.earcutLinkedList(polygon, searchNode, tessellation, State.INIT, mortonIndexed);
                    Tessellator.earcutLinkedList(polygon, splitNode, tessellation, State.INIT, mortonIndexed);
                    return true;
                }
                diagonal = diagonal.next;
            }
        } while ((searchNode = searchNode.next) != start);
        return false;
    }

    private static final Node splitPolygon(Node a, Node b) {
        Node a2 = new Node(a);
        Node b2 = new Node(b);
        Node an = a.next;
        Node bp = b.previous;
        a.next = b;
        a.nextZ = b;
        b.previous = a;
        b.previousZ = a;
        a2.next = an;
        a2.nextZ = an;
        an.previous = a2;
        an.previousZ = a2;
        b2.next = a2;
        b2.nextZ = a2;
        a2.previous = b2;
        a2.previousZ = b2;
        bp.next = b2;
        bp.nextZ = b2;
        return b2;
    }

    private static final boolean isValidDiagonal(Node a, Node b) {
        if (Tessellator.isVertexEquals(a, b)) {
            return Tessellator.isCWPolygon(a, b);
        }
        return a.next.idx != b.idx && a.previous.idx != b.idx && !Tessellator.isIntersectingPolygon(a, a.getX(), a.getY(), b.getX(), b.getY()) && Tessellator.isLocallyInside(a, b) && Tessellator.isLocallyInside(b, a) && Tessellator.middleInsert(a, a.getX(), a.getY(), b.getX(), b.getY());
    }

    private static boolean isCWPolygon(Node start, Node end) {
        Node next = start;
        double windingSum = 0.0;
        do {
            windingSum += Tessellator.area(next.getX(), next.getY(), next.next.getX(), next.next.getY(), end.getX(), end.getY());
        } while ((next = next.next).next != end);
        return windingSum < 0.0;
    }

    private static final boolean isLocallyInside(Node a, Node b) {
        double area = Tessellator.area(a.previous.getX(), a.previous.getY(), a.getX(), a.getY(), a.next.getX(), a.next.getY());
        if (area == 0.0) {
            return false;
        }
        if (area < 0.0) {
            return Tessellator.area(a.getX(), a.getY(), b.getX(), b.getY(), a.next.getX(), a.next.getY()) >= 0.0 && Tessellator.area(a.getX(), a.getY(), a.previous.getX(), a.previous.getY(), b.getX(), b.getY()) >= 0.0;
        }
        return Tessellator.area(a.getX(), a.getY(), b.getX(), b.getY(), a.previous.getX(), a.previous.getY()) < 0.0 || Tessellator.area(a.getX(), a.getY(), a.next.getX(), a.next.getY(), b.getX(), b.getY()) < 0.0;
    }

    private static final boolean middleInsert(Node start, double x0, double y0, double x1, double y1) {
        Node node = start;
        boolean lIsInside = false;
        double lDx = (x0 + x1) / 2.0;
        double lDy = (y0 + y1) / 2.0;
        do {
            Node nextNode = node.next;
            if (node.getY() > lDy == nextNode.getY() > lDy || !(lDx < (nextNode.getX() - node.getX()) * (lDy - node.getY()) / (nextNode.getY() - node.getY()) + node.getX())) continue;
            boolean bl = lIsInside = !lIsInside;
        } while ((node = node.next) != start);
        return lIsInside;
    }

    private static final boolean isIntersectingPolygon(Node start, double x0, double y0, double x1, double y1) {
        Node nextNode;
        Node node = start;
        do {
            nextNode = node.next;
            if (Tessellator.isVertexEquals(node, x0, y0) || Tessellator.isVertexEquals(node, x1, y1) || !Tessellator.linesIntersect(node.getX(), node.getY(), nextNode.getX(), nextNode.getY(), x0, y0, x1, y1)) continue;
            return true;
        } while ((node = nextNode) != start);
        return false;
    }

    public static final boolean linesIntersect(double aX0, double aY0, double aX1, double aY1, double bX0, double bY0, double bX1, double bY1) {
        return Tessellator.area(aX0, aY0, aX1, aY1, bX0, bY0) > 0.0 != Tessellator.area(aX0, aY0, aX1, aY1, bX1, bY1) > 0.0 && Tessellator.area(bX0, bY0, bX1, bY1, aX0, aY0) > 0.0 != Tessellator.area(bX0, bY0, bX1, bY1, aX1, aY1) > 0.0;
    }

    private static final void sortByMortonWithReset(Node start) {
        Node next = start;
        do {
            next.previousZ = next.previous;
            next.nextZ = next.next;
        } while ((next = next.next) != start);
        Tessellator.sortByMorton(start);
    }

    private static final void sortByMorton(Node start) {
        start.previousZ.nextZ = null;
        start.previousZ = null;
        Tessellator.tathamSort(start);
    }

    private static final void tathamSort(Node list) {
        int numMerges;
        int inSize = 1;
        if (list == null) {
            return;
        }
        do {
            Node p = list;
            list = null;
            Node tail = null;
            numMerges = 0;
            while (p != null) {
                ++numMerges;
                Node q = p;
                int i = 0;
                int pSize = 0;
                while (i < inSize && q != null) {
                    ++i;
                    ++pSize;
                    q = q.nextZ;
                }
                int qSize = inSize;
                while (pSize > 0 || qSize > 0 && q != null) {
                    Node e;
                    if (pSize != 0 && (qSize == 0 || q == null || Long.compareUnsigned(p.morton, q.morton) <= 0)) {
                        e = p;
                        p = p.nextZ;
                        --pSize;
                    } else {
                        e = q;
                        q = q.nextZ;
                        --qSize;
                    }
                    if (tail != null) {
                        tail.nextZ = e;
                    } else {
                        list = e;
                    }
                    e.previousZ = tail;
                    tail = e;
                }
                p = q;
            }
            tail.nextZ = null;
            inSize *= 2;
        } while (numMerges > 1);
    }

    private static final Node filterPoints(Node start, Node end) {
        boolean continueIteration;
        if (start == null) {
            return start;
        }
        if (end == null) {
            end = start;
        }
        Node node = start;
        do {
            continueIteration = false;
            Node nextNode = node.next;
            Node prevNode = node.previous;
            if (Tessellator.isVertexEquals(node, nextNode) || Tessellator.area(prevNode.getX(), prevNode.getY(), node.getX(), node.getY(), nextNode.getX(), nextNode.getY()) == 0.0) {
                Tessellator.removeNode(node);
                node = end = prevNode;
                if (node == nextNode) break;
                continueIteration = true;
                continue;
            }
            node = nextNode;
        } while (continueIteration || node != end);
        return end;
    }

    private static final Node insertNode(double[] x2, double[] y, int index, int vertexIndex, Node lastNode, boolean isGeo) {
        Node node = new Node(x2, y, index, vertexIndex, isGeo);
        if (lastNode == null) {
            node.previous = node;
            node.previousZ = node;
            node.next = node;
            node.nextZ = node;
        } else {
            node.next = lastNode.next;
            node.nextZ = lastNode.next;
            node.previous = lastNode;
            node.previousZ = lastNode;
            lastNode.next.previous = node;
            lastNode.nextZ.previousZ = node;
            lastNode.next = node;
            lastNode.nextZ = node;
        }
        return node;
    }

    private static final void removeNode(Node node) {
        node.next.previous = node.previous;
        node.previous.next = node.next;
        if (node.previousZ != null) {
            node.previousZ.nextZ = node.nextZ;
        }
        if (node.nextZ != null) {
            node.nextZ.previousZ = node.previousZ;
        }
    }

    private static final boolean isVertexEquals(Node a, Node b) {
        return Tessellator.isVertexEquals(a, b.getX(), b.getY());
    }

    private static final boolean isVertexEquals(Node a, double x2, double y) {
        return a.getX() == x2 && a.getY() == y;
    }

    private static double area(double aX, double aY, double bX, double bY, double cX, double cY) {
        return (bY - aY) * (cX - bX) - (bX - aX) * (cY - bY);
    }

    private static boolean pointInEar(double x2, double y, double ax, double ay, double bx, double by2, double cx, double cy) {
        return (cx - x2) * (ay - y) - (ax - x2) * (cy - y) >= 0.0 && (ax - x2) * (by2 - y) - (bx - x2) * (ay - y) >= 0.0 && (bx - x2) * (cy - y) - (cx - x2) * (by2 - y) >= 0.0;
    }

    public static boolean pointInTriangle(double x2, double y, double ax, double ay, double bx, double by2, double cx, double cy) {
        int a = GeoUtils.orient(x2, y, ax, ay, bx, by2);
        int b = GeoUtils.orient(x2, y, bx, by2, cx, cy);
        if (a == 0 || b == 0 || a < 0 == b < 0) {
            int c = GeoUtils.orient(x2, y, cx, cy, ax, ay);
            return c == 0 || c < 0 == (b < 0 || a < 0);
        }
        return false;
    }

    public static final boolean pointInPolygon(List<Triangle> tessellation, double lat, double lon) {
        for (int i = 0; i < tessellation.size(); ++i) {
            if (!tessellation.get(i).containsPoint(lat, lon)) continue;
            return true;
        }
        return false;
    }

    public static final class Triangle {
        Node[] vertex;

        protected Triangle(Node a, Node b, Node c) {
            this.vertex = new Node[]{a, b, c};
        }

        public int getEncodedX(int vertex) {
            return this.vertex[vertex].x;
        }

        public int getEncodedY(int vertex) {
            return this.vertex[vertex].y;
        }

        public double getY(int vertex) {
            return this.vertex[vertex].getY();
        }

        public double getX(int vertex) {
            return this.vertex[vertex].getX();
        }

        protected boolean containsPoint(double lat, double lon) {
            return Tessellator.pointInTriangle(lon, lat, this.vertex[0].getX(), this.vertex[0].getY(), this.vertex[1].getX(), this.vertex[1].getY(), this.vertex[2].getX(), this.vertex[2].getY());
        }

        public String toString() {
            String result2 = this.vertex[0].x + ", " + this.vertex[0].y + " " + this.vertex[1].x + ", " + this.vertex[1].y + " " + this.vertex[2].x + ", " + this.vertex[2].y;
            return result2;
        }
    }

    protected static class Node {
        private final int idx;
        private final int vrtxIdx;
        private final double[] polyX;
        private final double[] polyY;
        private final int x;
        private final int y;
        private final long morton;
        private Node previous;
        private Node next;
        private Node previousZ;
        private Node nextZ;

        protected Node(double[] x2, double[] y, int index, int vertexIndex, boolean isGeo) {
            this.idx = index;
            this.vrtxIdx = vertexIndex;
            this.polyX = x2;
            this.polyY = y;
            this.y = isGeo ? GeoEncodingUtils.encodeLatitude(this.polyY[this.vrtxIdx]) : XYEncodingUtils.encode(this.polyY[this.vrtxIdx]);
            this.x = isGeo ? GeoEncodingUtils.encodeLongitude(this.polyX[this.vrtxIdx]) : XYEncodingUtils.encode(this.polyX[this.vrtxIdx]);
            this.morton = BitUtil.interleave(this.x ^ Integer.MIN_VALUE, this.y ^ Integer.MIN_VALUE);
            this.previous = null;
            this.next = null;
            this.previousZ = null;
            this.nextZ = null;
        }

        protected Node(Node other) {
            this.idx = other.idx;
            this.vrtxIdx = other.vrtxIdx;
            this.polyX = other.polyX;
            this.polyY = other.polyY;
            this.morton = other.morton;
            this.x = other.x;
            this.y = other.y;
            this.previous = other.previous;
            this.next = other.next;
            this.previousZ = other.previousZ;
            this.nextZ = other.nextZ;
        }

        public final double getX() {
            return this.polyX[this.vrtxIdx];
        }

        public final double getY() {
            return this.polyY[this.vrtxIdx];
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.previous == null) {
                builder.append("||-");
            } else {
                builder.append(this.previous.idx).append(" <- ");
            }
            builder.append(this.idx);
            if (this.next == null) {
                builder.append(" -||");
            } else {
                builder.append(" -> ").append(this.next.idx);
            }
            return builder.toString();
        }
    }

    private static enum State {
        INIT,
        CURE,
        SPLIT;

    }
}

