/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.IntConsumer;
import org.apache.lucene.index.BinaryDocValuesFieldUpdates;
import org.apache.lucene.index.BufferedUpdates;
import org.apache.lucene.index.BufferedUpdatesStream;
import org.apache.lucene.index.DocValuesFieldUpdates;
import org.apache.lucene.index.FieldTermIterator;
import org.apache.lucene.index.FieldUpdatesBuffer;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValuesFieldUpdates;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.PrefixCodedTerms;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.RamUsageEstimator;

final class FrozenBufferedUpdates {
    static final int BYTES_PER_DEL_QUERY = RamUsageEstimator.NUM_BYTES_OBJECT_REF + 4 + 24;
    final PrefixCodedTerms deleteTerms;
    final Query[] deleteQueries;
    final int[] deleteQueryLimits;
    public final CountDownLatch applied = new CountDownLatch(1);
    private final ReentrantLock applyLock = new ReentrantLock();
    private final Map<String, FieldUpdatesBuffer> fieldUpdates;
    public long totalDelCount;
    private final int fieldUpdatesCount;
    final int bytesUsed;
    final int numTermDeletes;
    private long delGen = -1L;
    final SegmentCommitInfo privateSegment;
    private final InfoStream infoStream;

    public FrozenBufferedUpdates(InfoStream infoStream, BufferedUpdates updates, SegmentCommitInfo privateSegment) {
        this.infoStream = infoStream;
        this.privateSegment = privateSegment;
        assert (updates.deleteDocIDs.isEmpty());
        assert (privateSegment == null || updates.deleteTerms.isEmpty()) : "segment private packet should only have del queries";
        Comparable[] termsArray = updates.deleteTerms.keySet().toArray(new Term[updates.deleteTerms.size()]);
        ArrayUtil.timSort((Comparable[])termsArray);
        PrefixCodedTerms.Builder builder = new PrefixCodedTerms.Builder();
        for (Comparable term : termsArray) {
            builder.add((Term)term);
        }
        this.deleteTerms = builder.finish();
        this.deleteQueries = new Query[updates.deleteQueries.size()];
        this.deleteQueryLimits = new int[updates.deleteQueries.size()];
        int upto = 0;
        for (Map.Entry<Query, Integer> ent : updates.deleteQueries.entrySet()) {
            this.deleteQueries[upto] = ent.getKey();
            this.deleteQueryLimits[upto] = ent.getValue();
            ++upto;
        }
        this.fieldUpdates = Collections.unmodifiableMap(new HashMap<String, FieldUpdatesBuffer>(updates.fieldUpdates));
        this.fieldUpdatesCount = updates.numFieldUpdates.get();
        this.bytesUsed = (int)(this.deleteTerms.ramBytesUsed() + (long)(this.deleteQueries.length * BYTES_PER_DEL_QUERY) + updates.fieldUpdatesBytesUsed.get());
        this.numTermDeletes = updates.numTermDeletes.get();
        if (infoStream != null && infoStream.isEnabled("BD")) {
            infoStream.message("BD", String.format(Locale.ROOT, "compressed %d to %d bytes (%.2f%%) for deletes/updates; private segment %s", updates.ramBytesUsed(), this.bytesUsed, 100.0 * (double)this.bytesUsed / (double)updates.ramBytesUsed(), privateSegment));
        }
    }

    private List<SegmentCommitInfo> getInfosToApply(IndexWriter writer) {
        List<SegmentCommitInfo> infos;
        assert (Thread.holdsLock(writer));
        if (this.privateSegment != null) {
            if (writer.segmentCommitInfoExist(this.privateSegment)) {
                infos = Collections.singletonList(this.privateSegment);
            } else {
                if (this.infoStream.isEnabled("BD")) {
                    this.infoStream.message("BD", "private segment already gone; skip processing updates");
                }
                infos = null;
            }
        } else {
            infos = writer.listOfSegmentCommitInfos();
        }
        return infos;
    }

    boolean tryApply(IndexWriter writer) throws IOException {
        if (this.applyLock.tryLock()) {
            try {
                this.forceApply(writer);
                boolean bl = true;
                return bl;
            }
            finally {
                this.applyLock.unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceApply(IndexWriter writer) throws IOException {
        this.applyLock.lock();
        try {
            if (this.applied.getCount() == 0L) {
                return;
            }
            long startNS = System.nanoTime();
            assert (this.any());
            HashSet<SegmentCommitInfo> seenSegments = new HashSet<SegmentCommitInfo>();
            int iter = 0;
            int totalSegmentCount = 0;
            long totalDelCount = 0L;
            boolean finished = false;
            while (true) {
                long delCount;
                BufferedUpdatesStream.SegmentState[] segStates;
                String messagePrefix = iter == 0 ? "" : "iter " + iter;
                long iterStartNS = System.nanoTime();
                long mergeGenStart = writer.mergeFinishedGen.get();
                HashSet<String> delFiles = new HashSet<String>();
                IndexWriter indexWriter = writer;
                synchronized (indexWriter) {
                    List<SegmentCommitInfo> infos = this.getInfosToApply(writer);
                    if (infos == null) {
                        break;
                    }
                    for (SegmentCommitInfo info : infos) {
                        delFiles.addAll(info.files());
                    }
                    segStates = FrozenBufferedUpdates.openSegmentStates(writer, infos, seenSegments, this.delGen());
                    if (segStates.length == 0) {
                        if (this.infoStream.isEnabled("BD")) {
                            this.infoStream.message("BD", "packet matches no segments");
                        }
                        break;
                    }
                    if (this.infoStream.isEnabled("BD")) {
                        this.infoStream.message("BD", String.format(Locale.ROOT, messagePrefix + "now apply del packet (%s) to %d segments, mergeGen %d", this, segStates.length, mergeGenStart));
                    }
                    totalSegmentCount += segStates.length;
                    writer.deleter.incRef(delFiles);
                }
                AtomicBoolean success = new AtomicBoolean();
                try (Closeable finalizer = () -> this.finishApply(writer, segStates, success.get(), delFiles);){
                    assert (finalizer != null);
                    delCount = this.apply(segStates);
                    success.set(true);
                }
                writer.writeSomeDocValuesUpdates();
                totalDelCount += delCount;
                if (this.infoStream.isEnabled("BD")) {
                    this.infoStream.message("BD", String.format(Locale.ROOT, messagePrefix + "done inner apply del packet (%s) to %d segments; %d new deletes/updates; took %.3f sec", this, segStates.length, delCount, (double)(System.nanoTime() - iterStartNS) / 1.0E9));
                }
                if (this.privateSegment != null) break;
                IndexWriter indexWriter2 = writer;
                synchronized (indexWriter2) {
                    long mergeGenCur = writer.mergeFinishedGen.get();
                    if (mergeGenCur == mergeGenStart) {
                        writer.finished(this);
                        finished = true;
                        break;
                    }
                }
                if (this.infoStream.isEnabled("BD")) {
                    this.infoStream.message("BD", messagePrefix + "concurrent merges finished; move to next iter");
                }
                ++iter;
            }
            if (!finished) {
                writer.finished(this);
            }
            if (this.infoStream.isEnabled("BD")) {
                String message = String.format(Locale.ROOT, "done apply del packet (%s) to %d segments; %d new deletes/updates; took %.3f sec", this, totalSegmentCount, totalDelCount, (double)(System.nanoTime() - startNS) / 1.0E9);
                if (iter > 0) {
                    message = message + "; " + (iter + 1) + " iters due to concurrent merges";
                }
                message = message + "; " + writer.getPendingUpdatesCount() + " packets remain";
                this.infoStream.message("BD", message);
            }
        }
        finally {
            this.applyLock.unlock();
        }
    }

    private static BufferedUpdatesStream.SegmentState[] openSegmentStates(IndexWriter writer, List<SegmentCommitInfo> infos, Set<SegmentCommitInfo> alreadySeenSegments, long delGen) throws IOException {
        ArrayList<BufferedUpdatesStream.SegmentState> segStates = new ArrayList<BufferedUpdatesStream.SegmentState>();
        try {
            for (SegmentCommitInfo info : infos) {
                if (info.getBufferedDeletesGen() > delGen || alreadySeenSegments.contains(info)) continue;
                segStates.add(new BufferedUpdatesStream.SegmentState(writer.getPooledInstance(info, true), writer::release, info));
                alreadySeenSegments.add(info);
            }
        }
        catch (Throwable t) {
            try {
                IOUtils.close(segStates);
            }
            catch (Throwable t1) {
                t.addSuppressed(t1);
            }
            throw t;
        }
        return segStates.toArray(new BufferedUpdatesStream.SegmentState[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedUpdatesStream.ApplyDeletesResult closeSegmentStates(IndexWriter writer, BufferedUpdatesStream.SegmentState[] segStates, boolean success) throws IOException {
        ArrayList<SegmentCommitInfo> allDeleted = null;
        long totDelCount = 0L;
        try {
            for (BufferedUpdatesStream.SegmentState segState : segStates) {
                if (!success) continue;
                totDelCount += (long)(segState.rld.getDelCount() - segState.startDelCount);
                int fullDelCount = segState.rld.getDelCount();
                assert (fullDelCount <= segState.rld.info.info.maxDoc()) : fullDelCount + " > " + segState.rld.info.info.maxDoc();
                if (!segState.rld.isFullyDeleted() || writer.getConfig().getMergePolicy().keepFullyDeletedSegment(() -> segState.reader)) continue;
                if (allDeleted == null) {
                    allDeleted = new ArrayList<SegmentCommitInfo>();
                }
                allDeleted.add(segState.reader.getOriginalSegmentInfo());
            }
        }
        finally {
            IOUtils.close(segStates);
        }
        if (writer.infoStream.isEnabled("BD")) {
            writer.infoStream.message("BD", "closeSegmentStates: " + totDelCount + " new deleted documents; pool " + writer.getPendingUpdatesCount() + " packets; bytesUsed=" + writer.getReaderPoolRamBytesUsed());
        }
        return new BufferedUpdatesStream.ApplyDeletesResult(totDelCount > 0L, allDeleted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishApply(IndexWriter writer, BufferedUpdatesStream.SegmentState[] segStates, boolean success, Set<String> delFiles) throws IOException {
        assert (this.applyLock.isHeldByCurrentThread());
        IndexWriter indexWriter = writer;
        synchronized (indexWriter) {
            BufferedUpdatesStream.ApplyDeletesResult result2;
            try {
                result2 = FrozenBufferedUpdates.closeSegmentStates(writer, segStates, success);
            }
            finally {
                writer.deleter.decRef(delFiles);
            }
            if (result2.anyDeletes) {
                writer.maybeMerge.set(true);
                writer.checkpoint();
            }
            if (result2.allDeleted != null) {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "drop 100% deleted segments: " + writer.segString(result2.allDeleted));
                }
                for (SegmentCommitInfo info : result2.allDeleted) {
                    writer.dropDeletedSegment(info);
                }
                writer.checkpoint();
            }
        }
    }

    private long apply(BufferedUpdatesStream.SegmentState[] segStates) throws IOException {
        assert (this.applyLock.isHeldByCurrentThread());
        if (this.delGen == -1L) {
            throw new IllegalArgumentException("gen is not yet set; call BufferedUpdatesStream.push first");
        }
        assert (this.applied.getCount() != 0L);
        if (this.privateSegment != null) {
            assert (segStates.length == 1);
            assert (this.privateSegment == segStates[0].reader.getOriginalSegmentInfo());
        }
        this.totalDelCount += this.applyTermDeletes(segStates);
        this.totalDelCount += this.applyQueryDeletes(segStates);
        this.totalDelCount += this.applyDocValuesUpdates(segStates);
        return this.totalDelCount;
    }

    private long applyDocValuesUpdates(BufferedUpdatesStream.SegmentState[] segStates) throws IOException {
        if (this.fieldUpdates.isEmpty()) {
            return 0L;
        }
        long startNS = System.nanoTime();
        long updateCount = 0L;
        for (BufferedUpdatesStream.SegmentState segState : segStates) {
            boolean isSegmentPrivateDeletes;
            if (this.delGen < segState.delGen || segState.rld.refCount() == 1) continue;
            boolean bl = isSegmentPrivateDeletes = this.privateSegment != null;
            if (this.fieldUpdates.isEmpty()) continue;
            updateCount += FrozenBufferedUpdates.applyDocValuesUpdates(segState, this.fieldUpdates, this.delGen, isSegmentPrivateDeletes);
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", String.format(Locale.ROOT, "applyDocValuesUpdates %.1f msec for %d segments, %d field updates; %d new updates", (double)(System.nanoTime() - startNS) / 1000000.0, segStates.length, this.fieldUpdatesCount, updateCount));
        }
        return updateCount;
    }

    private static long applyDocValuesUpdates(BufferedUpdatesStream.SegmentState segState, Map<String, FieldUpdatesBuffer> updates, long delGen, boolean segmentPrivateDeletes) throws IOException {
        long updateCount = 0L;
        ArrayList<BinaryDocValuesFieldUpdates> resolvedUpdates = new ArrayList<BinaryDocValuesFieldUpdates>();
        for (Map.Entry<String, FieldUpdatesBuffer> entry : updates.entrySet()) {
            FieldUpdatesBuffer.BufferedUpdate bufferedUpdate;
            String updateField = entry.getKey();
            DocValuesFieldUpdates dvUpdates = null;
            FieldUpdatesBuffer value = entry.getValue();
            boolean isNumeric = value.isNumeric();
            FieldUpdatesBuffer.BufferedUpdateIterator iterator = value.iterator();
            TermDocsIterator termDocsIterator = new TermDocsIterator(segState.reader, false);
            while ((bufferedUpdate = iterator.next()) != null) {
                int doc2;
                BytesRef binaryValue;
                long longValue;
                int limit;
                DocIdSetIterator docIdSetIterator = termDocsIterator.nextTerm(bufferedUpdate.termField, bufferedUpdate.termValue);
                if (docIdSetIterator == null) continue;
                if (delGen == segState.delGen) {
                    assert (segmentPrivateDeletes);
                    limit = bufferedUpdate.docUpTo;
                } else {
                    limit = Integer.MAX_VALUE;
                }
                if (!bufferedUpdate.hasValue) {
                    longValue = -1L;
                    binaryValue = null;
                } else {
                    longValue = bufferedUpdate.numericValue;
                    binaryValue = bufferedUpdate.binaryValue;
                }
                termDocsIterator.getDocs();
                if (dvUpdates == null) {
                    dvUpdates = isNumeric ? (value.hasSingleValue() ? new NumericDocValuesFieldUpdates.SingleValueNumericDocValuesFieldUpdates(delGen, updateField, segState.reader.maxDoc(), value.getNumericValue(0)) : new NumericDocValuesFieldUpdates(delGen, updateField, value.getMinNumeric(), value.getMaxNumeric(), segState.reader.maxDoc())) : new BinaryDocValuesFieldUpdates(delGen, updateField, segState.reader.maxDoc());
                    resolvedUpdates.add((BinaryDocValuesFieldUpdates)dvUpdates);
                }
                BinaryDocValuesFieldUpdates update = dvUpdates;
                IntConsumer docIdConsumer = !bufferedUpdate.hasValue ? doc -> update.reset(doc) : (isNumeric ? doc -> update.add(doc, longValue) : doc -> update.add(doc, binaryValue));
                Bits acceptDocs = segState.rld.getLiveDocs();
                if (segState.rld.sortMap != null && segmentPrivateDeletes) {
                    int doc3;
                    while ((doc3 = docIdSetIterator.nextDoc()) != Integer.MAX_VALUE) {
                        if (acceptDocs != null && !acceptDocs.get(doc3) || segState.rld.sortMap.newToOld(doc3) >= limit) continue;
                        docIdConsumer.accept(doc3);
                        ++updateCount;
                    }
                    continue;
                }
                while ((doc2 = docIdSetIterator.nextDoc()) != Integer.MAX_VALUE && doc2 < limit) {
                    if (acceptDocs != null && !acceptDocs.get(doc2)) continue;
                    docIdConsumer.accept(doc2);
                    ++updateCount;
                }
            }
        }
        for (DocValuesFieldUpdates docValuesFieldUpdates : resolvedUpdates) {
            if (!docValuesFieldUpdates.any()) continue;
            docValuesFieldUpdates.finish();
            segState.rld.addDVUpdate(docValuesFieldUpdates);
        }
        return updateCount;
    }

    private long applyQueryDeletes(BufferedUpdatesStream.SegmentState[] segStates) throws IOException {
        if (this.deleteQueries.length == 0) {
            return 0L;
        }
        long startNS = System.nanoTime();
        long delCount = 0L;
        for (BufferedUpdatesStream.SegmentState segState : segStates) {
            if (this.delGen < segState.delGen || segState.rld.refCount() == 1) continue;
            LeafReaderContext readerContext = segState.reader.getContext();
            for (int i = 0; i < this.deleteQueries.length; ++i) {
                int docID;
                int limit;
                Query query = this.deleteQueries[i];
                if (this.delGen == segState.delGen) {
                    assert (this.privateSegment != null);
                    limit = this.deleteQueryLimits[i];
                } else {
                    limit = Integer.MAX_VALUE;
                }
                IndexSearcher searcher = new IndexSearcher(readerContext.reader());
                searcher.setQueryCache(null);
                query = searcher.rewrite(query);
                Weight weight = searcher.createWeight(query, ScoreMode.COMPLETE_NO_SCORES, 1.0f);
                Scorer scorer = weight.scorer(readerContext);
                if (scorer == null) continue;
                DocIdSetIterator it = scorer.iterator();
                if (segState.rld.sortMap != null && limit != Integer.MAX_VALUE) {
                    assert (this.privateSegment != null);
                    while ((docID = it.nextDoc()) != Integer.MAX_VALUE) {
                        if (segState.rld.sortMap.newToOld(docID) >= limit || !segState.rld.delete(docID)) continue;
                        ++delCount;
                    }
                    continue;
                }
                while ((docID = it.nextDoc()) < limit) {
                    if (!segState.rld.delete(docID)) continue;
                    ++delCount;
                }
            }
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", String.format(Locale.ROOT, "applyQueryDeletes took %.2f msec for %d segments and %d queries; %d new deletions", (double)(System.nanoTime() - startNS) / 1000000.0, segStates.length, this.deleteQueries.length, delCount));
        }
        return delCount;
    }

    private long applyTermDeletes(BufferedUpdatesStream.SegmentState[] segStates) throws IOException {
        if (this.deleteTerms.size() == 0L) {
            return 0L;
        }
        assert (this.privateSegment == null);
        long startNS = System.nanoTime();
        long delCount = 0L;
        for (BufferedUpdatesStream.SegmentState segState : segStates) {
            BytesRef delTerm;
            assert (segState.delGen != this.delGen) : "segState.delGen=" + segState.delGen + " vs this.gen=" + this.delGen;
            if (segState.delGen > this.delGen || segState.rld.refCount() == 1) continue;
            PrefixCodedTerms.TermIterator iter = this.deleteTerms.iterator();
            TermDocsIterator termDocsIterator = new TermDocsIterator(segState.reader, true);
            while ((delTerm = iter.next()) != null) {
                int docID;
                DocIdSetIterator iterator = termDocsIterator.nextTerm(((FieldTermIterator)iter).field(), delTerm);
                if (iterator == null) continue;
                while ((docID = iterator.nextDoc()) != Integer.MAX_VALUE) {
                    if (!segState.rld.delete(docID)) continue;
                    ++delCount;
                }
            }
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", String.format(Locale.ROOT, "applyTermDeletes took %.2f msec for %d segments and %d del terms; %d new deletions", (double)(System.nanoTime() - startNS) / 1000000.0, segStates.length, this.deleteTerms.size(), delCount));
        }
        return delCount;
    }

    public void setDelGen(long delGen) {
        assert (this.delGen == -1L) : "delGen was already previously set to " + this.delGen;
        this.delGen = delGen;
        this.deleteTerms.setDelGen(delGen);
    }

    public long delGen() {
        assert (this.delGen != -1L);
        return this.delGen;
    }

    public String toString() {
        String s2 = "delGen=" + this.delGen;
        if (this.numTermDeletes != 0) {
            s2 = s2 + " numDeleteTerms=" + this.numTermDeletes;
            if ((long)this.numTermDeletes != this.deleteTerms.size()) {
                s2 = s2 + " (" + this.deleteTerms.size() + " unique)";
            }
        }
        if (this.deleteQueries.length != 0) {
            s2 = s2 + " numDeleteQueries=" + this.deleteQueries.length;
        }
        if (this.fieldUpdates.size() > 0) {
            s2 = s2 + " fieldUpdates=" + this.fieldUpdatesCount;
        }
        if (this.bytesUsed != 0) {
            s2 = s2 + " bytesUsed=" + this.bytesUsed;
        }
        if (this.privateSegment != null) {
            s2 = s2 + " privateSegment=" + this.privateSegment;
        }
        return s2;
    }

    boolean any() {
        return this.deleteTerms.size() > 0L || this.deleteQueries.length > 0 || this.fieldUpdatesCount > 0;
    }

    static final class TermDocsIterator {
        private final TermsProvider provider;
        private String field;
        private TermsEnum termsEnum;
        private PostingsEnum postingsEnum;
        private final boolean sortedTerms;
        private BytesRef readerTerm;
        private BytesRef lastTerm;

        TermDocsIterator(Fields fields, boolean sortedTerms) {
            this(fields::terms, sortedTerms);
        }

        TermDocsIterator(LeafReader reader, boolean sortedTerms) {
            this(reader::terms, sortedTerms);
        }

        private TermDocsIterator(TermsProvider provider, boolean sortedTerms) {
            this.sortedTerms = sortedTerms;
            this.provider = provider;
        }

        private void setField(String field2) throws IOException {
            if (this.field == null || !this.field.equals(field2)) {
                this.field = field2;
                Terms terms = this.provider.terms(field2);
                if (terms != null) {
                    this.termsEnum = terms.iterator();
                    if (this.sortedTerms) {
                        if (!$assertionsDisabled) {
                            this.lastTerm = null;
                            if (null != null) {
                                throw new AssertionError();
                            }
                        }
                        this.readerTerm = this.termsEnum.next();
                    }
                } else {
                    this.termsEnum = null;
                }
            }
        }

        DocIdSetIterator nextTerm(String field2, BytesRef term) throws IOException {
            this.setField(field2);
            if (this.termsEnum != null) {
                if (this.sortedTerms) {
                    assert (this.assertSorted(term));
                    int cmp = term.compareTo(this.readerTerm);
                    if (cmp < 0) {
                        return null;
                    }
                    if (cmp == 0) {
                        return this.getDocs();
                    }
                    if (cmp > 0) {
                        TermsEnum.SeekStatus status = this.termsEnum.seekCeil(term);
                        switch (status) {
                            case FOUND: {
                                return this.getDocs();
                            }
                            case NOT_FOUND: {
                                this.readerTerm = this.termsEnum.term();
                                return null;
                            }
                            case END: {
                                this.termsEnum = null;
                                return null;
                            }
                        }
                        throw new AssertionError((Object)"unknown status");
                    }
                } else if (this.termsEnum.seekExact(term)) {
                    return this.getDocs();
                }
            }
            return null;
        }

        private boolean assertSorted(BytesRef term) {
            assert (this.sortedTerms);
            assert (this.lastTerm == null || term.compareTo(this.lastTerm) >= 0) : "boom: " + term.utf8ToString() + " last: " + this.lastTerm.utf8ToString();
            this.lastTerm = BytesRef.deepCopyOf(term);
            return true;
        }

        private DocIdSetIterator getDocs() throws IOException {
            assert (this.termsEnum != null);
            this.postingsEnum = this.termsEnum.postings(this.postingsEnum, 0);
            return this.postingsEnum;
        }

        @FunctionalInterface
        static interface TermsProvider {
            public Terms terms(String var1) throws IOException;
        }
    }
}

