/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanWeight;

public final class SpanBoostQuery
extends SpanQuery {
    private final SpanQuery query;
    private final float boost;

    public SpanBoostQuery(SpanQuery query, float boost) {
        this.query = Objects.requireNonNull(query);
        this.boost = boost;
    }

    public SpanQuery getQuery() {
        return this.query;
    }

    public float getBoost() {
        return this.boost;
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((SpanBoostQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(SpanBoostQuery other) {
        return this.query.equals(other.query) && Float.floatToIntBits(this.boost) == Float.floatToIntBits(other.boost);
    }

    @Override
    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + this.query.hashCode();
        h = 31 * h + Float.floatToIntBits(this.boost);
        return h;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.boost == 1.0f) {
            return this.query;
        }
        SpanQuery rewritten = (SpanQuery)this.query.rewrite(reader);
        if (this.query != rewritten) {
            return new SpanBoostQuery(rewritten, this.boost);
        }
        if (this.query.getClass() == SpanBoostQuery.class) {
            SpanBoostQuery in = (SpanBoostQuery)this.query;
            return new SpanBoostQuery(in.query, this.boost * in.boost);
        }
        return super.rewrite(reader);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.getField())) {
            this.query.visit(visitor.getSubVisitor(BooleanClause.Occur.MUST, this));
        }
    }

    @Override
    public String toString(String field2) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        builder.append(this.query.toString(field2));
        builder.append(")^");
        builder.append(this.boost);
        return builder.toString();
    }

    @Override
    public String getField() {
        return this.query.getField();
    }

    @Override
    public SpanWeight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return this.query.createWeight(searcher, scoreMode, this.boost * boost);
    }
}

