/*
 * Decompiled with CFR 0.152.
 */
package fs2.timeseries;

import cats.effect.kernel.GenTemporal;
import fs2.Chunk;
import fs2.Pull;
import fs2.Pull$;
import fs2.Pull$StreamPullOps$;
import fs2.Scan;
import fs2.Scan$;
import fs2.Stream;
import fs2.Stream$;
import fs2.Stream$InvariantOps$;
import fs2.Stream$ToPull$;
import fs2.timeseries.TimeStamped;
import fs2.timeseries.TimeStamped$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package$IntMult$;
import scala.math.Numeric$IntIsIntegral$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class TimeSeries$ {
    public static final TimeSeries$ MODULE$ = new TimeSeries$();

    public <F, A> Stream<F, TimeStamped<Option<A>>> apply(Stream<F, TimeStamped<A>> source, FiniteDuration tickPeriod, FiniteDuration reorderOver, GenTemporal<F, Throwable> evidence$1) {
        return this.apply(source, tickPeriod, reorderOver, false, evidence$1);
    }

    public <F, A> Stream<F, TimeStamped<Option<A>>> apply(Stream<F, TimeStamped<A>> source, FiniteDuration tickPeriod, FiniteDuration reorderOver, boolean monotonic, GenTemporal<F, Throwable> evidence$2) {
        Stream src = source.map((Function1<TimeStamped, TimeStamped> & Serializable)tsa -> tsa.map((Function1<Object, Option> & Serializable)x$1 -> new Some<Object>(x$1)));
        Stream ticks = this.timeTicks(tickPeriod, monotonic, evidence$2).map((Function1<TimeStamped, TimeStamped> & Serializable)tsu -> tsu.map((Function1<BoxedUnit, None$> & Serializable)x$2 -> None$.MODULE$));
        return src.merge(ticks, evidence$2).through(TimeStamped$.MODULE$.reorderLocally(reorderOver));
    }

    public <F, A> Stream<F, TimeStamped<Option<A>>> timePulled(Stream<F, A> source, FiniteDuration tickPeriod, FiniteDuration reorderOver, GenTemporal<F, Throwable> evidence$3) {
        return this.apply(source.map((Function1<Object, TimeStamped> & Serializable)a -> TimeStamped$.MODULE$.unsafeRealTime(a)), tickPeriod, reorderOver, evidence$3);
    }

    public <F, A> Stream<F, TimeStamped<Option<A>>> timePulled(Stream<F, A> source, FiniteDuration tickPeriod, FiniteDuration reorderOver, boolean monotonic, GenTemporal<F, Throwable> evidence$4) {
        return this.apply(source.map((Function1<Object, TimeStamped> & Serializable)a -> {
            if (monotonic) {
                return TimeStamped$.MODULE$.unsafeMonotonic(a);
            }
            return TimeStamped$.MODULE$.unsafeRealTime(a);
        }), tickPeriod, reorderOver, monotonic, evidence$4);
    }

    public <F, A, B> Function1<Stream<F, TimeStamped<Option<A>>>, Stream<F, TimeStamped<Option<B>>>> lift(Function1<A, B> f) {
        return (Function1<Stream, Stream> & Serializable)x$3 -> x$3.map((Function1<TimeStamped, TimeStamped> & Serializable)x$4 -> x$4.map((Function1<Option, Option> & Serializable)x$5 -> x$5.map(f)));
    }

    public <F, L, R> Function1<Stream<F, TimeStamped<Option<Either<L, R>>>>, Stream<F, TimeStamped<Option<L>>>> drainRight() {
        return (Function1<Stream, Stream> & Serializable)x$6 -> x$6.collect(new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends TimeStamped<Option<Either<L, R>>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Option<Either<L, R>> option;
                A1 A1 = x1;
                if (A1 != null && None$.MODULE$.equals(option = A1.value())) {
                    return (B1)A1;
                }
                if (A1 != null) {
                    Some some;
                    Either either2;
                    FiniteDuration ts = A1.time();
                    Option<Either<L, R>> option2 = A1.value();
                    if (option2 instanceof Some && (either2 = (Either)(some = (Some)option2).value()) instanceof Left) {
                        Left left = (Left)either2;
                        A l = left.value();
                        return (B1)new TimeStamped<Some<A>>(ts, new Some<A>(l));
                    }
                }
                return function1.apply(x1);
            }

            public final boolean isDefinedAt(TimeStamped<Option<Either<L, R>>> x1) {
                Some some;
                Either either2;
                Option<Either<L, R>> option;
                Option<Either<L, R>> option2;
                TimeStamped<Option<Either<L, R>>> timeStamped = x1;
                if (timeStamped != null && None$.MODULE$.equals(option2 = timeStamped.value())) {
                    return true;
                }
                return timeStamped != null && (option = timeStamped.value()) instanceof Some && (either2 = (Either)(some = (Some)option).value()) instanceof Left;
            }
        });
    }

    public <F, L, R> Function1<Stream<F, TimeStamped<Option<Either<L, R>>>>, Stream<F, TimeStamped<Option<R>>>> drainLeft() {
        return (Function1<Stream, Stream> & Serializable)x$7 -> x$7.collect(new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends TimeStamped<Option<Either<L, R>>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Option<Either<L, R>> option;
                A1 A1 = x1;
                if (A1 != null && None$.MODULE$.equals(option = A1.value())) {
                    return (B1)A1;
                }
                if (A1 != null) {
                    Some some;
                    Either either2;
                    FiniteDuration ts = A1.time();
                    Option<Either<L, R>> option2 = A1.value();
                    if (option2 instanceof Some && (either2 = (Either)(some = (Some)option2).value()) instanceof Right) {
                        Right right = (Right)either2;
                        B r = right.value();
                        return (B1)new TimeStamped<Some<B>>(ts, new Some<B>(r));
                    }
                }
                return function1.apply(x1);
            }

            public final boolean isDefinedAt(TimeStamped<Option<Either<L, R>>> x1) {
                Some some;
                Either either2;
                Option<Either<L, R>> option;
                Option<Either<L, R>> option2;
                TimeStamped<Option<Either<L, R>>> timeStamped = x1;
                if (timeStamped != null && None$.MODULE$.equals(option2 = timeStamped.value())) {
                    return true;
                }
                return timeStamped != null && (option = timeStamped.value()) instanceof Some && (either2 = (Either)(some = (Some)option).value()) instanceof Right;
            }
        });
    }

    private <F> Stream<F, TimeStamped<BoxedUnit>> timeTicks(FiniteDuration tickPeriod, boolean monotonic, GenTemporal<F, Throwable> evidence$5) {
        return Stream$.MODULE$.awakeEvery(tickPeriod, evidence$5).map((Function1<FiniteDuration, TimeStamped> & Serializable)x$8 -> {
            if (monotonic) {
                return TimeStamped$.MODULE$.unsafeMonotonic(BoxedUnit.UNIT);
            }
            return TimeStamped$.MODULE$.unsafeRealTime(BoxedUnit.UNIT);
        });
    }

    public <F, A> Function1<Stream<F, TimeStamped<A>>, Stream<F, TimeStamped<Option<A>>>> interpolateTicks(FiniteDuration tickPeriod) {
        return (Function1<Stream, Stream> & Serializable)in -> Pull$StreamPullOps$.MODULE$.stream$extension(Pull$.MODULE$.StreamPullOps(Stream$ToPull$.MODULE$.uncons1$extension(Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(in))).flatMap((Function1<Option, Pull> & Serializable)x0$1 -> {
            Some some;
            Tuple2 tuple2;
            Option option = x0$1;
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                TimeStamped hd = (TimeStamped)tuple2._1();
                Stream tl = (Stream)tuple2._2();
                return Pull$.MODULE$.output1(hd.map((Function1<Object, Some> & Serializable)x$15 -> new Some<Object>(x$15))).$greater$greater((Function0<Pull> & Serializable)() -> TimeSeries$.go$1(hd.time().$plus(tickPeriod), tl, tickPeriod));
            }
            if (None$.MODULE$.equals(option)) {
                return Pull$.MODULE$.done();
            }
            throw new MatchError(option);
        })));
    }

    public <S, I, O> Scan<S, TimeStamped<Option<I>>, TimeStamped<Option<O>>> preserve(Scan<S, I, O> t) {
        return this.preserveTicks(TimeStamped$.MODULE$.preserve(t));
    }

    public <S, I, O> Scan<S, TimeStamped<Option<I>>, TimeStamped<Option<O>>> preserveTicks(Scan<S, TimeStamped<I>, TimeStamped<O>> t) {
        return t.semilens((Function1<TimeStamped, Either> & Serializable)tsi -> (Either)((Option)tsi.value()).map((Function1<Object, Right> & Serializable)v -> package$.MODULE$.Right().apply(new TimeStamped<Object>(tsi.time(), v))).getOrElse((Function0<Left> & Serializable)() -> package$.MODULE$.Left().apply(TimeStamped$.MODULE$.tick(tsi.time()))), (Function2<TimeStamped, TimeStamped, TimeStamped> & Serializable)(x$16, tso) -> tso.map((Function1<Object, Some> & Serializable)x$17 -> new Some<Object>(x$17)));
    }

    public <LS, L, RS, R, O> Scan<Tuple2<LS, RS>, TimeStamped<Option<Either<L, R>>>, O> choice(Scan<LS, TimeStamped<Option<L>>, O> l, Scan<RS, TimeStamped<Option<R>>, O> r) {
        return Scan$.MODULE$.apply(new Tuple2<LS, RS>(l.initial(), r.initial()), (Function2<Tuple2, TimeStamped, Tuple2> & Serializable)(x0$1, x1$1) -> {
            Tuple2<Tuple2, TimeStamped> tuple2 = new Tuple2<Tuple2, TimeStamped>((Tuple2)x0$1, (TimeStamped)x1$1);
            if (tuple2 != null) {
                Tuple2 tuple22 = tuple2._1();
                TimeStamped tsv = tuple2._2();
                if (tuple22 != null) {
                    Object lState = tuple22._1();
                    Object rState = tuple22._2();
                    TimeStamped timeStamped = tsv;
                    if (timeStamped != null) {
                        Some some;
                        Either either2;
                        FiniteDuration t = timeStamped.time();
                        Option option = (Option)timeStamped.value();
                        if (option instanceof Some && (either2 = (Either)(some = (Some)option).value()) instanceof Left) {
                            Left left = (Left)either2;
                            Object lValue = left.value();
                            Tuple2 tuple23 = l.transform(lState, new TimeStamped(t, new Some(lValue)));
                            if (tuple23 == null) {
                                throw new MatchError(tuple23);
                            }
                            Object s2 = tuple23._1();
                            Chunk out = tuple23._2();
                            Tuple2 tuple24 = new Tuple2(s2, out);
                            Object s3 = tuple24._1();
                            Chunk out2 = tuple24._2();
                            return new Tuple2(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(s3), rState), out2);
                        }
                    }
                    if (timeStamped != null) {
                        Some some;
                        Either either3;
                        FiniteDuration t = timeStamped.time();
                        Option option = (Option)timeStamped.value();
                        if (option instanceof Some && (either3 = (Either)(some = (Some)option).value()) instanceof Right) {
                            Right right = (Right)either3;
                            Object rValue = right.value();
                            Tuple2 tuple25 = r.transform(rState, new TimeStamped(t, new Some(rValue)));
                            if (tuple25 == null) {
                                throw new MatchError(tuple25);
                            }
                            Object s4 = tuple25._1();
                            Chunk out = tuple25._2();
                            Tuple2 tuple26 = new Tuple2(s4, out);
                            Object s5 = tuple26._1();
                            Chunk out3 = tuple26._2();
                            return new Tuple2(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(lState), s5), out3);
                        }
                    }
                    if (timeStamped != null) {
                        FiniteDuration t = timeStamped.time();
                        Option option = (Option)timeStamped.value();
                        if (None$.MODULE$.equals(option)) {
                            Tuple2 tuple27 = l.transform(lState, new TimeStamped<None$>(t, None$.MODULE$));
                            if (tuple27 == null) {
                                throw new MatchError(tuple27);
                            }
                            Object ls = tuple27._1();
                            Chunk lout = tuple27._2();
                            Tuple2 tuple28 = new Tuple2(ls, lout);
                            Object ls2 = tuple28._1();
                            Chunk lout2 = tuple28._2();
                            Tuple2 tuple29 = r.transform(rState, new TimeStamped<None$>(t, None$.MODULE$));
                            if (tuple29 == null) {
                                throw new MatchError(tuple29);
                            }
                            Object rs = tuple29._1();
                            Chunk rout = tuple29._2();
                            Tuple2 tuple210 = new Tuple2(rs, rout);
                            Object rs2 = tuple210._1();
                            Chunk rout2 = tuple210._2();
                            return new Tuple2(new Tuple2(ls2, rs2), lout2.$plus$plus(rout2));
                        }
                    }
                    throw new MatchError(timeStamped);
                }
            }
            throw new MatchError(tuple2);
        }, (Function1<Tuple2, Chunk> & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Object lState = tuple2._1();
                Object rState = tuple2._2();
                return l.onComplete(lState).$plus$plus(r.onComplete(rState));
            }
            throw new MatchError(tuple2);
        });
    }

    private static final FiniteDuration tickTime$1(int x2, FiniteDuration nextTick$1, FiniteDuration tickPeriod$1) {
        return nextTick$1.$plus(package$IntMult$.MODULE$.$times$extension(scala.concurrent.duration.package$.MODULE$.IntMult(x2), tickPeriod$1));
    }

    public static final /* synthetic */ boolean $anonfun$interpolateTicks$2(FiniteDuration nextTick$1, TimeStamped x$9) {
        return x$9.time().$greater$eq(nextTick$1);
    }

    private static final Pull go$1(FiniteDuration nextTick, Stream s2, FiniteDuration tickPeriod$1) {
        return Stream$ToPull$.MODULE$.uncons$extension(Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(s2))).flatMap((Function1<Option, Pull> & Serializable)x0$1 -> {
            Some some;
            Tuple2 tuple2;
            Option option = x0$1;
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                Chunk hd = (Chunk)tuple2._1();
                Stream tl = (Stream)tuple2._2();
                Option<Object> option2 = hd.indexWhere((Function1<TimeStamped, Object> & Serializable)x$9 -> BoxesRunTime.boxToBoolean(TimeSeries$.$anonfun$interpolateTicks$2(nextTick, x$9)));
                if (None$.MODULE$.equals(option2)) {
                    return Pull$.MODULE$.output(hd.map((Function1<TimeStamped, TimeStamped> & Serializable)x$10 -> x$10.map((Function1<Object, Some> & Serializable)x$11 -> new Some<Object>(x$11)))).$greater$greater((Function0<Pull> & Serializable)() -> TimeSeries$.go$1(nextTick, tl, tickPeriod$1));
                }
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    int idx = BoxesRunTime.unboxToInt(some2.value());
                    Tuple2 tuple22 = hd.splitAt(idx);
                    if (tuple22 == null) {
                        throw new MatchError(tuple22);
                    }
                    Chunk prefix = tuple22._1();
                    Chunk suffix = tuple22._2();
                    Tuple2 tuple23 = new Tuple2(prefix, suffix);
                    Chunk prefix2 = tuple23._1();
                    Chunk suffix2 = tuple23._2();
                    Pull out = Pull$.MODULE$.output(prefix2.map((Function1<TimeStamped, TimeStamped> & Serializable)x$13 -> x$13.map((Function1<Object, Some> & Serializable)x$14 -> new Some<Object>(x$14))));
                    TimeStamped next = (TimeStamped)suffix2.apply(0);
                    int tickCount = (int)((next.time().toMillis() - nextTick.toMillis()) / tickPeriod$1.toMillis() + 1L);
                    Stream ticks = Stream$.MODULE$.range(BoxesRunTime.boxToInteger(0), BoxesRunTime.boxToInteger(tickCount), Numeric$IntIsIntegral$.MODULE$).map((Function1<Object, TimeStamped> & Serializable)i -> TimeStamped$.MODULE$.tick(TimeSeries$.tickTime$1(BoxesRunTime.unboxToInt(i), nextTick, tickPeriod$1)));
                    Pull rest = Stream$ToPull$.MODULE$.echo$extension(Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(ticks))).$greater$greater((Function0<Pull> & Serializable)() -> TimeSeries$.go$1(TimeSeries$.tickTime$1(tickCount, nextTick, tickPeriod$1), tl.cons(suffix2), tickPeriod$1));
                    return out.$greater$greater((Function0<Pull> & Serializable)() -> rest);
                }
                throw new MatchError(option2);
            }
            if (None$.MODULE$.equals(option)) {
                return Pull$.MODULE$.done();
            }
            throw new MatchError(option);
        });
    }

    private TimeSeries$() {
    }
}

