/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FilterNumericDocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.NumericUtils;

public class SortedNumericSelector {
    public static NumericDocValues wrap(SortedNumericDocValues sortedNumeric, Type selector, SortField.Type numericType) {
        NumericDocValues view;
        if (numericType != SortField.Type.INT && numericType != SortField.Type.LONG && numericType != SortField.Type.FLOAT && numericType != SortField.Type.DOUBLE) {
            throw new IllegalArgumentException("numericType must be a numeric type");
        }
        NumericDocValues singleton2 = DocValues.unwrapSingleton(sortedNumeric);
        if (singleton2 != null) {
            view = singleton2;
        } else {
            switch (selector) {
                case MIN: {
                    view = new MinValue(sortedNumeric);
                    break;
                }
                case MAX: {
                    view = new MaxValue(sortedNumeric);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        switch (numericType) {
            case FLOAT: {
                return new FilterNumericDocValues(view){

                    @Override
                    public long longValue() throws IOException {
                        return NumericUtils.sortableFloatBits((int)this.in.longValue());
                    }
                };
            }
            case DOUBLE: {
                return new FilterNumericDocValues(view){

                    @Override
                    public long longValue() throws IOException {
                        return NumericUtils.sortableDoubleBits(this.in.longValue());
                    }
                };
            }
        }
        return view;
    }

    static class MaxValue
    extends NumericDocValues {
        final SortedNumericDocValues in;
        private long value;

        MaxValue(SortedNumericDocValues in) {
            this.in = in;
        }

        @Override
        public int docID() {
            return this.in.docID();
        }

        private void setValue() throws IOException {
            int count = this.in.docValueCount();
            for (int i = 0; i < count; ++i) {
                this.value = this.in.nextValue();
            }
        }

        @Override
        public int nextDoc() throws IOException {
            int docID = this.in.nextDoc();
            if (docID != Integer.MAX_VALUE) {
                this.setValue();
            }
            return docID;
        }

        @Override
        public int advance(int target) throws IOException {
            int docID = this.in.advance(target);
            if (docID != Integer.MAX_VALUE) {
                this.setValue();
            }
            return docID;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            if (this.in.advanceExact(target)) {
                this.setValue();
                return true;
            }
            return false;
        }

        @Override
        public long cost() {
            return this.in.cost();
        }

        @Override
        public long longValue() {
            return this.value;
        }
    }

    static class MinValue
    extends NumericDocValues {
        final SortedNumericDocValues in;
        private long value;

        MinValue(SortedNumericDocValues in) {
            this.in = in;
        }

        @Override
        public int docID() {
            return this.in.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            int docID = this.in.nextDoc();
            if (docID != Integer.MAX_VALUE) {
                this.value = this.in.nextValue();
            }
            return docID;
        }

        @Override
        public int advance(int target) throws IOException {
            int docID = this.in.advance(target);
            if (docID != Integer.MAX_VALUE) {
                this.value = this.in.nextValue();
            }
            return docID;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            if (this.in.advanceExact(target)) {
                this.value = this.in.nextValue();
                return true;
            }
            return false;
        }

        @Override
        public long cost() {
            return this.in.cost();
        }

        @Override
        public long longValue() {
            return this.value;
        }
    }

    public static enum Type {
        MIN,
        MAX;

    }
}

