/*
 * Decompiled with CFR 0.152.
 */
package com.comcast.ip4s;

import com.comcast.ip4s.Cidr;
import com.comcast.ip4s.Cidr$;
import com.comcast.ip4s.Ipv4Address;
import com.comcast.ip4s.Ipv4Address$;
import com.comcast.ip4s.Ipv6Address;
import com.comcast.ip4s.Ipv6AddressCompanionPlatform;
import java.io.Serializable;
import java.net.Inet6Address;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.util.matching.Regex;

public final class Ipv6Address$
implements Ipv6AddressCompanionPlatform,
Serializable {
    public static final Ipv6Address$ MODULE$ = new Ipv6Address$();
    private static final Ipv6Address MulticastRangeStart;
    private static final Ipv6Address MulticastRangeEnd;
    private static final Ipv6Address SourceSpecificMulticastRangeStart;
    private static final Ipv6Address SourceSpecificMulticastRangeEnd;
    private static final Cidr<Ipv6Address> MappedV4Block;
    private static final Regex MixedStringFormat;

    static {
        Ipv6AddressCompanionPlatform.$init$(MODULE$);
        MulticastRangeStart = MODULE$.fromBytes(255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
        MulticastRangeEnd = MODULE$.fromBytes(255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255);
        SourceSpecificMulticastRangeStart = MODULE$.fromBytes(255, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
        SourceSpecificMulticastRangeEnd = MODULE$.fromBytes(255, 63, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255);
        MappedV4Block = Cidr$.MODULE$.apply(MODULE$.fromBytes(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 0, 0, 0, 0), 96);
        MixedStringFormat = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("([:a-fA-F0-9]+:)(\\d+\\.\\d+\\.\\d+\\.\\d+)"));
    }

    @Override
    public Ipv6Address fromInet6Address(Inet6Address address) {
        return Ipv6AddressCompanionPlatform.fromInet6Address$(this, address);
    }

    public Ipv6Address MulticastRangeStart() {
        return MulticastRangeStart;
    }

    public Ipv6Address MulticastRangeEnd() {
        return MulticastRangeEnd;
    }

    public Ipv6Address SourceSpecificMulticastRangeStart() {
        return SourceSpecificMulticastRangeStart;
    }

    public Ipv6Address SourceSpecificMulticastRangeEnd() {
        return SourceSpecificMulticastRangeEnd;
    }

    public Cidr<Ipv6Address> MappedV4Block() {
        return MappedV4Block;
    }

    public Option<Ipv6Address> fromString(String value) {
        return this.fromNonMixedString(value).orElse((Function0<Option> & Serializable)() -> MODULE$.fromMixedString(value));
    }

    private Option<Ipv6Address> fromNonMixedString(String value) {
        int idx;
        List suffix;
        List prefix;
        block13: {
            block14: {
                prefix = Nil$.MODULE$;
                boolean beforeCondenser = true;
                suffix = Nil$.MODULE$;
                String trimmed = value.trim();
                None$ result2 = null;
                String[] fields = StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(trimmed), ':') ? StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(trimmed), ':') : (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
                for (idx = 0; idx < ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps(fields)) && result2 == null; ++idx) {
                    String field2 = fields[idx];
                    if (field2.isEmpty()) {
                        if (beforeCondenser) {
                            beforeCondenser = false;
                            if (idx + 1 >= ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps(fields)) || !fields[idx + 1].isEmpty()) continue;
                            ++idx;
                            continue;
                        }
                        result2 = None$.MODULE$;
                        continue;
                    }
                    try {
                        if (StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(field2)) > 4) {
                            result2 = None$.MODULE$;
                            continue;
                        }
                        int fieldValue = Integer.parseInt(field2, 16);
                        if (beforeCondenser) {
                            int n = fieldValue;
                            prefix = prefix.$colon$colon(BoxesRunTime.boxToInteger(n));
                            continue;
                        }
                        int n = fieldValue;
                        suffix = suffix.$colon$colon(BoxesRunTime.boxToInteger(n));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        result2 = None$.MODULE$;
                    }
                }
                if (result2 != null) {
                    return result2;
                }
                if (!ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps(fields))) break block13;
                if (trimmed.isEmpty()) break block14;
                String string = trimmed;
                String string2 = "::";
                if (!(string == null ? string2 != null : !string.equals(string2))) break block13;
            }
            return None$.MODULE$;
        }
        byte[] bytes = new byte[16];
        idx = 0;
        int prefixSize = prefix.size();
        int prefixIdx = prefixSize - 1;
        while (prefixIdx >= 0) {
            int value2 = BoxesRunTime.unboxToInt(prefix.apply(prefixIdx));
            bytes[idx] = (byte)(value2 >> 8);
            bytes[idx + 1] = (byte)value2;
            --prefixIdx;
            idx += 2;
        }
        int suffixSize = suffix.size();
        int numCondensedZeroes = ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.byteArrayOps(bytes)) - idx - suffixSize * 2;
        idx += numCondensedZeroes;
        int suffixIdx = suffixSize - 1;
        while (suffixIdx >= 0) {
            int value3 = BoxesRunTime.unboxToInt(suffix.apply(suffixIdx));
            bytes[idx] = (byte)(value3 >> 8);
            bytes[idx + 1] = (byte)value3;
            --suffixIdx;
            idx += 2;
        }
        return new Some<Ipv6Address>(this.com$comcast$ip4s$Ipv6Address$$unsafeFromBytes(bytes));
    }

    private Regex MixedStringFormat() {
        return MixedStringFormat;
    }

    private Option<Ipv6Address> fromMixedString(String value) {
        Option<List<String>> option;
        String string = value;
        if (string != null && !(option = this.MixedStringFormat().unapplySeq(string)).isEmpty() && option.get() != null && option.get().lengthCompare(2) == 0) {
            String prefix = (String)((LinearSeqOps)option.get()).apply(0);
            String v4Str = (String)((LinearSeqOps)option.get()).apply(1);
            return this.fromNonMixedString(new StringBuilder(3).append(prefix).append("0:0").toString()).flatMap((Function1<Ipv6Address, Option> & Serializable)pfx -> Ipv4Address$.MODULE$.fromString(v4Str).map((Function1<Ipv4Address, Ipv6Address> & Serializable)v4 -> {
                byte[] bytes = pfx.toBytes();
                byte[] v4bytes = v4.toBytes();
                bytes[12] = v4bytes[0];
                bytes[13] = v4bytes[1];
                bytes[14] = v4bytes[2];
                bytes[15] = v4bytes[3];
                return MODULE$.com$comcast$ip4s$Ipv6Address$$unsafeFromBytes(bytes);
            }));
        }
        return None$.MODULE$;
    }

    public Option<Ipv6Address> fromBytes(byte[] bytes) {
        if (ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.byteArrayOps(bytes)) == 16) {
            return new Some<Ipv6Address>(this.com$comcast$ip4s$Ipv6Address$$unsafeFromBytes((byte[])bytes.clone()));
        }
        return None$.MODULE$;
    }

    public Ipv6Address com$comcast$ip4s$Ipv6Address$$unsafeFromBytes(byte[] bytes) {
        return new Ipv6Address(bytes);
    }

    public Ipv6Address fromBytes(int b0, int b1, int b2, int b3, int b4, int b5, int b6, int b7, int b8, int b9, int b10, int b11, int b12, int b13, int b14, int b15) {
        byte[] bytes = new byte[]{(byte)b0, (byte)b1, (byte)b2, (byte)b3, (byte)b4, (byte)b5, (byte)b6, (byte)b7, (byte)b8, (byte)b9, (byte)b10, (byte)b11, (byte)b12, (byte)b13, (byte)b14, (byte)b15};
        return this.com$comcast$ip4s$Ipv6Address$$unsafeFromBytes(bytes);
    }

    public Ipv6Address fromBigInt(BigInt value) {
        byte[] bytes = new byte[16];
        ObjectRef<BigInt> rem = ObjectRef.create(value);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(15), 0).by(-1).foreach$mVc$sp(i -> {
            bytes$3[i] = ((BigInt)rem$2.elem).$amp(BigInt$.MODULE$.int2bigInt(255)).toByte();
            rem$2.elem = ((BigInt)rem$2.elem).$greater$greater(8);
        });
        return this.com$comcast$ip4s$Ipv6Address$$unsafeFromBytes(bytes);
    }

    public Ipv6Address mask(int bits) {
        int b;
        int n = bits < 0 ? 0 : (b = bits > 128 ? 128 : bits);
        return this.fromBigInt(b == 128 ? package$.MODULE$.BigInt().apply(-1L).$less$less(64).$bar(package$.MODULE$.BigInt().apply(-1L)) : (b < 64 ? package$.MODULE$.BigInt().apply(-1L >>> b ^ 0xFFFFFFFFFFFFFFFFL).$less$less(64) : package$.MODULE$.BigInt().apply(-1L).$less$less(64).$bar(package$.MODULE$.BigInt().apply(-1L >>> b - 64 ^ 0xFFFFFFFFFFFFFFFFL))));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Ipv6Address$.class);
    }

    private Ipv6Address$() {
    }
}

