/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene80;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.lucene80.IndexedDISI;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.EmptyDocValuesProducer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.SortedSetSelector;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.ByteBuffersIndexOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.MathUtil;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.packed.DirectMonotonicWriter;
import org.apache.lucene.util.packed.DirectWriter;

final class Lucene80DocValuesConsumer
extends DocValuesConsumer
implements Closeable {
    IndexOutput data;
    IndexOutput meta;
    final int maxDoc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene80DocValuesConsumer(SegmentWriteState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        boolean success = false;
        try {
            String dataName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, dataExtension);
            this.data = state.directory.createOutput(dataName, state.context);
            CodecUtil.writeIndexHeader(this.data, dataCodec, 0, state.segmentInfo.getId(), state.segmentSuffix);
            String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, metaExtension);
            this.meta = state.directory.createOutput(metaName, state.context);
            CodecUtil.writeIndexHeader(this.meta, metaCodec, 0, state.segmentInfo.getId(), state.segmentSuffix);
            this.maxDoc = state.segmentInfo.maxDoc();
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    @Override
    public void close() throws IOException {
        block7: {
            block6: {
                boolean success = false;
                try {
                    if (this.meta != null) {
                        this.meta.writeInt(-1);
                        CodecUtil.writeFooter(this.meta);
                    }
                    if (this.data != null) {
                        CodecUtil.writeFooter(this.data);
                    }
                    if (!(success = true)) break block6;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(this.data, this.meta);
                    } else {
                        IOUtils.closeWhileHandlingException(this.data, this.meta);
                    }
                    this.data = null;
                    this.meta = null;
                    throw throwable;
                }
                IOUtils.close(this.data, this.meta);
                break block7;
            }
            IOUtils.closeWhileHandlingException(this.data, this.meta);
        }
        this.data = null;
        this.meta = null;
    }

    @Override
    public void addNumericField(FieldInfo field2, final DocValuesProducer valuesProducer) throws IOException {
        this.meta.writeInt(field2.number);
        this.meta.writeByte((byte)0);
        this.writeValues(field2, new EmptyDocValuesProducer(){

            @Override
            public SortedNumericDocValues getSortedNumeric(FieldInfo field2) throws IOException {
                return DocValues.singleton(valuesProducer.getNumeric(field2));
            }
        });
    }

    private long[] writeValues(FieldInfo field2, DocValuesProducer valuesProducer) throws IOException {
        int numBitsPerValue;
        SortedNumericDocValues values2 = valuesProducer.getSortedNumeric(field2);
        int numDocsWithValue = 0;
        MinMaxTracker minMax = new MinMaxTracker();
        MinMaxTracker blockMinMax = new MinMaxTracker();
        long gcd = 0L;
        HashSet<Long> uniqueValues = new HashSet<Long>();
        int doc = values2.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            int count = values2.docValueCount();
            for (int i = 0; i < count; ++i) {
                long v = values2.nextValue();
                if (gcd != 1L) {
                    if (v < -4611686018427387904L || v > 0x3FFFFFFFFFFFFFFFL) {
                        gcd = 1L;
                    } else if (minMax.numValues != 0L) {
                        gcd = MathUtil.gcd(gcd, v - minMax.min);
                    }
                }
                minMax.update(v);
                blockMinMax.update(v);
                if (blockMinMax.numValues == 16384L) {
                    blockMinMax.nextBlock();
                }
                if (uniqueValues == null || !uniqueValues.add(v) || uniqueValues.size() <= 256) continue;
                uniqueValues = null;
            }
            ++numDocsWithValue;
            doc = values2.nextDoc();
        }
        minMax.finish();
        blockMinMax.finish();
        long numValues = minMax.numValues;
        long min2 = minMax.min;
        long max2 = minMax.max;
        assert (blockMinMax.spaceInBits <= minMax.spaceInBits);
        if (numDocsWithValue == 0) {
            this.meta.writeLong(-2L);
            this.meta.writeLong(0L);
            this.meta.writeShort((short)-1);
            this.meta.writeByte((byte)-1);
        } else if (numDocsWithValue == this.maxDoc) {
            this.meta.writeLong(-1L);
            this.meta.writeLong(0L);
            this.meta.writeShort((short)-1);
            this.meta.writeByte((byte)-1);
        } else {
            long offset = this.data.getFilePointer();
            this.meta.writeLong(offset);
            values2 = valuesProducer.getSortedNumeric(field2);
            short jumpTableEntryCount = IndexedDISI.writeBitSet(values2, this.data, (byte)9);
            this.meta.writeLong(this.data.getFilePointer() - offset);
            this.meta.writeShort(jumpTableEntryCount);
            this.meta.writeByte((byte)9);
        }
        this.meta.writeLong(numValues);
        boolean doBlocks = false;
        HashMap<Object, Integer> encode = null;
        if (min2 >= max2) {
            numBitsPerValue = 0;
            this.meta.writeInt(-1);
        } else if (uniqueValues != null && uniqueValues.size() > 1 && DirectWriter.unsignedBitsRequired(uniqueValues.size() - 1) < DirectWriter.unsignedBitsRequired((max2 - min2) / gcd)) {
            numBitsPerValue = DirectWriter.unsignedBitsRequired(uniqueValues.size() - 1);
            Object[] sortedUniqueValues = uniqueValues.toArray(new Long[0]);
            Arrays.sort(sortedUniqueValues);
            this.meta.writeInt(sortedUniqueValues.length);
            for (Object v : sortedUniqueValues) {
                this.meta.writeLong((Long)v);
            }
            encode = new HashMap<Object, Integer>();
            for (int i = 0; i < sortedUniqueValues.length; ++i) {
                encode.put(sortedUniqueValues[i], i);
            }
            min2 = 0L;
            gcd = 1L;
        } else {
            uniqueValues = null;
            boolean bl = doBlocks = minMax.spaceInBits > 0L && (double)blockMinMax.spaceInBits / (double)minMax.spaceInBits <= 0.9;
            if (doBlocks) {
                numBitsPerValue = 255;
                this.meta.writeInt(-16);
            } else {
                numBitsPerValue = DirectWriter.unsignedBitsRequired((max2 - min2) / gcd);
                if (gcd == 1L && min2 > 0L && DirectWriter.unsignedBitsRequired(max2) == DirectWriter.unsignedBitsRequired(max2 - min2)) {
                    min2 = 0L;
                }
                this.meta.writeInt(-1);
            }
        }
        this.meta.writeByte((byte)numBitsPerValue);
        this.meta.writeLong(min2);
        this.meta.writeLong(gcd);
        long startOffset = this.data.getFilePointer();
        this.meta.writeLong(startOffset);
        long jumpTableOffset = -1L;
        if (doBlocks) {
            jumpTableOffset = this.writeValuesMultipleBlocks(valuesProducer.getSortedNumeric(field2), gcd);
        } else if (numBitsPerValue != 0) {
            this.writeValuesSingleBlock(valuesProducer.getSortedNumeric(field2), numValues, numBitsPerValue, min2, gcd, encode);
        }
        this.meta.writeLong(this.data.getFilePointer() - startOffset);
        this.meta.writeLong(jumpTableOffset);
        return new long[]{numDocsWithValue, numValues};
    }

    private void writeValuesSingleBlock(SortedNumericDocValues values2, long numValues, int numBitsPerValue, long min2, long gcd, Map<Long, Integer> encode) throws IOException {
        DirectWriter writer = DirectWriter.getInstance(this.data, numValues, numBitsPerValue);
        int doc = values2.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            int count = values2.docValueCount();
            for (int i = 0; i < count; ++i) {
                long v = values2.nextValue();
                if (encode == null) {
                    writer.add((v - min2) / gcd);
                    continue;
                }
                writer.add(encode.get(v).intValue());
            }
            doc = values2.nextDoc();
        }
        writer.finish();
    }

    private long writeValuesMultipleBlocks(SortedNumericDocValues values2, long gcd) throws IOException {
        long[] offsets = new long[ArrayUtil.oversize(1, 8)];
        int offsetsIndex = 0;
        long[] buffer = new long[16384];
        ByteBuffersDataOutput encodeBuffer = ByteBuffersDataOutput.newResettableInstance();
        int upTo = 0;
        int doc = values2.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            int count = values2.docValueCount();
            for (int i = 0; i < count; ++i) {
                buffer[upTo++] = values2.nextValue();
                if (upTo != 16384) continue;
                offsets = ArrayUtil.grow(offsets, offsetsIndex + 1);
                offsets[offsetsIndex++] = this.data.getFilePointer();
                this.writeBlock(buffer, 16384, gcd, encodeBuffer);
                upTo = 0;
            }
            doc = values2.nextDoc();
        }
        if (upTo > 0) {
            offsets = ArrayUtil.grow(offsets, offsetsIndex + 1);
            offsets[offsetsIndex++] = this.data.getFilePointer();
            this.writeBlock(buffer, upTo, gcd, encodeBuffer);
        }
        long offsetsOrigo = this.data.getFilePointer();
        for (int i = 0; i < offsetsIndex; ++i) {
            this.data.writeLong(offsets[i]);
        }
        this.data.writeLong(offsetsOrigo);
        return offsetsOrigo;
    }

    private void writeBlock(long[] values2, int length, long gcd, ByteBuffersDataOutput buffer) throws IOException {
        assert (length > 0);
        long min2 = values2[0];
        long max2 = values2[0];
        for (int i = 1; i < length; ++i) {
            long v = values2[i];
            assert (Math.floorMod(values2[i] - min2, gcd) == 0L);
            min2 = Math.min(min2, v);
            max2 = Math.max(max2, v);
        }
        if (min2 == max2) {
            this.data.writeByte((byte)0);
            this.data.writeLong(min2);
        } else {
            int bitsPerValue = DirectWriter.unsignedBitsRequired(max2 - min2);
            buffer.reset();
            assert (buffer.size() == 0L);
            DirectWriter w = DirectWriter.getInstance(buffer, length, bitsPerValue);
            for (int i = 0; i < length; ++i) {
                w.add((values2[i] - min2) / gcd);
            }
            w.finish();
            this.data.writeByte((byte)bitsPerValue);
            this.data.writeLong(min2);
            this.data.writeInt(Math.toIntExact(buffer.size()));
            buffer.copyTo(this.data);
        }
    }

    @Override
    public void addBinaryField(FieldInfo field2, DocValuesProducer valuesProducer) throws IOException {
        this.meta.writeInt(field2.number);
        this.meta.writeByte((byte)1);
        BinaryDocValues values2 = valuesProducer.getBinary(field2);
        long start = this.data.getFilePointer();
        this.meta.writeLong(start);
        int numDocsWithField = 0;
        int minLength = Integer.MAX_VALUE;
        int maxLength = 0;
        int doc = values2.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            ++numDocsWithField;
            BytesRef v = values2.binaryValue();
            int length = v.length;
            this.data.writeBytes(v.bytes, v.offset, v.length);
            minLength = Math.min(length, minLength);
            maxLength = Math.max(length, maxLength);
            doc = values2.nextDoc();
        }
        assert (numDocsWithField <= this.maxDoc);
        this.meta.writeLong(this.data.getFilePointer() - start);
        if (numDocsWithField == 0) {
            this.meta.writeLong(-2L);
            this.meta.writeLong(0L);
            this.meta.writeShort((short)-1);
            this.meta.writeByte((byte)-1);
        } else if (numDocsWithField == this.maxDoc) {
            this.meta.writeLong(-1L);
            this.meta.writeLong(0L);
            this.meta.writeShort((short)-1);
            this.meta.writeByte((byte)-1);
        } else {
            long offset = this.data.getFilePointer();
            this.meta.writeLong(offset);
            values2 = valuesProducer.getBinary(field2);
            short jumpTableEntryCount = IndexedDISI.writeBitSet(values2, this.data, (byte)9);
            this.meta.writeLong(this.data.getFilePointer() - offset);
            this.meta.writeShort(jumpTableEntryCount);
            this.meta.writeByte((byte)9);
        }
        this.meta.writeInt(numDocsWithField);
        this.meta.writeInt(minLength);
        this.meta.writeInt(maxLength);
        if (maxLength > minLength) {
            start = this.data.getFilePointer();
            this.meta.writeLong(start);
            this.meta.writeVInt(16);
            DirectMonotonicWriter writer = DirectMonotonicWriter.getInstance(this.meta, this.data, numDocsWithField + 1, 16);
            long addr2 = 0L;
            writer.add(addr2);
            values2 = valuesProducer.getBinary(field2);
            int doc2 = values2.nextDoc();
            while (doc2 != Integer.MAX_VALUE) {
                writer.add(addr2 += (long)values2.binaryValue().length);
                doc2 = values2.nextDoc();
            }
            writer.finish();
            this.meta.writeLong(this.data.getFilePointer() - start);
        }
    }

    @Override
    public void addSortedField(FieldInfo field2, DocValuesProducer valuesProducer) throws IOException {
        this.meta.writeInt(field2.number);
        this.meta.writeByte((byte)2);
        this.doAddSortedField(field2, valuesProducer);
    }

    private void doAddSortedField(FieldInfo field2, DocValuesProducer valuesProducer) throws IOException {
        SortedDocValues values2 = valuesProducer.getSorted(field2);
        int numDocsWithField = 0;
        int doc = values2.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            ++numDocsWithField;
            doc = values2.nextDoc();
        }
        if (numDocsWithField == 0) {
            this.meta.writeLong(-2L);
            this.meta.writeLong(0L);
            this.meta.writeShort((short)-1);
            this.meta.writeByte((byte)-1);
        } else if (numDocsWithField == this.maxDoc) {
            this.meta.writeLong(-1L);
            this.meta.writeLong(0L);
            this.meta.writeShort((short)-1);
            this.meta.writeByte((byte)-1);
        } else {
            long offset = this.data.getFilePointer();
            this.meta.writeLong(offset);
            values2 = valuesProducer.getSorted(field2);
            short jumpTableentryCount = IndexedDISI.writeBitSet(values2, this.data, (byte)9);
            this.meta.writeLong(this.data.getFilePointer() - offset);
            this.meta.writeShort(jumpTableentryCount);
            this.meta.writeByte((byte)9);
        }
        this.meta.writeInt(numDocsWithField);
        if (values2.getValueCount() <= 1) {
            this.meta.writeByte((byte)0);
            this.meta.writeLong(0L);
            this.meta.writeLong(0L);
        } else {
            int numberOfBitsPerOrd = DirectWriter.unsignedBitsRequired(values2.getValueCount() - 1);
            this.meta.writeByte((byte)numberOfBitsPerOrd);
            long start = this.data.getFilePointer();
            this.meta.writeLong(start);
            DirectWriter writer = DirectWriter.getInstance(this.data, numDocsWithField, numberOfBitsPerOrd);
            values2 = valuesProducer.getSorted(field2);
            int doc2 = values2.nextDoc();
            while (doc2 != Integer.MAX_VALUE) {
                writer.add(values2.ordValue());
                doc2 = values2.nextDoc();
            }
            writer.finish();
            this.meta.writeLong(this.data.getFilePointer() - start);
        }
        this.addTermsDict(DocValues.singleton(valuesProducer.getSorted(field2)));
    }

    private void addTermsDict(SortedSetDocValues values2) throws IOException {
        long size = values2.getValueCount();
        this.meta.writeVLong(size);
        this.meta.writeInt(4);
        ByteBuffersDataOutput addressBuffer = new ByteBuffersDataOutput();
        ByteBuffersIndexOutput addressOutput = new ByteBuffersIndexOutput(addressBuffer, "temp", "temp");
        this.meta.writeInt(16);
        long numBlocks = size + 15L >>> 4;
        DirectMonotonicWriter writer = DirectMonotonicWriter.getInstance(this.meta, addressOutput, numBlocks, 16);
        BytesRefBuilder previous = new BytesRefBuilder();
        long ord = 0L;
        long start = this.data.getFilePointer();
        int maxLength = 0;
        TermsEnum iterator = values2.termsEnum();
        BytesRef term = iterator.next();
        while (term != null) {
            if ((ord & 0xFL) == 0L) {
                writer.add(this.data.getFilePointer() - start);
                this.data.writeVInt(term.length);
                this.data.writeBytes(term.bytes, term.offset, term.length);
            } else {
                int prefixLength = StringHelper.bytesDifference(previous.get(), term);
                int suffixLength = term.length - prefixLength;
                assert (suffixLength > 0);
                this.data.writeByte((byte)(Math.min(prefixLength, 15) | Math.min(15, suffixLength - 1) << 4));
                if (prefixLength >= 15) {
                    this.data.writeVInt(prefixLength - 15);
                }
                if (suffixLength >= 16) {
                    this.data.writeVInt(suffixLength - 16);
                }
                this.data.writeBytes(term.bytes, term.offset + prefixLength, term.length - prefixLength);
            }
            maxLength = Math.max(maxLength, term.length);
            previous.copyBytes(term);
            ++ord;
            term = iterator.next();
        }
        writer.finish();
        this.meta.writeInt(maxLength);
        this.meta.writeLong(start);
        this.meta.writeLong(this.data.getFilePointer() - start);
        start = this.data.getFilePointer();
        addressBuffer.copyTo(this.data);
        this.meta.writeLong(start);
        this.meta.writeLong(this.data.getFilePointer() - start);
        this.writeTermsIndex(values2);
    }

    private void writeTermsIndex(SortedSetDocValues values2) throws IOException {
        long size = values2.getValueCount();
        this.meta.writeInt(10);
        long start = this.data.getFilePointer();
        long numBlocks = 1L + (size + 1023L >>> 10);
        ByteBuffersDataOutput addressBuffer = new ByteBuffersDataOutput();
        try (ByteBuffersIndexOutput addressOutput = new ByteBuffersIndexOutput(addressBuffer, "temp", "temp");){
            DirectMonotonicWriter writer = DirectMonotonicWriter.getInstance(this.meta, addressOutput, numBlocks, 16);
            TermsEnum iterator = values2.termsEnum();
            BytesRefBuilder previous = new BytesRefBuilder();
            long offset = 0L;
            long ord = 0L;
            BytesRef term = iterator.next();
            while (term != null) {
                if ((ord & 0x3FFL) == 0L) {
                    writer.add(offset);
                    int sortKeyLength = ord == 0L ? 0 : StringHelper.sortKeyLength(previous.get(), term);
                    offset += (long)sortKeyLength;
                    this.data.writeBytes(term.bytes, term.offset, sortKeyLength);
                } else if ((ord & 0x3FFL) == 1023L) {
                    previous.copyBytes(term);
                }
                ++ord;
                term = iterator.next();
            }
            writer.add(offset);
            writer.finish();
            this.meta.writeLong(start);
            this.meta.writeLong(this.data.getFilePointer() - start);
            start = this.data.getFilePointer();
            addressBuffer.copyTo(this.data);
            this.meta.writeLong(start);
            this.meta.writeLong(this.data.getFilePointer() - start);
        }
    }

    @Override
    public void addSortedNumericField(FieldInfo field2, DocValuesProducer valuesProducer) throws IOException {
        this.meta.writeInt(field2.number);
        this.meta.writeByte((byte)4);
        long[] stats = this.writeValues(field2, valuesProducer);
        int numDocsWithField = Math.toIntExact(stats[0]);
        long numValues = stats[1];
        assert (numValues >= (long)numDocsWithField);
        this.meta.writeInt(numDocsWithField);
        if (numValues > (long)numDocsWithField) {
            long start = this.data.getFilePointer();
            this.meta.writeLong(start);
            this.meta.writeVInt(16);
            DirectMonotonicWriter addressesWriter = DirectMonotonicWriter.getInstance(this.meta, this.data, (long)numDocsWithField + 1L, 16);
            long addr2 = 0L;
            addressesWriter.add(addr2);
            SortedNumericDocValues values2 = valuesProducer.getSortedNumeric(field2);
            int doc = values2.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                addressesWriter.add(addr2 += (long)values2.docValueCount());
                doc = values2.nextDoc();
            }
            addressesWriter.finish();
            this.meta.writeLong(this.data.getFilePointer() - start);
        }
    }

    @Override
    public void addSortedSetField(FieldInfo field2, final DocValuesProducer valuesProducer) throws IOException {
        this.meta.writeInt(field2.number);
        this.meta.writeByte((byte)3);
        SortedSetDocValues values2 = valuesProducer.getSortedSet(field2);
        int numDocsWithField = 0;
        long numOrds = 0L;
        int doc = values2.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            ++numDocsWithField;
            long ord = values2.nextOrd();
            while (ord != -1L) {
                ++numOrds;
                ord = values2.nextOrd();
            }
            doc = values2.nextDoc();
        }
        if ((long)numDocsWithField == numOrds) {
            this.meta.writeByte((byte)0);
            this.doAddSortedField(field2, new EmptyDocValuesProducer(){

                @Override
                public SortedDocValues getSorted(FieldInfo field2) throws IOException {
                    return SortedSetSelector.wrap(valuesProducer.getSortedSet(field2), SortedSetSelector.Type.MIN);
                }
            });
            return;
        }
        this.meta.writeByte((byte)1);
        assert (numDocsWithField != 0);
        if (numDocsWithField == this.maxDoc) {
            this.meta.writeLong(-1L);
            this.meta.writeLong(0L);
            this.meta.writeShort((short)-1);
            this.meta.writeByte((byte)-1);
        } else {
            long offset = this.data.getFilePointer();
            this.meta.writeLong(offset);
            values2 = valuesProducer.getSortedSet(field2);
            short jumpTableEntryCount = IndexedDISI.writeBitSet(values2, this.data, (byte)9);
            this.meta.writeLong(this.data.getFilePointer() - offset);
            this.meta.writeShort(jumpTableEntryCount);
            this.meta.writeByte((byte)9);
        }
        int numberOfBitsPerOrd = DirectWriter.unsignedBitsRequired(values2.getValueCount() - 1L);
        this.meta.writeByte((byte)numberOfBitsPerOrd);
        long start = this.data.getFilePointer();
        this.meta.writeLong(start);
        DirectWriter writer = DirectWriter.getInstance(this.data, numOrds, numberOfBitsPerOrd);
        values2 = valuesProducer.getSortedSet(field2);
        int doc2 = values2.nextDoc();
        while (doc2 != Integer.MAX_VALUE) {
            long ord = values2.nextOrd();
            while (ord != -1L) {
                writer.add(ord);
                ord = values2.nextOrd();
            }
            doc2 = values2.nextDoc();
        }
        writer.finish();
        this.meta.writeLong(this.data.getFilePointer() - start);
        this.meta.writeInt(numDocsWithField);
        start = this.data.getFilePointer();
        this.meta.writeLong(start);
        this.meta.writeVInt(16);
        DirectMonotonicWriter addressesWriter = DirectMonotonicWriter.getInstance(this.meta, this.data, numDocsWithField + 1, 16);
        long addr2 = 0L;
        addressesWriter.add(addr2);
        values2 = valuesProducer.getSortedSet(field2);
        int doc3 = values2.nextDoc();
        while (doc3 != Integer.MAX_VALUE) {
            values2.nextOrd();
            ++addr2;
            while (values2.nextOrd() != -1L) {
                ++addr2;
            }
            addressesWriter.add(addr2);
            doc3 = values2.nextDoc();
        }
        addressesWriter.finish();
        this.meta.writeLong(this.data.getFilePointer() - start);
        this.addTermsDict(values2);
    }

    private static class MinMaxTracker {
        long min;
        long max;
        long numValues;
        long spaceInBits;

        MinMaxTracker() {
            this.reset();
            this.spaceInBits = 0L;
        }

        private void reset() {
            this.min = Long.MAX_VALUE;
            this.max = Long.MIN_VALUE;
            this.numValues = 0L;
        }

        void update(long v) {
            this.min = Math.min(this.min, v);
            this.max = Math.max(this.max, v);
            ++this.numValues;
        }

        void finish() {
            if (this.max > this.min) {
                this.spaceInBits += (long)DirectWriter.unsignedBitsRequired(this.max - this.min) * this.numValues;
            }
        }

        void nextBlock() {
            this.finish();
            this.reset();
        }
    }
}

