/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.PointInSetQuery;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FutureArrays;

public final class BinaryPoint
extends Field {
    private static FieldType getType(byte[][] point) {
        if (point == null) {
            throw new IllegalArgumentException("point must not be null");
        }
        if (point.length == 0) {
            throw new IllegalArgumentException("point must not be 0 dimensions");
        }
        int bytesPerDim = -1;
        for (int i = 0; i < point.length; ++i) {
            byte[] oneDim = point[i];
            if (oneDim == null) {
                throw new IllegalArgumentException("point must not have null values");
            }
            if (oneDim.length == 0) {
                throw new IllegalArgumentException("point must not have 0-length values");
            }
            if (bytesPerDim == -1) {
                bytesPerDim = oneDim.length;
                continue;
            }
            if (bytesPerDim == oneDim.length) continue;
            throw new IllegalArgumentException("all dimensions must have same bytes length; got " + bytesPerDim + " and " + oneDim.length);
        }
        return BinaryPoint.getType(point.length, bytesPerDim);
    }

    private static FieldType getType(int numDims, int bytesPerDim) {
        FieldType type = new FieldType();
        type.setDimensions(numDims, bytesPerDim);
        type.freeze();
        return type;
    }

    private static BytesRef pack(byte[] ... point) {
        if (point == null) {
            throw new IllegalArgumentException("point must not be null");
        }
        if (point.length == 0) {
            throw new IllegalArgumentException("point must not be 0 dimensions");
        }
        if (point.length == 1) {
            return new BytesRef(point[0]);
        }
        int bytesPerDim = -1;
        for (byte[] dim : point) {
            if (dim == null) {
                throw new IllegalArgumentException("point must not have null values");
            }
            if (bytesPerDim == -1) {
                if (dim.length == 0) {
                    throw new IllegalArgumentException("point must not have 0-length values");
                }
                bytesPerDim = dim.length;
                continue;
            }
            if (dim.length == bytesPerDim) continue;
            throw new IllegalArgumentException("all dimensions must have same bytes length; got " + bytesPerDim + " and " + dim.length);
        }
        byte[] packed = new byte[bytesPerDim * point.length];
        for (int i = 0; i < point.length; ++i) {
            System.arraycopy(point[i], 0, packed, i * bytesPerDim, bytesPerDim);
        }
        return new BytesRef(packed);
    }

    public BinaryPoint(String name, byte[] ... point) {
        super(name, BinaryPoint.pack(point), (IndexableFieldType)BinaryPoint.getType(point));
    }

    public BinaryPoint(String name, byte[] packedPoint, IndexableFieldType type) {
        super(name, packedPoint, type);
        if (packedPoint.length != type.pointDataDimensionCount() * type.pointNumBytes()) {
            throw new IllegalArgumentException("packedPoint is length=" + packedPoint.length + " but type.pointDimensionCount()=" + type.pointDataDimensionCount() + " and type.pointNumBytes()=" + type.pointNumBytes());
        }
    }

    public static Query newExactQuery(String field2, byte[] value) {
        return BinaryPoint.newRangeQuery(field2, value, value);
    }

    public static Query newRangeQuery(String field2, byte[] lowerValue, byte[] upperValue) {
        PointRangeQuery.checkArgs(field2, lowerValue, upperValue);
        return BinaryPoint.newRangeQuery(field2, new byte[][]{lowerValue}, new byte[][]{upperValue});
    }

    public static Query newRangeQuery(String field2, byte[][] lowerValue, byte[][] upperValue) {
        return new PointRangeQuery(field2, BinaryPoint.pack((byte[][])lowerValue).bytes, BinaryPoint.pack((byte[][])upperValue).bytes, lowerValue.length){

            @Override
            protected String toString(int dimension, byte[] value) {
                assert (value != null);
                StringBuilder sb = new StringBuilder();
                sb.append("binary(");
                for (int i = 0; i < value.length; ++i) {
                    if (i > 0) {
                        sb.append(' ');
                    }
                    sb.append(Integer.toHexString(value[i] & 0xFF));
                }
                sb.append(')');
                return sb.toString();
            }
        };
    }

    public static Query newSetQuery(String field2, byte[] ... values2) {
        int bytesPerDim = -1;
        for (byte[] value : values2) {
            if (bytesPerDim == -1) {
                bytesPerDim = value.length;
                continue;
            }
            if (value.length == bytesPerDim) continue;
            throw new IllegalArgumentException("all byte[] must be the same length, but saw " + bytesPerDim + " and " + value.length);
        }
        if (bytesPerDim == -1) {
            return new MatchNoDocsQuery("empty BinaryPoint.newSetQuery");
        }
        final byte[][] sortedValues = (byte[][])values2.clone();
        Arrays.sort(sortedValues, new Comparator<byte[]>(){

            @Override
            public int compare(byte[] a, byte[] b) {
                return FutureArrays.compareUnsigned(a, 0, a.length, b, 0, b.length);
            }
        });
        final BytesRef encoded = new BytesRef(new byte[bytesPerDim]);
        return new PointInSetQuery(field2, 1, bytesPerDim, new PointInSetQuery.Stream(){
            int upto;

            @Override
            public BytesRef next() {
                if (this.upto == sortedValues.length) {
                    return null;
                }
                encoded.bytes = sortedValues[this.upto];
                ++this.upto;
                return encoded;
            }
        }){

            @Override
            protected String toString(byte[] value) {
                return new BytesRef(value).toString();
            }
        };
    }
}

