/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.DocValuesFieldUpdates;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.AbstractPagedMutable;
import org.apache.lucene.util.packed.PackedInts;
import org.apache.lucene.util.packed.PagedGrowableWriter;
import org.apache.lucene.util.packed.PagedMutable;

final class NumericDocValuesFieldUpdates
extends DocValuesFieldUpdates {
    private AbstractPagedMutable<?> values;
    private final long minValue;

    NumericDocValuesFieldUpdates(long delGen, String field2, int maxDoc) {
        super(maxDoc, delGen, field2, DocValuesType.NUMERIC);
        this.values = new PagedGrowableWriter(1L, 1024, 1, 0.25f);
        this.minValue = 0L;
    }

    NumericDocValuesFieldUpdates(long delGen, String field2, long minValue, long maxValue, int maxDoc) {
        super(maxDoc, delGen, field2, DocValuesType.NUMERIC);
        assert (minValue <= maxValue) : "minValue must be <= maxValue [" + minValue + " > " + maxValue + "]";
        int bitsPerValue = PackedInts.unsignedBitsRequired(maxValue - minValue);
        this.values = new PagedMutable(1L, 1024, bitsPerValue, 0.25f);
        this.minValue = minValue;
    }

    @Override
    void add(int doc, BytesRef value) {
        throw new UnsupportedOperationException();
    }

    @Override
    void add(int docId, DocValuesFieldUpdates.Iterator iterator) {
        this.add(docId, iterator.longValue());
    }

    @Override
    synchronized void add(int doc, long value) {
        int add = this.add(doc);
        this.values.set(add, value - this.minValue);
    }

    @Override
    protected void swap(int i, int j) {
        super.swap(i, j);
        long tmpVal = this.values.get(j);
        this.values.set(j, this.values.get(i));
        this.values.set(i, tmpVal);
    }

    @Override
    protected void grow(int size) {
        super.grow(size);
        this.values = this.values.grow(size);
    }

    @Override
    protected void resize(int size) {
        super.resize(size);
        this.values = this.values.resize(size);
    }

    @Override
    Iterator iterator() {
        this.ensureFinished();
        return new Iterator(this.size, this.minValue, this.values, this.docs, this.delGen);
    }

    @Override
    public long ramBytesUsed() {
        return this.values.ramBytesUsed() + super.ramBytesUsed() + 8L + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
    }

    static class SingleValueNumericDocValuesFieldUpdates
    extends DocValuesFieldUpdates.SingleValueDocValuesFieldUpdates {
        private final long value;

        SingleValueNumericDocValuesFieldUpdates(long delGen, String field2, int maxDoc, long value) {
            super(maxDoc, delGen, field2, DocValuesType.NUMERIC);
            this.value = value;
        }

        @Override
        protected BytesRef binaryValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected long longValue() {
            return this.value;
        }
    }

    static final class Iterator
    extends DocValuesFieldUpdates.AbstractIterator {
        private final AbstractPagedMutable<?> values;
        private final long minValue;
        private long value;

        Iterator(int size, long minValue, AbstractPagedMutable<?> values2, PagedMutable docs, long delGen) {
            super(size, docs, delGen);
            this.values = values2;
            this.minValue = minValue;
        }

        @Override
        long longValue() {
            return this.value;
        }

        @Override
        BytesRef binaryValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void set(long idx) {
            this.value = this.values.get(idx) + this.minValue;
        }
    }
}

