/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.util.MathUtil;
import org.apache.lucene.util.Selector;
import org.apache.lucene.util.Sorter;

public abstract class IntroSelector
extends Selector {
    @Override
    public final void select(int from2, int to, int k) {
        this.checkArgs(from2, to, k);
        int maxDepth = 2 * MathUtil.log(to - from2, 2);
        this.quickSelect(from2, to, k, maxDepth);
    }

    void slowSelect(int from2, int to, int k) {
        new Sorter(){

            @Override
            protected void swap(int i, int j) {
                IntroSelector.this.swap(i, j);
            }

            @Override
            protected int compare(int i, int j) {
                return IntroSelector.this.compare(i, j);
            }

            @Override
            public void sort(int from2, int to) {
                this.heapSort(from2, to);
            }
        }.sort(from2, to);
    }

    private void quickSelect(int from2, int to, int k, int maxDepth) {
        assert (from2 <= k);
        assert (k < to);
        if (to - from2 == 1) {
            return;
        }
        if (--maxDepth < 0) {
            this.slowSelect(from2, to, k);
            return;
        }
        int mid = from2 + to >>> 1;
        if (this.compare(from2, to - 1) > 0) {
            this.swap(from2, to - 1);
        }
        if (this.compare(to - 1, mid) > 0) {
            this.swap(to - 1, mid);
            if (this.compare(from2, to - 1) > 0) {
                this.swap(from2, to - 1);
            }
        }
        this.setPivot(to - 1);
        int left = from2 + 1;
        int right = to - 2;
        while (true) {
            if (this.comparePivot(left) > 0) {
                ++left;
                continue;
            }
            while (left < right && this.comparePivot(right) <= 0) {
                --right;
            }
            if (left >= right) break;
            this.swap(left, right);
            --right;
        }
        this.swap(left, to - 1);
        if (left == k) {
            return;
        }
        if (left < k) {
            this.quickSelect(left + 1, to, k, maxDepth);
        } else {
            this.quickSelect(from2, left, k, maxDepth);
        }
    }

    protected int compare(int i, int j) {
        this.setPivot(i);
        return this.comparePivot(j);
    }

    protected abstract void setPivot(int var1);

    protected abstract int comparePivot(int var1);
}

