/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.document.BinaryRangeDocValuesField;
import org.apache.lucene.document.IntRange;
import org.apache.lucene.document.IntRangeSlowRangeQuery;
import org.apache.lucene.document.RangeFieldQuery;
import org.apache.lucene.search.Query;

public class IntRangeDocValuesField
extends BinaryRangeDocValuesField {
    final String field;
    final int[] min;
    final int[] max;

    public IntRangeDocValuesField(String field2, int[] min2, int[] max2) {
        super(field2, IntRange.encode(min2, max2), min2.length, 4);
        IntRangeDocValuesField.checkArgs(min2, max2);
        this.field = field2;
        this.min = min2;
        this.max = max2;
    }

    public int getMin(int dimension) {
        if (dimension > 4 || dimension > this.min.length) {
            throw new IllegalArgumentException("Dimension out of valid range");
        }
        return this.min[dimension];
    }

    public int getMax(int dimension) {
        if (dimension > 4 || dimension > this.min.length) {
            throw new IllegalArgumentException("Dimension out of valid range");
        }
        return this.max[dimension];
    }

    private static Query newSlowRangeQuery(String field2, int[] min2, int[] max2, RangeFieldQuery.QueryType queryType) {
        IntRangeDocValuesField.checkArgs(min2, max2);
        return new IntRangeSlowRangeQuery(field2, min2, max2, queryType);
    }

    public static Query newSlowIntersectsQuery(String field2, int[] min2, int[] max2) {
        return IntRangeDocValuesField.newSlowRangeQuery(field2, min2, max2, RangeFieldQuery.QueryType.INTERSECTS);
    }

    private static void checkArgs(int[] min2, int[] max2) {
        if (min2 == null || max2 == null || min2.length == 0 || max2.length == 0) {
            throw new IllegalArgumentException("min/max range values cannot be null or empty");
        }
        if (min2.length != max2.length) {
            throw new IllegalArgumentException("min/max ranges must agree");
        }
        for (int i = 0; i < min2.length; ++i) {
            if (min2[i] <= max2[i]) continue;
            throw new IllegalArgumentException("min should be less than max but min = " + min2[i] + " and max = " + max2[i]);
        }
    }
}

