/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.BaseTermsEnum;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.OrdTermState;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;

class SortedSetDocValuesTermsEnum
extends BaseTermsEnum {
    private final SortedSetDocValues values;
    private long currentOrd = -1L;
    private final BytesRefBuilder scratch;

    public SortedSetDocValuesTermsEnum(SortedSetDocValues values2) {
        this.values = values2;
        this.scratch = new BytesRefBuilder();
    }

    @Override
    public TermsEnum.SeekStatus seekCeil(BytesRef text2) throws IOException {
        long ord = this.values.lookupTerm(text2);
        if (ord >= 0L) {
            this.currentOrd = ord;
            this.scratch.copyBytes(text2);
            return TermsEnum.SeekStatus.FOUND;
        }
        this.currentOrd = -ord - 1L;
        if (this.currentOrd == this.values.getValueCount()) {
            return TermsEnum.SeekStatus.END;
        }
        this.scratch.copyBytes(this.values.lookupOrd(this.currentOrd));
        return TermsEnum.SeekStatus.NOT_FOUND;
    }

    @Override
    public boolean seekExact(BytesRef text2) throws IOException {
        long ord = this.values.lookupTerm(text2);
        if (ord >= 0L) {
            this.currentOrd = ord;
            this.scratch.copyBytes(text2);
            return true;
        }
        return false;
    }

    @Override
    public void seekExact(long ord) throws IOException {
        assert (ord >= 0L && ord < this.values.getValueCount());
        this.currentOrd = (int)ord;
        this.scratch.copyBytes(this.values.lookupOrd(this.currentOrd));
    }

    @Override
    public BytesRef next() throws IOException {
        ++this.currentOrd;
        if (this.currentOrd >= this.values.getValueCount()) {
            return null;
        }
        this.scratch.copyBytes(this.values.lookupOrd(this.currentOrd));
        return this.scratch.get();
    }

    @Override
    public BytesRef term() throws IOException {
        return this.scratch.get();
    }

    @Override
    public long ord() throws IOException {
        return this.currentOrd;
    }

    @Override
    public int docFreq() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long totalTermFreq() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImpactsEnum impacts(int flags) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void seekExact(BytesRef term, TermState state) throws IOException {
        assert (state != null && state instanceof OrdTermState);
        this.seekExact(((OrdTermState)state).ord);
    }

    @Override
    public TermState termState() throws IOException {
        OrdTermState state = new OrdTermState();
        state.ord = this.currentOrd;
        return state;
    }
}

