/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import org.apache.lucene.geo.EdgeTree;
import org.apache.lucene.geo.Polygon2D;
import org.apache.lucene.geo.XYPolygon;

public class XYPolygon2D
extends Polygon2D {
    protected XYPolygon2D(XYPolygon polygon, XYPolygon2D holes) {
        super(polygon.minY, polygon.maxY, polygon.minX, polygon.maxX, polygon.getPolyY(), polygon.getPolyX(), holes);
    }

    public static XYPolygon2D create(XYPolygon ... polygons) {
        EdgeTree[] components = new XYPolygon2D[polygons.length];
        for (int i = 0; i < components.length; ++i) {
            XYPolygon gon = polygons[i];
            XYPolygon[] gonHoles = gon.getHoles();
            XYPolygon2D holes = null;
            if (gonHoles.length > 0) {
                holes = XYPolygon2D.create(gonHoles);
            }
            components[i] = new XYPolygon2D(gon, holes);
        }
        return (XYPolygon2D)XYPolygon2D.createTree(components, 0, components.length - 1, false);
    }
}

