/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.id;

import org.apache.lucene.analysis.util.StemmerUtil;

public class IndonesianStemmer {
    private int numSyllables;
    private int flags;
    private static final int REMOVED_KE = 1;
    private static final int REMOVED_PENG = 2;
    private static final int REMOVED_DI = 4;
    private static final int REMOVED_MENG = 8;
    private static final int REMOVED_TER = 16;
    private static final int REMOVED_BER = 32;
    private static final int REMOVED_PE = 64;

    public int stem(char[] text2, int length, boolean stemDerivational) {
        this.flags = 0;
        this.numSyllables = 0;
        for (int i = 0; i < length; ++i) {
            if (!this.isVowel(text2[i])) continue;
            ++this.numSyllables;
        }
        if (this.numSyllables > 2) {
            length = this.removeParticle(text2, length);
        }
        if (this.numSyllables > 2) {
            length = this.removePossessivePronoun(text2, length);
        }
        if (stemDerivational) {
            length = this.stemDerivational(text2, length);
        }
        return length;
    }

    private int stemDerivational(char[] text2, int length) {
        int oldLength = length;
        if (this.numSyllables > 2) {
            length = this.removeFirstOrderPrefix(text2, length);
        }
        if (oldLength != length) {
            oldLength = length;
            if (this.numSyllables > 2) {
                length = this.removeSuffix(text2, length);
            }
            if (oldLength != length && this.numSyllables > 2) {
                length = this.removeSecondOrderPrefix(text2, length);
            }
        } else {
            if (this.numSyllables > 2) {
                length = this.removeSecondOrderPrefix(text2, length);
            }
            if (this.numSyllables > 2) {
                length = this.removeSuffix(text2, length);
            }
        }
        return length;
    }

    private boolean isVowel(char ch) {
        switch (ch) {
            case 'a': 
            case 'e': 
            case 'i': 
            case 'o': 
            case 'u': {
                return true;
            }
        }
        return false;
    }

    private int removeParticle(char[] text2, int length) {
        if (StemmerUtil.endsWith(text2, length, "kah") || StemmerUtil.endsWith(text2, length, "lah") || StemmerUtil.endsWith(text2, length, "pun")) {
            --this.numSyllables;
            return length - 3;
        }
        return length;
    }

    private int removePossessivePronoun(char[] text2, int length) {
        if (StemmerUtil.endsWith(text2, length, "ku") || StemmerUtil.endsWith(text2, length, "mu")) {
            --this.numSyllables;
            return length - 2;
        }
        if (StemmerUtil.endsWith(text2, length, "nya")) {
            --this.numSyllables;
            return length - 3;
        }
        return length;
    }

    private int removeFirstOrderPrefix(char[] text2, int length) {
        if (StemmerUtil.startsWith(text2, length, "meng")) {
            this.flags |= 8;
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length, 4);
        }
        if (StemmerUtil.startsWith(text2, length, "meny") && length > 4 && this.isVowel(text2[4])) {
            this.flags |= 8;
            text2[3] = 115;
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length, 3);
        }
        if (StemmerUtil.startsWith(text2, length, "men")) {
            this.flags |= 8;
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length, 3);
        }
        if (StemmerUtil.startsWith(text2, length, "mem")) {
            this.flags |= 8;
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length, 3);
        }
        if (StemmerUtil.startsWith(text2, length, "me")) {
            this.flags |= 8;
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length, 2);
        }
        if (StemmerUtil.startsWith(text2, length, "peng")) {
            this.flags |= 2;
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length, 4);
        }
        if (StemmerUtil.startsWith(text2, length, "peny") && length > 4 && this.isVowel(text2[4])) {
            this.flags |= 2;
            text2[3] = 115;
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length, 3);
        }
        if (StemmerUtil.startsWith(text2, length, "peny")) {
            this.flags |= 2;
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length, 4);
        }
        if (StemmerUtil.startsWith(text2, length, "pen") && length > 3 && this.isVowel(text2[3])) {
            this.flags |= 2;
            text2[2] = 116;
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length, 2);
        }
        if (StemmerUtil.startsWith(text2, length, "pen")) {
            this.flags |= 2;
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length, 3);
        }
        if (StemmerUtil.startsWith(text2, length, "pem")) {
            this.flags |= 2;
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length, 3);
        }
        if (StemmerUtil.startsWith(text2, length, "di")) {
            this.flags |= 4;
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length, 2);
        }
        if (StemmerUtil.startsWith(text2, length, "ter")) {
            this.flags |= 0x10;
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length, 3);
        }
        if (StemmerUtil.startsWith(text2, length, "ke")) {
            this.flags |= 1;
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length, 2);
        }
        return length;
    }

    private int removeSecondOrderPrefix(char[] text2, int length) {
        if (StemmerUtil.startsWith(text2, length, "ber")) {
            this.flags |= 0x20;
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length, 3);
        }
        if (length == 7 && StemmerUtil.startsWith(text2, length, "belajar")) {
            this.flags |= 0x20;
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length, 3);
        }
        if (StemmerUtil.startsWith(text2, length, "be") && length > 4 && !this.isVowel(text2[2]) && text2[3] == 'e' && text2[4] == 'r') {
            this.flags |= 0x20;
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length, 2);
        }
        if (StemmerUtil.startsWith(text2, length, "per")) {
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length, 3);
        }
        if (length == 7 && StemmerUtil.startsWith(text2, length, "pelajar")) {
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length, 3);
        }
        if (StemmerUtil.startsWith(text2, length, "pe")) {
            this.flags |= 0x40;
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length, 2);
        }
        return length;
    }

    private int removeSuffix(char[] text2, int length) {
        if (StemmerUtil.endsWith(text2, length, "kan") && (this.flags & 1) == 0 && (this.flags & 2) == 0 && (this.flags & 0x40) == 0) {
            --this.numSyllables;
            return length - 3;
        }
        if (StemmerUtil.endsWith(text2, length, "an") && (this.flags & 4) == 0 && (this.flags & 8) == 0 && (this.flags & 0x10) == 0) {
            --this.numSyllables;
            return length - 2;
        }
        if (StemmerUtil.endsWith(text2, length, "i") && !StemmerUtil.endsWith(text2, length, "si") && (this.flags & 0x20) == 0 && (this.flags & 1) == 0 && (this.flags & 2) == 0) {
            --this.numSyllables;
            return length - 1;
        }
        return length;
    }
}

