/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.middleware;

import cats.Eval;
import cats.Eval$;
import cats.Foldable;
import cats.UnorderedFoldable$;
import cats.effect.kernel.Async;
import cats.effect.kernel.Ref;
import cats.effect.kernel.Ref$;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.kernel.Sync;
import cats.syntax.OptionIdOps$;
import cats.syntax.package$all$;
import java.io.Serializable;
import org.http4s.HttpDate;
import org.http4s.HttpDate$;
import org.http4s.Request;
import org.http4s.RequestCookie;
import org.http4s.Response;
import org.http4s.ResponseCookie;
import org.http4s.SameSite;
import org.http4s.Uri;
import org.http4s.Uri$Scheme$;
import org.http4s.client.Client;
import org.http4s.client.Client$;
import org.http4s.client.middleware.CookieJar;
import org.http4s.client.middleware.CookieJar$CookieValue$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class CookieJar$ {
    public static final CookieJar$ MODULE$ = new CookieJar$();

    public <F> Client<F> apply(CookieJar<F> alg, Client<F> client, Async<F> evidence$2) {
        return Client$.MODULE$.apply((Function1<Request, Resource> & Serializable)req -> Resource$.MODULE$.eval(alg.evictExpired()).flatMap((Function1<BoxedUnit, Resource> & Serializable)x$5 -> {
            BoxedUnit boxedUnit = x$5;
            return Resource$.MODULE$.eval(alg.enrichRequest(req)).flatMap((Function1<Request, Resource> & Serializable)modRequest -> client.run((Request)modRequest).flatMap((Function1<Response, Resource> & Serializable)out -> Resource$.MODULE$.eval(package$all$.MODULE$.toFoldableOps(out.cookies().map((Function1<ResponseCookie, ResponseCookie> & Serializable)r -> (ResponseCookie)r.domain().fold((Function0<ResponseCookie> & Serializable)() -> {
                Option<String> x$12 = req.uri().host().map((Function1<Uri.Host, String> & Serializable)x$1 -> x$1.value());
                String x$2 = r.copy$default$1();
                String x$3 = r.copy$default$2();
                Option<HttpDate> x$4 = r.copy$default$3();
                Option<Object> x$5 = r.copy$default$4();
                Option<String> x$6 = r.copy$default$6();
                Option<SameSite> x$7 = r.copy$default$7();
                boolean x$8 = r.copy$default$8();
                boolean x$9 = r.copy$default$9();
                Option<String> x$10 = r.copy$default$10();
                return r.copy(x$2, x$3, x$4, x$5, x$12, x$6, x$7, x$8, x$9, x$10);
            }, (Function1<String, ResponseCookie> & Serializable)x$2 -> r)), UnorderedFoldable$.MODULE$.catsTraverseForList()).traverse_((Function1<ResponseCookie, Object> & Serializable)x$3 -> alg.addCookie((ResponseCookie)x$3, req.uri()), evidence$2)).map((Function1<BoxedUnit, Response> & Serializable)x$4 -> {
                BoxedUnit boxedUnit = x$4;
                return out;
            })));
        }), evidence$2);
    }

    public <F> F impl(Client<F> c, Async<F> evidence$3) {
        return this.in(c, evidence$3, evidence$3);
    }

    public <F, G> G in(Client<F> c, Async<F> evidence$4, Sync<G> evidence$5) {
        return package$all$.MODULE$.toFunctorOps(this.jarIn(evidence$4, evidence$5), evidence$5).map((Function1<CookieJar, Client> & Serializable)x$6 -> MODULE$.apply((CookieJar)x$6, c, evidence$4));
    }

    public <F> F jarImpl(Async<F> evidence$6) {
        return this.jarIn(evidence$6, evidence$6);
    }

    public <F, G> G jarIn(Async<F> evidence$7, Sync<G> evidence$8) {
        return package$all$.MODULE$.toFunctorOps(Ref$.MODULE$.in(Predef$.MODULE$.Map().empty(), evidence$8, evidence$7), evidence$8).map((Function1<Ref, CookieJar.CookieJarRefImpl> & Serializable)ref -> new CookieJar.CookieJarRefImpl<F>((Ref)ref, evidence$7){});
    }

    public HttpDate expiresAt(HttpDate now, ResponseCookie c, HttpDate httpDate) {
        return (HttpDate)c.expires().orElse((Function0<Option> & Serializable)() -> c.maxAge().flatMap((Function1<Object, Option> & Serializable)seconds -> CookieJar$.$anonfun$expiresAt$2(now, BoxesRunTime.unboxToLong(seconds)))).getOrElse((Function0<HttpDate> & Serializable)() -> httpDate);
    }

    public <G> Map<CookieJar.CookieKey, CookieJar.CookieValue> extractFromResponseCookies(Map<CookieJar.CookieKey, CookieJar.CookieValue> m, G cookies, HttpDate httpDate, Foldable<G> evidence$11) {
        return package$all$.MODULE$.toFoldableOps(cookies, evidence$11).foldRight(Eval$.MODULE$.now(m), (Function2<Tuple2, Eval, Eval> & Serializable)(x0$1, x1$1) -> {
            Tuple2<Tuple2, Eval> tuple2 = new Tuple2<Tuple2, Eval>((Tuple2)x0$1, (Eval)x1$1);
            if (tuple2 != null) {
                Tuple2 tuple22 = tuple2._1();
                Eval eM = tuple2._2();
                if (tuple22 != null) {
                    ResponseCookie rc = (ResponseCookie)tuple22._1();
                    Uri uri = (Uri)tuple22._2();
                    return eM.map((Function1<Map, Map> & Serializable)m -> MODULE$.extractFromResponseCookie((Map<CookieJar.CookieKey, CookieJar.CookieValue>)m, rc, httpDate, uri));
                }
            }
            throw new MatchError(tuple2);
        }).value();
    }

    public Map<CookieJar.CookieKey, CookieJar.CookieValue> extractFromResponseCookie(Map<CookieJar.CookieKey, CookieJar.CookieValue> m, ResponseCookie c, HttpDate httpDate, Uri uri) {
        Option option = c.domain().orElse((Function0<Option> & Serializable)() -> uri.host().map((Function1<Uri.Host, String> & Serializable)x$11 -> x$11.value()));
        if (option instanceof Some) {
            Some some = (Some)option;
            String domainS = (String)some.value();
            CookieJar.CookieKey key = new CookieJar.CookieKey(c.name(), domainS, c.path());
            Option<String> x$1 = OptionIdOps$.MODULE$.some$extension(package$all$.MODULE$.catsSyntaxOptionId(domainS));
            String x$2 = c.copy$default$1();
            String x$3 = c.copy$default$2();
            Option<HttpDate> x$4 = c.copy$default$3();
            Option<Object> x$5 = c.copy$default$4();
            Option<String> x$6 = c.copy$default$6();
            Option<SameSite> x$7 = c.copy$default$7();
            boolean x$8 = c.copy$default$8();
            boolean x$9 = c.copy$default$9();
            Option<String> x$10 = c.copy$default$10();
            ResponseCookie newCookie = c.copy(x$2, x$3, x$4, x$5, x$1, x$6, x$7, x$8, x$9, x$10);
            HttpDate expires = this.expiresAt(httpDate, c, HttpDate$.MODULE$.MaxValue());
            CookieJar.CookieValue value = CookieJar$CookieValue$.MODULE$.apply(httpDate, expires, newCookie);
            return (Map)m.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), value));
        }
        if (None$.MODULE$.equals(option)) {
            return m;
        }
        throw new MatchError(option);
    }

    public RequestCookie responseCookieToRequestCookie(ResponseCookie r) {
        return new RequestCookie(r.name(), r.content());
    }

    public <N> boolean cookieAppliesToRequest(Request<N> r, ResponseCookie c) {
        boolean domainApplies = c.domain().exists((Function1<String, Object> & Serializable)s2 -> BoxesRunTime.boxToBoolean(CookieJar$.$anonfun$cookieAppliesToRequest$1(r, s2)));
        boolean pathApplies = c.path().forall((Function1<String, Object> & Serializable)s2 -> BoxesRunTime.boxToBoolean(CookieJar$.$anonfun$cookieAppliesToRequest$3(r, s2)));
        boolean secureSatisfied = c.secure() ? r.uri().scheme().exists((Function1<Uri.Scheme, Object> & Serializable)scheme -> BoxesRunTime.boxToBoolean(CookieJar$.$anonfun$cookieAppliesToRequest$4(scheme))) : true;
        return domainApplies && pathApplies && secureSatisfied;
    }

    public <N> List<RequestCookie> cookiesForRequest(Request<N> r, List<ResponseCookie> l) {
        return (List)l.foldLeft(package$.MODULE$.List().empty(), (Function2<List, ResponseCookie, List> & Serializable)(x0$1, x1$1) -> {
            Tuple2<List, ResponseCookie> tuple2 = new Tuple2<List, ResponseCookie>((List)x0$1, (ResponseCookie)x1$1);
            if (tuple2 != null) {
                List list = tuple2._1();
                ResponseCookie cookie = tuple2._2();
                if (MODULE$.cookieAppliesToRequest(r, cookie)) {
                    RequestCookie requestCookie = MODULE$.responseCookieToRequestCookie(cookie);
                    return list.$colon$colon(requestCookie);
                }
                return list;
            }
            throw new MatchError(tuple2);
        });
    }

    public static final /* synthetic */ Option $anonfun$expiresAt$2(HttpDate now$3, long seconds) {
        return HttpDate$.MODULE$.fromEpochSecond(now$3.epochSecond() + seconds).toOption();
    }

    public static final /* synthetic */ boolean $anonfun$cookieAppliesToRequest$2(String s$1, Uri.Host authority) {
        return authority.renderString().contains(s$1);
    }

    public static final /* synthetic */ boolean $anonfun$cookieAppliesToRequest$1(Request r$3, String s2) {
        return r$3.uri().host().forall((Function1<Uri.Host, Object> & Serializable)authority -> BoxesRunTime.boxToBoolean(CookieJar$.$anonfun$cookieAppliesToRequest$2(s2, authority)));
    }

    public static final /* synthetic */ boolean $anonfun$cookieAppliesToRequest$3(Request r$3, String s2) {
        return r$3.uri().path().renderString().contains(s2);
    }

    public static final /* synthetic */ boolean $anonfun$cookieAppliesToRequest$4(Uri.Scheme scheme) {
        return package$all$.MODULE$.catsSyntaxEq(scheme, Uri$Scheme$.MODULE$.http4sOrderForScheme()).$eq$eq$eq(Uri$Scheme$.MODULE$.https());
    }

    private CookieJar$() {
    }
}

