/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;

public class RegExUtils {
    public static Pattern dotAll(String regex) {
        return Pattern.compile(regex, 32);
    }

    public static Matcher dotAllMatcher(String regex, String text2) {
        return RegExUtils.dotAll(regex).matcher(text2);
    }

    public static String removeAll(String text2, Pattern regex) {
        return RegExUtils.replaceAll(text2, regex, "");
    }

    public static String removeAll(String text2, String regex) {
        return RegExUtils.replaceAll(text2, regex, "");
    }

    public static String removeFirst(String text2, Pattern regex) {
        return RegExUtils.replaceFirst(text2, regex, "");
    }

    public static String removeFirst(String text2, String regex) {
        return RegExUtils.replaceFirst(text2, regex, "");
    }

    public static String removePattern(String text2, String regex) {
        return RegExUtils.replacePattern(text2, regex, "");
    }

    public static String replaceAll(String text2, Pattern regex, String replacement) {
        if (ObjectUtils.anyNull(text2, regex, replacement)) {
            return text2;
        }
        return regex.matcher(text2).replaceAll(replacement);
    }

    public static String replaceAll(String text2, String regex, String replacement) {
        if (ObjectUtils.anyNull(text2, regex, replacement)) {
            return text2;
        }
        return text2.replaceAll(regex, replacement);
    }

    public static String replaceFirst(String text2, Pattern regex, String replacement) {
        if (text2 == null || regex == null || replacement == null) {
            return text2;
        }
        return regex.matcher(text2).replaceFirst(replacement);
    }

    public static String replaceFirst(String text2, String regex, String replacement) {
        if (text2 == null || regex == null || replacement == null) {
            return text2;
        }
        return text2.replaceFirst(regex, replacement);
    }

    public static String replacePattern(String text2, String regex, String replacement) {
        if (ObjectUtils.anyNull(text2, regex, replacement)) {
            return text2;
        }
        return RegExUtils.dotAllMatcher(regex, text2).replaceAll(replacement);
    }
}

