/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.intervals;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.queries.intervals.ConjunctionIntervalIterator;
import org.apache.lucene.queries.intervals.ConjunctionIntervalsSource;
import org.apache.lucene.queries.intervals.Disjunctions;
import org.apache.lucene.queries.intervals.IntervalIterator;
import org.apache.lucene.queries.intervals.IntervalsSource;
import org.apache.lucene.util.PriorityQueue;

class UnorderedIntervalsSource
extends ConjunctionIntervalsSource {
    static IntervalsSource build(List<IntervalsSource> sources) {
        if (sources.size() == 1) {
            return sources.get(0);
        }
        return new UnorderedIntervalsSource(UnorderedIntervalsSource.flatten(sources));
    }

    private static List<IntervalsSource> flatten(List<IntervalsSource> sources) {
        ArrayList<IntervalsSource> flattened = new ArrayList<IntervalsSource>();
        for (IntervalsSource s2 : sources) {
            if (s2 instanceof UnorderedIntervalsSource) {
                flattened.addAll(((UnorderedIntervalsSource)s2).subSources);
                continue;
            }
            flattened.add(s2);
        }
        return flattened;
    }

    private UnorderedIntervalsSource(List<IntervalsSource> sources) {
        super(sources, true);
    }

    @Override
    protected IntervalIterator combine(List<IntervalIterator> iterators) {
        return new UnorderedIntervalIterator(iterators);
    }

    @Override
    public int minExtent() {
        int minExtent = 0;
        for (IntervalsSource subSource : this.subSources) {
            minExtent += subSource.minExtent();
        }
        return minExtent;
    }

    @Override
    public Collection<IntervalsSource> pullUpDisjunctions() {
        return Disjunctions.pullUp(this.subSources, UnorderedIntervalsSource::new);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.subSources);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof UnorderedIntervalsSource)) {
            return false;
        }
        UnorderedIntervalsSource o = (UnorderedIntervalsSource)other;
        return Objects.equals(this.subSources, o.subSources);
    }

    @Override
    public String toString() {
        return "UNORDERED(" + this.subSources.stream().map(IntervalsSource::toString).collect(Collectors.joining(",")) + ")";
    }

    private static class UnorderedIntervalIterator
    extends ConjunctionIntervalIterator {
        private final PriorityQueue<IntervalIterator> queue;
        private final IntervalIterator[] subIterators;
        private final int[] innerPositions;
        int start = -1;
        int end = -1;
        int firstEnd;
        int queueEnd;

        UnorderedIntervalIterator(List<IntervalIterator> subIterators) {
            super(subIterators);
            this.queue = new PriorityQueue<IntervalIterator>(subIterators.size()){

                @Override
                protected boolean lessThan(IntervalIterator a, IntervalIterator b) {
                    return a.start() < b.start() || a.start() == b.start() && a.end() >= b.end();
                }
            };
            this.subIterators = new IntervalIterator[subIterators.size()];
            this.innerPositions = new int[subIterators.size() * 2];
            for (int i = 0; i < subIterators.size(); ++i) {
                this.subIterators[i] = subIterators.get(i);
            }
        }

        @Override
        public int start() {
            return this.start;
        }

        @Override
        public int end() {
            return this.end;
        }

        void updateRightExtreme(IntervalIterator it) {
            int itEnd = it.end();
            if (itEnd > this.queueEnd) {
                this.queueEnd = itEnd;
            }
        }

        @Override
        public int nextInterval() throws IOException {
            IntervalIterator it;
            while (this.queue.size() == this.subIterators.length && this.queue.top().start() == this.start) {
                it = this.queue.pop();
                if (it == null || it.nextInterval() == Integer.MAX_VALUE) continue;
                this.queue.add(it);
                this.updateRightExtreme(it);
            }
            if (this.queue.size() < this.subIterators.length) {
                this.end = Integer.MAX_VALUE;
                this.start = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            do {
                this.start = this.queue.top().start();
                this.firstEnd = this.queue.top().end();
                this.end = this.queueEnd;
                if (this.queue.top().end() == this.end) {
                    return this.start;
                }
                it = this.queue.pop();
                if (it == null || it.nextInterval() == Integer.MAX_VALUE) continue;
                this.queue.add(it);
                this.updateRightExtreme(it);
            } while (this.queue.size() == this.subIterators.length && this.end == this.queueEnd);
            return this.start;
        }

        @Override
        public int gaps() {
            for (int i = 0; i < this.subIterators.length; ++i) {
                if (this.subIterators[i].end() > this.end) {
                    this.innerPositions[i * 2] = this.start;
                    this.innerPositions[i * 2 + 1] = this.firstEnd;
                    continue;
                }
                this.innerPositions[i * 2] = this.subIterators[i].start();
                this.innerPositions[i * 2 + 1] = this.subIterators[i].end();
            }
            Arrays.sort(this.innerPositions);
            int gaps = 0;
            for (int i = 1; i < this.subIterators.length; ++i) {
                gaps += this.innerPositions[i * 2] - this.innerPositions[i * 2 - 1] - 1;
            }
            return gaps;
        }

        @Override
        protected void reset() throws IOException {
            this.end = -1;
            this.start = -1;
            this.queueEnd = -1;
            this.queue.clear();
            for (IntervalIterator it : this.subIterators) {
                if (it.nextInterval() == Integer.MAX_VALUE) break;
                this.queue.add(it);
                this.updateRightExtreme(it);
            }
        }
    }
}

