/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.middleware;

import cats.effect.SyncIO;
import cats.effect.kernel.Async;
import cats.effect.kernel.Ref;
import cats.effect.kernel.Ref$ApplyBuilders$;
import cats.effect.kernel.Ref$Make$;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Sync;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.package$all$;
import fs2.Chunk;
import fs2.Stream;
import fs2.Stream$;
import fs2.Stream$InvariantOps$;
import fs2.compat.NotGiven$;
import java.io.Serializable;
import org.http4s.Headers$;
import org.http4s.Platform$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Status;
import org.http4s.Status$ClientError$;
import org.http4s.Status$Informational$;
import org.http4s.Status$Redirection$;
import org.http4s.Status$ServerError$;
import org.http4s.Status$Successful$;
import org.http4s.client.Client;
import org.http4s.client.Client$;
import org.http4s.client.middleware.Logger$;
import org.typelevel.ci.CIString;
import org.typelevel.log4cats.SelfAwareStructuredLogger;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class ResponseLogger$ {
    public static final ResponseLogger$ MODULE$ = new ResponseLogger$();
    private static final SelfAwareStructuredLogger<SyncIO> logger = (SelfAwareStructuredLogger)Platform$.MODULE$.loggerFactory().getLogger("org.http4s.client.middleware.ResponseLogger");

    private <F> F defaultLogAction(String s2, Sync<F> evidence$1) {
        return ((SyncIO)logger.info((Function0<String> & Serializable)() -> s2)).to(evidence$1);
    }

    public <F> Client<F> apply(boolean logHeaders, boolean logBody, Function1<CIString, Object> redactHeadersWhen, Option<Function1<String, F>> logAction, Client<F> client, Async<F> evidence$2) {
        return this.impl(client, logBody, (Function1<Response, Object> & Serializable)response -> Logger$.MODULE$.logMessage(response, logHeaders, logBody, redactHeadersWhen, (Function1)logAction.getOrElse((Function0<Function1> & Serializable)() -> (Function1<String, Object> & Serializable)s2 -> MODULE$.defaultLogAction((String)s2, evidence$2)), evidence$2), evidence$2);
    }

    public <F> Function1<CIString, Object> apply$default$3() {
        return (Function1<CIString, Object> & Serializable)elem -> BoxesRunTime.boxToBoolean(ResponseLogger$.$anonfun$apply$default$3$1(elem));
    }

    public <F> None$ apply$default$4() {
        return None$.MODULE$;
    }

    public <F> Client<F> logBodyText(boolean logHeaders, Function1<Stream<F, Object>, Option<F>> logBody, Function1<CIString, Object> redactHeadersWhen, Option<Function1<String, F>> logAction, Client<F> client, Async<F> evidence$3) {
        return this.impl(client, true, (Function1<Response, Object> & Serializable)response -> org.http4s.internal.Logger$.MODULE$.logMessageWithBodyText(response, logHeaders, logBody, redactHeadersWhen, (Function1)logAction.getOrElse((Function0<Function1> & Serializable)() -> (Function1<String, Object> & Serializable)s2 -> MODULE$.defaultLogAction((String)s2, evidence$3)), evidence$3), evidence$3);
    }

    public <F> Function1<CIString, Object> logBodyText$default$3() {
        return (Function1<CIString, Object> & Serializable)elem -> BoxesRunTime.boxToBoolean(ResponseLogger$.$anonfun$logBodyText$default$3$1(elem));
    }

    public <F> None$ logBodyText$default$4() {
        return None$.MODULE$;
    }

    public <F> Client<F> customized(Client<F> client, boolean logBody, Option<Function1<String, F>> logAction, Function1<Response<F>, F> responseToText, Async<F> evidence$4) {
        return this.impl(client, logBody, (Function1<Response, Object> & Serializable)response -> {
            Function1 log = (Function1)logAction.getOrElse((Function0<Function1> & Serializable)() -> (Function1<String, Object> & Serializable)s2 -> MODULE$.defaultLogAction((String)s2, evidence$4));
            return package$all$.MODULE$.toFlatMapOps(responseToText.apply((Response)response), evidence$4).flatMap(log);
        }, evidence$4);
    }

    public <F> boolean customized$default$2() {
        return true;
    }

    public <F> None$ customized$default$3() {
        return None$.MODULE$;
    }

    private <F> Client<F> impl(Client<F> client, boolean logBody, Function1<Response<F>, F> logMessage, Async<F> F2) {
        return Client$.MODULE$.apply((Function1<Request, Resource> & Serializable)req -> client.run((Request)req).flatMap((Function1<Response, Resource> & Serializable)response -> ResponseLogger$.logResponse$1(response, logBody, logMessage, F2)), F2);
    }

    public <F> String defaultResponseColor(Response<F> response) {
        Status.ResponseClass responseClass = response.status().responseClass();
        if (Status$Informational$.MODULE$.equals(responseClass) ? true : (Status$Successful$.MODULE$.equals(responseClass) ? true : Status$Redirection$.MODULE$.equals(responseClass))) {
            return "\u001b[32m";
        }
        if (Status$ClientError$.MODULE$.equals(responseClass)) {
            return "\u001b[33m";
        }
        if (Status$ServerError$.MODULE$.equals(responseClass)) {
            return "\u001b[31m";
        }
        throw new MatchError(responseClass);
    }

    public <F> Client<F> colored(boolean logHeaders, boolean logBody, Function1<CIString, Object> redactHeadersWhen, Function1<Response<F>, String> color, Option<Function1<String, F>> logAction, Client<F> client, Async<F> evidence$5) {
        return this.customized(client, logBody, logAction, (Function1<Response, Object> & Serializable)response -> {
            Object object;
            String prelude = new StringBuilder(1).append(response.httpVersion()).append(" ").append(response.status()).toString();
            String headers = org.http4s.internal.Logger$.MODULE$.defaultLogHeaders(response, logHeaders, redactHeadersWhen);
            Option option = org.http4s.internal.Logger$.MODULE$.defaultLogBody(response, logBody, evidence$5);
            if (option instanceof Some) {
                Some some = (Some)option;
                Object textF = some.value();
                object = package$all$.MODULE$.toFunctorOps(textF, evidence$5).map((Function1<String, String> & Serializable)text2 -> new StringBuilder(7).append("body=\"").append((String)text2).append("\"").toString());
            } else if (None$.MODULE$.equals(option)) {
                object = cats.effect.package$.MODULE$.Sync().apply(evidence$5).pure("");
            } else {
                throw new MatchError(option);
            }
            Object bodyText = object;
            return package$all$.MODULE$.toFunctorOps(bodyText, evidence$5).map((Function1<String, String> & Serializable)body -> new StringBuilder(4).append(color.apply((Response)response)).append(prelude).append(ResponseLogger$.spaced$1(headers)).append(ResponseLogger$.spaced$1(body)).append("\u001b[0m").toString());
        }, evidence$5);
    }

    public <F> Function1<CIString, Object> colored$default$3() {
        return (Function1<CIString, Object> & Serializable)elem -> BoxesRunTime.boxToBoolean(ResponseLogger$.$anonfun$colored$default$3$1(elem));
    }

    public <F> Function1<Response<Nothing$>, String> colored$default$4() {
        return (Function1<Response, String> & Serializable)response -> MODULE$.defaultResponseColor((Response)response);
    }

    public <F> None$ colored$default$5() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$apply$default$3$1(CIString elem) {
        return Headers$.MODULE$.SensitiveHeaders().contains(elem);
    }

    public static final /* synthetic */ boolean $anonfun$logBodyText$default$3$1(CIString elem) {
        return Headers$.MODULE$.SensitiveHeaders().contains(elem);
    }

    private static final Resource logResponse$1(Response response, boolean logBody$3, Function1 logMessage$1, Async F$1) {
        if (!logBody$3) {
            return cats.effect.package$.MODULE$.Resource().eval(package$all$.MODULE$.catsSyntaxApply(logMessage$1.apply(response), F$1).$times$greater(F$1.delay((Function0<Response> & Serializable)() -> response)));
        }
        return cats.effect.package$.MODULE$.Resource().suspend(package$all$.MODULE$.toFunctorOps(Ref$ApplyBuilders$.MODULE$.of$extension(cats.effect.package$.MODULE$.Ref().apply(Ref$Make$.MODULE$.concurrentInstance(F$1)), package$.MODULE$.Vector().empty()), F$1).map((Function1<Ref, Resource> & Serializable)vec -> {
            Function1<Stream, Stream> & Serializable dumpChunksToVec = (Function1<Stream, Stream> & Serializable)x$1 -> x$1.chunks().flatMap((Function1<Chunk, Stream> & Serializable)s2 -> Stream$.MODULE$.exec(vec.update((Function1<Vector, Vector> & Serializable)x$2 -> (Vector)x$2.$colon$plus(s2))), NotGiven$.MODULE$.default());
            return cats.effect.package$.MODULE$.Resource().make(F$1.pure(response.pipeBodyThrough((Function1<Stream, Stream> & Serializable)x$3 -> Stream$InvariantOps$.MODULE$.observe$extension(Stream$.MODULE$.InvariantOps(x$3), dumpChunksToVec, F$1))), (Function1<Response, Object> & Serializable)x$4 -> {
                Stream newBody = Stream$.MODULE$.eval(vec.get()).flatMap((Function1<Seq, Stream> & Serializable)os -> Stream$.MODULE$.emits(os), NotGiven$.MODULE$.default()).unchunks($less$colon$less$.MODULE$.refl());
                return ApplicativeErrorOps$.MODULE$.handleErrorWith$extension(package$all$.MODULE$.catsSyntaxApplicativeError(logMessage$1.apply(response.withBodyStream(newBody)), F$1), (Function1<Throwable, Object> & Serializable)t -> ((SyncIO)logger.error((Throwable)t, (Function0<String> & Serializable)() -> "Error logging response body")).to(F$1), F$1);
            }, F$1);
        }));
    }

    private static final String spaced$1(String x2) {
        if (x2.isEmpty()) {
            return x2;
        }
        return new StringBuilder(1).append(" ").append(x2).toString();
    }

    public static final /* synthetic */ boolean $anonfun$colored$default$3$1(CIString elem) {
        return Headers$.MODULE$.SensitiveHeaders().contains(elem);
    }

    private ResponseLogger$() {
    }
}

