/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.middleware;

import cats.effect.SyncIO;
import cats.effect.SyncIO$;
import cats.effect.kernel.GenTemporal;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.std.Hotswap;
import cats.effect.std.Hotswap$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.package$all$;
import java.io.Serializable;
import org.http4s.Header;
import org.http4s.Header$Select$;
import org.http4s.Headers$;
import org.http4s.HttpDate;
import org.http4s.Method;
import org.http4s.Platform$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.client.Client;
import org.http4s.client.Client$;
import org.http4s.headers.Retry$minusAfter;
import org.http4s.headers.Retry$minusAfter$;
import org.typelevel.ci.CIString;
import org.typelevel.log4cats.SelfAwareStructuredLogger;
import org.typelevel.vault.Key;
import org.typelevel.vault.Key$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Retry$ {
    public static final Retry$ MODULE$ = new Retry$();
    private static final SelfAwareStructuredLogger<SyncIO> logger = (SelfAwareStructuredLogger)Platform$.MODULE$.loggerFactory().getLogger("org.http4s.client.middleware.Retry");
    private static final Key<Object> AttemptCountKey = (Key)Key$.MODULE$.newKey(SyncIO$.MODULE$.syncForSyncIO(), SyncIO$.MODULE$.syncForSyncIO()).unsafeRunSync();

    public Key<Object> AttemptCountKey() {
        return AttemptCountKey;
    }

    public <F> Client<F> apply(Function3<Request<F>, Either<Throwable, Response<F>>, Object, Option<FiniteDuration>> policy, Function1<CIString, Object> redactHeaderWhen, Client<F> client, GenTemporal<F, Throwable> F2) {
        return this.create(policy, redactHeaderWhen, this.create$default$3(), client, F2);
    }

    public <F> Function1<CIString, Object> apply$default$2() {
        return (Function1<CIString, Object> & Serializable)elem -> BoxesRunTime.boxToBoolean(Retry$.$anonfun$apply$default$2$1(elem));
    }

    public <F> Client<F> create(Function3<Request<F>, Either<Throwable, Response<F>>, Object, Option<FiniteDuration>> policy, Function1<CIString, Object> redactHeaderWhen, boolean logRetries, Client<F> client, GenTemporal<F, Throwable> F2) {
        return Client$.MODULE$.apply((Function1<Request, Resource> & Serializable)req -> Hotswap$.MODULE$.create(F2).flatMap((Function1<Hotswap, Resource> & Serializable)hotswap -> Resource$.MODULE$.eval(this.retryLoop$1((Request)req, 1, (Hotswap)hotswap, F2, client, policy, logRetries, redactHeaderWhen))), F2);
    }

    public <F> Function1<CIString, Object> create$default$2() {
        return (Function1<CIString, Object> & Serializable)elem -> BoxesRunTime.boxToBoolean(Retry$.$anonfun$create$default$2$1(elem));
    }

    public <F> boolean create$default$3() {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$apply$default$2$1(CIString elem) {
        return Headers$.MODULE$.SensitiveHeaders().contains(elem);
    }

    private static final String showRequest$1(Request request, Function1 redactWhen) {
        String headers = Headers$.MODULE$.mkString$extension(request.headers(), ",", redactWhen);
        String uri = request.uri().renderString();
        Method method = request.method();
        return new StringBuilder(21).append("method=").append(method).append(" uri=").append(uri).append(" headers=").append(headers).toString();
    }

    private final Object nextAttempt$1(Request req, int attempts, FiniteDuration duration, Option retryHeader, Hotswap hotswap, GenTemporal F$1, Client client$1, Function3 policy$1, boolean logRetries$1, Function1 redactHeaderWhen$1) {
        Object headerDuration = retryHeader.map((Function1<Retry$minusAfter, Object> & Serializable)h -> {
            Either<HttpDate, Object> either2 = h.retry();
            if (either2 instanceof Left) {
                Left left = (Left)either2;
                HttpDate date = (HttpDate)left.value();
                return package$all$.MODULE$.toFunctorOps(F$1.realTime(), F$1).map((Function1<FiniteDuration, FiniteDuration> & Serializable)x$1 -> date.toDuration().$minus((FiniteDuration)x$1));
            }
            if (either2 instanceof Right) {
                Right right = (Right)either2;
                long secs = BoxesRunTime.unboxToLong(right.value());
                return ApplicativeIdOps$.MODULE$.pure$extension(package$all$.MODULE$.catsSyntaxApplicativeId(new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(secs)).seconds()), F$1);
            }
            throw new MatchError(either2);
        }).getOrElse((Function0<Object> & Serializable)() -> ApplicativeIdOps$.MODULE$.pure$extension(package$all$.MODULE$.catsSyntaxApplicativeId(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(0)).seconds()), F$1));
        Object sleepDuration = package$all$.MODULE$.toFunctorOps(headerDuration, F$1).map((Function1<FiniteDuration, FiniteDuration> & Serializable)x$2 -> x$2.max(duration));
        return FlatMapOps$.MODULE$.$greater$greater$extension(package$all$.MODULE$.catsSyntaxFlatMapOps(package$all$.MODULE$.toFlatMapOps(sleepDuration, F$1).flatMap((Function1<FiniteDuration, Object> & Serializable)x$3 -> F$1.sleep((Duration)x$3)), F$1), (Function0<Object> & Serializable)() -> this.retryLoop$1(req, attempts + 1, hotswap, F$1, client$1, policy$1, logRetries$1, redactHeaderWhen$1), F$1);
    }

    private final Object retryLoop$1(Request req, int attempts, Hotswap hotswap, GenTemporal F$1, Client client$1, Function3 policy$1, boolean logRetries$1, Function1 redactHeaderWhen$1) {
        return package$all$.MODULE$.catsSyntaxApply(hotswap.clear(), F$1).$times$greater(package$all$.MODULE$.toFlatMapOps(hotswap.swap(client$1.run((Request)req.withAttribute(this.AttemptCountKey(), BoxesRunTime.boxToInteger(attempts))).map((Function1<Response, Response> & Serializable)x$4 -> (Response)x$4.withAttribute(MODULE$.AttemptCountKey(), BoxesRunTime.boxToInteger(attempts))).attempt(F$1)), F$1).flatMap((Function1<Either, Object> & Serializable)x0$1 -> {
            Either either2 = x0$1;
            if (either2 instanceof Right) {
                Right right = (Right)either2;
                Response response = (Response)right.value();
                Option option = (Option)policy$1.apply(req, package$.MODULE$.Right().apply(response), BoxesRunTime.boxToInteger(attempts));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    FiniteDuration duration = (FiniteDuration)some.value();
                    BoxedUnit boxedUnit = logRetries$1 ? ((SyncIO)logger.info((Function0<String> & Serializable)() -> new StringBuilder(63).append("Request ").append(Retry$.showRequest$1(req, redactHeaderWhen$1)).append(" has failed on attempt #").append(attempts).append(" with reason ").append(response.status()).append(". Retrying after ").append(duration).append(".").toString())).unsafeRunSync() : BoxedUnit.UNIT;
                    return this.nextAttempt$1(req, attempts, duration, Headers$.MODULE$.get$extension((List<Header.Raw>)response.headers(), Header$Select$.MODULE$.singleHeaders(Retry$minusAfter$.MODULE$.headerInstance())), hotswap, F$1, client$1, policy$1, logRetries$1, redactHeaderWhen$1);
                }
                if (None$.MODULE$.equals(option)) {
                    return F$1.pure(response);
                }
                throw new MatchError(option);
            }
            if (either2 instanceof Left) {
                Left left = (Left)either2;
                Throwable e = (Throwable)left.value();
                Option option = (Option)policy$1.apply(req, package$.MODULE$.Left().apply(e), BoxesRunTime.boxToInteger(attempts));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    FiniteDuration duration = (FiniteDuration)some.value();
                    BoxedUnit boxedUnit = logRetries$1 ? ((SyncIO)logger.info(e, (Function0<String> & Serializable)() -> new StringBuilder(56).append("Request threw an exception on attempt #").append(attempts).append(". Retrying after ").append(duration).toString())).unsafeRunSync() : BoxedUnit.UNIT;
                    return this.nextAttempt$1(req, attempts, duration, None$.MODULE$, hotswap, F$1, client$1, policy$1, logRetries$1, redactHeaderWhen$1);
                }
                if (None$.MODULE$.equals(option)) {
                    BoxedUnit boxedUnit = logRetries$1 ? ((SyncIO)logger.info(e, (Function0<String> & Serializable)() -> new StringBuilder(52).append("Request ").append(Retry$.showRequest$1(req, redactHeaderWhen$1)).append(" threw an exception on attempt #").append(attempts).append(". Giving up.").toString())).unsafeRunSync() : BoxedUnit.UNIT;
                    return F$1.raiseError(e);
                }
                throw new MatchError(option);
            }
            throw new MatchError(either2);
        }));
    }

    public static final /* synthetic */ boolean $anonfun$create$default$2$1(CIString elem) {
        return Headers$.MODULE$.SensitiveHeaders().contains(elem);
    }

    private Retry$() {
    }
}

